/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BaseTimetableManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iEmailAddress;
    private Set<ManagerSettings> iSettings;
    private Set<Department> iDepartments;
    private Set<ManagerRole> iManagerRoles;
    private Set<SolverGroup> iSolverGroups;

    public BaseTimetableManager() {
    }

    public BaseTimetableManager(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="timetable_mgr_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Column(name="first_name", nullable=false, length=100)
    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    @Column(name="middle_name", nullable=true, length=100)
    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    @Column(name="last_name", nullable=false, length=100)
    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    @Column(name="acad_title", nullable=true, length=50)
    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    @Column(name="email_address", nullable=true, length=200)
    public String getEmailAddress() {
        return this.iEmailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.iEmailAddress = emailAddress;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="manager", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ManagerSettings> getSettings() {
        return this.iSettings;
    }

    public void setSettings(Set<ManagerSettings> settings) {
        this.iSettings = settings;
    }

    public void addToSettings(ManagerSettings managerSettings) {
        if (this.iSettings == null) {
            this.iSettings = new HashSet<ManagerSettings>();
        }
        this.iSettings.add(managerSettings);
    }

    @Deprecated
    public void addTosettings(ManagerSettings managerSettings) {
        this.addToSettings(managerSettings);
    }

    @ManyToMany(mappedBy="timetableManagers")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addToDepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    @Deprecated
    public void addTodepartments(Department department) {
        this.addToDepartments(department);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="timetableManager", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ManagerRole> getManagerRoles() {
        return this.iManagerRoles;
    }

    public void setManagerRoles(Set<ManagerRole> managerRoles) {
        this.iManagerRoles = managerRoles;
    }

    public void addToManagerRoles(ManagerRole managerRole) {
        if (this.iManagerRoles == null) {
            this.iManagerRoles = new HashSet<ManagerRole>();
        }
        this.iManagerRoles.add(managerRole);
    }

    @Deprecated
    public void addTomanagerRoles(ManagerRole managerRole) {
        this.addToManagerRoles(managerRole);
    }

    @ManyToMany(mappedBy="timetableManagers")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<SolverGroup> getSolverGroups() {
        return this.iSolverGroups;
    }

    public void setSolverGroups(Set<SolverGroup> solverGroups) {
        this.iSolverGroups = solverGroups;
    }

    public void addToSolverGroups(SolverGroup solverGroup) {
        if (this.iSolverGroups == null) {
            this.iSolverGroups = new HashSet<SolverGroup>();
        }
        this.iSolverGroups.add(solverGroup);
    }

    @Deprecated
    public void addTosolverGroups(SolverGroup solverGroup) {
        this.addToSolverGroups(solverGroup);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimetableManager)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TimetableManager)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TimetableManager)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TimetableManager[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "TimetableManager[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tEmailAddress: " + this.getEmailAddress() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

