/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.Settings;

@MappedSuperclass
public abstract class BaseSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iKey;
    private String iDefaultValue;
    private String iAllowedValues;
    private String iDescription;
    private Set<ManagerSettings> iManagerSettings;

    public BaseSettings() {
    }

    public BaseSettings(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="settings_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=30)
    public String getKey() {
        return this.iKey;
    }

    public void setKey(String key) {
        this.iKey = key;
    }

    @Column(name="default_value", nullable=false, length=100)
    public String getDefaultValue() {
        return this.iDefaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.iDefaultValue = defaultValue;
    }

    @Column(name="allowed_values", nullable=false, length=500)
    public String getAllowedValues() {
        return this.iAllowedValues;
    }

    public void setAllowedValues(String allowedValues) {
        this.iAllowedValues = allowedValues;
    }

    @Column(name="description", nullable=false, length=100)
    public String getDescription() {
        return this.iDescription;
    }

    public void setDescription(String description) {
        this.iDescription = description;
    }

    @OneToMany
    @JoinColumn(name="uniqueid", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<ManagerSettings> getManagerSettings() {
        return this.iManagerSettings;
    }

    public void setManagerSettings(Set<ManagerSettings> managerSettings) {
        this.iManagerSettings = managerSettings;
    }

    public void addToManagerSettings(ManagerSettings managerSettings) {
        if (this.iManagerSettings == null) {
            this.iManagerSettings = new HashSet<ManagerSettings>();
        }
        this.iManagerSettings.add(managerSettings);
    }

    @Deprecated
    public void addTomanagerSettings(ManagerSettings managerSettings) {
        this.addToManagerSettings(managerSettings);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Settings)) {
            return false;
        }
        if (this.getUniqueId() == null || ((Settings)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((Settings)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "Settings[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "Settings[\n\tAllowedValues: " + this.getAllowedValues() + "\n\tDefaultValue: " + this.getDefaultValue() + "\n\tDescription: " + this.getDescription() + "\n\tKey: " + this.getKey() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

