/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.JoinFormula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitSchedulingSubpart;
import org.unitime.timetable.model.PitStudentClassEnrollment;
import org.unitime.timetable.model.TimePattern;

@MappedSuperclass
public abstract class BasePitClass
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iLimit;
    private Integer iNbrRooms;
    private Boolean iEnabledForStudentScheduling;
    private Integer iSectionNumber;
    private String iClassSuffix;
    private Long iUniqueIdRolledForwardFrom;
    private String iExternalUniqueId;
    private Integer iEnrollment;
    private Department iControllingDept;
    private Class_ iClazz;
    private Department iManagingDept;
    private PitSchedulingSubpart iPitSchedulingSubpart;
    private PitClass iPitParentClass;
    private DatePattern iDatePattern;
    private TimePattern iTimePattern;
    private Department iFundingDept;
    private Set<PitClass> iPitChildClasses;
    private Set<PitClassInstructor> iPitClassInstructors;
    private Set<PitStudentClassEnrollment> iStudentEnrollments;
    private Set<PitClassEvent> iPitClassEvents;

    public BasePitClass() {
    }

    public BasePitClass(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="point_in_time_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="class_limit", nullable=true, length=10)
    public Integer getLimit() {
        return this.iLimit;
    }

    public void setLimit(Integer limit) {
        this.iLimit = limit;
    }

    @Column(name="nbr_rooms", nullable=true, length=4)
    public Integer getNbrRooms() {
        return this.iNbrRooms;
    }

    public void setNbrRooms(Integer nbrRooms) {
        this.iNbrRooms = nbrRooms;
    }

    @Column(name="enabled_for_stu_sched", nullable=false)
    public Boolean isEnabledForStudentScheduling() {
        return this.iEnabledForStudentScheduling;
    }

    @Transient
    public Boolean getEnabledForStudentScheduling() {
        return this.iEnabledForStudentScheduling;
    }

    public void setEnabledForStudentScheduling(Boolean enabledForStudentScheduling) {
        this.iEnabledForStudentScheduling = enabledForStudentScheduling;
    }

    @Column(name="section_number", nullable=true, length=5)
    public Integer getSectionNumber() {
        return this.iSectionNumber;
    }

    public void setSectionNumber(Integer sectionNumber) {
        this.iSectionNumber = sectionNumber;
    }

    @Column(name="class_suffix", nullable=true, length=40)
    public String getClassSuffix() {
        return this.iClassSuffix;
    }

    public void setClassSuffix(String classSuffix) {
        this.iClassSuffix = classSuffix;
    }

    @Column(name="uid_rolled_fwd_from", nullable=true, length=20)
    public Long getUniqueIdRolledForwardFrom() {
        return this.iUniqueIdRolledForwardFrom;
    }

    public void setUniqueIdRolledForwardFrom(Long uniqueIdRolledForwardFrom) {
        this.iUniqueIdRolledForwardFrom = uniqueIdRolledForwardFrom;
    }

    @Column(name="external_uid", nullable=true, length=40)
    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    @Formula(value="(select count(e.pit_student_id) from %SCHEMA%.pit_student_class_enrl e where e.pit_class_id = uniqueid)")
    public Integer getEnrollment() {
        return this.iEnrollment;
    }

    public void setEnrollment(Integer enrollment) {
        this.iEnrollment = enrollment;
    }

    @ManyToOne
    @JoinFormula(value=" ( select sa.department_uniqueid from %SCHEMA%.pit_sched_subpart ss, %SCHEMA%.pit_instr_offer_config ioc, %SCHEMA%.pit_instr_offering io, %SCHEMA%.pit_course_offering co, %SCHEMA%.subject_area sa where ss.uniqueid = pit_subpart_id and ioc.uniqueid = ss.pit_config_id and io.uniqueid = ioc.pit_instr_offr_id and co.pit_instr_offr_id = io.uniqueid and co.is_control = %TRUE% and sa.uniqueid = co.subject_area_id ) ")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getControllingDept() {
        return this.iControllingDept;
    }

    public void setControllingDept(Department controllingDept) {
        this.iControllingDept = controllingDept;
    }

    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    @JoinColumn(name="class_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Class_ getClazz() {
        return this.iClazz;
    }

    public void setClazz(Class_ clazz) {
        this.iClazz = clazz;
    }

    @ManyToOne(optional=true, fetch=FetchType.EAGER)
    @JoinColumn(name="managing_dept", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getManagingDept() {
        return this.iManagingDept;
    }

    public void setManagingDept(Department managingDept) {
        this.iManagingDept = managingDept;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="pit_subpart_id", nullable=false)
    public PitSchedulingSubpart getPitSchedulingSubpart() {
        return this.iPitSchedulingSubpart;
    }

    public void setPitSchedulingSubpart(PitSchedulingSubpart pitSchedulingSubpart) {
        this.iPitSchedulingSubpart = pitSchedulingSubpart;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="pit_parent_id", nullable=true)
    public PitClass getPitParentClass() {
        return this.iPitParentClass;
    }

    public void setPitParentClass(PitClass pitParentClass) {
        this.iPitParentClass = pitParentClass;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="date_pattern_id", nullable=true)
    public DatePattern getDatePattern() {
        return this.iDatePattern;
    }

    public void setDatePattern(DatePattern datePattern) {
        this.iDatePattern = datePattern;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="time_pattern_id", nullable=true)
    public TimePattern getTimePattern() {
        return this.iTimePattern;
    }

    public void setTimePattern(TimePattern timePattern) {
        this.iTimePattern = timePattern;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="funding_dept_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Department getFundingDept() {
        return this.iFundingDept;
    }

    public void setFundingDept(Department fundingDept) {
        this.iFundingDept = fundingDept;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitParentClass", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClass> getPitChildClasses() {
        return this.iPitChildClasses;
    }

    public void setPitChildClasses(Set<PitClass> pitChildClasses) {
        this.iPitChildClasses = pitChildClasses;
    }

    public void addToPitChildClasses(PitClass pitClass) {
        if (this.iPitChildClasses == null) {
            this.iPitChildClasses = new HashSet<PitClass>();
        }
        this.iPitChildClasses.add(pitClass);
    }

    @Deprecated
    public void addTopitChildClasses(PitClass pitClass) {
        this.addToPitChildClasses(pitClass);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitClassInstructing", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClassInstructor> getPitClassInstructors() {
        return this.iPitClassInstructors;
    }

    public void setPitClassInstructors(Set<PitClassInstructor> pitClassInstructors) {
        this.iPitClassInstructors = pitClassInstructors;
    }

    public void addToPitClassInstructors(PitClassInstructor pitClassInstructor) {
        if (this.iPitClassInstructors == null) {
            this.iPitClassInstructors = new HashSet<PitClassInstructor>();
        }
        this.iPitClassInstructors.add(pitClassInstructor);
    }

    @Deprecated
    public void addTopitClassInstructors(PitClassInstructor pitClassInstructor) {
        this.addToPitClassInstructors(pitClassInstructor);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitClass", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitStudentClassEnrollment> getStudentEnrollments() {
        return this.iStudentEnrollments;
    }

    public void setStudentEnrollments(Set<PitStudentClassEnrollment> studentEnrollments) {
        this.iStudentEnrollments = studentEnrollments;
    }

    public void addToStudentEnrollments(PitStudentClassEnrollment pitStudentClassEnrollment) {
        if (this.iStudentEnrollments == null) {
            this.iStudentEnrollments = new HashSet<PitStudentClassEnrollment>();
        }
        this.iStudentEnrollments.add(pitStudentClassEnrollment);
    }

    @Deprecated
    public void addTostudentEnrollments(PitStudentClassEnrollment pitStudentClassEnrollment) {
        this.addToStudentEnrollments(pitStudentClassEnrollment);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="pitClass", cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<PitClassEvent> getPitClassEvents() {
        return this.iPitClassEvents;
    }

    public void setPitClassEvents(Set<PitClassEvent> pitClassEvents) {
        this.iPitClassEvents = pitClassEvents;
    }

    public void addToPitClassEvents(PitClassEvent pitClassEvent) {
        if (this.iPitClassEvents == null) {
            this.iPitClassEvents = new HashSet<PitClassEvent>();
        }
        this.iPitClassEvents.add(pitClassEvent);
    }

    @Deprecated
    public void addTopitClassEvents(PitClassEvent pitClassEvent) {
        this.addToPitClassEvents(pitClassEvent);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PitClass)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PitClass)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PitClass)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PitClass[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PitClass[\n\tClassSuffix: " + this.getClassSuffix() + "\n\tClazz: " + String.valueOf(this.getClazz()) + "\n\tDatePattern: " + String.valueOf(this.getDatePattern()) + "\n\tEnabledForStudentScheduling: " + this.getEnabledForStudentScheduling() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFundingDept: " + String.valueOf(this.getFundingDept()) + "\n\tLimit: " + this.getLimit() + "\n\tManagingDept: " + String.valueOf(this.getManagingDept()) + "\n\tNbrRooms: " + this.getNbrRooms() + "\n\tPitParentClass: " + String.valueOf(this.getPitParentClass()) + "\n\tPitSchedulingSubpart: " + String.valueOf(this.getPitSchedulingSubpart()) + "\n\tSectionNumber: " + this.getSectionNumber() + "\n\tTimePattern: " + String.valueOf(this.getTimePattern()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tUniqueIdRolledForwardFrom: " + this.getUniqueIdRolledForwardFrom() + "]";
    }
}

