/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PeriodicTask;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TaskExecution;
import org.unitime.timetable.model.TaskParameter;
import org.unitime.timetable.model.TimetableManager;

@MappedSuperclass
public abstract class BasePeriodicTask
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iName;
    private String iEmail;
    private byte[] iInputFile;
    private Session iSession;
    private Script iScript;
    private TimetableManager iOwner;
    private Set<TaskParameter> iParameters;
    private Set<TaskExecution> iSchedule;

    public BasePeriodicTask() {
    }

    public BasePeriodicTask(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="name", nullable=false, length=128)
    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    @Column(name="email", nullable=true, length=1000)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="input_file", nullable=true)
    public byte[] getInputFile() {
        return this.iInputFile;
    }

    public void setInputFile(byte[] inputFile) {
        this.iInputFile = inputFile;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="session_id", nullable=false)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="script_id", nullable=false)
    public Script getScript() {
        return this.iScript;
    }

    public void setScript(Script script) {
        this.iScript = script;
    }

    @ManyToOne(optional=false)
    @JoinColumn(name="owner_id", nullable=false)
    public TimetableManager getOwner() {
        return this.iOwner;
    }

    public void setOwner(TimetableManager owner) {
        this.iOwner = owner;
    }

    @OneToMany(mappedBy="task", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TaskParameter> getParameters() {
        return this.iParameters;
    }

    public void setParameters(Set<TaskParameter> parameters) {
        this.iParameters = parameters;
    }

    public void addToParameters(TaskParameter taskParameter) {
        if (this.iParameters == null) {
            this.iParameters = new HashSet<TaskParameter>();
        }
        this.iParameters.add(taskParameter);
    }

    @Deprecated
    public void addToparameters(TaskParameter taskParameter) {
        this.addToParameters(taskParameter);
    }

    @OneToMany(mappedBy="task", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<TaskExecution> getSchedule() {
        return this.iSchedule;
    }

    public void setSchedule(Set<TaskExecution> schedule) {
        this.iSchedule = schedule;
    }

    public void addToSchedule(TaskExecution taskExecution) {
        if (this.iSchedule == null) {
            this.iSchedule = new HashSet<TaskExecution>();
        }
        this.iSchedule.add(taskExecution);
    }

    @Deprecated
    public void addToschedule(TaskExecution taskExecution) {
        this.addToSchedule(taskExecution);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PeriodicTask)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PeriodicTask)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PeriodicTask)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PeriodicTask[" + this.getUniqueId() + " " + this.getName() + "]";
    }

    public String toDebugString() {
        return "PeriodicTask[\n\tEmail: " + this.getEmail() + "\n\tInputFile: " + String.valueOf(this.getInputFile()) + "\n\tName: " + this.getName() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tScript: " + String.valueOf(this.getScript()) + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

