/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.MessageLog;

@MappedSuperclass
public abstract class BaseMessageLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Date iTimeStamp;
    private Integer iLevel;
    private String iMessage;
    private String iLogger;
    private String iThread;
    private String iNdc;
    private String iException;

    public BaseMessageLog() {
    }

    public BaseMessageLog(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="time_stamp", nullable=false)
    public Date getTimeStamp() {
        return this.iTimeStamp;
    }

    public void setTimeStamp(Date timeStamp) {
        this.iTimeStamp = timeStamp;
    }

    @Column(name="log_level", nullable=false)
    public Integer getLevel() {
        return this.iLevel;
    }

    public void setLevel(Integer level) {
        this.iLevel = level;
    }

    @Column(name="message", nullable=true)
    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    @Column(name="logger", nullable=false, length=255)
    public String getLogger() {
        return this.iLogger;
    }

    public void setLogger(String logger) {
        this.iLogger = logger;
    }

    @Column(name="thread", nullable=true, length=100)
    public String getThread() {
        return this.iThread;
    }

    public void setThread(String thread) {
        this.iThread = thread;
    }

    @Column(name="ndc", nullable=true)
    public String getNdc() {
        return this.iNdc;
    }

    public void setNdc(String ndc) {
        this.iNdc = ndc;
    }

    @Column(name="exception", nullable=true)
    public String getException() {
        return this.iException;
    }

    public void setException(String exception) {
        this.iException = exception;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof MessageLog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((MessageLog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((MessageLog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "MessageLog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "MessageLog[\n\tException: " + this.getException() + "\n\tLevel: " + this.getLevel() + "\n\tLogger: " + this.getLogger() + "\n\tMessage: " + this.getMessage() + "\n\tNdc: " + this.getNdc() + "\n\tThread: " + this.getThread() + "\n\tTimeStamp: " + String.valueOf(this.getTimeStamp()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

