/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;
import org.unitime.timetable.model.HashedQuery;

@MappedSuperclass
public abstract class BaseHashedQuery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String iQueryHash;
    private String iQueryText;
    private Date iCreated;
    private Long iNbrUsed;
    private Date iLastUsed;

    public BaseHashedQuery() {
    }

    public BaseHashedQuery(String queryHash) {
        this.setQueryHash(queryHash);
    }

    @Id
    @Column(name="query_hash")
    public String getQueryHash() {
        return this.iQueryHash;
    }

    public void setQueryHash(String queryHash) {
        this.iQueryHash = queryHash;
    }

    @Column(name="query_text", nullable=false, length=2048)
    public String getQueryText() {
        return this.iQueryText;
    }

    public void setQueryText(String queryText) {
        this.iQueryText = queryText;
    }

    @Column(name="ts_create", nullable=false)
    public Date getCreated() {
        return this.iCreated;
    }

    public void setCreated(Date created) {
        this.iCreated = created;
    }

    @Column(name="nbr_use", nullable=false)
    public Long getNbrUsed() {
        return this.iNbrUsed;
    }

    public void setNbrUsed(Long nbrUsed) {
        this.iNbrUsed = nbrUsed;
    }

    @Column(name="ts_use", nullable=true)
    public Date getLastUsed() {
        return this.iLastUsed;
    }

    public void setLastUsed(Date lastUsed) {
        this.iLastUsed = lastUsed;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof HashedQuery)) {
            return false;
        }
        if (this.getQueryHash() == null || ((HashedQuery)o).getQueryHash() == null) {
            return false;
        }
        return this.getQueryHash().equals(((HashedQuery)o).getQueryHash());
    }

    public int hashCode() {
        if (this.getQueryHash() == null) {
            return super.hashCode();
        }
        return this.getQueryHash().hashCode();
    }

    public String toString() {
        return "HashedQuery[" + this.getQueryHash() + "]";
    }

    public String toDebugString() {
        return "HashedQuery[\n\tCreated: " + String.valueOf(this.getCreated()) + "\n\tLastUsed: " + String.valueOf(this.getLastUsed()) + "\n\tNbrUsed: " + this.getNbrUsed() + "\n\tQueryHash: " + this.getQueryHash() + "\n\tQueryText: " + this.getQueryText() + "]";
    }
}

