/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Formula;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamConflict;
import org.unitime.timetable.model.Student;

@MappedSuperclass
public abstract class BaseExamConflict
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iConflictType;
    private Double iDistance;
    private Integer iNrStudents;
    private Integer iNrInstructors;
    private Set<Exam> iExams;
    private Set<Student> iStudents;
    private Set<DepartmentalInstructor> iInstructors;

    public BaseExamConflict() {
    }

    public BaseExamConflict(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_group_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="conflict_type", nullable=false, length=10)
    public Integer getConflictType() {
        return this.iConflictType;
    }

    public void setConflictType(Integer conflictType) {
        this.iConflictType = conflictType;
    }

    @Column(name="distance", nullable=true)
    public Double getDistance() {
        return this.iDistance;
    }

    public void setDistance(Double distance) {
        this.iDistance = distance;
    }

    @Formula(value="(select count(xs.student_id) from %SCHEMA%.xconflict_student xs where xs.conflict_id = uniqueid)")
    public Integer getNrStudents() {
        return this.iNrStudents;
    }

    public void setNrStudents(Integer nrStudents) {
        this.iNrStudents = nrStudents;
    }

    @Formula(value="(select count(xi.instructor_id) from %SCHEMA%.xconflict_instructor xi where xi.conflict_id = uniqueid)")
    public Integer getNrInstructors() {
        return this.iNrInstructors;
    }

    public void setNrInstructors(Integer nrInstructors) {
        this.iNrInstructors = nrInstructors;
    }

    @ManyToMany(fetch=FetchType.EAGER, mappedBy="conflicts")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Exam> getExams() {
        return this.iExams;
    }

    public void setExams(Set<Exam> exams) {
        this.iExams = exams;
    }

    public void addToExams(Exam exam) {
        if (this.iExams == null) {
            this.iExams = new HashSet<Exam>();
        }
        this.iExams.add(exam);
    }

    @Deprecated
    public void addToexams(Exam exam) {
        this.addToExams(exam);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xconflict_student", joinColumns={@JoinColumn(name="conflict_id")}, inverseJoinColumns={@JoinColumn(name="student_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<Student> getStudents() {
        return this.iStudents;
    }

    public void setStudents(Set<Student> students) {
        this.iStudents = students;
    }

    public void addToStudents(Student student) {
        if (this.iStudents == null) {
            this.iStudents = new HashSet<Student>();
        }
        this.iStudents.add(student);
    }

    @Deprecated
    public void addTostudents(Student student) {
        this.addToStudents(student);
    }

    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="xconflict_instructor", joinColumns={@JoinColumn(name="conflict_id")}, inverseJoinColumns={@JoinColumn(name="instructor_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public Set<DepartmentalInstructor> getInstructors() {
        return this.iInstructors;
    }

    public void setInstructors(Set<DepartmentalInstructor> instructors) {
        this.iInstructors = instructors;
    }

    public void addToInstructors(DepartmentalInstructor departmentalInstructor) {
        if (this.iInstructors == null) {
            this.iInstructors = new HashSet<DepartmentalInstructor>();
        }
        this.iInstructors.add(departmentalInstructor);
    }

    @Deprecated
    public void addToinstructors(DepartmentalInstructor departmentalInstructor) {
        this.addToInstructors(departmentalInstructor);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ExamConflict)) {
            return false;
        }
        if (this.getUniqueId() == null || ((ExamConflict)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((ExamConflict)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "ExamConflict[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "ExamConflict[\n\tConflictType: " + this.getConflictType() + "\n\tDistance: " + this.getDistance() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

