/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.Session;

@MappedSuperclass
public abstract class BaseEventServiceProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iReference;
    private String iLabel;
    private String iNote;
    private String iEmail;
    private Boolean iAllRooms;
    private Boolean iVisible;
    private Session iSession;
    private Department iDepartment;

    public BaseEventServiceProvider() {
    }

    public BaseEventServiceProvider(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="ref_table_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="reference", nullable=false, length=20)
    public String getReference() {
        return this.iReference;
    }

    public void setReference(String reference) {
        this.iReference = reference;
    }

    @Column(name="label", nullable=true, length=60)
    public String getLabel() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    @Column(name="note", nullable=true, length=1000)
    public String getNote() {
        return this.iNote;
    }

    public void setNote(String note) {
        this.iNote = note;
    }

    @Column(name="email", nullable=true, length=200)
    public String getEmail() {
        return this.iEmail;
    }

    public void setEmail(String email) {
        this.iEmail = email;
    }

    @Column(name="all_rooms", nullable=false)
    public Boolean isAllRooms() {
        return this.iAllRooms;
    }

    @Transient
    public Boolean getAllRooms() {
        return this.iAllRooms;
    }

    public void setAllRooms(Boolean allRooms) {
        this.iAllRooms = allRooms;
    }

    @Column(name="visible", nullable=false)
    public Boolean isVisible() {
        return this.iVisible;
    }

    @Transient
    public Boolean getVisible() {
        return this.iVisible;
    }

    public void setVisible(Boolean visible) {
        this.iVisible = visible;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="session_id", nullable=true)
    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="department_id", nullable=true)
    public Department getDepartment() {
        return this.iDepartment;
    }

    public void setDepartment(Department department) {
        this.iDepartment = department;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EventServiceProvider)) {
            return false;
        }
        if (this.getUniqueId() == null || ((EventServiceProvider)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((EventServiceProvider)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "EventServiceProvider[" + this.getUniqueId() + " " + this.getLabel() + "]";
    }

    public String toDebugString() {
        return "EventServiceProvider[\n\tAllRooms: " + this.getAllRooms() + "\n\tDepartment: " + String.valueOf(this.getDepartment()) + "\n\tEmail: " + this.getEmail() + "\n\tLabel: " + this.getLabel() + "\n\tNote: " + this.getNote() + "\n\tReference: " + this.getReference() + "\n\tSession: " + String.valueOf(this.getSession()) + "\n\tUniqueId: " + this.getUniqueId() + "\n\tVisible: " + this.getVisible() + "]";
    }
}

