/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import org.unitime.timetable.model.base.BaseVariableRangeCreditUnitConfig;

@Entity
@DiscriminatorValue(value="variableRange")
public class VariableRangeCreditUnitConfig
extends BaseVariableRangeCreditUnitConfig {
    private static final long serialVersionUID = 1L;
    public static String CREDIT_FORMAT = "variableRange";

    public VariableRangeCreditUnitConfig() {
    }

    public VariableRangeCreditUnitConfig(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public String creditText() {
        StringBuffer sb = new StringBuffer();
        sb.append(sCreditFormat.format(this.getMinUnits()));
        sb.append(" to ");
        sb.append(sCreditFormat.format(this.getMaxUnits()));
        sb.append(" ");
        sb.append(this.getCreditUnitType().getLabel());
        sb.append(" of ");
        sb.append(this.getCreditType().getLabel());
        if (this.isFractionalIncrementsAllowed() == null || this.isFractionalIncrementsAllowed().booleanValue()) {
            sb.append(" in fractional increments");
        } else {
            sb.append(" in whole number increments");
        }
        return sb.toString();
    }

    @Override
    public String creditAbbv() {
        return (this.getCreditFormatAbbv() + " " + sCreditFormat.format(this.getMinUnits()) + "-" + sCreditFormat.format(this.getMaxUnits()) + " " + this.getCreditUnitType().getAbbv() + " " + this.getCreditType().getAbbv()).trim();
    }

    @Override
    public Object clone() {
        VariableRangeCreditUnitConfig newCreditConfig = new VariableRangeCreditUnitConfig();
        this.baseClone(newCreditConfig);
        newCreditConfig.setMaxUnits(this.getMaxUnits());
        newCreditConfig.setMinUnits(this.getMinUnits());
        newCreditConfig.setFractionalIncrementsAllowed(this.isFractionalIncrementsAllowed());
        return newCreditConfig;
    }
}

