/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.query.Query;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.base.BaseStaff;
import org.unitime.timetable.model.dao.StaffDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="staff")
public class Staff
extends BaseStaff
implements Comparable,
NameInterface {
    private static final long serialVersionUID = 1L;

    public Staff() {
    }

    public Staff(Long uniqueId) {
        super(uniqueId);
    }

    public static List<Staff> getStaffByDept(String deptCode, Long acadSessionId) throws Exception {
        if (deptCode == null) {
            return null;
        }
        Query q = StaffDAO.getInstance().getSession().createQuery("select distinct s from Staff s where s.dept=:deptCode and (s.campus is null or s.campus=(select x.academicInitiative from Session x where x.uniqueId = :sessionId)) and (select di.externalUniqueId from DepartmentalInstructor di where di.department.deptCode=:deptCode and di.department.session.uniqueId=:sessionId and di.externalUniqueId = s.externalUniqueId ) is null", Staff.class);
        q.setParameter("deptCode", (Object)deptCode);
        q.setParameter("sessionId", (Object)acadSessionId);
        q.setCacheable(true);
        return q.list();
    }

    public static List<Staff> findMatchingName(String fname, String lname) {
        if (!(fname != null && fname.trim().length() != 0 || lname != null && lname.trim().length() != 0)) {
            return null;
        }
        return StaffDAO.getInstance().getSession().createQuery("from Staff where firstName like :fname and lastName like :lname", Staff.class).setParameter("fname", fname == null ? "%" : fname + "%").setParameter("lname", lname == null ? "%" : lname + "%").list();
    }

    public int compareTo(Object o) {
        int cmp;
        if (o == null || !(o instanceof Staff)) {
            return -1;
        }
        Staff i = (Staff)o;
        if (this.getPositionType() == null) {
            if (i.getPositionType() != null) {
                return 1;
            }
        } else {
            if (i.getPositionType() == null) {
                return -1;
            }
            cmp = this.getPositionType().getSortOrder().compareTo(i.getPositionType().getSortOrder());
            if (cmp != 0) {
                return cmp;
            }
        }
        if ((cmp = this.nameLastNameFirst().compareToIgnoreCase(i.nameLastNameFirst())) != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(i.getUniqueId() == null ? -1L : i.getUniqueId());
    }

    public String nameLastNameFirst() {
        return (this.getLastName() == null ? "" : this.getLastName().trim()) + ", " + (this.getFirstName() == null ? "" : this.getFirstName().trim()) + " " + (this.getMiddleName() == null ? "" : this.getMiddleName().trim());
    }

    public String getDeptName(Long sessionId) {
        if (this.getDept() == null || this.getDept().length() == 0) {
            return "N/A";
        }
        Department d = Department.findByDeptCode(this.getDept(), sessionId);
        if (d != null && (this.getCampus() == null || this.getCampus().equals(d.getSession().getAcademicInitiative()))) {
            return "<span title='" + d.getHtmlTitle() + "'>" + d.getShortLabel() + "</span>";
        }
        return this.getDept() + (String)(this.getCampus() == null ? "" : " (" + this.getCampus() + ")");
    }

    @Transient
    public String getName() {
        return Constants.toInitialCase((this.getLastName() == null ? "" : this.getLastName().trim()) + ", " + (this.getFirstName() == null ? "" : this.getFirstName().trim()) + (String)(this.getMiddleName() == null ? "" : " " + this.getMiddleName().trim()));
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }
}

