/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.base.BaseSolverPredefinedSetting;
import org.unitime.timetable.model.dao.SolverPredefinedSettingDAO;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="solver_predef_setting")
public class SolverPredefinedSetting
extends BaseSolverPredefinedSetting {
    private static final long serialVersionUID = 1L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public SolverPredefinedSetting() {
    }

    public SolverPredefinedSetting(Long uniqueId) {
        super(uniqueId);
    }

    public static SolverPredefinedSetting findByName(String name) {
        return (SolverPredefinedSetting)SolverPredefinedSettingDAO.getInstance().getSession().createQuery("from SolverPredefinedSetting where name = :name", SolverPredefinedSetting.class).setParameter("name", (Object)name).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    @Transient
    public Appearance getAppearanceType() {
        if (this.getAppearance() == null) {
            return null;
        }
        return Appearance.values()[this.getAppearance()];
    }

    public void setAppearanceType(Appearance appearance) {
        if (appearance == null) {
            this.setAppearance(null);
        } else {
            this.setAppearance(appearance.ordinal());
        }
    }

    public static enum Appearance {
        TIMETABLES,
        SOLVER,
        EXAM_SOLVER,
        STUDENT_SOLVER,
        INSTRUCTOR_SOLVER;


        @Transient
        public String getLabel() {
            switch (this) {
                case TIMETABLES: {
                    return MSG.solverConfigAppearanceTimetables();
                }
                case SOLVER: {
                    return MSG.solverConfigAppearanceSolver();
                }
                case EXAM_SOLVER: {
                    return MSG.solverConfigAppearanceExamSolver();
                }
                case STUDENT_SOLVER: {
                    return MSG.solverConfigAppearanceStudentSolver();
                }
                case INSTRUCTOR_SOLVER: {
                    return MSG.solverConfigAppearanceInstructorSolver();
                }
            }
            return this.name();
        }

        @Transient
        public SolverParameterGroup.SolverType getSolverType() {
            switch (this) {
                case TIMETABLES: 
                case SOLVER: {
                    return SolverParameterGroup.SolverType.COURSE;
                }
                case EXAM_SOLVER: {
                    return SolverParameterGroup.SolverType.EXAM;
                }
                case STUDENT_SOLVER: {
                    return SolverParameterGroup.SolverType.STUDENT;
                }
                case INSTRUCTOR_SOLVER: {
                    return SolverParameterGroup.SolverType.INSTRUCTOR;
                }
            }
            return SolverParameterGroup.SolverType.COURSE;
        }
    }
}

