/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BasePreferenceLevel;
import org.unitime.timetable.model.dao.PreferenceLevelDAO;
import org.unitime.timetable.util.Constants;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="preference_level")
public class PreferenceLevel
extends BasePreferenceLevel {
    private static final long serialVersionUID = 1L;
    public static String PREF_LEVEL_ATTR_NAME = "prefLevelsList";
    public static String PREF_LEVEL_NEUTRAL = "4";
    public static String PREF_LEVEL_REQUIRED = "1";
    private static Hashtable sPref2color = null;
    private static Hashtable sHexPref2color = null;
    private static Hashtable sAwtPref2color = null;
    private static Hashtable sBgPref2color = null;
    public static String sProhibited = "P";
    public static String sRequired = "R";
    public static String sStronglyDiscouraged = "2";
    public static String sDiscouraged = "1";
    public static String sPreferred = "-1";
    public static String sStronglyPreferred = "-2";
    public static String sNeutral = "0";
    public static String sNotAvailable = "N";
    public static final char sCharLevelProhibited = 'P';
    public static final char sCharLevelRequired = 'R';
    public static final char sCharLevelStronglyDiscouraged = '4';
    public static final char sCharLevelDiscouraged = '3';
    public static final char sCharLevelPreferred = '1';
    public static final char sCharLevelStronglyPreferred = '0';
    public static final char sCharLevelNeutral = '2';
    public static final char sCharLevelNotAvailable = 'N';
    public static int sIntLevelProhibited = Constants.sPreferenceLevelProhibited;
    public static int sIntLevelRequired = Constants.sPreferenceLevelRequired;
    public static int sIntLevelStronglyDiscouraged = Constants.sPreferenceLevelStronglyDiscouraged;
    public static int sIntLevelDiscouraged = Constants.sPreferenceLevelDiscouraged;
    public static int sIntLevelPreferred = Constants.sPreferenceLevelDiscouraged;
    public static int sIntLevelStronglyPreferred = Constants.sPreferenceLevelStronglyPreferred;
    public static int sIntLevelNeutral = Constants.sPreferenceLevelNeutral;
    public static int sIntLevelNotAvailable = Constants.sPreferenceLevelProhibited;

    public PreferenceLevel() {
    }

    public PreferenceLevel(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public static Hashtable getSAwtPref2color() {
        return sAwtPref2color;
    }

    @Transient
    public static Hashtable getSPref2color() {
        return sPref2color;
    }

    @Transient
    public static synchronized List<PreferenceLevel> getPreferenceLevelList() {
        return PreferenceLevel.getPreferenceLevelList(false);
    }

    public static synchronized List<PreferenceLevel> getPreferenceLevelList(boolean includeNotAvailable) {
        if (includeNotAvailable) {
            return PreferenceLevelDAO.getInstance().getSession().createQuery("from PreferenceLevel order by prefId", PreferenceLevel.class).setCacheable(true).list();
        }
        return PreferenceLevelDAO.getInstance().getSession().createQuery("from PreferenceLevel where prefProlog != :na order by prefId", PreferenceLevel.class).setParameter("na", (Object)sNotAvailable).setCacheable(true).list();
    }

    @Transient
    public static List<PreferenceLevel> getPreferenceLevelListSoftOnly() {
        List<PreferenceLevel> ret = PreferenceLevel.getPreferenceLevelList(false);
        Iterator<PreferenceLevel> i = ret.iterator();
        while (i.hasNext()) {
            PreferenceLevel level = i.next();
            if (!sRequired.equals(level.getPrefProlog()) && !sProhibited.equals(level.getPrefProlog())) continue;
            i.remove();
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof PreferenceLevel)) {
            return false;
        }
        return this.getPrefId().intValue() == ((PreferenceLevel)o).getPrefId().intValue();
    }

    @Override
    public int hashCode() {
        return this.getPrefId();
    }

    @Override
    public String toString() {
        return "PreferenceLevel{id=" + this.getPrefId() + ",prolog=" + this.getPrefProlog() + ",name=" + this.getPrefName() + "}";
    }

    public static PreferenceLevel getPreferenceLevel(int id) {
        for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList()) {
            if (p.getPrefId() != id) continue;
            return p;
        }
        return null;
    }

    public static PreferenceLevel getPreferenceLevel(String prologId) {
        for (PreferenceLevel p : PreferenceLevel.getPreferenceLevelList(true)) {
            if (!p.getPrefProlog().equalsIgnoreCase(prologId)) continue;
            return p;
        }
        return null;
    }

    public PreferenceLevel combine(PreferenceLevel another) {
        if (this.getPrefProlog().equals(another.getPrefProlog())) {
            return this;
        }
        if (this.getPrefProlog().equals(sProhibited) || another.getPrefProlog().equals(sProhibited)) {
            return PreferenceLevel.getPreferenceLevel(sProhibited);
        }
        if (this.getPrefProlog().equals(sRequired)) {
            return another;
        }
        if (another.getPrefProlog().equals(sRequired)) {
            return this;
        }
        return PreferenceLevel.getPreferenceLevel(String.valueOf(Math.max(Integer.parseInt(this.getPrefProlog()), Integer.parseInt(another.getPrefProlog()))));
    }

    public String prefcolor() {
        if (PreferenceLevel.getSPref2color().containsKey(this.getPrefProlog())) {
            return (String)PreferenceLevel.getSPref2color().get(this.getPrefProlog());
        }
        Debug.log("Unknown color for preference " + this.getPrefName() + ".");
        return "rgb(200,200,200)";
    }

    @Transient
    public String getDropdownOptionStyle() {
        return "background-color: " + this.prefcolor() + ";";
    }

    public String prefcolorNeutralBlack() {
        if (sNeutral.equals(this.getPrefProlog())) {
            return "black";
        }
        return this.prefcolor();
    }

    public Color awtPrefcolor() {
        if (PreferenceLevel.getSAwtPref2color().containsKey(this.getPrefProlog())) {
            return (Color)PreferenceLevel.getSAwtPref2color().get(this.getPrefProlog());
        }
        Debug.log("Unknown color for preference " + this.getPrefName() + ".");
        return new Color(200, 200, 200);
    }

    public static String int2color(int intPref) {
        return PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(intPref));
    }

    public static int prolog2int(String prologPref) {
        return Constants.preference2preferenceLevel((String)prologPref);
    }

    public static String prolog2color(String prologPref) {
        String ret = (String)sHexPref2color.get(prologPref);
        if (ret == null) {
            ret = (String)sHexPref2color.get(sNeutral);
        }
        return ret;
    }

    public static String prolog2abbv(String prologPref) {
        PreferenceLevel pref = PreferenceLevel.getPreferenceLevel(prologPref);
        return pref == null ? null : (pref.getPrefAbbv() == null ? "" : pref.getPrefAbbv());
    }

    public static String prolog2colorNohex(String prologPref) {
        String ret = (String)sPref2color.get(prologPref);
        if (ret == null) {
            ret = (String)sPref2color.get(sNeutral);
        }
        return ret;
    }

    public static Color prolog2awtColor(String prologPref) {
        Color ret = (Color)sAwtPref2color.get(prologPref);
        if (ret == null) {
            ret = (Color)sAwtPref2color.get(sNeutral);
        }
        return ret;
    }

    public static Color int2awtColor(int intPref, Color neutralPref) {
        String prologPref = PreferenceLevel.int2prolog(intPref);
        if (prologPref == null || prologPref.equals(sNeutral)) {
            return neutralPref;
        }
        return PreferenceLevel.prolog2awtColor(prologPref);
    }

    public static String int2prolog(int intPref) {
        return Constants.preferenceLevel2preference((int)intPref);
    }

    public static String int2bgColor(int intPref) {
        return PreferenceLevel.prolog2bgColor(PreferenceLevel.int2prolog(intPref));
    }

    public static String prolog2bgColor(String prologPref) {
        String ret = (String)sBgPref2color.get(prologPref);
        if (ret == null) {
            ret = (String)sBgPref2color.get(sNeutral);
        }
        return ret;
    }

    public static String prolog2string(String prologPref) {
        return PreferenceLevel.getPreferenceLevel(prologPref).getPrefName();
    }

    public static String int2string(int intPref) {
        return PreferenceLevel.prolog2string(PreferenceLevel.int2prolog(intPref));
    }

    public static char prolog2char(String prologPref) {
        if (sRequired.equals(prologPref)) {
            return 'R';
        }
        if (sStronglyPreferred.equals(prologPref)) {
            return '0';
        }
        if (sPreferred.equals(prologPref)) {
            return '1';
        }
        if (sDiscouraged.equals(prologPref)) {
            return '3';
        }
        if (sStronglyDiscouraged.equals(prologPref)) {
            return '4';
        }
        if (sProhibited.equals(prologPref)) {
            return 'P';
        }
        if (sNotAvailable.equals(prologPref)) {
            return 'N';
        }
        return '2';
    }

    public static String char2prolog(char charPref) {
        switch (charPref) {
            case 'P': {
                return sProhibited;
            }
            case '4': {
                return sStronglyDiscouraged;
            }
            case '3': {
                return sDiscouraged;
            }
            case '2': {
                return sNeutral;
            }
            case '1': {
                return sPreferred;
            }
            case '0': {
                return sStronglyPreferred;
            }
            case 'R': {
                return sRequired;
            }
            case 'N': {
                return sNotAvailable;
            }
        }
        return sNeutral;
    }

    @Transient
    public boolean isHard() {
        return sProhibited.equals(this.getPrefProlog()) || sRequired.equals(this.getPrefProlog());
    }

    @Transient
    public String getAbbreviation() {
        return this.getPrefAbbv() == null ? "" : this.getPrefAbbv();
    }

    static {
        sPref2color = new Hashtable();
        sPref2color.put(sRequired, "rgb(60,60,180)");
        sPref2color.put(sStronglyPreferred, "rgb(15,130,30)");
        sPref2color.put(sPreferred, "rgb(50,200,20)");
        sPref2color.put(sNeutral, "rgb(240,240,240)");
        sPref2color.put(sDiscouraged, "rgb(220,180,20)");
        sPref2color.put(sStronglyDiscouraged, "rgb(240,100,40)");
        sPref2color.put(sProhibited, "rgb(200,30,20)");
        sPref2color.put(sNotAvailable, "rgb(150,150,150)");
        sAwtPref2color = new Hashtable();
        sAwtPref2color.put(sRequired, new Color(60, 60, 180));
        sAwtPref2color.put(sStronglyPreferred, new Color(15, 130, 30));
        sAwtPref2color.put(sPreferred, new Color(50, 200, 20));
        sAwtPref2color.put(sNeutral, new Color(240, 240, 240));
        sAwtPref2color.put(sDiscouraged, new Color(220, 180, 20));
        sAwtPref2color.put(sStronglyDiscouraged, new Color(240, 100, 40));
        sAwtPref2color.put(sProhibited, new Color(200, 30, 20));
        sAwtPref2color.put(sNotAvailable, new Color(150, 150, 150));
        sBgPref2color = new Hashtable();
        sBgPref2color.put(sRequired, "rgb(80,80,200)");
        sBgPref2color.put(sStronglyPreferred, "rgb(30,160,60)");
        sBgPref2color.put(sPreferred, "rgb(70,230,30)");
        sBgPref2color.put(sNeutral, "rgb(240,240,240)");
        sBgPref2color.put(sDiscouraged, "rgb(240,210,60)");
        sBgPref2color.put(sStronglyDiscouraged, "rgb(240,120,60)");
        sBgPref2color.put(sProhibited, "rgb(220,50,40)");
        sBgPref2color.put(sNotAvailable, "rgb(150,150,150)");
        sHexPref2color = new Hashtable();
        sHexPref2color.put(sRequired, "#3c3cb4");
        sHexPref2color.put(sStronglyPreferred, "#0f821e");
        sHexPref2color.put(sPreferred, "#32c814");
        sHexPref2color.put(sNeutral, "#0a0a0a");
        sHexPref2color.put(sDiscouraged, "#dcb414");
        sHexPref2color.put(sStronglyDiscouraged, "#f06428");
        sHexPref2color.put(sProhibited, "#c81e14");
        sHexPref2color.put(sNotAvailable, "#696969");
    }
}

