/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseNonUniversityLocation;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.NonUniversityLocationDAO;

@Entity
@Table(name="non_university_location")
public class NonUniversityLocation
extends BaseNonUniversityLocation {
    private static final long serialVersionUID = 1L;

    public NonUniversityLocation() {
    }

    public NonUniversityLocation(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    @Transient
    public String getLabel() {
        return this.getName();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Object clone() {
        NonUniversityLocation l = new NonUniversityLocation();
        l.setCapacity(this.getCapacity());
        l.setCoordinateX(this.getCoordinateX());
        l.setCoordinateY(this.getCoordinateY());
        l.setArea(this.getArea());
        l.setDisplayName(this.getDisplayName());
        l.setName(this.getName());
        l.setIgnoreRoomCheck(this.isIgnoreRoomCheck());
        l.setIgnoreTooFar(this.isIgnoreTooFar());
        l.setPattern(this.getPattern());
        l.setSession(this.getSession());
        l.setPermanentId(this.getPermanentId());
        l.setExamCapacity(this.getExamCapacity());
        l.setExamTypes(new HashSet<ExamType>(this.getExamTypes()));
        l.setRoomType(this.getRoomType());
        l.setEventStatus(null);
        l.setBreakTime(this.getBreakTime());
        l.setNote(this.getNote());
        l.setEventEmail(this.getEventEmail());
        l.setEventAvailability(this.getEventAvailability());
        l.setExternalUniqueId(this.getExternalUniqueId());
        l.setShareNote(this.getShareNote());
        return l;
    }

    public NonUniversityLocation findSameNonUniversityLocationInSession(Session newSession) {
        if (newSession == null) {
            return null;
        }
        NonUniversityLocation newNonUniversityLocation = (NonUniversityLocation)NonUniversityLocationDAO.getInstance().getSession().createQuery("from NonUniversityLocation where permanentId = :permanentId and session.uniqueId = :sessionId", NonUniversityLocation.class).setParameter("permanentId", (Object)this.getPermanentId()).setParameter("sessionId", (Object)newSession.getUniqueId()).setCacheable(true).uniqueResult();
        if (newNonUniversityLocation == null && this.getExternalUniqueId() != null) {
            newNonUniversityLocation = (NonUniversityLocation)NonUniversityLocationDAO.getInstance().getSession().createQuery("from NonUniversityLocation where externalUniqueId = :externalUniqueId and session.uniqueId = :sessionId", NonUniversityLocation.class).setParameter("externalUniqueId", (Object)this.getExternalUniqueId()).setParameter("sessionId", (Object)newSession.getUniqueId()).setCacheable(true).uniqueResult();
        }
        return newNonUniversityLocation;
    }

    @Override
    @Transient
    public List<Location> getFutureLocations() {
        ArrayList<Location> ret = new ArrayList<Location>();
        HashSet<Long> futureSessionIds = new HashSet<Long>();
        HashSet<Long> blackListedSessionIds = new HashSet<Long>();
        for (Location location : LocationDAO.getInstance().getSession().createQuery("select f from NonUniversityLocation l, NonUniversityLocation f where l.uniqueId = :uniqueId and l.session.academicInitiative = f.session.academicInitiative and l.session.sessionBeginDateTime < f.session.sessionBeginDateTime and ((l.permanentId = f.permanentId) or (not exists (from Location x where x.permanentId = f.permanentId and x.session = l.session) and l.roomType = f.roomType and ((length(f.externalUniqueId) > 0 and l.externalUniqueId = f.externalUniqueId) or ((f.externalUniqueId is null or length(f.externalUniqueId) = 0) and (l.externalUniqueId is null or length(l.externalUniqueId) = 0) and f.name = l.name and f.capacity = l.capacity)))) order by f.session.sessionBeginDateTime", Location.class).setParameter("uniqueId", (Object)this.getUniqueId()).setCacheable(true).list()) {
            if (futureSessionIds.add(location.getSession().getUniqueId())) {
                ret.add(location);
                continue;
            }
            blackListedSessionIds.add(location.getSession().getUniqueId());
        }
        if (!blackListedSessionIds.isEmpty()) {
            Iterator i = ret.iterator();
            while (i.hasNext()) {
                Location location;
                location = (Location)i.next();
                if (!blackListedSessionIds.contains(location.getSession().getUniqueId())) continue;
                i.remove();
            }
        }
        return ret;
    }

    @Override
    @Transient
    public Set<? extends LocationPicture> getRoomPictures() {
        return this.getPictures();
    }
}

