/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.base.BaseInstructorSurvey;
import org.unitime.timetable.model.dao.InstructorSurveyDAO;

@Entity
@Table(name="instructor_survey")
public class InstructorSurvey
extends BaseInstructorSurvey {
    private static final long serialVersionUID = 6737724550632383507L;

    @Override
    public String htmlLabel() {
        return null;
    }

    @Override
    @Transient
    public Department getDepartment() {
        return null;
    }

    public static InstructorSurvey getInstructorSurvey(String externalUniqueId, Long sessionId) {
        return (InstructorSurvey)InstructorSurveyDAO.getInstance().getSession().createQuery("from InstructorSurvey where session.uniqueId = :sessionId and externalUniqueId = :externalId", InstructorSurvey.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalUniqueId).setMaxResults(1).uniqueResult();
    }

    public static InstructorSurvey getInstructorSurvey(DepartmentalInstructor di) {
        if (di.getExternalUniqueId() == null || di.getExternalUniqueId().isEmpty()) {
            return null;
        }
        return InstructorSurvey.getInstructorSurvey(di.getExternalUniqueId(), di.getDepartment().getSessionId());
    }

    public static boolean hasInstructorSurveys(Long departmentId) {
        return ((Number)InstructorSurveyDAO.getInstance().getSession().createQuery("select count(s) from DepartmentalInstructor di, InstructorSurvey s where s.session = di.department.session and s.externalUniqueId = di.externalUniqueId and di.department.uniqueId = :deptId", Number.class).setParameter("deptId", (Object)departmentId).setCacheable(true).uniqueResult()).intValue() > 0;
    }

    public static Map<String, InstructorSurvey> getInstructorSurveysForDepartment(Long departmentId) {
        HashedMap ret = new HashedMap();
        for (InstructorSurvey is : InstructorSurveyDAO.getInstance().getSession().createQuery("select s from DepartmentalInstructor di, InstructorSurvey s where s.session = di.department.session and s.externalUniqueId = di.externalUniqueId and di.department.uniqueId = :deptId", InstructorSurvey.class).setParameter("deptId", (Object)departmentId).setCacheable(true).list()) {
            ret.put(is.getExternalUniqueId(), is);
        }
        return ret;
    }

    public DepartmentalInstructor getInstructor(InstructionalOffering io) {
        HashMap<Department, DepartmentalInstructor> ret = new HashMap<Department, DepartmentalInstructor>();
        DepartmentalInstructor match = null;
        for (DepartmentalInstructor di : InstructorSurveyDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId = :extId and department.session.uniqueId = :sessionId", DepartmentalInstructor.class).setParameter("extId", (Object)this.getExternalUniqueId()).setParameter("sessionId", (Object)io.getSessionId()).setCacheable(true).list()) {
            if (di.getDepartment().equals(io.getDepartment())) {
                match = di;
                break;
            }
            ret.put(di.getDepartment(), di);
        }
        if (match != null) {
            return match;
        }
        if (ret.isEmpty()) {
            return null;
        }
        if (ret.size() == 1) {
            return (DepartmentalInstructor)ret.entrySet().iterator().next().getValue();
        }
        for (CourseOffering co : io.getCourseOfferings()) {
            DepartmentalInstructor di = (DepartmentalInstructor)ret.get(co.getDepartment());
            if (di == null) continue;
            return di;
        }
        return (DepartmentalInstructor)ret.entrySet().iterator().next().getValue();
    }
}

