/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseCourseOffering;
import org.unitime.timetable.model.base.BaseInstructionalOffering;
import org.unitime.timetable.model.comparators.CourseOfferingComparator;
import org.unitime.timetable.model.comparators.InstructionalOfferingComparator;
import org.unitime.timetable.model.comparators.NavigationComparator;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.InstrOfferingPermIdGenerator;
import org.unitime.timetable.webutil.Navigation;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="instructional_offering")
public class InstructionalOffering
extends BaseInstructionalOffering {
    private static final long serialVersionUID = 1L;
    private CourseOffering controllingCourseOffering = null;

    public InstructionalOffering() {
    }

    public InstructionalOffering(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public String getCourseName() {
        return this.getControllingCourseOffering() == null ? "missing course name" : this.getControllingCourseOffering().getCourseName();
    }

    @Transient
    public String getCourseNameWithTitle() {
        return this.getControllingCourseOffering().getCourseNameWithTitle();
    }

    public boolean removeCourseOffering(CourseOffering co) {
        Set<CourseOffering> s = this.getCourseOfferings();
        Iterator<CourseOffering> it = s.iterator();
        CourseOffering tempCo = null;
        while (it.hasNext()) {
            tempCo = it.next();
            if (tempCo.getUniqueId().intValue() != co.getUniqueId().intValue()) continue;
            Debug.debug("Removing course from instructional offering");
            s.remove(tempCo);
            tempCo.setInstructionalOffering(null);
            this.setCourseOfferings(s);
            return true;
        }
        return false;
    }

    public CourseOffering findSortCourseOfferingForSubjectArea(Long subjectAreaUniqueId) {
        CourseOffering controlingCourseOffering = this.getControllingCourseOffering();
        if (controlingCourseOffering != null && (subjectAreaUniqueId == null || subjectAreaUniqueId.equals(controlingCourseOffering.getSubjectArea().getUniqueId()))) {
            return controlingCourseOffering;
        }
        BaseCourseOffering minCo = null;
        for (CourseOffering co : this.getCourseOfferings()) {
            if (subjectAreaUniqueId != null && !co.getSubjectArea().getUniqueId().equals(subjectAreaUniqueId) || minCo != null && minCo.getCourseNbr().compareTo(co.getCourseNbr()) >= 0) continue;
            minCo = co;
        }
        return minCo;
    }

    public CourseOffering findSortCourseOfferingForSubjectArea(SubjectArea subjectArea) {
        return this.findSortCourseOfferingForSubjectArea(subjectArea.getUniqueId());
    }

    public TreeSet<CourseOffering> courseOfferingsMinusSortCourseOfferingForSubjectArea(Long subjectAreaUID) {
        CourseOffering co = this.findSortCourseOfferingForSubjectArea(subjectAreaUID);
        TreeSet<CourseOffering> crsOffrs = new TreeSet<CourseOffering>(new CourseOfferingComparator());
        for (CourseOffering tmpCo : this.getCourseOfferings()) {
            if (tmpCo.getUniqueId().equals(co.getUniqueId())) continue;
            crsOffrs.add(tmpCo);
        }
        return crsOffrs;
    }

    public TreeSet courseOfferingsMinusSortCourseOfferingForSubjectArea(SubjectArea subjectArea) {
        return this.courseOfferingsMinusSortCourseOfferingForSubjectArea(subjectArea.getUniqueId());
    }

    @Override
    @Transient
    public Boolean getNotOffered() {
        return this.isNotOffered();
    }

    @Transient
    public Department getDepartment() {
        CourseOffering course = this.getControllingCourseOffering();
        return course == null ? null : course.getDepartment();
    }

    @Transient
    public Department getManagingDept() {
        CourseOffering course = this.getControllingCourseOffering();
        return course == null ? null : course.getManagingDept();
    }

    @Transient
    public CourseOffering getControllingCourseOffering() {
        if (this.controllingCourseOffering == null && this.getCourseOfferings() != null && this.getCourseOfferings().size() > 0) {
            Iterator<CourseOffering> it = this.getCourseOfferings().iterator();
            CourseOffering co = null;
            while (this.controllingCourseOffering == null && it.hasNext()) {
                co = it.next();
                if (!co.isIsControl().booleanValue()) continue;
                this.controllingCourseOffering = co;
            }
        }
        return this.controllingCourseOffering;
    }

    @Override
    public String toString() {
        return this.getControllingCourseOffering().getCourseName();
    }

    public static TreeSet<InstructionalOffering> search(Long acadSessionId, Long subjectAreaId, String courseNbr, boolean fetchStructure, boolean fetchCredits, boolean fetchInstructors, boolean fetchPreferences, boolean fetchAssignments, boolean fetchReservations) {
        return InstructionalOffering.search(acadSessionId, subjectAreaId, courseNbr, fetchStructure, fetchCredits, fetchInstructors, fetchPreferences, fetchAssignments, fetchReservations, null);
    }

    public static TreeSet<InstructionalOffering> search(Long acadSessionId, Long subjectAreaId, String courseNbr, boolean fetchStructure, boolean fetchCredits, boolean fetchInstructors, boolean fetchPreferences, boolean fetchAssignments, boolean fetchReservations, String filterWaitList) {
        Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
        StringBuffer query = new StringBuffer();
        query.append("select distinct io ");
        query.append(" from InstructionalOffering as io inner join io.courseOfferings as co ");
        if (fetchStructure) {
            query.append("left join fetch io.courseOfferings as cox ");
            query.append("left join fetch io.instrOfferingConfigs as ioc ");
            query.append("left join fetch ioc.schedulingSubparts as ss ");
            query.append("left join fetch ss.classes as c ");
            query.append("left join fetch ss.childSubparts as css ");
            query.append("left join fetch c.childClasses as cc ");
        }
        if (fetchCredits) {
            query.append("left join fetch ss.creditConfigs as ssc ");
        }
        if (fetchPreferences || fetchInstructors) {
            query.append("left join fetch c.classInstructors as ci ");
            query.append("left join fetch ci.instructor as di ");
        }
        if (fetchAssignments) {
            query.append("left join fetch c.assignments as ca ");
            query.append("left join fetch ca.rooms as car ");
        }
        if (fetchPreferences) {
            query.append("left join fetch c.preferences as cp ");
            query.append("left join fetch ss.preferences as ssp ");
            query.append("left join fetch di.preferences as dip ");
        }
        if (fetchReservations) {
            query.append("left join fetch ioc.individualReservations as ir ");
            query.append("left join fetch ioc.studentGroupReservations as sgr ");
            query.append("left join fetch ioc.acadAreaReservations as aar ");
            query.append("left join fetch ioc.posReservations as pr ");
        }
        query.append(" where io.session.uniqueId=:sessionId ");
        if (ApplicationProperty.CourseOfferingTitleSearch.isTrue() && courseNbr != null && courseNbr.length() > 2) {
            if (courseNbr.indexOf(42) >= 0) {
                query.append(" and (co.courseNbr like :courseNbr or lower(co.title) like lower(:courseNbr))");
            } else {
                query.append(" and (co.courseNbr = :courseNbr or lower(co.title) like ('%' || lower(:courseNbr) || '%'))");
            }
        } else if (courseNbr != null && courseNbr.length() > 0) {
            if (courseNbr.indexOf(42) >= 0) {
                query.append(" and co.courseNbr like :courseNbr ");
            } else {
                query.append(" and co.courseNbr = :courseNbr ");
            }
        }
        if ("W".equals(filterWaitList)) {
            if (InstructionalOffering.getDefaultWaitListMode() == OfferingWaitListMode.WaitList) {
                query.append(" and (io.waitlistMode is null or io.waitlistMode = 1) and io.notOffered = false");
            } else {
                query.append(" and io.waitlistMode = 1 and io.notOffered = false");
            }
        } else if ("N".equals(filterWaitList)) {
            if (InstructionalOffering.getDefaultWaitListMode() != OfferingWaitListMode.WaitList) {
                query.append(" and (io.waitlistMode is null or io.waitlistMode != 1) and io.notOffered = false");
            } else {
                query.append(" and io.waitlistMode != 1 and io.notOffered = false");
            }
        } else if ("R".equals(filterWaitList)) {
            if (InstructionalOffering.getDefaultWaitListMode() != OfferingWaitListMode.Disabled) {
                query.append(" and (io.waitlistMode is null or io.waitlistMode > 0) and io.notOffered = false");
            } else {
                query.append(" and io.waitlistMode > 0 and io.notOffered = false");
            }
        } else if ("X".equals(filterWaitList)) {
            if (InstructionalOffering.getDefaultWaitListMode() == OfferingWaitListMode.Disabled) {
                query.append(" and (io.waitlistMode is null or io.waitlistMode = 0) and io.notOffered = false");
            } else {
                query.append(" and io.waitlistMode = 0 and io.notOffered = false");
            }
        } else if ("Z".equals(filterWaitList)) {
            if (InstructionalOffering.getDefaultWaitListMode() == OfferingWaitListMode.ReSchedule) {
                query.append(" and (io.waitlistMode is null or io.waitlistMode = 2) and io.notOffered = false");
            } else {
                query.append(" and io.waitlistMode = 2 and io.notOffered = false");
            }
        }
        query.append(" and co.subjectArea.uniqueId = :subjectAreaId ");
        Query q = hibSession.createQuery(query.toString(), InstructionalOffering.class);
        q.setFetchSize(1000);
        q.setParameter("subjectAreaId", (Object)subjectAreaId);
        q.setParameter("sessionId", (Object)acadSessionId);
        if (courseNbr != null && courseNbr.length() > 0) {
            if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
                courseNbr = courseNbr.toUpperCase();
            }
            q.setParameter("courseNbr", (Object)courseNbr.replace('*', '%'));
        }
        q.setCacheable(true);
        TreeSet<InstructionalOffering> ts = new TreeSet<InstructionalOffering>(new InstructionalOfferingComparator((long)subjectAreaId));
        long sTime = new Date().getTime();
        ts.addAll(q.list());
        long eTime = new Date().getTime();
        Debug.debug("fetch time = " + (eTime - sTime));
        return ts;
    }

    public void deleteAllClasses(Session hibSession) {
        Set<InstrOfferingConfig> sIoc = this.getInstrOfferingConfigs();
        for (InstrOfferingConfig tIoc : sIoc) {
            Set<SchedulingSubpart> sSp = tIoc.getSchedulingSubparts();
            for (SchedulingSubpart tSp : sSp) {
                Set<Class_> sCl = tSp.getClasses();
                for (Class_ c : sCl) {
                    Set<ClassInstructor> classInstrs = c.getClassInstructors();
                    for (ClassInstructor ci : classInstrs) {
                        DepartmentalInstructor instr = ci.getInstructor();
                        instr.removeClassInstructor(ci);
                        hibSession.remove((Object)ci);
                    }
                    Event.deleteFromEvents(hibSession, c);
                    Exam.deleteFromExams(hibSession, c);
                    hibSession.remove((Object)c);
                }
                tSp.getClasses().clear();
            }
            Event.deleteFromEvents(hibSession, tIoc);
            Exam.deleteFromExams(hibSession, tIoc);
        }
    }

    public void deleteAllDistributionPreferences(Session hibSession) {
        for (InstrOfferingConfig cfg : this.getInstrOfferingConfigs()) {
            for (SchedulingSubpart ss : cfg.getSchedulingSubparts()) {
                ss.deleteAllDistributionPreferences(hibSession);
            }
        }
    }

    public InstructionalOffering getNextInstructionalOffering(SessionContext context) {
        return this.getNextInstructionalOffering(context, new NavigationComparator());
    }

    public InstructionalOffering getPreviousInstructionalOffering(SessionContext context) {
        return this.getPreviousInstructionalOffering(context, new NavigationComparator());
    }

    public InstructionalOffering getNextInstructionalOffering(SessionContext context, Comparator cmp) {
        Long nextId = Navigation.getNext(context, Navigation.sInstructionalOfferingLevel, this.getUniqueId());
        if (nextId != null) {
            if (nextId < 0L) {
                return null;
            }
            return (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(nextId);
        }
        InstructionalOffering next = null;
        SubjectArea area = this.getControllingCourseOffering().getSubjectArea();
        Iterator<CourseOffering> i = null;
        try {
            i = area.getCourseOfferings().iterator();
        }
        catch (ObjectNotFoundException e) {
            new _RootDAO().getSession().refresh((Object)area);
            i = area.getCourseOfferings().iterator();
        }
        while (i.hasNext()) {
            InstructionalOffering o;
            CourseOffering c = i.next();
            if (c == null || !c.isIsControl().booleanValue() || !(o = c.getInstructionalOffering()).isNotOffered().equals(this.isNotOffered()) || cmp.compare(this, o) >= 0 || next != null && cmp.compare(next, o) <= 0) continue;
            next = o;
        }
        return next;
    }

    public InstructionalOffering getPreviousInstructionalOffering(SessionContext context, Comparator cmp) {
        Long previousId = Navigation.getPrevious(context, Navigation.sInstructionalOfferingLevel, this.getUniqueId());
        if (previousId != null) {
            if (previousId < 0L) {
                return null;
            }
            return (InstructionalOffering)InstructionalOfferingDAO.getInstance().get(previousId);
        }
        InstructionalOffering previous = null;
        SubjectArea area = this.getControllingCourseOffering().getSubjectArea();
        Iterator<CourseOffering> i = null;
        try {
            i = area.getCourseOfferings().iterator();
        }
        catch (ObjectNotFoundException e) {
            new _RootDAO().getSession().refresh((Object)area);
            i = area.getCourseOfferings().iterator();
        }
        while (i.hasNext()) {
            InstructionalOffering o;
            CourseOffering c = i.next();
            if (c == null || !c.isIsControl().booleanValue() || !(o = c.getInstructionalOffering()).isNotOffered().equals(this.isNotOffered()) || cmp.compare(this, o) <= 0 || previous != null && cmp.compare(previous, o) >= 0) continue;
            previous = o;
        }
        return previous;
    }

    public void removeConfiguration(InstrOfferingConfig ioc) {
        Set<InstrOfferingConfig> configs = this.getInstrOfferingConfigs();
        Iterator<InstrOfferingConfig> i = configs.iterator();
        while (i.hasNext()) {
            InstrOfferingConfig config = i.next();
            if (!config.equals(ioc)) continue;
            i.remove();
            break;
        }
    }

    public boolean existsConfig(String name, Long configId) {
        Set<InstrOfferingConfig> configs = this.getInstrOfferingConfigs();
        for (InstrOfferingConfig config : configs) {
            if (config.getName() == null || !config.getName().equals(name.trim()) || config.getUniqueId().equals(configId)) continue;
            return true;
        }
        return false;
    }

    public static List<InstructionalOffering> findAll(Long sessionId) {
        return InstructionalOfferingDAO.getInstance().getSession().createQuery("select distinct io from InstructionalOffering io where io.session.uniqueId=:sessionId", InstructionalOffering.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public void computeLabels(Session hibSession) {
        hibSession.flush();
        for (InstrOfferingConfig cfg : this.getInstrOfferingConfigs()) {
            for (SchedulingSubpart ss : cfg.getSchedulingSubparts()) {
                ss.setSchedulingSubpartSuffixCache(null);
                ss.getSchedulingSubpartSuffix(false);
                hibSession.merge((Object)ss);
                for (Class_ c : ss.getClasses()) {
                    c.setSectionNumberCache(null);
                    c.getSectionNumber(false);
                    hibSession.merge((Object)c);
                }
            }
        }
    }

    public int getNrClasses(ItypeDesc itype) {
        int ret = 0;
        for (InstrOfferingConfig cfg : this.getInstrOfferingConfigs()) {
            for (SchedulingSubpart subpart : cfg.getSchedulingSubparts()) {
                if (!subpart.getItype().equals(itype)) continue;
                ret += subpart.getClasses().size();
            }
        }
        return ret;
    }

    @Transient
    public Long getSessionId() {
        if (this.getSession() != null) {
            return this.getSession().getSessionId();
        }
        return null;
    }

    public boolean hasGroupedClasses() {
        if (this.getInstrOfferingConfigs() != null && this.getInstrOfferingConfigs().size() > 0) {
            InstrOfferingConfig ioc2 = null;
            for (InstrOfferingConfig ioc2 : this.getInstrOfferingConfigs()) {
                if (!ioc2.hasGroupedClasses()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMultipleConfigurations() {
        return this.getInstrOfferingConfigs().size() > 1;
    }

    public void generateInstrOfferingPermId() throws HibernateException {
        this.setInstrOfferingPermId((Long)InstrOfferingPermIdGenerator.getGenerator().generate((SharedSessionContractImplementor)((SessionImplementor)InstructionalOfferingDAO.getInstance().getSession()), this));
    }

    public Boolean hasUnlimitedEnrollment() {
        Iterator<InstrOfferingConfig> i = this.getInstrOfferingConfigs().iterator();
        while (i.hasNext()) {
            if (!i.next().isUnlimitedEnrollment().booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean hasClasses() {
        for (InstrOfferingConfig ioc : this.getInstrOfferingConfigs()) {
            if (!ioc.hasClasses()) continue;
            return true;
        }
        return false;
    }

    public void deleteAllCourses(Session hibSession) {
        for (CourseOffering co : this.getCourseOfferings()) {
            Event.deleteFromEvents(hibSession, co);
            Exam.deleteFromExams(hibSession, co);
            hibSession.remove((Object)co);
        }
    }

    public void cloneOfferingConfigurationFrom(InstructionalOffering instrOffrToCloneFrom) {
        if (instrOffrToCloneFrom == null || instrOffrToCloneFrom.getInstrOfferingConfigs() == null) {
            return;
        }
        if (this.getInstrOfferingConfigs() != null) {
            this.getInstrOfferingConfigs().clear();
        }
        this.setNotOffered(instrOffrToCloneFrom.getNotOffered());
        InstrOfferingConfig origIoc2 = null;
        InstrOfferingConfig newIoc = null;
        for (InstrOfferingConfig origIoc2 : instrOffrToCloneFrom.getInstrOfferingConfigs()) {
            newIoc = (InstrOfferingConfig)origIoc2.cloneWithSubparts();
            newIoc.setInstructionalOffering(this);
            if (!this.getControllingCourseOffering().getSubjectArea().getUniqueId().equals(instrOffrToCloneFrom.getControllingCourseOffering().getSubjectArea().getUniqueId())) {
                Department controlDept = this.getControllingCourseOffering().getSubjectArea().getDepartment();
                SchedulingSubpart ss2 = null;
                Class_ c2 = null;
                if (newIoc.getSchedulingSubparts() != null) {
                    for (SchedulingSubpart ss2 : newIoc.getSchedulingSubparts()) {
                        if (ss2.getClasses() == null) continue;
                        for (Class_ c2 : ss2.getClasses()) {
                            if (c2.getManagingDept() == null || c2.getManagingDept().getUniqueId().equals(controlDept.getUniqueId()) || c2.getManagingDept().isExternalManager().booleanValue()) continue;
                            c2.setManagingDept(controlDept);
                            if (c2.getClassInstructors() == null || c2.getClassInstructors().isEmpty()) continue;
                            DepartmentalInstructor di = null;
                            ClassInstructor ci2 = null;
                            ArrayList<ClassInstructor> al = new ArrayList<ClassInstructor>();
                            al.addAll(c2.getClassInstructors());
                            for (ClassInstructor ci2 : al) {
                                di = DepartmentalInstructor.findByPuidDepartmentId(ci2.getInstructor().getExternalUniqueId(), controlDept.getUniqueId());
                                if (di != null) {
                                    ci2.getInstructor().getClasses().remove(ci2);
                                    ci2.setInstructor(di);
                                    di.addToClasses(ci2);
                                    continue;
                                }
                                c2.getClassInstructors().remove(ci2);
                                ci2.setClassInstructing(null);
                            }
                        }
                    }
                }
            }
            this.addToInstrOfferingConfigs(newIoc);
        }
    }

    public static InstructionalOffering findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (InstructionalOffering)InstructionalOfferingDAO.getInstance().getSession().createQuery("select io from InstructionalOffering io where io.session.uniqueId=:sessionId and io.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom", InstructionalOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("uniqueIdRolledForwardFrom", (Object)uniqueIdRolledForwardFrom).setCacheable(true).uniqueResult();
    }

    @Transient
    public Integer getProjectedDemand() {
        int demand = 0;
        for (CourseOffering course : this.getCourseOfferings()) {
            if (course.getProjectedDemand() == null) continue;
            demand += course.getProjectedDemand().intValue();
        }
        return demand;
    }

    @Transient
    public int getUnreservedSpace() {
        int available = 0;
        for (InstrOfferingConfig config : this.getInstrOfferingConfigs()) {
            available += config.getLimit() - config.getEnrollment();
            if (!config.isUnlimitedEnrollment().booleanValue()) continue;
            for (Reservation r : this.getReservations()) {
                if (r.isExpired() || r.getReservationLimit() >= 0) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        int reserved = 0;
        for (Reservation r : this.getReservations()) {
            if (r.isExpired()) continue;
            if (r.getReservationLimit() < 0) {
                return 0;
            }
            reserved = (int)((double)reserved + Math.max(0.0, (double)r.getReservedAvailableSpace()));
        }
        return available - reserved;
    }

    @Transient
    public boolean isAllowStudentScheduling() {
        for (CourseOffering course : this.getCourseOfferings()) {
            if (!course.isAllowStudentScheduling()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCrossList() {
        return this.getCourseOfferings().size() > 1;
    }

    @Transient
    public OfferingWaitListMode getEffectiveWaitListMode() {
        if (this.getWaitlistMode() != null) {
            return this.getWaitListMode();
        }
        return InstructionalOffering.getDefaultWaitListMode();
    }

    public boolean effectiveWaitList() {
        return this.getEffectiveWaitListMode().isWaitlist();
    }

    public boolean effectiveReSchedule() {
        return this.getEffectiveWaitListMode().isReschedule();
    }

    public boolean effectiveReScheduleNow() {
        return this.getEffectiveWaitListMode().isReschedule() && StudentSectioningStatus.hasEffectiveOption(null, this.getSession(), StudentSectioningStatus.Option.reschedule, StudentSectioningStatus.Option.enrollment) && this.getSession() != null && this.getSession().canOnlineSectionStudents();
    }

    public boolean effectiveWaitListNow() {
        return this.getEffectiveWaitListMode().isWaitlist() && StudentSectioningStatus.hasEffectiveOption(null, this.getSession(), StudentSectioningStatus.Option.waitlist, StudentSectioningStatus.Option.enrollment) && this.getSession() != null && this.getSession().canOnlineSectionStudents();
    }

    @Transient
    public Department getEffectiveFundingDept() {
        return this.getControllingCourseOffering().getEffectiveFundingDept();
    }

    @Transient
    public static OfferingWaitListMode getDefaultWaitListMode() {
        String value = ApplicationProperty.OfferingWaitListDefault.value();
        if ("waitlist".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            return OfferingWaitListMode.WaitList;
        }
        if ("reschedule".equalsIgnoreCase(value)) {
            return OfferingWaitListMode.ReSchedule;
        }
        return OfferingWaitListMode.Disabled;
    }

    @Transient
    public OfferingWaitListMode getWaitListMode() {
        if (this.getWaitlistMode() == null) {
            return OfferingWaitListMode.Disabled;
        }
        return OfferingWaitListMode.values()[this.getWaitlistMode()];
    }

    public void setWaitListMode(OfferingWaitListMode mode) {
        if (mode == null) {
            this.setWaitlistMode(null);
        } else {
            this.setWaitlistMode(mode.ordinal());
        }
    }

    @Transient
    public Boolean isWaitlist() {
        return this.getWaitListMode().isWaitlist();
    }

    @Transient
    public Boolean getWaitlist() {
        return this.getWaitListMode().isWaitlist();
    }

    @Transient
    public Boolean isReschedule() {
        return this.getWaitListMode().isReschedule();
    }

    @Transient
    public Integer getLimit() {
        if (this.getInstrOfferingConfigs() == null || this.getInstrOfferingConfigs().isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (InstrOfferingConfig config : this.getInstrOfferingConfigs()) {
            if (config.isUnlimitedEnrollment().booleanValue()) continue;
            ret += config.getLimit().intValue();
        }
        return ret;
    }

    @Transient
    public Integer getDemand() {
        if (this.getCourseOfferings() == null || this.getCourseOfferings().isEmpty()) {
            return 0;
        }
        int ret = 0;
        for (CourseOffering co : this.getCourseOfferings()) {
            ret += co.getDemand().intValue();
            if (co.getDemandOffering() == null) continue;
            ret += co.getDemandOffering().getDemand().intValue();
        }
        return ret;
    }

    public static enum OfferingWaitListMode {
        Disabled,
        WaitList,
        ReSchedule;


        @Transient
        public boolean isWaitlist() {
            return this == WaitList;
        }

        @Transient
        public boolean isReschedule() {
            return this == WaitList || this == ReSchedule;
        }
    }
}

