/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.util.TreeMap;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BaseGlobalRoomFeature;
import org.unitime.timetable.model.dao.GlobalRoomFeatureDAO;

@Entity
@DiscriminatorValue(value="global")
public class GlobalRoomFeature
extends BaseGlobalRoomFeature {
    private static final long serialVersionUID = 1L;
    public static TreeMap sisFeatureMap = null;

    public GlobalRoomFeature() {
    }

    public GlobalRoomFeature(Long uniqueId) {
        super(uniqueId);
    }

    public static String featureTypeDisplayString() {
        return "Global";
    }

    public static GlobalRoomFeature featureWithSisReference(Session session, String sisReference) {
        for (GlobalRoomFeature grf : RoomFeature.getAllGlobalRoomFeatures(session)) {
            if (!sisReference.equals(grf.getSisReference())) continue;
            return grf;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public static GlobalRoomFeature findGlobalRoomFeatureForLabel(Session session, String label) {
        return (GlobalRoomFeature)GlobalRoomFeatureDAO.getInstance().getSession().createQuery("from GlobalRoomFeature where label = :label and session.uniqueId = :sessionId", GlobalRoomFeature.class).setParameter("label", (Object)label).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public static GlobalRoomFeature findGlobalRoomFeatureForAbbv(Session session, String label) {
        return (GlobalRoomFeature)GlobalRoomFeatureDAO.getInstance().getSession().createQuery("from GlobalRoomFeature where abbv = :label and session.uniqueId = :sessionId", GlobalRoomFeature.class).setParameter("label", (Object)label).setParameter("sessionId", (Object)session.getUniqueId()).setCacheable(true).setMaxResults(1).uniqueResult();
    }

    public String htmlLabel() {
        return "<span title='" + this.getLabel() + " (" + (this.getFeatureType() == null ? "global" : this.getFeatureType().getReference()) + ")'>" + this.getLabel() + (String)(this.getFeatureType() == null ? "" : " (" + this.getFeatureType().getReference() + ")") + "</span>";
    }

    public Object clone() {
        GlobalRoomFeature newFeature = new GlobalRoomFeature();
        newFeature.setLabel(this.getLabel());
        newFeature.setAbbv(this.getAbbv());
        newFeature.setSession(this.getSession());
        newFeature.setSisReference(this.getSisReference());
        newFeature.setSisValue(this.getSisValue());
        newFeature.setFeatureType(this.getFeatureType());
        return newFeature;
    }
}

