/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Month;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.hibernate.FlushMode;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectNotFoundException;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributeType;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseDepartmentalInstructor;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;
import org.unitime.timetable.webutil.Navigation;

@Entity
@Table(name="departmental_instructor")
public class DepartmentalInstructor
extends BaseDepartmentalInstructor
implements Comparable,
NameInterface {
    private static final long serialVersionUID = 1L;
    protected static GwtConstants CONS = Localization.create(GwtConstants.class);
    public static String INSTR_LIST_ATTR_NAME = "instructorsList";
    public static String INSTR_HAS_PREF_ATTR_NAME = "instructorsHasPrefs";
    public static String INSTRDEPT_LIST_ATTR_NAME = "instructorDeptList";
    public static final String sNameFormatLastFist = NameFormat.LAST_FIRST.reference();
    public static final String sNameFormatFirstLast = NameFormat.FIRST_LAST.reference();
    public static final String sNameFormatInitialLast = NameFormat.INITIAL_LAST.reference();
    public static final String sNameFormatLastInitial = NameFormat.LAST_INITIAL.reference();
    public static final String sNameFormatFirstMiddleLast = NameFormat.FIRST_MIDDLE_LAST.reference();
    public static final String sNameFormatLastFirstMiddle = NameFormat.LAST_FIRST_MIDDLE.reference();
    public static final String sNameFormatShort = NameFormat.SHORT.reference();

    public DepartmentalInstructor() {
    }

    public DepartmentalInstructor(Long uniqueId) {
        super(uniqueId);
    }

    public String nameLastNameFirst() {
        return this.nameLastFirstMiddle();
    }

    public String nameFirstNameFirst() {
        return Constants.toInitialCase((this.hasFirstName() ? this.getFirstName() : "") + (String)(this.hasMiddleName() ? " " + this.getMiddleName() : "") + (String)(this.hasLastName() ? " " + this.getLastName() : "")).trim();
    }

    public String nameShort() {
        return (String)(this.hasFirstName() ? this.getFirstName().substring(0, 1).toUpperCase() + ". " : "") + ((String)(this.hasLastName() ? this.getLastName().substring(0, 1).toUpperCase() + this.getLastName().substring(1, Math.min(10, this.getLastName().length())).toLowerCase() : "")).trim();
    }

    @Transient
    public String getNameFirst() {
        return this.nameFirstNameFirst();
    }

    @Transient
    public String getNameLast() {
        return this.nameLastNameFirst();
    }

    @Transient
    public String getNameLastFirst() {
        return this.nameLastFirst();
    }

    @Transient
    public String getNameInitLast() {
        return this.nameInitLast();
    }

    private String nameInitLast() {
        return ((this.hasFirstName() ? this.getFirstName().trim().substring(0, 1).toUpperCase() : "") + (String)(this.hasMiddleName() ? " " + this.getMiddleName().trim().substring(0, 1).toUpperCase() : "") + (String)(this.hasLastName() ? " " + Constants.toInitialCase(this.getLastName()) : "")).trim();
    }

    private String nameLastFirst() {
        return Constants.toInitialCase((this.hasLastName() ? this.getLastName() : "") + (String)(this.hasFirstName() ? ", " + this.getFirstName() : "")).trim();
    }

    public String nameFirstLast() {
        return Constants.toInitialCase((this.hasFirstName() ? this.getFirstName() : "") + (String)(this.hasLastName() ? " " + this.getLastName() : "")).trim();
    }

    public String getName(String instructorNameFormat) {
        return NameFormat.fromReference(instructorNameFormat).format(this);
    }

    public boolean hasLastName() {
        return this.getLastName() != null && !this.getLastName().isEmpty();
    }

    public boolean hasFirstName() {
        return this.getFirstName() != null && !this.getFirstName().isEmpty();
    }

    public boolean hasMiddleName() {
        return this.getMiddleName() != null && !this.getMiddleName().isEmpty();
    }

    private String nameLastFirstMiddle() {
        return Constants.toInitialCase((this.hasLastName() ? this.getLastName() : "") + (this.hasFirstName() || this.hasMiddleName() ? "," : "") + (String)(this.hasFirstName() ? " " + this.getFirstName() : "") + (String)(this.hasMiddleName() ? " " + this.getMiddleName() : "")).trim();
    }

    public void removeClassInstructor(ClassInstructor classInstr) {
        Set<ClassInstructor> s = this.getClasses();
        for (ClassInstructor ci : s) {
            if (ci.getUniqueId().intValue() != classInstr.getUniqueId().intValue()) continue;
            s.remove(ci);
            break;
        }
    }

    @Override
    public String htmlLabel() {
        return this.nameFirstNameFirst() + ", " + this.getDepartment().getDeptCode();
    }

    @Override
    @Transient
    public Set<Location> getAvailableRooms() {
        return new TreeSet<Location>(DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct r from RoomDept rd inner join rd.room r inner join rd.department d where r.session.uniqueId = :sessionId and (d.uniqueId = :deptId or (d.externalManager = true and d.inheritInstructorPreferences = true))", Location.class).setParameter("sessionId", (Object)this.getDepartment().getSessionId()).setParameter("deptId", (Object)this.getDepartment().getUniqueId()).setCacheable(true).list());
    }

    @Override
    @Transient
    public Set<Building> getAvailableBuildings() {
        return new TreeSet<Building>(DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct r.building from Room r inner join r.roomDepts rd inner join rd.department d where r.session.uniqueId = :sessionId and (d.uniqueId = :deptId or (d.externalManager = true and d.inheritInstructorPreferences = true))", Building.class).setParameter("sessionId", (Object)this.getDepartment().getSessionId()).setParameter("deptId", (Object)this.getDepartment().getUniqueId()).setCacheable(true).list());
    }

    @Override
    @Transient
    public Set<RoomFeature> getAvailableRoomFeatures() {
        Set<RoomFeature> features = super.getAvailableRoomFeatures();
        features.addAll(DepartmentRoomFeature.getAllDepartmentRoomFeatures(this.getDepartment()));
        return features;
    }

    @Override
    @Transient
    public Set<RoomGroup> getAvailableRoomGroups() {
        Set<RoomGroup> groups = super.getAvailableRoomGroups();
        groups.addAll(RoomGroup.getAllDepartmentRoomGroups(this.getDepartment()));
        return groups;
    }

    public Set prefsOfTypeForDepartment(Class type, Department dept) {
        if (dept == null || dept.equals(this.getDepartment())) {
            return this.getPreferences(type);
        }
        return null;
    }

    public static List<DepartmentalInstructor> getAllForInstructor(DepartmentalInstructor di, Long sessionId) {
        if (di.getExternalUniqueId() == null || di.getExternalUniqueId().trim().isEmpty()) {
            ArrayList<DepartmentalInstructor> ret = new ArrayList<DepartmentalInstructor>(1);
            ret.add((DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(di.getUniqueId()));
            return ret;
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId=:puid and department.session.uniqueId=:sessionId", DepartmentalInstructor.class).setParameter("puid", (Object)di.getExternalUniqueId()).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public static List<DepartmentalInstructor> getAllForInstructor(DepartmentalInstructor di) {
        return DepartmentalInstructor.getAllForInstructor(di, di.getDepartment().getSessionId());
    }

    public static List<DepartmentalInstructor> findInstructorsForDepartment(Long departmentId) {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where department.uniqueId = :departmentId order by lastName, firstName, middleName", DepartmentalInstructor.class).setParameter("departmentId", (Object)departmentId).setCacheable(true).list();
    }

    public static List<DepartmentalInstructor> findInstructorsForSession(Long sessionId) {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where department.session.uniqueId = :sessionId order by lastName, firstName, middleName", DepartmentalInstructor.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof DepartmentalInstructor)) {
            return -1;
        }
        DepartmentalInstructor i = (DepartmentalInstructor)o;
        int cmp = this.nameLastNameFirst().compareToIgnoreCase(i.nameLastNameFirst());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? Long.valueOf(-1L) : this.getUniqueId()).compareTo(i.getUniqueId() == null ? -1L : i.getUniqueId());
    }

    public static boolean existInst(String puid) {
        if (puid == null) {
            return false;
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor where externalUniqueId = :puid", DepartmentalInstructor.class).setParameter("puid", (Object)puid).setMaxResults(1).uniqueResult() != null;
    }

    public static DepartmentalInstructor findByPuidDepartmentId(String puid, Long deptId) {
        return DepartmentalInstructor.findByPuidDepartmentId(puid, deptId, DepartmentalInstructorDAO.getInstance().getSession());
    }

    public static DepartmentalInstructor findByPuidDepartmentId(String puid, Long deptId, org.hibernate.Session hibSession) {
        try {
            return (DepartmentalInstructor)hibSession.createQuery("select d from DepartmentalInstructor d where d.externalUniqueId=:puid and d.department.uniqueId=:deptId", DepartmentalInstructor.class).setParameter("puid", (Object)puid).setParameter("deptId", (Object)deptId).setCacheable(true).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
        }
        catch (NonUniqueResultException e) {
            Debug.warning("There are two or more instructors with puid " + puid + " for department " + deptId + " -- returning the first one.");
            return (DepartmentalInstructor)hibSession.createQuery("select d from DepartmentalInstructor d where d.externalUniqueId=:puid and d.department.uniqueId=:deptId", DepartmentalInstructor.class).setParameter("puid", (Object)puid).setParameter("deptId", (Object)deptId).setCacheable(true).setHibernateFlushMode(FlushMode.MANUAL).list().get(0);
        }
    }

    public DepartmentalInstructor findThisInstructorInSession(Long sessionId) {
        return this.findThisInstructorInSession(sessionId, DepartmentalInstructorDAO.getInstance().getSession());
    }

    public DepartmentalInstructor findThisInstructorInSession(Long sessionId, org.hibernate.Session hibSession) {
        Department newDept = this.getDepartment().findSameDepartmentInSession(sessionId, hibSession);
        if (newDept != null) {
            return DepartmentalInstructor.findByPuidDepartmentId(this.getExternalUniqueId(), newDept.getUniqueId(), hibSession);
        }
        return null;
    }

    public DepartmentalInstructor getNextDepartmentalInstructor(SessionContext context, Right right) {
        Long nextId = Navigation.getNext(context, Navigation.sInstructionalOfferingLevel, this.getUniqueId());
        if (nextId != null) {
            if (nextId < 0L) {
                return null;
            }
            return (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(nextId);
        }
        return null;
    }

    public DepartmentalInstructor getPreviousDepartmentalInstructor(SessionContext context, Right right) {
        Long prevId = Navigation.getPrevious(context, Navigation.sInstructionalOfferingLevel, this.getUniqueId());
        if (prevId != null) {
            if (prevId < 0L) {
                return null;
            }
            return (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(prevId);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.nameShort();
    }

    public boolean hasPreferences() {
        Iterator<Preference> i = null;
        try {
            i = this.getPreferences().iterator();
        }
        catch (ObjectNotFoundException e) {
            Debug.error("Exception " + e.getMessage() + " seen for " + String.valueOf(this));
            new _RootDAO().getSession().refresh((Object)this);
            i = this.getPreferences() != null ? this.getPreferences().iterator() : null;
        }
        catch (Exception e) {
            i = null;
        }
        if (i == null) {
            return false;
        }
        while (i.hasNext()) {
            TimePref timePref;
            Preference preference = i.next();
            if (preference instanceof TimePref && ((timePref = (TimePref)preference).getPreference() == null || timePref.getPreference().matches("2*")) || preference instanceof DistributionPref || preference instanceof InstructorCoursePref) continue;
            return true;
        }
        return false;
    }

    public Object clone() {
        DepartmentalInstructor newDepartmentalInstructor = new DepartmentalInstructor();
        newDepartmentalInstructor.setCareerAcct(this.getCareerAcct());
        newDepartmentalInstructor.setDepartment(this.getDepartment());
        newDepartmentalInstructor.setExternalUniqueId(this.getExternalUniqueId());
        newDepartmentalInstructor.setFirstName(this.getFirstName());
        newDepartmentalInstructor.setMiddleName(this.getMiddleName());
        newDepartmentalInstructor.setLastName(this.getLastName());
        newDepartmentalInstructor.setAcademicTitle(this.getAcademicTitle());
        newDepartmentalInstructor.setIgnoreToFar(this.isIgnoreToFar());
        newDepartmentalInstructor.setNote(this.getNote());
        newDepartmentalInstructor.setPositionType(this.getPositionType());
        newDepartmentalInstructor.setEmail(this.getEmail());
        newDepartmentalInstructor.setRole(this.getRole());
        newDepartmentalInstructor.setTeachingPreference(this.getTeachingPreference());
        newDepartmentalInstructor.setMaxLoad(this.getMaxLoad());
        return newDepartmentalInstructor;
    }

    public static List<DepartmentalInstructor> findAllExamInstructors(Long sessionId, Long examTypeId) {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct i from Exam x inner join x.instructors i where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId", DepartmentalInstructor.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list();
    }

    public List<Exam> getExams(Integer examType) {
        if (this.getExternalUniqueId() != null) {
            return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId)) and x.examType.type=:examType", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)this.getDepartment().getSession().getUniqueId()).setParameter("externalId", (Object)this.getExternalUniqueId()).setParameter("examType", (Object)examType).setCacheable(true).list();
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.examType=:examType", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setParameter("examType", (Object)examType).setCacheable(true).list();
    }

    public List<Exam> getExams(ExamType examType) {
        if (this.getExternalUniqueId() != null) {
            return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId)) and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)this.getDepartment().getSession().getUniqueId()).setParameter("externalId", (Object)this.getExternalUniqueId()).setParameter("examTypeId", (Object)examType.getUniqueId()).setCacheable(true).list();
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setParameter("examTypeId", (Object)examType.getUniqueId()).setCacheable(true).list();
    }

    @Transient
    public List<Exam> getAllExams() {
        if (this.getExternalUniqueId() != null) {
            return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where (i.uniqueId=:instructorId or (i.externalUniqueId=:externalId and i.department.session.uniqueId=:sessionId))", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setParameter("sessionId", (Object)this.getDepartment().getSession().getUniqueId()).setParameter("externalId", (Object)this.getExternalUniqueId()).setCacheable(true).list();
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId", Exam.class).setParameter("instructorId", (Object)this.getUniqueId()).setCacheable(true).list();
    }

    @Transient
    public Collection<Assignment> getCommitedAssignments() {
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("select a from Assignment a inner join a.instructors i where a.solution.commited=true and i.uniqueId=:instructorId", Assignment.class).setParameter("instructorId", (Object)this.getUniqueId()).setCacheable(true).list();
    }

    @Override
    @Transient
    public Session getSession() {
        return this.getDepartment().getSession();
    }

    public static boolean canLookupInstructor() {
        return ApplicationProperty.InstructorExternalIdLookupClass.value() != null;
    }

    public static ExternalUidLookup.UserInfo lookupInstructor(String externalId) throws Exception {
        ExternalUidLookup lookup = null;
        String className = ApplicationProperty.InstructorExternalIdLookupClass.value();
        if (className != null) {
            lookup = (ExternalUidLookup)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return lookup == null ? null : lookup.doLookup(externalId);
    }

    public Set<InstructorAttribute> getAttributes(InstructorAttributeType type) {
        TreeSet<InstructorAttribute> ret = new TreeSet<InstructorAttribute>();
        for (InstructorAttribute a : this.getAttributes()) {
            if (!type.equals(a.getType())) continue;
            ret.add(a);
        }
        return ret;
    }

    @Override
    @Transient
    public Set<CourseOffering> getAvailableCourses() {
        return new TreeSet<CourseOffering>(DepartmentalInstructorDAO.getInstance().getSession().createQuery("from CourseOffering c where c.subjectArea.department.uniqueId = :departmentId and c.isControl = true and c.instructionalOffering.notOffered = false", CourseOffering.class).setParameter("departmentId", (Object)this.getDepartment().getUniqueId()).setCacheable(true).list());
    }

    @Override
    @Transient
    public Set getAvailableAttributeTypes() {
        return this.getDepartment().getAvailableAttributeTypes();
    }

    @Override
    @Transient
    public Set getAvailableAttributes() {
        return this.getDepartment().getAvailableAttributes();
    }

    public boolean hasUnavailabilities() {
        if (this.getUnavailableDays() == null || this.getUnavailableDays().isEmpty()) {
            return false;
        }
        return this.getUnavailableDays().indexOf(49) >= 0;
    }

    public boolean isUnavailable(int day, int month) {
        if (this.getUnavailableDays() == null || this.getUnavailableDays().isEmpty()) {
            return false;
        }
        int idx = this.getSession().getDayOfYear(day, month) - this.getUnavailablePatternOffset();
        if (idx < 0 || idx >= this.getUnavailableDays().length()) {
            return false;
        }
        return this.getUnavailableDays().charAt(idx) == '1';
    }

    public List<RoomAvailabilityInterface.TimeBlock> listUnavailableDays() {
        if (!this.hasUnavailabilities()) {
            return null;
        }
        ArrayList<RoomAvailabilityInterface.TimeBlock> ret = new ArrayList<RoomAvailabilityInterface.TimeBlock>();
        int i = -1;
        Calendar cal = Calendar.getInstance(Locale.US);
        Date start = this.getUnavailableStartDate();
        while ((i = this.getUnavailableDays().indexOf(49, i + 1)) >= 0) {
            cal.setTime(start);
            cal.add(6, i);
            Date startTime = cal.getTime();
            cal.add(6, 1);
            Date endTime = cal.getTime();
            ret.add(new UnavailableDay(this, startTime, endTime));
        }
        return ret;
    }

    public List<TimeLocation> listUnavailableTimes() {
        if (this.getUnavailableDays() == null || this.getUnavailableDays().isEmpty()) {
            return null;
        }
        ArrayList<TimeLocation> ret = new ArrayList<TimeLocation>();
        for (int i = 0; i < 7; ++i) {
            BitSet weekCode = this.getUnavailableBitSet(i);
            if (weekCode.isEmpty()) continue;
            Object name = "";
            int idx = -1;
            Calendar cal = Calendar.getInstance(Locale.US);
            Date start = DateUtils.getDate(1, this.getSession().getPatternStartMonth(), this.getSession().getSessionStartYear());
            Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_SHORT);
            while ((idx = weekCode.nextSetBit(1 + idx)) >= 0) {
                cal.setTime(start);
                cal.add(6, idx);
                name = (String)name + (((String)name).isEmpty() ? "" : ", ") + df.format(cal.getTime());
            }
            ret.add(new TimeLocation(Constants.DAY_CODES[i], 0, 288, 0, 0.0, null, (String)name, weekCode, 0));
        }
        return ret;
    }

    public BitSet getUnavailableBitSet(int targetDow) {
        if (this.getUnavailableDays() == null || this.getUnavailableOffset() == null) {
            return null;
        }
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int size = this.getSession().getDayOfYear(0, endMonth + 1) - this.getSession().getDayOfYear(1, startMonth);
        BitSet ret = new BitSet(size);
        int offset = this.getUnavailablePatternOffset() - this.getSession().getDayOfYear(1, startMonth);
        int dayOfWeekOffset = Constants.getDayOfWeek(DateUtils.getDate(1, this.getSession().getPatternStartMonth(), this.getSession().getSessionStartYear()));
        for (int i = 0; i < this.getUnavailableDays().length(); ++i) {
            int dow = (i + offset + dayOfWeekOffset) % 7;
            if (this.getUnavailableDays().charAt(i) != '1' || i + offset < 0 || dow != targetDow) continue;
            ret.set(i + offset);
        }
        return ret;
    }

    public static List<DepartmentalInstructor> getUserInstructors(UserContext user) {
        if (user == null || user.getCurrentAcademicSessionId() == null || user.getExternalUserId() == null) {
            return null;
        }
        return DepartmentalInstructorDAO.getInstance().getSession().createQuery("from DepartmentalInstructor i where i.department.session.uniqueId = :sessionId and i.externalUniqueId = :externalId order by i.department.deptCode", DepartmentalInstructor.class).setParameter("sessionId", (Object)user.getCurrentAcademicSessionId()).setParameter("externalId", (Object)user.getExternalUserId()).setCacheable(true).list();
    }

    @Transient
    public int getUnavailablePatternOffset() {
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        int beginDate = cal.get(6);
        return beginDate - (this.getUnavailableOffset() == null ? 0 : this.getUnavailableOffset()) - 1;
    }

    @Transient
    public String getUnavailablePatternArray() {
        StringBuffer sb = new StringBuffer("[");
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        for (int m = startMonth; m <= endMonth; ++m) {
            if (m != startMonth) {
                sb.append(",");
            }
            sb.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    sb.append(",");
                }
                sb.append(this.isUnavailable(d, m) ? "'1'" : "'0'");
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    @Transient
    public String getUnavailablePattern() {
        StringBuffer sb = new StringBuffer();
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                sb.append(this.isUnavailable(d, m) ? "1" : "0");
            }
        }
        return sb.toString();
    }

    @Transient
    public String getUnavailableBorderArray() {
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int year = this.getSession().getSessionStartYear();
        StringBuffer sb = new StringBuffer("[");
        for (int m = startMonth; m <= endMonth; ++m) {
            if (m != startMonth) {
                sb.append(",");
            }
            sb.append("[");
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                if (d > 1) {
                    sb.append(",");
                }
                String border = this.getSession().getBorder(d, m);
                sb.append(border);
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    @Transient
    public String getUnavailablePatternHtml() {
        return this.getUnavailablePatternHtml(true, true);
    }

    public String getUnavailablePatternHtml(boolean editable) {
        return this.getUnavailablePatternHtml(editable, true);
    }

    public String getUnavailablePatternHtml(boolean editable, boolean includeScript) {
        int i;
        StringBuffer sb = new StringBuffer();
        if (includeScript) {
            sb.append("<script language='JavaScript' type='text/javascript' src='scripts/datepatt.js'></script>\n");
        }
        sb.append("<script language='JavaScript'>\n");
        sb.append("var CAL_WEEKDAYS = [");
        for (i = 0; i < 7; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"" + CONS.days()[(i + 6) % 7] + "\"");
        }
        sb.append("];\n");
        sb.append("var CAL_MONTHS = [");
        for (i = 0; i < 12; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"" + Month.of(1 + i).getDisplayName(TextStyle.FULL_STANDALONE, Localization.getJavaLocale()) + "\"");
        }
        sb.append("];\n");
        sb.append("calGenerate2(" + this.getSession().getSessionStartYear() + ",\n\t" + this.getSession().getPatternStartMonth() + ",\n\t" + this.getSession().getPatternEndMonth() + ",\n\t" + this.getUnavailablePatternArray() + ",\n\t['1','0'],\n\t['" + MSG.dateNotAvailable() + "','" + MSG.dateAvailable() + "'],\n\t['rgb(150,150,150)','rgb(240,240,240)'],\n\t'1',\n\t" + this.getUnavailableBorderArray() + "," + this.getSession().getColorArray() + "," + editable + "," + editable + ");\n");
        sb.append("</script>\n");
        return sb.toString();
    }

    public void setUnavailablePatternAndOffset(HttpServletRequest request) {
        int startMonth = this.getSession().getPatternStartMonth();
        int endMonth = this.getSession().getPatternEndMonth();
        int firstOne = 0;
        int lastOne = 0;
        int year = this.getSession().getSessionStartYear();
        StringBuffer sb = null;
        int idx = this.getSession().getDayOfYear(1, startMonth);
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, year);
            int yr = DateUtils.calculateActualYear(m, year);
            for (int d = 1; d <= daysOfMonth; ++d) {
                String unavailable = request.getParameter("cal_val_" + yr + "_" + (12 + m) % 12 + "_" + d);
                if (unavailable != null) {
                    if (sb != null || !unavailable.equals("0")) {
                        if (sb == null) {
                            firstOne = idx;
                            sb = new StringBuffer();
                        }
                        sb.append(unavailable);
                    }
                    if (!unavailable.equals("0")) {
                        lastOne = idx;
                    }
                }
                ++idx;
            }
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        if (sb != null) {
            this.setUnavailableDays(sb.substring(0, lastOne - firstOne + 1));
            this.setUnavailableOffset(cal.get(6) - firstOne - 1);
        } else {
            this.setUnavailableDays(null);
            this.setUnavailableOffset(null);
        }
    }

    @Transient
    public Date getUnavailableStartDate() {
        if (this.getUnavailableDays() == null || this.getUnavailableOffset() == null) {
            return null;
        }
        int idx = this.getUnavailableDays().indexOf(49);
        if (idx < 0) {
            return this.getSession().getSessionBeginDateTime();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        cal.add(6, idx - this.getUnavailableOffset());
        return cal.getTime();
    }

    @Transient
    public Date getUnavailableEndDate() {
        if (this.getUnavailableDays() == null || this.getUnavailableOffset() == null) {
            return null;
        }
        int idx = this.getUnavailableDays().lastIndexOf(49);
        if (idx < 0) {
            return this.getSession().getSessionEndDateTime();
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setTime(this.getSession().getSessionBeginDateTime());
        cal.add(6, idx - this.getUnavailableOffset());
        return cal.getTime();
    }

    @Transient
    public Map<Date, Date> getUnavailablePatternDateStringHashMaps() {
        Calendar startDate = Calendar.getInstance(Locale.US);
        startDate.setTime(this.getUnavailableStartDate());
        Calendar endDate = Calendar.getInstance(Locale.US);
        endDate.setTime(this.getUnavailableEndDate());
        int startMonth = startDate.get(2);
        int endMonth = endDate.get(2);
        int startYear = startDate.get(1);
        int endYear = endDate.get(1);
        if (endYear > startYear) {
            endMonth += 12 * (endYear - startYear);
        }
        HashMap<Date, Date> mapStartToEndDate = new HashMap<Date, Date>();
        Date first = null;
        Date previous = null;
        char[] ptrn = this.getUnavailableDays().toCharArray();
        int charPosition = 0;
        int dayOfWeek = startDate.get(7);
        Calendar cal = Calendar.getInstance(Locale.US);
        for (int m = startMonth; m <= endMonth; ++m) {
            int daysOfMonth = DateUtils.getNrDaysOfMonth(m, startYear);
            for (int d = m == startMonth ? startDate.get(5) : 1; d <= daysOfMonth && charPosition < ptrn.length; ++d) {
                if (ptrn[charPosition] == '1' || first != null && dayOfWeek == 1 && charPosition + 1 < ptrn.length && ptrn[1 + charPosition] == '1') {
                    if (first == null) {
                        cal.setTime(this.getUnavailableStartDate());
                        cal.add(6, charPosition);
                        first = cal.getTime();
                    }
                } else if (first != null) {
                    mapStartToEndDate.put(first, previous);
                    first = null;
                }
                cal.setTime(this.getUnavailableStartDate());
                cal.add(6, charPosition);
                previous = cal.getTime();
                ++charPosition;
                if (++dayOfWeek <= 7) continue;
                dayOfWeek = 1;
            }
        }
        if (first != null) {
            mapStartToEndDate.put(first, previous);
            first = null;
        }
        return mapStartToEndDate;
    }

    public String getUnavailableDaysText(String separator) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Map<Date, Date> dates = this.getUnavailablePatternDateStringHashMaps();
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_SHORT);
        for (Date startDate : new TreeSet<Date>(dates.keySet())) {
            Date endDate = dates.get(startDate);
            String startDateStr = df.format(startDate);
            String endDateStr = df.format(endDate);
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(startDateStr);
            if (startDateStr.equals(endDateStr)) continue;
            sb.append("-" + endDateStr);
        }
        return sb.toString();
    }

    public static class UnavailableDay
    implements RoomAvailabilityInterface.TimeBlock,
    Comparable<RoomAvailabilityInterface.TimeBlock> {
        private static final long serialVersionUID = 1L;
        private Date iStartTime;
        private Date iEndTime;
        private Long iEventId;
        private String iDeptCode;

        private UnavailableDay(DepartmentalInstructor instructor, Date startTime, Date endTime) {
            this.iEventId = -instructor.getUniqueId().longValue();
            this.iStartTime = startTime;
            this.iEndTime = endTime;
            this.iDeptCode = instructor.getDepartment().getDeptCode();
        }

        @Override
        @Transient
        public Long getEventId() {
            return this.iEventId;
        }

        @Override
        @Transient
        public String getEventName() {
            Formats.Format<Date> df = Formats.getDateFormat(CONS.meetingDateFormat());
            return PreferenceGroup.MSG.instructorNotAvailableName(df.format(this.getStartTime()), this.iDeptCode);
        }

        @Override
        @Transient
        public String getEventType() {
            return PreferenceGroup.MSG.instructorNotAvailableType();
        }

        @Override
        @Transient
        public Date getStartTime() {
            return this.iStartTime;
        }

        @Override
        @Transient
        public Date getEndTime() {
            return this.iEndTime;
        }

        @Override
        public int compareTo(RoomAvailabilityInterface.TimeBlock block) {
            int cmp = this.getStartTime().compareTo(block.getStartTime());
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.getEndTime().compareTo(block.getEndTime());
            if (cmp != 0) {
                return cmp;
            }
            return this.getEventName().compareTo(block.getEventName());
        }

        public String toString() {
            Formats.Format<Date> df = Formats.getDateFormat(CONS.eventDateFormatLong());
            return this.getEventName() + " (" + this.getEventType() + ") " + df.format(this.getStartTime());
        }
    }
}

