/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.cpsolver.coursett.preference.MinMaxPreferenceCombination;
import org.hibernate.FlushMode;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.ExternalClassEditAction;
import org.unitime.timetable.interfaces.ExternalClassNameHelperInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.AssignmentInfo;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentRoomFeature;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionObject;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventDateMapping;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.InstructorAttributePref;
import org.unitime.timetable.model.InstructorCoursePref;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Reservation;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.SectioningInfo;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Solution;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.SolverInfoDef;
import org.unitime.timetable.model.TeachingClassRequest;
import org.unitime.timetable.model.TeachingRequest;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.base.BaseClass_;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.model.comparators.NavigationComparator;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.SectioningInfoDAO;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.CommitedClassAssignmentProxy;
import org.unitime.timetable.solver.course.ui.ClassAssignmentInfo;
import org.unitime.timetable.solver.course.ui.ClassInstructorInfo;
import org.unitime.timetable.solver.course.ui.ClassRoomInfo;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.Navigation;

@Entity
@Table(name="class_")
public class Class_
extends BaseClass_ {
    private static final long serialVersionUID = 1L;
    private static CourseMessages MSG = Localization.create(CourseMessages.class);
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private ClassEvent iEvent = null;

    public Class_() {
    }

    public Class_(Long uniqueId) {
        super(uniqueId);
    }

    @Transient
    public String getCourseName() {
        return this.getSchedulingSubpart().getCourseName();
    }

    @Transient
    public String getCourseNameWithTitle() {
        return this.getSchedulingSubpart().getCourseNameWithTitle();
    }

    @Transient
    public String getItypeDesc() {
        return this.getSchedulingSubpart().getItypeDesc();
    }

    @Override
    @Transient
    public Department getManagingDept() {
        if (super.getManagingDept() == null) {
            return this.getControllingDept();
        }
        return super.getManagingDept();
    }

    @Override
    @Transient
    public Department getControllingDept() {
        if (this.getSchedulingSubpart() == null) {
            return null;
        }
        if (super.getControllingDept() == null) {
            return this.getSchedulingSubpart().getControllingDept();
        }
        return super.getControllingDept();
    }

    @Override
    public void setManagingDept(Department dept) {
        if (super.getManagingDept() == null) {
            super.setManagingDept(dept);
        } else {
            this.setManagingDept(dept, null, Class_DAO.getInstance().getSession());
        }
    }

    public void setManagingDept(Department dept, UserContext user, org.hibernate.Session hibSession) {
        Department oldDept = this.getManagingDept();
        super.setManagingDept(dept);
        if (dept == null) {
            return;
        }
        if (oldDept != null && !oldDept.equals(dept) && this.getAssignments() != null && !this.getAssignments().isEmpty()) {
            boolean deleteEvent = false;
            String deletedAssignment = null;
            Iterator<Assignment> i = this.getAssignments().iterator();
            while (i.hasNext()) {
                Assignment a = i.next();
                if (a.getSolution().getOwner().getDepartments().contains(dept)) continue;
                if (a.getSolution().isCommited().booleanValue()) {
                    deleteEvent = true;
                    deletedAssignment = a.getPlacement().getName();
                }
                hibSession.remove((Object)a);
                i.remove();
            }
            ClassEvent event = this.getEvent();
            if (event != null) {
                if (deleteEvent) {
                    if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
                        hibSession.remove((Object)event);
                    } else {
                        Calendar cal = Calendar.getInstance(Locale.US);
                        cal.set(11, 0);
                        cal.set(12, 0);
                        cal.set(13, 0);
                        cal.set(14, 0);
                        Date today = cal.getTime();
                        Iterator<Meeting> i2 = event.getMeetings().iterator();
                        while (i2.hasNext()) {
                            if (i2.next().getMeetingDate().before(today)) continue;
                            i2.remove();
                        }
                        if (event.getMeetings().isEmpty()) {
                            hibSession.remove((Object)event);
                        } else if (user != null) {
                            if (event.getNotes() == null) {
                                event.setNotes(new HashSet<EventNote>());
                            }
                            EventNote note = new EventNote();
                            note.setEvent(event);
                            note.setNoteType(4);
                            note.setTimeStamp(new Date());
                            note.setUser(user.getTrueName());
                            note.setUserId(user.getTrueExternalUserId());
                            note.setTextNote(MSG.classNoteUnassigned(deletedAssignment));
                            note.setMeetings(MSG.classMeetingsNotApplicable());
                            event.getNotes().add(note);
                            hibSession.persist((Object)event);
                        }
                    }
                } else {
                    event.setEventName(this.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseName() + " " + this.getItypeDesc().trim() + " " + this.getSectionNumberString(hibSession));
                    if (event.getUniqueId() == null) {
                        hibSession.persist((Object)event);
                    } else {
                        hibSession.merge((Object)event);
                    }
                }
            }
        }
    }

    @Transient
    public Department getDepartmentForSubjectArea() {
        Department dept = this.getSchedulingSubpart().getInstrOfferingConfig().getControllingCourseOffering().getSubjectArea().getDepartment();
        return dept;
    }

    @Override
    @Transient
    public Session getSession() {
        return this.getSchedulingSubpart().getSession();
    }

    @Transient
    public Long getSessionId() {
        return this.getSchedulingSubpart().getSessionId();
    }

    public Set classInstructorPrefsOfType(Class type) {
        List<DepartmentalInstructor> instructors = this.getLeadInstructors();
        if (instructors.isEmpty()) {
            return null;
        }
        if (InstructorCoursePref.class.equals((Object)type)) {
            return null;
        }
        Set<Preference> ret = null;
        for (DepartmentalInstructor instructor : instructors) {
            if (ret == null) {
                ret = instructor.getPreferences(type);
                continue;
            }
            ret = this.combinePreferences(ret, instructor.getPreferences(type));
        }
        return ret;
    }

    private Set weakenHardPreferences(Set prefs) {
        if (prefs == null || prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        Iterator i = prefs.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)((Preference)i.next()).clone();
            if (!pref.weakenHardPreferences()) continue;
            ret.add(pref);
        }
        return ret;
    }

    private Set removeNeutralPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet ret = new TreeSet(prefs);
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            Preference pref = (Preference)i.next();
            if (!PreferenceLevel.sNeutral.equals(pref.getPrefLevel().getPrefProlog())) continue;
            i.remove();
        }
        return ret;
    }

    private Set removeDepartmentalPreferences(Set prefs) {
        if (prefs == null) {
            return new TreeSet();
        }
        if (prefs.isEmpty()) {
            return prefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        block0: for (Preference pref : prefs) {
            if (pref instanceof RoomPref) {
                Location loc = ((RoomPref)pref).getRoom();
                for (RoomDept rd : loc.getRoomDepts()) {
                    if (!rd.getDepartment().equals(this.getManagingDept())) continue;
                    ret.add(pref);
                    continue block0;
                }
                continue;
            }
            if (pref instanceof BuildingPref) {
                Building b = ((BuildingPref)pref).getBuilding();
                if (!this.getAvailableBuildings().contains(b)) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomFeaturePref) {
                RoomFeature rf = ((RoomFeaturePref)pref).getRoomFeature();
                if (rf instanceof GlobalRoomFeature) {
                    ret.add(pref);
                    continue;
                }
                if (!(rf instanceof DepartmentRoomFeature) || !((DepartmentRoomFeature)rf).getDepartment().equals(this.getManagingDept())) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof RoomGroupPref) {
                RoomGroup rg = ((RoomGroupPref)pref).getRoomGroup();
                if (!rg.isGlobal().booleanValue() && !this.getManagingDept().equals(rg.getDepartment())) continue;
                ret.add(pref);
                continue;
            }
            if (pref instanceof InstructorAttributePref) {
                InstructorAttribute at = ((InstructorAttributePref)pref).getAttribute();
                if (at.getDepartment() != null && !this.getManagingDept().equals(at.getDepartment())) continue;
                ret.add(pref);
                continue;
            }
            ret.add(pref);
        }
        return ret;
    }

    private Set<Preference> combinePreferences(Set<Preference> instrPrefs1, Set<Preference> instrPrefs2) {
        if (instrPrefs1 == null || instrPrefs1.isEmpty()) {
            return instrPrefs2;
        }
        if (instrPrefs2 == null || instrPrefs2.isEmpty()) {
            return instrPrefs1;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>();
        TimePref tp = null;
        for (Preference p1 : instrPrefs1) {
            if (p1 instanceof TimePref) {
                if (tp == null) {
                    tp = (TimePref)p1.clone();
                    continue;
                }
                tp.combineWith((TimePref)p1, false);
                continue;
            }
            ret.add(p1);
        }
        for (Preference p2 : instrPrefs2) {
            if (p2 instanceof TimePref) {
                if (tp == null) {
                    tp = (TimePref)p2.clone();
                    continue;
                }
                tp.combineWith((TimePref)p2, false);
                continue;
            }
            Preference p1 = null;
            Iterator j = ret.iterator();
            while (j.hasNext()) {
                Preference p = (Preference)j.next();
                if (!p.isSame(p2, this)) continue;
                p1 = p;
                j.remove();
                break;
            }
            if (p1 == null) {
                ret.add(p2);
                continue;
            }
            Preference combPref = (Preference)p1.clone();
            MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
            com.addPreferenceProlog(p1.getPrefLevel().getPrefProlog());
            com.addPreferenceProlog(p2.getPrefLevel().getPrefProlog());
            combPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(com.getPreferenceProlog()));
            ret.add(combPref);
        }
        if (tp != null) {
            ret.add(tp);
        }
        return ret;
    }

    private Set combinePreferences(Class type, Set subpartPrefs, Set instrPrefs) {
        if (TimePref.class.equals((Object)type)) {
            if (subpartPrefs == null || subpartPrefs.isEmpty() || instrPrefs == null || instrPrefs.isEmpty()) {
                return subpartPrefs;
            }
            TimePref instrPref = (TimePref)instrPrefs.iterator().next();
            TreeSet<TimePref> ret = new TreeSet<TimePref>();
            Iterator i = subpartPrefs.iterator();
            while (i.hasNext()) {
                TimePref pref = (TimePref)((TimePref)i.next()).clone();
                pref.combineWith(instrPref, false);
                ret.add(pref);
            }
            return ret;
        }
        if (subpartPrefs == null || subpartPrefs.isEmpty()) {
            return instrPrefs;
        }
        if (instrPrefs == null || instrPrefs.isEmpty()) {
            return subpartPrefs;
        }
        TreeSet<Preference> ret = new TreeSet<Preference>(subpartPrefs);
        for (Preference instrPref : instrPrefs) {
            Preference subpartPref = null;
            Iterator j = ret.iterator();
            while (j.hasNext()) {
                Preference p = (Preference)j.next();
                if (!p.isSame(instrPref, this)) continue;
                subpartPref = p;
                j.remove();
                break;
            }
            if (subpartPref == null) {
                ret.add(instrPref);
                continue;
            }
            Preference combPref = (Preference)subpartPref.clone();
            MinMaxPreferenceCombination com = new MinMaxPreferenceCombination();
            com.addPreferenceProlog(instrPref.getPrefLevel().getPrefProlog());
            com.addPreferenceProlog(subpartPref.getPrefLevel().getPrefProlog());
            combPref.setPrefLevel(PreferenceLevel.getPreferenceLevel(com.getPreferenceProlog()));
            ret.add(combPref);
        }
        return ret;
    }

    private Set combinePreferences(Class type, Set classPrefs, Set subpartPrefs, Set instrPrefs) {
        TreeSet<Preference> ret = new TreeSet<Preference>(classPrefs);
        Set combined = this.combinePreferences(type, subpartPrefs, instrPrefs);
        if (combined == null) {
            return ret;
        }
        for (Preference combPref : combined) {
            Preference classPref = null;
            for (Preference p : classPrefs) {
                if (!p.isSame(combPref, this)) continue;
                classPref = p;
                break;
            }
            if (classPref != null) continue;
            ret.add(combPref);
        }
        return ret;
    }

    @Override
    @Transient
    public Set getDistributionPreferences() {
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        if (this.getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getDistributionObjects()) {
                prefs.add(distObj.getDistributionPref());
            }
        }
        return prefs;
    }

    public Set effectiveDistributionPreferences(Department owningDept) {
        DistributionPref pref;
        TreeSet<DistributionPref> prefs = new TreeSet<DistributionPref>();
        if (this.getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getDistributionObjects()) {
                pref = distObj.getDistributionPref();
                if (owningDept != null && !owningDept.equals(pref.getOwner())) continue;
                prefs.add(pref);
            }
        }
        if (this.getSchedulingSubpart().getDistributionObjects() != null) {
            for (DistributionObject distObj : this.getSchedulingSubpart().getDistributionObjects()) {
                pref = distObj.getDistributionPref();
                if (owningDept != null && !owningDept.equals(pref.getOwner())) continue;
                prefs.add(pref);
            }
        }
        return prefs;
    }

    private Set fixDurationInTimePreferences(Set prefs) {
        if (prefs == null || prefs.isEmpty()) {
            return prefs;
        }
        DatePattern dp = this.effectiveDatePattern();
        if (dp == null) {
            return prefs;
        }
        DurationModel dm = this.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
        TreeSet ret = new TreeSet(prefs);
        ArrayList<TimePref> fixed = new ArrayList<TimePref>();
        Iterator i = ret.iterator();
        while (i.hasNext()) {
            int t;
            int d;
            TimePref tp;
            Preference pref = (Preference)i.next();
            if (!(pref instanceof TimePref) || (tp = (TimePref)pref).getTimePattern().getType() != null && tp.getTimePattern().isExactTime()) continue;
            Set<Integer> days = dm.getDayCodes(this.getSchedulingSubpart().getMinutesPerWk(), dp, tp.getTimePattern());
            if (days.isEmpty()) {
                i.remove();
                continue;
            }
            if (days.size() >= tp.getTimePattern().getDays().size()) continue;
            TimePatternModel model = tp.getTimePatternModel();
            boolean req = model.hasRequiredPreferences();
            for (d = 0; d < model.getNrDays(); ++d) {
                if (days.contains(model.getDayCode(d))) continue;
                for (t = 0; t < model.getNrTimes(); ++t) {
                    model.setPreference(d, t, PreferenceLevel.sNotAvailable);
                }
            }
            if (req && !model.hasRequiredPreferences()) {
                for (d = 0; d < model.getNrDays(); ++d) {
                    if (!days.contains(model.getDayCode(d))) continue;
                    for (t = 0; t < model.getNrTimes(); ++t) {
                        model.setPreference(d, t, PreferenceLevel.sProhibited);
                    }
                }
            }
            i.remove();
            TimePref copy = (TimePref)tp.clone();
            copy.setPreference(model.getPreferences());
            fixed.add(copy);
        }
        ret.addAll(fixed);
        return ret;
    }

    public Set effectivePreferences(Class type, Vector leadInstructors, boolean fixDurationInTimePreferences) {
        Set subpartPrefs;
        Department mngDept = this.getManagingDept();
        if (DistributionPref.class.equals((Object)type)) {
            return this.effectiveDistributionPreferences(mngDept);
        }
        if (leadInstructors == null || leadInstructors.isEmpty()) {
            return this.effectivePreferences(type, fixDurationInTimePreferences);
        }
        Set instrPrefs = null;
        Enumeration e = leadInstructors.elements();
        while (e.hasMoreElements()) {
            DepartmentalInstructor leadInstructor = (DepartmentalInstructor)e.nextElement();
            instrPrefs = this.combinePreferences(instrPrefs, leadInstructor.prefsOfTypeForDepartment(type, this.getControllingDept()));
        }
        if (instrPrefs != null && !instrPrefs.isEmpty()) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    instrPrefs = this.weakenHardPreferences(instrPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                instrPrefs = this.weakenHardPreferences(instrPrefs);
            }
        }
        if (instrPrefs != null && !instrPrefs.isEmpty()) {
            instrPrefs = this.removeDepartmentalPreferences(instrPrefs);
        }
        if ((subpartPrefs = this.getSchedulingSubpart().effectivePreferences(type, this)) != null && !subpartPrefs.isEmpty() && !mngDept.equals(this.getSchedulingSubpart().getManagingDept())) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    subpartPrefs = this.weakenHardPreferences(subpartPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                subpartPrefs = this.weakenHardPreferences(subpartPrefs);
            }
            if (instrPrefs != null && !instrPrefs.isEmpty()) {
                subpartPrefs = this.removeDepartmentalPreferences(subpartPrefs);
            }
        }
        Set ret = this.removeNeutralPreferences(this.combinePreferences(type, subpartPrefs, instrPrefs));
        return fixDurationInTimePreferences ? this.fixDurationInTimePreferences(ret) : ret;
    }

    public Set effectivePreferences(Class type, boolean fixDurationInTimePreferences) {
        Set subpartPrefs;
        Department mngDept = this.getManagingDept();
        if (DistributionPref.class.equals((Object)type)) {
            Set instPref;
            Set prefs = this.effectiveDistributionPreferences(mngDept);
            if (!mngDept.isExternalManager().booleanValue() && (instPref = this.classInstructorPrefsOfType(type)) != null) {
                prefs.addAll(instPref);
            }
            return prefs;
        }
        if (InstructorAttributePref.class.equals((Object)type) || InstructorPref.class.equals((Object)type)) {
            TreeSet prefs = new TreeSet();
            for (TeachingClassRequest tcr : this.getTeachingRequests()) {
                if (!tcr.getAssignInstructor().booleanValue()) continue;
                prefs.addAll(tcr.getTeachingRequest().getPreferences(type));
            }
            return prefs;
        }
        Set classPrefs = this.getPreferences(type, this);
        Set instrPrefs = null;
        if (mngDept.isInheritInstructorPreferences().booleanValue()) {
            instrPrefs = this.classInstructorPrefsOfType(type);
            if (instrPrefs != null && !instrPrefs.isEmpty()) {
                if (mngDept.isExternalManager().booleanValue() && TimePref.class.equals((Object)type)) {
                    if (!mngDept.isAllowReqTime().booleanValue()) {
                        instrPrefs = this.weakenHardPreferences(instrPrefs);
                    }
                } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                    instrPrefs = this.weakenHardPreferences(instrPrefs);
                }
            }
            if (instrPrefs != null && !instrPrefs.isEmpty()) {
                instrPrefs = this.removeDepartmentalPreferences(instrPrefs);
            }
        }
        boolean hasExactTimePattern = false;
        if (TimePref.class.equals((Object)type) && classPrefs != null && !classPrefs.isEmpty()) {
            for (TimePref tp : classPrefs) {
                if (tp.getTimePattern() == null || !tp.getTimePattern().isExactTime()) continue;
                hasExactTimePattern = true;
                break;
            }
        }
        Set set = subpartPrefs = hasExactTimePattern ? null : this.getSchedulingSubpart().effectivePreferences(type, this);
        if (subpartPrefs != null && !subpartPrefs.isEmpty() && !mngDept.equals(this.getSchedulingSubpart().getManagingDept())) {
            if (TimePref.class.equals((Object)type)) {
                if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqTime().booleanValue()) {
                    subpartPrefs = this.weakenHardPreferences(subpartPrefs);
                }
            } else if (mngDept.isExternalManager().booleanValue() && !mngDept.isAllowReqRoom().booleanValue()) {
                subpartPrefs = this.weakenHardPreferences(subpartPrefs);
            }
            if (instrPrefs != null && !instrPrefs.isEmpty()) {
                subpartPrefs = this.removeDepartmentalPreferences(subpartPrefs);
            }
        }
        Set ret = this.removeNeutralPreferences(this.combinePreferences(type, classPrefs, subpartPrefs, instrPrefs));
        return fixDurationInTimePreferences ? this.fixDurationInTimePreferences(ret) : ret;
    }

    public String instructorHtml(String instructorNameFormat) {
        StringBuffer sb = new StringBuffer();
        if (this.getClassInstructors() == null) {
            return "";
        }
        InstructorComparator ic = new InstructorComparator();
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            ic.setNameFormat(instructorNameFormat);
        }
        TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
        sortedInstructors.addAll(this.getClassInstructors());
        Iterator<ClassInstructor> it = sortedInstructors.iterator();
        ClassInstructor ci = null;
        while (it.hasNext()) {
            ci = it.next();
            Object title = ci.getInstructor().getNameLastFirst();
            title = (String)title + " (" + (String)(ci.getResponsibility() == null ? "" : ci.getResponsibility().getLabel() + " ") + ci.getPercentShare() + "%" + (String)(ci.isLead() != false ? ", " + MSG.toolTipInstructorLead() : "") + ")";
            if (!this.isDisplayInstructor().booleanValue()) {
                title = (String)title + MSG.toolTipInstructorDoNotDisplay();
            }
            if (ci.isLead().booleanValue()) {
                sb.append("<span style='font-weight:bold;" + (this.isDisplayInstructor() != false ? "" : "font-style:italic;") + "' title='" + (String)title + "'>");
            } else {
                sb.append("<span title='" + (String)title + "'>");
            }
            sb.append(ci.getInstructor().getName(instructorNameFormat));
            if (ci.getResponsibility() != null && ci.getResponsibility().getAbbreviation() != null && !ci.getResponsibility().getAbbreviation().isEmpty()) {
                sb.append(" (" + ci.getResponsibility().getAbbreviation() + ")");
            }
            sb.append("</span>");
            if (it.hasNext()) {
                sb.append("<br>");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String instructorText(String instructorNameFormat, String separator) {
        if (this.getClassInstructors() == null) {
            return "";
        }
        InstructorComparator ic = new InstructorComparator();
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            ic.setNameFormat(instructorNameFormat);
        }
        TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
        sortedInstructors.addAll(this.getClassInstructors());
        StringBuffer sb = new StringBuffer();
        Iterator<ClassInstructor> it = sortedInstructors.iterator();
        while (it.hasNext()) {
            ClassInstructor ci = it.next();
            sb.append(ci.getInstructor().getName(instructorNameFormat));
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    private String htmlForTimePatterns(Set patterns) {
        StringBuffer sb = new StringBuffer();
        if (patterns != null) {
            Iterator it = patterns.iterator();
            TimePattern t = null;
            while (it.hasNext()) {
                t = (TimePattern)it.next();
                sb.append(t.getName());
                if (!it.hasNext()) continue;
                sb.append("<BR>");
            }
        }
        if (patterns == null || patterns.isEmpty()) {
            DurationModel dm = this.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer ah = dm.getArrangedHours(this.getSchedulingSubpart().getMinutesPerWk(), this.effectiveDatePattern());
            if (ah == null) {
                sb.append("<span title='" + MSG.arrangeHours() + "'>" + MSG.arrHrs() + "</span>");
            } else {
                sb.append("<span title='" + MSG.arrangeHoursN(ah) + "'>" + MSG.arrHrsN(ah) + "</span>");
            }
        }
        return sb.toString();
    }

    @Override
    public String effectiveTimePatternHtml() {
        return this.htmlForTimePatterns(this.effectiveTimePatterns());
    }

    public String timePatternHtml() {
        return this.htmlForTimePatterns(this.getTimePatterns());
    }

    @Transient
    public Integer getSectionNumber() {
        return this.getSectionNumber(null, true);
    }

    public Integer getSectionNumber(org.hibernate.Session hibSession) {
        return this.getSectionNumber(hibSession, true);
    }

    public Integer getSectionNumber(boolean save) {
        return this.getSectionNumber(null, save);
    }

    public Integer getSectionNumber(org.hibernate.Session hibSession, boolean save) {
        Integer sectionNumber = this.getSectionNumberCache();
        if (sectionNumber != null) {
            return sectionNumber;
        }
        Comparator cmp = new Comparator(){

            public int compare(Object o1, Object o2) {
                Class_ c1 = (Class_)o1;
                Class_ c2 = (Class_)o2;
                if (c1.getParentClass() == null || c2.getParentClass() == null || c1.getParentClass().equals(c2.getParentClass())) {
                    return c1.getUniqueId().compareTo(c2.getUniqueId());
                }
                return this.compare(c1.getParentClass(), c2.getParentClass());
            }
        };
        int idx = 0;
        for (Class_ clazz : this.getSchedulingSubpart().getClasses()) {
            if (cmp.compare(clazz, this) >= 0) continue;
            ++idx;
        }
        sectionNumber = this.getSchedulingSubpart().getInstrOfferingConfig().getFirstSectionNumber(this.getSchedulingSubpart().getItype()) + idx;
        this.setSectionNumberCache(sectionNumber);
        if (save) {
            if (hibSession != null) {
                hibSession.merge((Object)this);
            } else {
                new Class_DAO().getSession().merge((Object)this);
                new Class_DAO().getSession().flush();
            }
        }
        return sectionNumber;
    }

    @Transient
    public String getSectionNumberString() {
        return this.getSectionNumber() + this.getSchedulingSubpart().getSchedulingSubpartSuffix();
    }

    public String getSectionNumberString(org.hibernate.Session hibSession) {
        return this.getSectionNumber(hibSession) + this.getSchedulingSubpart().getSchedulingSubpartSuffix(hibSession);
    }

    @Transient
    public List<DepartmentalInstructor> getLeadInstructors() {
        ArrayList<DepartmentalInstructor> ret = new ArrayList<DepartmentalInstructor>();
        if (this.getClassInstructors() == null) {
            return ret;
        }
        for (ClassInstructor classInstructor : this.getClassInstructors()) {
            if (!classInstructor.isLead().booleanValue()) continue;
            ret.add(classInstructor.getInstructor());
        }
        return ret;
    }

    @Transient
    public String getClassLabel() {
        return this.getClassLabel(this.getSchedulingSubpart().getControllingCourseOffering());
    }

    public String getClassLabel(CourseOffering course, boolean includeSuffix) {
        if (includeSuffix) {
            String extId = this.getClassSuffix(course);
            return course.getCourseName() + " " + this.getItypeDesc().trim() + " " + this.getSectionNumberString() + (String)(extId == null || extId.isEmpty() || extId.equalsIgnoreCase(this.getSectionNumberString()) ? "" : " - " + extId);
        }
        return this.getClassLabel(course);
    }

    public String getClassLabel(CourseOffering course, boolean includeSuffix, boolean includeConfigName) {
        String label = this.getClassLabel(course, includeSuffix);
        if (includeConfigName && course.getInstructionalOffering().getInstrOfferingConfigs().size() > 1) {
            return label + " (" + this.getSchedulingSubpart().getInstrOfferingConfig().getName() + ")";
        }
        return label;
    }

    public String getClassLabel(boolean includeSuffix, boolean includeConfigName) {
        return this.getClassLabel(this.getSchedulingSubpart().getControllingCourseOffering(), includeSuffix, includeConfigName);
    }

    public String getClassLabel(boolean includeSuffix) {
        return this.getClassLabel(this.getSchedulingSubpart().getControllingCourseOffering(), includeSuffix, false);
    }

    public String getClassLabel(org.hibernate.Session hibSession) {
        if (this.getSectionNumberCache() == null) {
            this.getSectionNumber(hibSession, true);
            this.getSchedulingSubpart().getSchedulingSubpartSuffix(hibSession, true);
        }
        return this.getClassLabel(this.getSchedulingSubpart().getControllingCourseOffering());
    }

    @Transient
    public String getClassLabelWithTitle() {
        return this.getClassLabelWithTitle(this.getSchedulingSubpart().getControllingCourseOffering());
    }

    @Override
    public String toString() {
        return this.getClassLabel();
    }

    @Override
    @Transient
    public Class getInstanceOf() {
        return Class_.class;
    }

    @Override
    public String htmlLabel() {
        return this.getItypeDesc() + " " + this.getSectionNumberString();
    }

    public boolean canBeDeleted() {
        if (this.getChildClasses() != null && this.getChildClasses().size() > 0) {
            return false;
        }
        if (this.getParentClass() != null) {
            int totalCapacity = 0;
            Class_ c2 = null;
            for (Class_ c2 : this.getParentClass().getChildClasses()) {
                totalCapacity += c2.getExpectedCapacity().intValue();
            }
            if ((totalCapacity -= this.getExpectedCapacity().intValue()) < this.getParentClass().getExpectedCapacity()) {
                return false;
            }
        }
        return true;
    }

    public void removeClassInstructor(ClassInstructor classInstr) {
        Set<ClassInstructor> s = this.getClassInstructors();
        for (ClassInstructor ci : s) {
            if (ci.getUniqueId().intValue() != classInstr.getUniqueId().intValue()) continue;
            s.remove(ci);
            break;
        }
    }

    @Override
    public DatePattern effectiveDatePattern() {
        if (this.getDatePattern() != null) {
            return this.getDatePattern();
        }
        return this.getSchedulingSubpart().effectiveDatePattern();
    }

    @Override
    @Transient
    public Set<Location> getAvailableRooms() {
        TreeSet<Location> rooms = new TreeSet<Location>();
        for (RoomDept roomDept : this.getManagingDept().getRoomDepts()) {
            rooms.add(roomDept.getRoom());
        }
        return rooms;
    }

    @Transient
    public Set getAvailableRoomFeatures() {
        TreeSet<GlobalRoomFeature> features = new TreeSet<GlobalRoomFeature>(GlobalRoomFeature.getAllGlobalRoomFeatures(this.getSession()));
        Department dept = this.getManagingDept();
        if (dept != null) {
            features.addAll(DepartmentRoomFeature.getAllDepartmentRoomFeatures(dept));
        }
        return features;
    }

    @Transient
    public Set getAvailableRoomGroups() {
        Set<RoomGroup> groups = super.getAvailableRoomGroups();
        Department dept = this.getManagingDept();
        if (dept != null) {
            groups.addAll(RoomGroup.getAllDepartmentRoomGroups(dept));
        }
        return groups;
    }

    @Override
    @Transient
    public Set getAvailableAttributeTypes() {
        return this.getControllingDept().getAvailableAttributeTypes();
    }

    @Override
    @Transient
    public Set getAvailableAttributes() {
        return this.getControllingDept().getAvailableAttributes();
    }

    public Class_ getNextClass(SessionContext context, Right right) {
        return this.getNextClass(context, new NavigationComparator(), right);
    }

    public Class_ getPreviousClass(SessionContext context, Right right) {
        return this.getPreviousClass(context, new NavigationComparator(), right);
    }

    public Class_ getNextClass(SessionContext context, Comparator cmp, Right right) {
        Long nextId = Navigation.getNext(context, Navigation.sClassLevel, this.getUniqueId());
        if (nextId != null) {
            if (nextId < 0L) {
                return null;
            }
            Class_ next = (Class_)new Class_DAO().get(nextId);
            if (next == null) {
                return null;
            }
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? next.getControllingDept() : next, right)) {
                return next.getNextClass(context, cmp, right);
            }
            return next;
        }
        Class_ next = null;
        for (SchedulingSubpart subpart = this.getSchedulingSubpart(); next == null && subpart != null; subpart = subpart.getNextSchedulingSubpart(context, cmp, null)) {
            for (Class_ c : subpart.getClasses()) {
                if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? c.getControllingDept() : c, right) || subpart.equals(this.getSchedulingSubpart()) && cmp.compare(this, c) >= 0 || next != null && cmp.compare(next, c) <= 0) continue;
                next = c;
            }
        }
        return next;
    }

    public Class_ getPreviousClass(SessionContext context, Comparator cmp, Right right) {
        Long previosId = Navigation.getPrevious(context, Navigation.sClassLevel, this.getUniqueId());
        if (previosId != null) {
            if (previosId < 0L) {
                return null;
            }
            Class_ previos = (Class_)new Class_DAO().get(previosId);
            if (previos == null) {
                return null;
            }
            if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? previos.getControllingDept() : previos, right)) {
                return previos.getPreviousClass(context, cmp, right);
            }
            return previos;
        }
        Class_ previous = null;
        for (SchedulingSubpart subpart = this.getSchedulingSubpart(); previous == null && subpart != null; subpart = subpart.getPreviousSchedulingSubpart(context, cmp, null)) {
            for (Class_ c : subpart.getClasses()) {
                if (right != null && !context.hasPermission(Department.class.equals(right.type()) ? c.getControllingDept() : c, right) || subpart.equals(this.getSchedulingSubpart()) && cmp.compare(this, c) <= 0 || previous != null && cmp.compare(previous, c) >= 0) continue;
                previous = c;
            }
        }
        return previous;
    }

    public void deleteAllDistributionPreferences(org.hibernate.Session hibSession) {
        this.deleteAllDistributionPreferences(hibSession, true);
    }

    public void deleteAllDistributionPreferences(org.hibernate.Session hibSession, boolean updateClass) {
        boolean deleted = false;
        if (this.getDistributionObjects() == null) {
            return;
        }
        Iterator<DistributionObject> i = this.getDistributionObjects().iterator();
        while (i.hasNext()) {
            DistributionObject relatedObject = i.next();
            DistributionPref distributionPref = relatedObject.getDistributionPref();
            distributionPref.getDistributionObjects().remove(relatedObject);
            Integer seqNo = relatedObject.getSequenceNumber();
            hibSession.remove((Object)relatedObject);
            deleted = true;
            if (distributionPref.getDistributionObjects().isEmpty()) {
                PreferenceGroup owner = distributionPref.getOwner();
                owner.getPreferences().remove(distributionPref);
                this.getPreferences().remove(distributionPref);
                hibSession.merge((Object)owner);
                hibSession.remove((Object)distributionPref);
            } else {
                if (seqNo != null) {
                    for (DistributionObject dObj : distributionPref.getDistributionObjects()) {
                        if (seqNo.compareTo(dObj.getSequenceNumber()) >= 0) continue;
                        dObj.setSequenceNumber(dObj.getSequenceNumber() - 1);
                        hibSession.merge((Object)dObj);
                    }
                }
                if (updateClass) {
                    hibSession.merge((Object)distributionPref);
                }
            }
            i.remove();
        }
        if (deleted && updateClass) {
            hibSession.merge((Object)this);
        }
    }

    @Transient
    public Integer getMinRoomLimit() {
        int expCap = this.getExpectedCapacity() == null ? 0 : this.getExpectedCapacity();
        float roomRatio = this.getRoomRatio() == null ? 0.0f : this.getRoomRatio().floatValue();
        return Math.round(expCap <= 0 ? roomRatio : (float)expCap * roomRatio);
    }

    public static List findAll(Long sessionId) {
        return Class_.findAll(Class_DAO.getInstance().getSession(), sessionId);
    }

    public static List<Class_> findAll(org.hibernate.Session hibSession, Long sessionId) {
        return hibSession.createQuery("select distinct c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId", Class_.class).setParameter("sessionId", (Object)sessionId).list();
    }

    public static List findAllForControllingSubjectArea(String subjectAreaAbbv, Long sessionId) {
        return Class_.findAllForControllingSubjectArea(subjectAreaAbbv, sessionId, new Class_DAO().getSession());
    }

    public static List<Class_> findAllForControllingSubjectArea(String subjectAreaAbbv, Long sessionId, org.hibernate.Session hibSession) {
        return hibSession.createQuery("select distinct c from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings as co where co.subjectArea.subjectAreaAbbreviation=:subjectAreaAbbv and c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and co.isControl=true", Class_.class).setParameter("subjectAreaAbbv", (Object)subjectAreaAbbv).setParameter("sessionId", (Object)sessionId).setHibernateFlushMode(FlushMode.MANUAL).list();
    }

    @Transient
    public String getDivSecNumber() {
        if (this.getParentClass() != null && this.getSchedulingSubpart().getItype().equals(this.getParentClass().getSchedulingSubpart().getItype())) {
            return this.getParentClass().getDivSecNumber();
        }
        String suffix = this.getClassSuffix();
        if (ApplicationProperty.ClassSuffixDivSecFormat.isTrue() && suffix != null && suffix.length() == 6) {
            return suffix.substring(0, 3) + "-" + suffix.substring(3, 6);
        }
        return suffix;
    }

    @Transient
    public int getClassLimit() {
        return this.getClassLimit(new CommitedClassAssignmentProxy());
    }

    public int getClassLimit(Assignment assignment) {
        int maxLimit;
        int minLimit = this.getExpectedCapacity();
        int limit = maxLimit = this.getMaxExpectedCapacity().intValue();
        if (minLimit < maxLimit && assignment != null) {
            int roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (this.getRoomRatio() == null ? 1.0f : this.getRoomRatio().floatValue()));
            limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
        }
        return limit;
    }

    public int getClassLimit(ClassAssignmentProxy proxy) {
        int roomLimit;
        int maxLimit;
        int minLimit = this.getExpectedCapacity();
        if (minLimit == (maxLimit = this.getMaxExpectedCapacity().intValue())) {
            return maxLimit;
        }
        ClassAssignmentProxy.AssignmentInfo assignment = null;
        try {
            assignment = proxy == null ? null : proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (assignment != null && (roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (this.getRoomRatio() == null ? 1.0f : this.getRoomRatio().floatValue()))) < maxLimit) {
            maxLimit = roomLimit;
        }
        for (SchedulingSubpart childSubpart : this.getSchedulingSubpart().getChildSubparts()) {
            int childrenLimit = 0;
            for (Class_ childClass : this.getChildClasses()) {
                if (!childClass.getSchedulingSubpart().equals(childSubpart)) continue;
                childrenLimit += childClass.getClassLimit(proxy);
            }
            if (childrenLimit >= maxLimit) continue;
            maxLimit = childrenLimit;
        }
        return Math.max(minLimit, maxLimit);
    }

    public int getClassLimit(CourseOffering offering) {
        return this.getClassLimit(new CommitedClassAssignmentProxy());
    }

    private boolean hasChildClass(Reservation r) {
        if (r.getClasses().contains(this)) {
            return true;
        }
        for (Class_ child : this.getChildClasses()) {
            if (!child.hasChildClass(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasClass(Reservation r) {
        if (r.getClasses().isEmpty()) {
            return false;
        }
        for (Class_ c = this; c != null; c = c.getParentClass()) {
            if (!r.getClasses().contains(c)) continue;
            return true;
        }
        for (Class_ child : this.getChildClasses()) {
            if (!child.hasChildClass(r)) continue;
            return true;
        }
        return false;
    }

    public void deleteAllDependentObjects(org.hibernate.Session hibSession, boolean updateClass) {
        this.deleteAllDistributionPreferences(hibSession, updateClass);
        this.deleteTeachingRequests(hibSession);
        this.deleteClassInstructors(hibSession);
        this.deleteAssignments(hibSession);
        Exam.deleteFromExams(hibSession, this);
        Event.deleteFromEvents(hibSession, this);
        if (updateClass) {
            hibSession.merge((Object)this);
        }
    }

    public void deleteClassInstructors(org.hibernate.Session hibSession) {
        Set<ClassInstructor> s = this.getClassInstructors();
        if (s == null || s.size() == 0) {
            return;
        }
        Iterator<ClassInstructor> i = s.iterator();
        while (i.hasNext()) {
            ClassInstructor ci = i.next();
            DepartmentalInstructor di = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(ci.getInstructor().getUniqueId());
            di.getClasses().remove(ci);
            ci.setInstructor(null);
            ci.setClassInstructing(null);
            hibSession.merge((Object)di);
            hibSession.remove((Object)ci);
            i.remove();
        }
    }

    public void deleteTeachingRequests(org.hibernate.Session hibSession) {
        Set<TeachingClassRequest> s = this.getTeachingRequests();
        if (s == null || s.size() == 0) {
            return;
        }
        Iterator<TeachingClassRequest> i = s.iterator();
        while (i.hasNext()) {
            TeachingClassRequest tcr = i.next();
            TeachingRequest tr = tcr.getTeachingRequest();
            tr.getClassRequests().remove(tcr);
            hibSession.remove((Object)tcr);
            if (tr.getClassRequests().isEmpty() && !tr.isAssignCoordinator().booleanValue()) {
                InstructionalOffering offering = tr.getOffering();
                offering.getTeachingRequests().remove(tr);
                hibSession.remove((Object)tr);
            } else {
                hibSession.merge((Object)tr);
            }
            i.remove();
        }
    }

    public void deleteAssignments(org.hibernate.Session hibSession) {
        Set<Assignment> s = this.getAssignments();
        for (Assignment ass : s) {
            for (ConstraintInfo ci : ass.getConstraintInfo()) {
                for (Assignment a : ci.getAssignments()) {
                    if (a.equals(ass)) continue;
                    a.getConstraintInfo().remove(ci);
                }
                hibSession.remove((Object)ci);
            }
        }
        this.deleteObjectsFromCollection(hibSession, s);
    }

    private void deleteObjectsFromCollection(org.hibernate.Session hibSession, Collection s) {
        if (s == null || s.size() == 0) {
            return;
        }
        Iterator i = s.iterator();
        while (i.hasNext()) {
            hibSession.remove(i.next());
            i.remove();
        }
    }

    @Transient
    public boolean isOddOrEvenWeeksOnly() {
        return this.effectiveDatePattern() != null && this.effectiveDatePattern().isAlternate();
    }

    public Object clone() {
        Class_ newClass = new Class_();
        newClass.setDatePattern(this.getDatePattern());
        newClass.setEnabledForStudentScheduling(this.isEnabledForStudentScheduling());
        newClass.setDisplayInstructor(this.isDisplayInstructor());
        newClass.setExpectedCapacity(this.getExpectedCapacity());
        newClass.setManagingDept(this.getManagingDept());
        newClass.setMaxExpectedCapacity(this.getMaxExpectedCapacity());
        newClass.setNbrRooms(this.getNbrRooms());
        newClass.setNotes(this.getNotes());
        newClass.setRoomRatio(this.getRoomRatio());
        newClass.setSchedulePrintNote(this.getSchedulePrintNote());
        newClass.setSchedulingSubpart(this.getSchedulingSubpart());
        newClass.setCancelled(this.isCancelled());
        newClass.setLmsInfo(this.getLmsInfo());
        newClass.setFundingDept(this.getFundingDept());
        return newClass;
    }

    public Object cloneWithPreferences() {
        Class_ newClass = (Class_)this.clone();
        if (this.getPreferences() != null) {
            Preference origPref2 = null;
            Preference newPref = null;
            for (Preference origPref2 : this.getPreferences()) {
                if (origPref2 instanceof DistributionPref) continue;
                newPref = (Preference)origPref2.clone();
                newPref.setOwner(newClass);
                newClass.addToPreferences(newPref);
            }
        }
        if (this.getClassInstructors() != null && !this.getClassInstructors().isEmpty()) {
            ClassInstructor ci2 = null;
            ClassInstructor newCi = null;
            for (ClassInstructor ci2 : this.getClassInstructors()) {
                newCi = new ClassInstructor();
                newCi.setClassInstructing(newClass);
                newCi.setInstructor(ci2.getInstructor());
                newCi.setLead(ci2.isLead());
                newCi.setPercentShare(ci2.getPercentShare());
                newCi.setResponsibility(ci2.getResponsibility());
                ci2.getInstructor().addToClasses(newCi);
                newClass.addToClassInstructors(newCi);
            }
        }
        return newClass;
    }

    public static Class_ findByExternalId(Long sessionId, String externalId) {
        return (Class_)new Class_DAO().getSession().createQuery("select c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and c.externalUniqueId=:externalId", Class_.class).setParameter("sessionId", (Object)sessionId).setParameter("externalId", (Object)externalId).setCacheable(true).uniqueResult();
    }

    public static Class_ findByIdRolledForwardFrom(Long sessionId, Long uniqueIdRolledForwardFrom) {
        return (Class_)new Class_DAO().getSession().createQuery("select c from Class_ c where c.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId=:sessionId and c.uniqueIdRolledForwardFrom=:uniqueIdRolledForwardFrom", Class_.class).setParameter("sessionId", (Object)sessionId).setParameter("uniqueIdRolledForwardFrom", (Object)uniqueIdRolledForwardFrom).setCacheable(true).uniqueResult();
    }

    @Transient
    public ClassEvent getEvent() {
        if (this.iEvent == null) {
            this.iEvent = (ClassEvent)new Class_DAO().getSession().createQuery("select e from ClassEvent e left join fetch e.meetings m where e.clazz.uniqueId=:classId", ClassEvent.class).setParameter("classId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult();
        }
        return this.iEvent;
    }

    public void setEvent(ClassEvent event) {
        this.iEvent = event;
    }

    @Transient
    public ClassEvent getCachedEvent() {
        return this.iEvent;
    }

    public void cancelEvent(UserContext user, org.hibernate.Session hibSession, boolean cancelled) {
        ClassEvent event = this.getEvent();
        if (event != null) {
            Calendar cal = Calendar.getInstance(Locale.US);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date today = cal.getTime();
            for (Meeting meeting : event.getMeetings()) {
                if (meeting.getMeetingDate().before(today) && !ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) continue;
                meeting.setStatus(cancelled ? Meeting.Status.CANCELLED : Meeting.Status.APPROVED);
                hibSession.merge((Object)meeting);
            }
            if (event.getNotes() == null) {
                event.setNotes(new HashSet<EventNote>());
            }
            EventNote note = new EventNote();
            note.setEvent(event);
            note.setNoteType(cancelled ? 7 : 2);
            note.setTimeStamp(new Date());
            note.setUser(user.getTrueName());
            note.setUserId(user.getTrueExternalUserId());
            note.setTextNote(cancelled ? MSG.classNoteCancelled(this.getClassLabel(hibSession)) : MSG.classNoteReopened(this.getClassLabel(hibSession)));
            if (this.getCommittedAssignment() == null) {
                note.setMeetings(MSG.classMeetingsNotApplicable());
            } else {
                note.setMeetings(this.getCommittedAssignment().getPlacement().getLongName(CONSTANTS.useAmPm()));
            }
            event.getNotes().add(note);
            hibSession.merge((Object)event);
        }
    }

    public String unassignCommited(UserContext user, org.hibernate.Session hibSession) {
        Transaction tx = null;
        try {
            Assignment oldAssignment;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            if ((oldAssignment = this.getCommittedAssignment()) == null) {
                throw new RuntimeException("Class " + this.getClassLabel() + " does not have an assignment.");
            }
            ClassEvent event = this.getEvent();
            if (event != null) {
                if (ApplicationProperty.ClassAssignmentChangePastMeetings.isTrue()) {
                    hibSession.remove((Object)event);
                } else {
                    Calendar cal = Calendar.getInstance(Locale.US);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    Date today = cal.getTime();
                    Iterator<Meeting> i = event.getMeetings().iterator();
                    while (i.hasNext()) {
                        if (i.next().getMeetingDate().before(today)) continue;
                        i.remove();
                    }
                    if (event.getMeetings().isEmpty()) {
                        hibSession.remove((Object)event);
                    } else {
                        if (event.getNotes() == null) {
                            event.setNotes(new HashSet<EventNote>());
                        }
                        EventNote note = new EventNote();
                        note.setEvent(event);
                        note.setNoteType(4);
                        note.setTimeStamp(new Date());
                        note.setUser(user.getTrueName());
                        note.setUserId(user.getTrueExternalUserId());
                        note.setTextNote(MSG.classNoteUnassigned(oldAssignment.getPlacement().getName()));
                        note.setMeetings(MSG.classMeetingsNotApplicable());
                        event.getNotes().add(note);
                        hibSession.persist((Object)event);
                    }
                }
            }
            String old = oldAssignment.getPlacement().getName();
            oldAssignment.getSolution().getAssignments().remove(oldAssignment);
            for (ConstraintInfo ci : oldAssignment.getConstraintInfo()) {
                for (Assignment a : ci.getAssignments()) {
                    if (a.equals(oldAssignment)) continue;
                    a.getConstraintInfo().remove(ci);
                }
                hibSession.remove((Object)ci);
            }
            hibSession.remove((Object)oldAssignment);
            this.setCommittedAssignment(null);
            hibSession.merge((Object)this);
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(user.getExternalUserId()), this.getSession(), this, this.getClassLabel() + " (" + old + " &rarr; N/A)", ChangeLog.Source.CLASS_INFO, ChangeLog.Operation.UNASSIGN, this.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), this.getManagingDept());
            if (tx != null) {
                tx.commit();
            }
            new _RootDAO().getSession().refresh((Object)this);
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalClassEditAction(this, hibSession);
            }
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Unassignment of " + this.getClassLabel() + " failed, reason: " + e.getMessage();
        }
    }

    public String assignCommited(ClassAssignmentInfo assignment, UserContext user, org.hibernate.Session hibSession) {
        Transaction tx = null;
        try {
            SolverGroup group;
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            String old = "N/A";
            Assignment oldAssignment = this.getCommittedAssignment();
            if (oldAssignment != null) {
                old = oldAssignment.getPlacement().getName();
                oldAssignment.getSolution().getAssignments().remove(oldAssignment);
                for (ConstraintInfo ci : oldAssignment.getConstraintInfo()) {
                    for (Assignment a : ci.getAssignments()) {
                        if (a.equals(oldAssignment)) continue;
                        a.getConstraintInfo().remove(ci);
                    }
                    hibSession.remove((Object)ci);
                }
                hibSession.remove((Object)oldAssignment);
            }
            if ((group = this.getManagingDept().getSolverGroup()) == null) {
                throw new RuntimeException("Department " + this.getManagingDept().getLabel() + " has no solver group.");
            }
            Solution solution = group.getCommittedSolution();
            if (solution == null) {
                throw new RuntimeException("Solver group " + group.getName() + " has no commited solution.");
            }
            DatePattern dp = (DatePattern)DatePatternDAO.getInstance().get(assignment.getDate().getId(), hibSession);
            Assignment a2 = new Assignment();
            a2.setSolution(solution);
            a2.setSlotsPerMtg(assignment.getTime().getNrSlotsPerMeeting());
            a2.setBreakTime(assignment.getTime().getBreakTime());
            a2.setClazz(this);
            a2.setClassName(this.getClassLabel(ApplicationProperty.SolverShowClassSufix.isTrue(), ApplicationProperty.SolverShowConfiguratioName.isTrue()));
            a2.setDays(assignment.getTime().getDayCode());
            a2.setRooms(new HashSet<Location>());
            a2.setInstructors(new HashSet<DepartmentalInstructor>());
            a2.setStartSlot(assignment.getTime().getStartSlot());
            a2.setTimePattern(assignment.getTime().getTimePattern(hibSession));
            a2.setDatePattern(dp != null ? dp : this.effectiveDatePattern());
            a2.setAssignmentInfo(new HashSet<AssignmentInfo>());
            for (ClassRoomInfo classRoomInfo : assignment.getRooms()) {
                a2.getRooms().add(classRoomInfo.getLocation(hibSession));
            }
            for (ClassInstructorInfo classInstructorInfo : assignment.getInstructors()) {
                if (!classInstructorInfo.isLead()) continue;
                a2.getInstructors().add(classInstructorInfo.getInstructor(hibSession).getInstructor());
            }
            hibSession.persist((Object)a2);
            AssignmentPreferenceInfo pref = new AssignmentPreferenceInfo();
            pref.setTimePreference(assignment.getTime().getPreference());
            for (ClassRoomInfo room : assignment.getRooms()) {
                pref.setRoomPreference(room.getLocationId(), room.getPreference());
            }
            AssignmentInfo assignmentInfo = new AssignmentInfo();
            assignmentInfo.setAssignment(a2);
            assignmentInfo.setDefinition(SolverInfoDef.findByName(hibSession, "AssignmentInfo"));
            assignmentInfo.setOpt(null);
            assignmentInfo.setInfo(pref);
            hibSession.persist((Object)assignmentInfo);
            a2.getAssignmentInfo().add(assignmentInfo);
            a2.cleastAssignmentInfoCache();
            ClassEvent event = this.getEvent();
            EventDateMapping.Class2EventDateMap class2eventDates = EventDateMapping.getMapping(this.getSession().getUniqueId());
            event = a2.generateCommittedEvent(event, true, class2eventDates);
            if (event != null && !event.getMeetings().isEmpty()) {
                if (event.getNotes() == null) {
                    event.setNotes(new HashSet<EventNote>());
                }
                EventNote note = new EventNote();
                note.setEvent(event);
                note.setNoteType(event.getUniqueId() == null ? 0 : 5);
                note.setTimeStamp(new Date());
                note.setUser(user.getTrueName());
                note.setUserId(user.getTrueExternalUserId());
                if (oldAssignment == null) {
                    note.setTextNote(MSG.classNoteAssigned(a2.getPlacement().getName()));
                } else {
                    note.setTextNote(MSG.classNoteReassigned(oldAssignment.getPlacement().getName(), a2.getPlacement().getName()));
                }
                note.setMeetings(assignment.getTime().getLongName() + (String)(assignment.getNrRooms() > 0 ? " " + assignment.getRoomNames(", ") : ""));
                event.getNotes().add(note);
                if (event.getUniqueId() == null) {
                    hibSession.persist((Object)event);
                } else {
                    hibSession.merge((Object)event);
                }
            }
            if (event != null && event.getMeetings().isEmpty() && event.getUniqueId() != null) {
                hibSession.remove((Object)event);
            }
            this.setCommittedAssignment(a2);
            hibSession.merge((Object)this);
            ChangeLog.addChange(hibSession, TimetableManager.findByExternalId(user.getExternalUserId()), this.getSession(), this, this.getClassLabel() + " (" + old + " &rarr; " + assignment.getTime().getName() + " " + assignment.getRoomNames(", ") + ")", ChangeLog.Source.CLASS_INFO, ChangeLog.Operation.ASSIGN, this.getSchedulingSubpart().getControllingCourseOffering().getSubjectArea(), this.getManagingDept());
            if (tx != null) {
                tx.commit();
            }
            new _RootDAO().getSession().refresh((Object)this);
            String className = ApplicationProperty.ExternalActionClassEdit.value();
            if (className != null && className.trim().length() > 0) {
                ExternalClassEditAction editAction = (ExternalClassEditAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                editAction.performExternalClassEditAction(this, hibSession);
            }
            return null;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            e.printStackTrace();
            return "Assignment of " + this.getClassLabel() + " failed, reason: " + e.getMessage();
        }
    }

    @Transient
    public Collection<Long> getEnrolledStudentIds() {
        return Class_DAO.getInstance().getSession().createQuery("select e.student.uniqueId from StudentClassEnrollment e where e.clazz.uniqueId=:classId", Long.class).setParameter("classId", (Object)this.getUniqueId()).setCacheable(true).list();
    }

    public String buildAssignedTimeHtml(ClassAssignmentProxy proxy) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        StringBuffer sb = new StringBuffer();
        try {
            a = proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null) {
            Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
            for (int i = 0; i < CONSTANTS.shortDays().length; ++i) {
                int idx;
                int n = idx = firstDay == null ? i : (i + firstDay) % 7;
                if ((Constants.DAY_CODES[idx] & a.getTimeLocation().getDayCode()) == 0) continue;
                sb.append(CONSTANTS.shortDays()[idx]);
            }
            sb.append(" ");
            sb.append(a.getTimeLocation().getStartTimeHeader(CONSTANTS.useAmPm()));
            sb.append("-");
            sb.append(a.getTimeLocation().getEndTimeHeader(CONSTANTS.useAmPm()));
        } else if (this.getEffectiveTimePreferences().isEmpty()) {
            DurationModel dm = this.getSchedulingSubpart().getInstrOfferingConfig().getDurationModel();
            Integer ah = dm.getArrangedHours(this.getSchedulingSubpart().getMinutesPerWk(), this.effectiveDatePattern());
            if (ah == null) {
                sb.append(MSG.arrHrs());
            } else {
                sb.append(MSG.arrHrsN(ah));
            }
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String buildAssignedDateHtml(ClassAssignmentProxy proxy) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        try {
            a = proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null && a.getTimeLocation() != null && a.getTimeLocation().getDatePatternName() != null) {
            return a.getTimeLocation().getDatePatternName();
        }
        return " ";
    }

    public String buildAssignedRoomHtml(ClassAssignmentProxy proxy) {
        ClassAssignmentProxy.AssignmentInfo a = null;
        StringBuffer sb = new StringBuffer();
        try {
            a = proxy.getAssignment(this);
        }
        catch (Exception e) {
            Debug.error(e);
        }
        if (a != null) {
            boolean first = true;
            for (Location room : a.getRooms()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(room.getLabel());
            }
        } else if (this.getEffectiveTimePreferences().isEmpty()) {
            boolean first = true;
            for (RoomPref rp : this.getEffectiveRoomPreferences()) {
                if (!rp.getPrefLevel().getPrefId().toString().equals(PreferenceLevel.PREF_LEVEL_REQUIRED)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(rp.getRoom().getLabel());
            }
        }
        if (sb.length() == 0) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public String buildInstructorHtml(String nameFormat) {
        StringBuffer sb = new StringBuffer();
        if (this.getClassInstructors() != null && !this.getClassInstructors().isEmpty()) {
            boolean first = true;
            for (ClassInstructor ci : this.getClassInstructors()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("<br>");
                }
                sb.append(ci.getInstructor().getName(nameFormat));
            }
        } else {
            sb.append(" ");
        }
        return sb.toString();
    }

    @Transient
    public static ExternalClassNameHelperInterface getExternalClassNameHelper() {
        return (ExternalClassNameHelperInterface)Customization.ClassNamingHelper.getProvider();
    }

    public String getClassLabel(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassLabel(this, courseOffering);
    }

    public String getClassSuffix(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassSuffix(this, courseOffering);
    }

    public String getClassLabelWithTitle(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassLabelWithTitle(this, courseOffering);
    }

    public String getExternalId(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getExternalId(this, courseOffering);
    }

    public Float getCredit(CourseOffering courseOffering) {
        return Class_.getExternalClassNameHelper().getClassCredit(this, courseOffering);
    }

    @Transient
    public SectioningInfo getSectioningInfo() {
        return (SectioningInfo)SectioningInfoDAO.getInstance().getSession().createQuery("select i from SectioningInfo i where i.clazz.uniqueId = :classId", SectioningInfo.class).setParameter("classId", (Object)this.getUniqueId()).setCacheable(true).uniqueResult();
    }

    @Override
    @Transient
    public Department getDepartment() {
        return this.getManagingDept();
    }

    public List<DistributionPref> getSharedPreferences(Long classId, Long subpartId, String[] preferences, String[] types) {
        if (classId == null) {
            return null;
        }
        Query q1 = Class_DAO.getInstance().getSession().createQuery("select o1.distributionPref from DistributionObject o1, DistributionObject o2" + (subpartId == null ? ", Class_ c2" : "") + " where o1.distributionPref = o2.distributionPref and o1.prefGroup.uniqueId in (:c1, :s1)" + (subpartId == null ? " and o2.prefGroup.uniqueId in (c2.uniqueId, c2.schedulingSubpart.uniqueId) and c2.uniqueId = :c2" : " and o2.prefGroup.uniqueId in (:c2, :s2)") + (String)(preferences == null || preferences.length == 0 ? "" : " and o1.distributionPref.prefLevel.prefProlog " + (preferences.length == 1 ? "=" : "in") + " :p") + (String)(types == null || types.length == 0 ? "" : " and o1.distributionPref.distributionType.reference " + (types.length == 1 ? "=" : "in") + " :t"), DistributionPref.class);
        Query q2 = Class_DAO.getInstance().getSession().createQuery("select dp from DistributionPref dp, ClassInstructor c1 inner join c1.instructor.preferences p, ClassInstructor c2 where c1.classInstructing.uniqueId = :c1 and c2.classInstructing.uniqueId = :c2 and c1.instructor = c2.instructor and p = dp" + (String)(preferences == null || preferences.length == 0 ? "" : " and dp.prefLevel.prefProlog " + (preferences.length == 1 ? "=" : "in") + " :p") + (String)(types == null || types.length == 0 ? "" : " and dp.distributionType.reference " + (types.length == 1 ? "=" : "in") + " :t"), DistributionPref.class);
        q1.setParameter("c1", (Object)this.getUniqueId()).setParameter("s1", (Object)this.getSchedulingSubpart().getUniqueId()).setParameter("c2", (Object)classId);
        q2.setParameter("c1", (Object)this.getUniqueId()).setParameter("c2", (Object)classId);
        if (subpartId != null) {
            q1.setParameter("s2", (Object)subpartId);
        }
        if (preferences != null) {
            if (preferences.length == 1) {
                q1.setParameter("p", (Object)preferences[0]);
                q2.setParameter("p", (Object)preferences[0]);
            } else if (preferences.length > 1) {
                q1.setParameterList("p", (Object[])preferences, String.class);
                q2.setParameterList("p", (Object[])preferences, String.class);
            }
        }
        if (types != null) {
            if (types.length == 1) {
                q1.setParameter("t", (Object)types[0]);
                q2.setParameter("t", (Object)types[0]);
            } else if (types.length > 1) {
                q1.setParameterList("t", (Object[])types, String.class);
                q2.setParameterList("t", (Object[])types, String.class);
            }
        }
        ArrayList<DistributionPref> ret = new ArrayList<DistributionPref>(q1.setCacheable(true).list());
        ret.addAll(q2.setCacheable(true).list());
        return ret;
    }

    public boolean canShareRoom(Class_ other) {
        if (other == null) {
            return false;
        }
        return !this.getSharedPreferences(other.getUniqueId(), other.getSchedulingSubpart().getUniqueId(), new String[]{PreferenceLevel.sRequired}, new String[]{"CAN_SHARE_ROOM", "MEET_WITH", "MEET_WITH_WEEKS"}).isEmpty();
    }

    public boolean canShareInstructor(Class_ other) {
        if (other == null) {
            return false;
        }
        return !this.getSharedPreferences(other.getUniqueId(), other.getSchedulingSubpart().getUniqueId(), new String[]{PreferenceLevel.sRequired}, new String[]{"MEET_WITH", "MEET_WITH_WEEKS"}).isEmpty();
    }

    public boolean canShareRoom(Long other) {
        if (other == null) {
            return false;
        }
        return !this.getSharedPreferences(other, null, new String[]{PreferenceLevel.sRequired}, new String[]{"CAN_SHARE_ROOM", "MEET_WITH", "MEET_WITH_WEEKS"}).isEmpty();
    }

    public boolean canShareInstructor(Long other) {
        if (other == null) {
            return false;
        }
        return !this.getSharedPreferences(other, null, new String[]{PreferenceLevel.sRequired}, new String[]{"MEET_WITH", "MEET_WITH_WEEKS"}).isEmpty();
    }

    public boolean isToIgnoreStudentConflictsWith(Class_ other) {
        if (other == null) {
            return false;
        }
        return !this.getSharedPreferences(other.getUniqueId(), other.getSchedulingSubpart().getUniqueId(), new String[]{PreferenceLevel.sRequired}, new String[]{"NO_CONFLICT"}).isEmpty();
    }

    public boolean isParentOf(Class_ clazz) {
        Class_ parent = clazz.getParentClass();
        return parent != null && (this.equals(parent) || this.isParentOf(parent));
    }

    @Transient
    public int getSectioningLimit() {
        if (this.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            return -1;
        }
        int limit = this.getMaxExpectedCapacity();
        Assignment assignment = this.getCommittedAssignment();
        if (this.getExpectedCapacity() < this.getMaxExpectedCapacity() && assignment != null && !assignment.getRooms().isEmpty()) {
            int roomSize = Integer.MAX_VALUE;
            for (Location room : assignment.getRooms()) {
                roomSize = Math.min(roomSize, room.getCapacity() == null ? 0 : room.getCapacity());
            }
            int roomLimit = (int)Math.floor((float)roomSize / (this.getRoomRatio() == null ? 1.0f : this.getRoomRatio().floatValue()));
            limit = Math.min(Math.max(this.getExpectedCapacity(), roomLimit), this.getMaxExpectedCapacity());
        }
        if (limit >= 9999) {
            limit = -1;
        }
        return limit;
    }

    @Transient
    private List<Reservation> getSectionReservations() {
        ArrayList<Reservation> reservations = new ArrayList<Reservation>();
        block0: for (Reservation reservation : this.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getReservations()) {
            if (reservation.getClasses().isEmpty()) continue;
            for (Class_ clazz : reservation.getClasses()) {
                if (!this.equals(clazz) && !this.isParentOf(clazz)) continue;
                reservations.add(reservation);
                continue block0;
            }
        }
        return reservations;
    }

    @Transient
    public int getUnreservedSectionSpace() {
        if (!this.isEnabledForStudentScheduling().booleanValue()) {
            return 0;
        }
        if (this.getSectioningLimit() < 0) {
            for (Reservation r : this.getSectionReservations()) {
                if (r.isExpired() || r.getReservationLimit() >= 0) continue;
                return 0;
            }
            return Integer.MAX_VALUE;
        }
        int available = this.getSectioningLimit() - this.getEnrollment();
        for (Reservation r : this.getSectionReservations()) {
            if (r.isExpired()) continue;
            if ((double)r.getReservationLimit() < 0.0) {
                return 0;
            }
            int reserved = r.getReservedAvailableSpace();
            available -= Math.max(0, reserved);
        }
        return available;
    }

    @Override
    @Transient
    public boolean isInstructorAssignmentNeeded() {
        for (TeachingClassRequest tcr : this.getTeachingRequests()) {
            if (!tcr.isAssignInstructor().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public int effectiveNbrInstructors() {
        int ret = 0;
        for (TeachingClassRequest tcr : this.getTeachingRequests()) {
            if (!tcr.isAssignInstructor().booleanValue()) continue;
            ret += tcr.getTeachingRequest().getNbrInstructors().intValue();
        }
        return ret;
    }

    public float effectiveTeachingLoad() {
        int instructors = 0;
        float totalLoad = 0.0f;
        for (TeachingClassRequest tcr : this.getTeachingRequests()) {
            if (!tcr.isAssignInstructor().booleanValue()) continue;
            instructors += tcr.getTeachingRequest().getNbrInstructors().intValue();
            totalLoad += (float)tcr.getTeachingRequest().getNbrInstructors().intValue() * tcr.getTeachingRequest().getTeachingLoad().floatValue();
        }
        return totalLoad / (float)instructors;
    }

    public String getClassPrefLabel(CourseOffering co) {
        Object label = this.getClassSuffix(co);
        if (label == null) {
            label = this.getSchedulingSubpart().getItypeDesc().trim() + " " + this.getSectionNumberString();
        } else if (((String)label).length() <= 4) {
            label = this.getSchedulingSubpart().getItypeDesc().trim() + " " + (String)label;
        }
        return label;
    }

    @Transient
    public LearningManagementSystemInfo getLms() {
        if (this.getLmsInfo() == null) {
            return LearningManagementSystemInfo.getDefaultIfExists(this.getSessionId());
        }
        return this.getLmsInfo();
    }

    public void setLms(LearningManagementSystemInfo lms) {
        if (lms != null && !lms.isDefaultLms().booleanValue()) {
            this.setLmsInfo(lms);
        } else {
            this.setLmsInfo(null);
        }
    }

    @Transient
    public Department getEffectiveFundingDept() {
        if (this.getFundingDept() == null) {
            return this.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getEffectiveFundingDept();
        }
        return this.getFundingDept();
    }

    public boolean hasRoomIndexedPrefs() {
        if (this.getNbrRooms() <= 1) {
            return false;
        }
        for (RoomPref roomPref : this.effectivePreferences(RoomPref.class)) {
            if (roomPref.getRoomIndex() == null || roomPref.getRoomIndex() >= this.getNbrRooms()) continue;
            return true;
        }
        for (BuildingPref buildingPref : this.effectivePreferences(BuildingPref.class)) {
            if (buildingPref.getRoomIndex() == null || buildingPref.getRoomIndex() >= this.getNbrRooms()) continue;
            return true;
        }
        for (RoomFeaturePref roomFeaturePref : this.effectivePreferences(RoomFeaturePref.class)) {
            if (roomFeaturePref.getRoomIndex() == null || roomFeaturePref.getRoomIndex() >= this.getNbrRooms()) continue;
            return true;
        }
        for (RoomGroupPref roomGroupPref : this.effectivePreferences(RoomGroupPref.class)) {
            if (roomGroupPref.getRoomIndex() == null || roomGroupPref.getRoomIndex() >= this.getNbrRooms()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeadInstructor() {
        for (ClassInstructor ci : this.getClassInstructors()) {
            if (!ci.isLead().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLeadInstructorWithUnavailabilities() {
        for (ClassInstructor ci : this.getClassInstructors()) {
            if (!ci.isLead().booleanValue() || !ci.getInstructor().hasUnavailabilities()) continue;
            return true;
        }
        return false;
    }
}

