/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;

public class TimetableGridInterface
implements GwtRpcResponse {

    public static class TimetableGridLegend
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 0L;
        private String iColor;
        private String iLabel;

        public TimetableGridLegend() {
        }

        public TimetableGridLegend(String color, String label) {
            this.iColor = color;
            this.iLabel = label;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String toString() {
            return this.iColor + ": " + this.iLabel;
        }
    }

    public static class TimetableGridBackground
    implements IsSerializable,
    Serializable,
    Comparable<TimetableGridBackground> {
        private static final long serialVersionUID = 0L;
        private int iDay;
        private int iSlot;
        private int iLength;
        private String iBackground;
        private boolean iAvailable = true;

        public String getBackground() {
            return this.iBackground;
        }

        public void setBackground(String background) {
            this.iBackground = background;
        }

        public boolean hasBackground() {
            return this.iBackground != null && !this.iBackground.isEmpty();
        }

        public int getDay() {
            return this.iDay;
        }

        public void setDay(int day) {
            this.iDay = day;
        }

        public int getSlot() {
            return this.iSlot;
        }

        public void setSlot(int slot) {
            this.iSlot = slot;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public boolean isAvailable() {
            return this.iAvailable;
        }

        public void setAvailable(boolean available) {
            this.iAvailable = available;
        }

        @Override
        public int compareTo(TimetableGridBackground c) {
            if (this.getDay() != c.getDay()) {
                return this.getDay() < c.getDay() ? -1 : 1;
            }
            if (this.getSlot() != c.getSlot()) {
                return this.getSlot() < c.getSlot() ? -1 : 1;
            }
            if (this.getLength() != c.getLength()) {
                return this.getLength() > c.getLength() ? -1 : 1;
            }
            return (this.hasBackground() ? this.getBackground() : "").compareTo(c.hasBackground() ? c.getBackground() : "");
        }

        private static String slot2time(int slot) {
            int h = slot / 12;
            int m = 5 * (slot % 12);
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString() {
            String[] days = new String[]{"M", "T", "W", "R", "F", "S", "U"};
            return days[this.getDay()] + " " + TimetableGridBackground.slot2time(this.getSlot()) + " - " + TimetableGridBackground.slot2time(this.getSlot() + this.getLength()) + " " + this.getBackground();
        }
    }

    public static class TimetableGridCell
    implements IsSerializable,
    Serializable,
    Comparable<TimetableGridCell> {
        private static final long serialVersionUID = 0L;
        private Type iType;
        private Long iId;
        private List<String> iNames;
        private List<String> iTitles;
        private String iDate;
        private String iTime;
        private List<String> iInstructors;
        private List<String> iRooms;
        private String iPreference;
        private int iDay;
        private int iSlot;
        private int iLength;
        private String iWeekCode;
        private Integer iNrLines = null;
        private Integer iIndex = null;
        private String iBackground;
        private boolean iItalics = false;
        private String iGroup;
        private boolean iCommitted = false;
        private Map<Integer, String> iProperties = null;
        private String iDays;
        private Map<Integer, Integer> iNrLinesPerDate = null;
        private Map<Integer, Integer> iIndexPerDate = null;

        public TimetableGridCell() {
        }

        public TimetableGridCell(TimetableGridCell cell, int day, String date) {
            this.iType = cell.iType;
            this.iId = cell.iId;
            this.iNames = cell.iNames == null ? null : new ArrayList<String>(cell.iNames);
            this.iTitles = cell.iTitles == null ? null : new ArrayList<String>(cell.iTitles);
            this.iDate = date;
            this.iTime = cell.iTime;
            this.iInstructors = cell.iInstructors == null ? null : new ArrayList<String>(cell.iInstructors);
            this.iRooms = cell.iRooms == null ? null : new ArrayList<String>(cell.iRooms);
            this.iPreference = cell.iPreference;
            this.iProperties = cell.iProperties;
            this.iDay = day;
            this.iSlot = cell.iSlot;
            this.iLength = cell.iLength;
            this.iWeekCode = cell.iWeekCode;
            this.iBackground = cell.iBackground;
            this.iItalics = cell.iItalics;
            this.iGroup = cell.iGroup;
            this.iDays = cell.iDays;
        }

        public void setType(Type type) {
            this.iType = type;
        }

        public boolean hasType() {
            return this.iType != null;
        }

        public Type getType() {
            return this.iType;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getId() {
            return this.iId;
        }

        public boolean hasId() {
            return this.iId != null;
        }

        public void clearName() {
            this.iNames = null;
        }

        public void addName(String name) {
            if (this.iNames == null) {
                this.iNames = new ArrayList<String>();
            }
            this.iNames.add(name);
        }

        public int getNrNames() {
            return this.iNames == null ? 0 : this.iNames.size();
        }

        public List<String> getNames() {
            return this.iNames;
        }

        public String getName(String delim) {
            if (this.iNames == null) {
                return "";
            }
            Object ret = "";
            for (String name : this.iNames) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : delim) + name;
            }
            return ret;
        }

        public void addTitle(String title) {
            if (this.iTitles == null) {
                this.iTitles = new ArrayList<String>();
            }
            this.iTitles.add(title);
        }

        public int getNrTitles() {
            return this.iTitles == null ? 0 : this.iTitles.size();
        }

        public List<String> getTitles() {
            return this.iTitles;
        }

        public String getTitle(String delim) {
            if (this.iTitles == null || this.iTitles.isEmpty()) {
                return this.getName(delim);
            }
            if (this.iTitles == null) {
                return "";
            }
            Object ret = "";
            for (String name : this.iTitles) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : delim) + name;
            }
            return ret;
        }

        public String getDate() {
            return this.iDate;
        }

        public void setDate(String date) {
            this.iDate = date;
        }

        public boolean hasDate() {
            return this.iDate != null && !this.iDate.isEmpty();
        }

        public String getTime() {
            return this.iTime;
        }

        public void setTime(String time) {
            this.iTime = time;
        }

        public boolean hasTime() {
            return this.iTime != null && !this.iTime.isEmpty();
        }

        public String getDays() {
            return this.iDays;
        }

        public void setDays(String days) {
            this.iDays = days;
        }

        public boolean hasDays() {
            return this.iDays != null && !this.iDays.isEmpty();
        }

        public void addInstructor(String name) {
            if (this.iInstructors == null) {
                this.iInstructors = new ArrayList<String>();
            }
            this.iInstructors.add(name);
        }

        public int getNrInstructors() {
            return this.iInstructors == null ? 0 : this.iInstructors.size();
        }

        public List<String> getInstructors() {
            return this.iInstructors;
        }

        public String getInstructor(String delim) {
            if (this.iInstructors == null) {
                return "";
            }
            Object ret = "";
            for (String name : this.iInstructors) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : delim) + name;
            }
            return ret;
        }

        public void resetInstructors() {
            this.iInstructors = null;
        }

        public void setWeekCode(String weekCode) {
            this.iWeekCode = weekCode;
        }

        public boolean hasWeekCode() {
            return this.iWeekCode != null && !this.iWeekCode.isEmpty() && this.iWeekCode.indexOf(49) >= 0;
        }

        public String getWeekCode() {
            return this.iWeekCode;
        }

        public boolean getWeekCode(int n) {
            return this.iWeekCode != null && n < this.iWeekCode.length() && this.iWeekCode.charAt(n) == '1';
        }

        public int getWeekCodeNextBitSet(int n) {
            return this.iWeekCode != null && n < this.iWeekCode.length() ? this.iWeekCode.indexOf(49, n) : -1;
        }

        public int getFirstDate() {
            return this.iWeekCode == null ? -1 : this.iWeekCode.indexOf(49);
        }

        public boolean hasDate(int n) {
            return this.iWeekCode == null || this.iWeekCode.length() <= n ? false : this.iWeekCode.charAt(n) == '1';
        }

        public void addRoom(String name) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<String>();
            }
            this.iRooms.add(name);
        }

        public int getNrRooms() {
            return this.iRooms == null ? (this.hasGroup() ? 1 : 0) : this.iRooms.size();
        }

        public List<String> getRooms() {
            if (this.iRooms == null || this.iRooms.isEmpty()) {
                ArrayList<String> rooms = new ArrayList<String>();
                if (this.hasGroup()) {
                    rooms.add(this.getGroup());
                }
                return rooms;
            }
            ArrayList<String> rooms = new ArrayList<String>(this.iRooms);
            if (this.hasGroup()) {
                rooms.set(rooms.size() - 1, (String)rooms.get(rooms.size() - 1) + " " + this.getGroup());
            }
            return rooms;
        }

        public String getRoom(String delim) {
            if (this.iRooms == null) {
                return this.hasGroup() ? this.getGroup() : "";
            }
            Object ret = "";
            for (String name : this.iRooms) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : delim) + name;
            }
            if (this.hasGroup()) {
                ret = (String)ret + " " + this.getGroup();
            }
            return ret;
        }

        public String getPreference() {
            return this.iPreference;
        }

        public void setPreference(String preference) {
            this.iPreference = preference;
        }

        public boolean hasPreference() {
            return this.iPreference != null && !this.iPreference.isEmpty();
        }

        public boolean hasProperties() {
            return this.iProperties != null && !this.iProperties.isEmpty();
        }

        public void setProperty(Property p, String value) {
            if (this.iProperties == null) {
                this.iProperties = new HashMap<Integer, String>();
            }
            this.iProperties.put(p.ordinal(), value);
        }

        public void setProperty(Property p, int value) {
            if (this.iProperties == null) {
                this.iProperties = new HashMap<Integer, String>();
            }
            this.iProperties.put(p.ordinal(), String.valueOf(value));
        }

        public String getProperty(Property p, String defaultValue) {
            if (this.iProperties == null) {
                return defaultValue;
            }
            String value = this.iProperties.get(p.ordinal());
            return value == null ? defaultValue : value;
        }

        public boolean hasProperty(Property p) {
            return this.iProperties != null && this.iProperties.containsKey(p.ordinal());
        }

        public String getBackground() {
            return this.iBackground;
        }

        public void setBackground(String background) {
            this.iBackground = background;
        }

        public boolean hasBackground() {
            return this.iBackground != null && !this.iBackground.isEmpty();
        }

        public int getDay() {
            return this.iDay;
        }

        public void setDay(int day) {
            this.iDay = day;
        }

        public int getSlot() {
            return this.iSlot;
        }

        public void setSlot(int slot) {
            this.iSlot = slot;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getGroup() {
            return this.iGroup;
        }

        public void setGroup(String group) {
            this.iGroup = group;
        }

        public boolean hasGroup() {
            return this.iGroup != null && !this.iGroup.isEmpty();
        }

        public int hashCode() {
            if (this.hasId()) {
                return this.getId().hashCode();
            }
            return this.getName(":").hashCode();
        }

        public boolean sameClassOrMeeting(TimetableGridCell c) {
            return this.getType() == c.getType() && this.hasId() && this.getId().equals(c.getId());
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimetableGridCell)) {
                return false;
            }
            TimetableGridCell c = (TimetableGridCell)o;
            if (this.hasId() || c.hasId()) {
                return this.hasId() ? this.getId().equals(c.getId()) : false;
            }
            return this.getSlot() == c.getSlot() && this.getDay() == c.getDay() && this.getLength() == c.getLength() && this.getName(":").equals(c.getName(":"));
        }

        @Override
        public int compareTo(TimetableGridCell c) {
            if (this.getFirstDate() != c.getFirstDate()) {
                return this.getFirstDate() < c.getFirstDate() ? -1 : 1;
            }
            if (this.getDay() != c.getDay()) {
                return this.getDay() < c.getDay() ? -1 : 1;
            }
            if (this.getSlot() != c.getSlot()) {
                return this.getSlot() < c.getSlot() ? -1 : 1;
            }
            if (this.getLength() != c.getLength()) {
                return this.getLength() > c.getLength() ? -1 : 1;
            }
            int cmp = this.getName(":").compareTo(c.getName(":"));
            if (cmp != 0) {
                return cmp;
            }
            if (this.getType() != c.getType()) {
                return this.getType().compareTo(c.getType());
            }
            return (this.hasId() ? this.getId() : Long.valueOf(0L)).compareTo(c.hasId() ? c.getId() : Long.valueOf(0L));
        }

        public int getMinLines(boolean showRoom, boolean showInstructor, boolean showTime, boolean showPreference, boolean showDate) {
            int lines = this.getNrNames() + (showTime && this.hasTime() ? 1 : 0) + (showDate && this.hasDate() ? 1 : 0) + (showRoom ? this.getNrRooms() : 0) + (showInstructor ? this.getNrInstructors() : 0) + (showPreference && this.hasPreference() ? 1 : 0);
            return lines < 2 ? 2 : lines;
        }

        public int getNrLines() {
            return this.iNrLines == null ? 0 : this.iNrLines;
        }

        public void setNrLines(int lines) {
            this.iNrLines = lines;
        }

        public int getIndex() {
            return this.iIndex == null ? 0 : this.iIndex;
        }

        public void setIndex(int index) {
            this.iIndex = index;
        }

        public int getNrLines(int date) {
            Integer lines;
            if (this.iNrLinesPerDate != null && (lines = this.iNrLinesPerDate.get(date)) != null) {
                return lines;
            }
            return this.iNrLines == null ? 0 : this.iNrLines;
        }

        public void setNrLines(int date, int lines) {
            if (this.iNrLinesPerDate == null) {
                this.iNrLinesPerDate = new HashMap<Integer, Integer>();
            }
            this.iNrLinesPerDate.put(date, lines);
            this.iNrLines = lines;
        }

        public int getIndex(int date) {
            Integer lines;
            if (this.iIndexPerDate != null && (lines = this.iIndexPerDate.get(date)) != null) {
                return lines;
            }
            return this.iIndex == null ? 0 : this.iIndex;
        }

        public void setIndex(int date, int index) {
            if (this.iIndexPerDate == null) {
                this.iIndexPerDate = new HashMap<Integer, Integer>();
            }
            this.iIndexPerDate.put(date, index);
            this.iIndex = index;
        }

        public boolean isItalics() {
            return this.iItalics;
        }

        public void setItalics(boolean italics) {
            this.iItalics = italics;
        }

        public boolean isCommitted() {
            return this.iCommitted;
        }

        public void setCommitted(boolean committed) {
            this.iCommitted = committed;
        }

        public String toString() {
            String[] days = new String[]{"M", "T", "W", "R", "F", "S", "U"};
            return this.getNames().get(0) + " " + days[this.getDay()] + (String)(this.hasTime() ? " " + this.getTime() : "") + (String)(this.hasDate() ? " " + this.getDate() : "");
        }

        public static enum Type implements IsSerializable
        {
            Class,
            Event;

        }

        public static enum Property implements IsSerializable
        {
            TimePreference,
            StudentConflicts,
            StudentConflictsHard,
            StudentConflictsCommitted,
            StudentConflictsDistance,
            RoomPreference,
            InstructorPreference,
            InitialAssignment,
            PerturbationPenalty,
            DepartmentBalance,
            DistributionPreference,
            Owner,
            NonConflictingPlacements,
            EventType;

        }
    }

    public static class TimetableGridModel
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 0L;
        private int iResourceType;
        private Long iResourceId;
        private String iExternalId;
        private List<TimetableGridCell> iCells = new ArrayList<TimetableGridCell>();
        private List<TimetableGridBackground> iBackgrounds = new ArrayList<TimetableGridBackground>();
        private String iName;
        private int iSize = 0;
        private Long iType = null;
        private int iFirstDay = -1;
        private int iFirstSessionDay = 0;
        private double iUtilization = 0.0;
        private Date iFirstDate = null;
        private String iNameColor = null;

        public TimetableGridModel() {
        }

        public TimetableGridModel(int resourceType, long resourceId) {
            this();
            this.iResourceType = resourceType;
            this.iResourceId = resourceId;
        }

        public int getResourceType() {
            return this.iResourceType;
        }

        public Long getResourceId() {
            return this.iResourceId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setFirstDay(int firstDay) {
            this.iFirstDay = firstDay;
        }

        public int getFirstDay() {
            return this.iFirstDay;
        }

        public void setFirstSessionDay(int firstDay) {
            this.iFirstSessionDay = firstDay;
        }

        public int getFirstSessionDay() {
            return this.iFirstSessionDay;
        }

        public void setFirstDate(Date date) {
            this.iFirstDate = date;
        }

        public Date getFirstDate() {
            return this.iFirstDate;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public boolean hasNameColor() {
            return this.iNameColor != null && !this.iNameColor.isEmpty();
        }

        public void setNameColor(String color) {
            this.iNameColor = color;
        }

        public String getNameColor() {
            return this.iNameColor;
        }

        public void setSize(int size) {
            this.iSize = size;
        }

        public int getSize() {
            return this.iSize;
        }

        public void setType(Long type) {
            this.iType = type;
        }

        public Long getType() {
            return this.iType;
        }

        public void setUtilization(double utilization) {
            this.iUtilization = utilization;
        }

        public double getUtilization() {
            return this.iUtilization;
        }

        public void addCell(TimetableGridCell cell) {
            this.iCells.add(cell);
        }

        public List<TimetableGridCell> getCells() {
            return this.iCells;
        }

        public void addBackground(TimetableGridBackground background) {
            this.iBackgrounds.add(background);
        }

        public List<TimetableGridBackground> getBackgrounds() {
            return this.iBackgrounds;
        }

        public int getNrLines(int day, int minLines) {
            int lines = minLines;
            for (TimetableGridCell cell : this.getCells()) {
                if (cell.getDay() != day || cell.getIndex() + cell.getNrLines() <= lines) continue;
                lines = cell.getIndex() + cell.getNrLines();
            }
            return lines;
        }

        public int getNrDateLines(int day, int date, int minLines) {
            int lines = minLines;
            for (TimetableGridCell cell : this.getCells()) {
                if (cell.getDay() != day || cell.getIndex(date) + cell.getNrLines(date) <= lines || !cell.hasDate(date)) continue;
                lines = cell.getIndex(date) + cell.getNrLines(date);
            }
            return lines;
        }

        public boolean hasDate(int day, int date) {
            for (TimetableGridCell cell : this.getCells()) {
                if (cell.getDay() != day || !cell.hasDate(date)) continue;
                return true;
            }
            return false;
        }

        public boolean isAvailable(int day, int slot) {
            for (TimetableGridBackground bg : this.getBackgrounds()) {
                if (bg.isAvailable() || bg.getDay() != day || bg.getSlot() > slot || slot >= bg.getSlot() + bg.getLength()) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.getName();
        }
    }

    public static class TimetableGridResponse
    implements GwtRpcResponse,
    Serializable,
    SolverInterface.HasPageMessages {
        private static final long serialVersionUID = 0L;
        private List<TimetableGridModel> iModels = new ArrayList<TimetableGridModel>();
        private String iDefaultDatePatternName;
        private List<SolverInterface.PageMessage> iPageMessages = null;
        private List<TimetableGridLegend> iAssignedLegend = new ArrayList<TimetableGridLegend>();
        private List<TimetableGridLegend> iNotAssignedLegend = new ArrayList<TimetableGridLegend>();
        private int iWeekOffset = 0;

        public void addModel(TimetableGridModel model) {
            this.iModels.add(model);
        }

        public List<TimetableGridModel> getModels() {
            return this.iModels;
        }

        public void setDefaultDatePatternName(String datePatternName) {
            this.iDefaultDatePatternName = datePatternName;
        }

        public String getDefaultDatePatternName() {
            return this.iDefaultDatePatternName;
        }

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<SolverInterface.PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(SolverInterface.PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<SolverInterface.PageMessage>();
            }
            this.iPageMessages.add(message);
        }

        public void addAssignedLegend(String color, String label) {
            this.iAssignedLegend.add(new TimetableGridLegend(color, label));
        }

        public List<TimetableGridLegend> getAssignedLegend() {
            return this.iAssignedLegend;
        }

        public void addNotAssignedLegend(String color, String label) {
            this.iNotAssignedLegend.add(new TimetableGridLegend(color, label));
        }

        public List<TimetableGridLegend> getNotAssignedLegend() {
            return this.iNotAssignedLegend;
        }

        public int getWeekOffset() {
            return this.iWeekOffset;
        }

        public void setWeekOffset(int weekOffset) {
            this.iWeekOffset = weekOffset;
        }
    }

    public static class TimetableGridRequest
    implements GwtRpcRequest<TimetableGridResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private FilterInterface iFilter;

        public FilterInterface getFilter() {
            return this.iFilter;
        }

        public void setFilter(FilterInterface filter) {
            this.iFilter = filter;
        }
    }

    public static class TimetableGridFilterResponse
    extends FilterInterface
    implements GwtRpcResponse,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class TimetableGridFilterRequest
    implements GwtRpcRequest<TimetableGridFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }
}

