/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.shared.EventInterface;

public class RoomInterface
implements IsSerializable {

    public static class BuildingCheckCanDeleteRequest
    implements GwtRpcRequest<GwtRpcResponseBoolean> {
        private Long iBuildingId;

        public BuildingCheckCanDeleteRequest() {
        }

        public BuildingCheckCanDeleteRequest(Long buildingId) {
            this.iBuildingId = buildingId;
        }

        public Long getBuildingId() {
            return this.iBuildingId;
        }

        public void setBuildingId(Long buildingId) {
            this.iBuildingId = buildingId;
        }
    }

    public static class UpdateBuildingRequest
    implements GwtRpcRequest<BuildingInterface> {
        private UpdateBuildingAction iAction;
        private BuildingInterface iBuilding;
        private Boolean iUpdateRoomCoordinates;

        public UpdateBuildingAction getAction() {
            return this.iAction;
        }

        public void setAction(UpdateBuildingAction action) {
            this.iAction = action;
        }

        public BuildingInterface getBuilding() {
            return this.iBuilding;
        }

        public void setBuilding(BuildingInterface building) {
            this.iBuilding = building;
        }

        public void setUpdateRoomCoordinates(Boolean updateRoomCoordinates) {
            this.iUpdateRoomCoordinates = updateRoomCoordinates;
        }

        public Boolean getUpdateRoomCoordinates() {
            return this.iUpdateRoomCoordinates;
        }
    }

    public static enum UpdateBuildingAction {
        CREATE,
        UPDATE,
        DELETE,
        UPDATE_DATA;

    }

    public static enum BuildingsColumn {
        ABBREVIATION,
        NAME,
        EXTERNAL_ID,
        COORDINATES;

    }

    public static class GetRoomsOfABuildingRequest
    implements GwtRpcRequest<GwtRpcResponseList<RoomDetailInterface>> {
        private Long iBuildingId;

        public GetRoomsOfABuildingRequest() {
        }

        public GetRoomsOfABuildingRequest(Long buildingId) {
            this.iBuildingId = buildingId;
        }

        public Long getBuildingId() {
            return this.iBuildingId;
        }

        public void setBuildingId(Long buildingId) {
            this.iBuildingId = buildingId;
        }
    }

    public static class BuildingsDataResponse
    implements GwtRpcResponse {
        private List<BuildingInterface> iBuildings;
        private boolean iCanAdd;
        private boolean iCanExportPDF;
        private boolean iCanUpdateData;
        private String iEllipsoid = null;

        public void addBuilding(BuildingInterface building) {
            if (this.iBuildings == null) {
                this.iBuildings = new ArrayList<BuildingInterface>();
            }
            this.iBuildings.add(building);
        }

        public List<BuildingInterface> getBuildings() {
            return this.iBuildings;
        }

        public boolean hasBuildings() {
            return this.iBuildings != null && !this.iBuildings.isEmpty();
        }

        public boolean isCanAdd() {
            return this.iCanAdd;
        }

        public void setCanAdd(boolean canAdd) {
            this.iCanAdd = canAdd;
        }

        public boolean isCanExportPDF() {
            return this.iCanExportPDF;
        }

        public void setCanExportPDF(boolean canExportPDF) {
            this.iCanExportPDF = canExportPDF;
        }

        public boolean isCanUpdateData() {
            return this.iCanUpdateData;
        }

        public void setCanUpdateData(boolean canUpdateData) {
            this.iCanUpdateData = canUpdateData;
        }

        public String getEllipsoid() {
            return this.iEllipsoid;
        }

        public boolean hasEllipsoid() {
            return this.iEllipsoid != null & !this.iEllipsoid.isEmpty();
        }

        public void setEllipsoid(String ellipsoid) {
            this.iEllipsoid = ellipsoid;
        }
    }

    public static class GetBuildingsRequest
    implements GwtRpcRequest<BuildingsDataResponse> {
    }

    public static class GeocodeResponse
    implements GwtRpcResponse {
        private Double iLat;
        private Double iLon;
        private String iQuery = null;

        public void setCoordinates(Double lat, Double lon) {
            this.iLat = lat;
            this.iLon = lon;
        }

        public boolean hasCoordinates() {
            return this.iLat != null && this.iLon != null;
        }

        public Double getLat() {
            return this.iLat;
        }

        public Double getLon() {
            return this.iLon;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public boolean hasQuery() {
            return this.iQuery != null && !this.iQuery.isEmpty();
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }
    }

    public static class GeocodeRequest
    implements GwtRpcRequest<GeocodeResponse> {
        private boolean iReverse = false;
        private Double iLat = null;
        private Double iLon = null;
        private String iViewbox = null;
        private String iQuery = null;

        public GeocodeRequest() {
        }

        public GeocodeRequest(String query, String viewbox) {
            this.iReverse = false;
            this.iQuery = query;
            this.iViewbox = viewbox;
        }

        public GeocodeRequest(double lat, double lon) {
            this.iReverse = true;
            this.iLat = lat;
            this.iLon = lon;
        }

        public boolean isReverse() {
            return this.iReverse;
        }

        public void setReverse(boolean reverse) {
            this.iReverse = reverse;
        }

        public void setCoordinates(double lat, double lon) {
            this.iLat = lat;
            this.iLon = lon;
        }

        public boolean hasCoordinates() {
            return this.iLat != null && this.iLon != null;
        }

        public Double getLat() {
            return this.iLat;
        }

        public Double getLon() {
            return this.iLon;
        }

        public boolean hasViewBox() {
            return this.iViewbox != null;
        }

        public void setViewBox(double x1, double y1, double x2, double y2) {
            this.iViewbox = x1 + "," + y1 + "," + x2 + "," + y2;
        }

        public void setViewBox(String viewbox) {
            this.iViewbox = viewbox;
        }

        public String getViewBox() {
            return this.iViewbox;
        }

        public String getQuery() {
            return this.iQuery;
        }

        public boolean hasQuery() {
            return this.iQuery != null && !this.iQuery.isEmpty();
        }

        public void setQuery(String query) {
            this.iQuery = query;
        }
    }

    public static class UpdateRoomFeatureRequest
    implements GwtRpcRequest<FeatureInterface> {
        private Long iSessionId = null;
        private Long iDeleteFeatureId = null;
        private FeatureInterface iFeature = null;
        private List<Long> iAddLocations = new ArrayList<Long>();
        private List<Long> iDropLocations = new ArrayList<Long>();
        private List<Long> iFutureSessions = null;

        public void setDeleteFeatureId(Long featureId) {
            this.iDeleteFeatureId = featureId;
        }

        public boolean hasDeleteFeatureId() {
            return this.iDeleteFeatureId != null;
        }

        public Long getDeleteFeatureId() {
            return this.iDeleteFeatureId;
        }

        public boolean hasFeature() {
            return this.iFeature != null;
        }

        public void setFeature(FeatureInterface Feature2) {
            this.iFeature = Feature2;
        }

        public FeatureInterface getFeature() {
            return this.iFeature;
        }

        public void addLocation(Long locationId) {
            this.iAddLocations.add(locationId);
        }

        public List<Long> getAddLocations() {
            return this.iAddLocations;
        }

        public boolean hasAddLocations() {
            return !this.iAddLocations.isEmpty();
        }

        public void dropLocation(Long locationId) {
            this.iDropLocations.add(locationId);
        }

        public List<Long> getDropLocations() {
            return this.iDropLocations;
        }

        public boolean hasDropLocations() {
            return !this.iDropLocations.isEmpty();
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void addFutureSession(Long sessionId) {
            if (this.iFutureSessions == null) {
                this.iFutureSessions = new ArrayList<Long>();
            }
            this.iFutureSessions.add(sessionId);
        }

        public List<Long> getFutureSessions() {
            return this.iFutureSessions;
        }

        public boolean hasFutureSessions() {
            return this.iFutureSessions != null && !this.iFutureSessions.isEmpty();
        }

        @Override
        public String toString() {
            if (this.hasFeature()) {
                return this.getFeature().getLabel() + (String)(this.getFeature().isDepartmental() ? " (" + this.getFeature().getDepartment().getDeptCode() + ")" : (this.getFeature().getType() == null ? "(Global)" : "(" + this.getFeature().getType().getAbbreviation() + ")")) + (String)(this.hasAddLocations() ? " ADD" + String.valueOf(this.getAddLocations()) : "") + (String)(this.hasDropLocations() ? " DROP" + String.valueOf(this.getDropLocations()) : "");
            }
            return "DELETE " + this.getDeleteFeatureId();
        }
    }

    public static class UpdateRoomGroupRequest
    implements GwtRpcRequest<GroupInterface> {
        private Long iSessionId = null;
        private Long iDeleteGroupId = null;
        private GroupInterface iGroup = null;
        private List<Long> iAddLocations = new ArrayList<Long>();
        private List<Long> iDropLocations = new ArrayList<Long>();
        private List<Long> iFutureSessions = null;

        public void setDeleteGroupId(Long groupId) {
            this.iDeleteGroupId = groupId;
        }

        public boolean hasDeleteGroupId() {
            return this.iDeleteGroupId != null;
        }

        public Long getDeleteGroupId() {
            return this.iDeleteGroupId;
        }

        public boolean hasGroup() {
            return this.iGroup != null;
        }

        public void setGroup(GroupInterface group) {
            this.iGroup = group;
        }

        public GroupInterface getGroup() {
            return this.iGroup;
        }

        public void addLocation(Long locationId) {
            this.iAddLocations.add(locationId);
        }

        public List<Long> getAddLocations() {
            return this.iAddLocations;
        }

        public boolean hasAddLocations() {
            return !this.iAddLocations.isEmpty();
        }

        public void dropLocation(Long locationId) {
            this.iDropLocations.add(locationId);
        }

        public List<Long> getDropLocations() {
            return this.iDropLocations;
        }

        public boolean hasDropLocations() {
            return !this.iDropLocations.isEmpty();
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void addFutureSession(Long sessionId) {
            if (this.iFutureSessions == null) {
                this.iFutureSessions = new ArrayList<Long>();
            }
            this.iFutureSessions.add(sessionId);
        }

        public List<Long> getFutureSessions() {
            return this.iFutureSessions;
        }

        public boolean hasFutureSessions() {
            return this.iFutureSessions != null && !this.iFutureSessions.isEmpty();
        }

        @Override
        public String toString() {
            if (this.hasGroup()) {
                return this.getGroup().getLabel() + (String)(this.getGroup().isDepartmental() ? " (" + this.getGroup().getDepartment().getDeptCode() + ")" : (this.getGroup().isDefault() ? "(Default)" : "(Global)")) + (String)(this.hasAddLocations() ? " ADD" + String.valueOf(this.getAddLocations()) : "") + (String)(this.hasDropLocations() ? " DROP" + String.valueOf(this.getDropLocations()) : "");
            }
            return "DELETE " + this.getDeleteGroupId();
        }
    }

    public static class SearchRoomFeaturesRequest
    implements GwtRpcRequest<GwtRpcResponseList<FeatureInterface>> {
        private EventInterface.RoomFilterRpcRequest iFilter;
        private Long iSessionId;

        public SearchRoomFeaturesRequest() {
        }

        public SearchRoomFeaturesRequest(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public EventInterface.RoomFilterRpcRequest getFilter() {
            return this.iFilter;
        }

        public void setFilter(EventInterface.RoomFilterRpcRequest filter) {
            this.iFilter = filter;
        }

        @Override
        public String toString() {
            return this.iFilter == null ? "NULL" : this.iFilter.toString();
        }
    }

    public static class SearchRoomGroupsRequest
    implements GwtRpcRequest<GwtRpcResponseList<GroupInterface>> {
        private EventInterface.RoomFilterRpcRequest iFilter;
        private Long iSessionId;

        public SearchRoomGroupsRequest() {
        }

        public SearchRoomGroupsRequest(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public EventInterface.RoomFilterRpcRequest getFilter() {
            return this.iFilter;
        }

        public void setFilter(EventInterface.RoomFilterRpcRequest filter) {
            this.iFilter = filter;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        @Override
        public String toString() {
            return this.iFilter == null ? "NULL" : this.iFilter.toString();
        }
    }

    public static class UpdateRoomDepartmentsRequest
    implements GwtRpcRequest<GwtRpcResponseNull> {
        private Long iSessionId = null;
        private DepartmentInterface iDepartment;
        private ExamTypeInterface iExamType;
        private List<Long> iAddLocations = new ArrayList<Long>();
        private List<Long> iDropLocations = new ArrayList<Long>();

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public void setDepartment(DepartmentInterface department) {
            this.iDepartment = department;
        }

        public DepartmentInterface getDepartment() {
            return this.iDepartment;
        }

        public boolean hasDepartment() {
            return this.iDepartment != null;
        }

        public void setExamType(ExamTypeInterface type) {
            this.iExamType = type;
        }

        public ExamTypeInterface getExamType() {
            return this.iExamType;
        }

        public boolean hasExamType() {
            return this.iExamType != null;
        }

        public void addLocation(Long locationId) {
            this.iAddLocations.add(locationId);
        }

        public List<Long> getAddLocations() {
            return this.iAddLocations;
        }

        public boolean hasAddLocations() {
            return !this.iAddLocations.isEmpty();
        }

        public void dropLocation(Long locationId) {
            this.iDropLocations.add(locationId);
        }

        public List<Long> getDropLocations() {
            return this.iDropLocations;
        }

        public boolean hasDropLocations() {
            return !this.iDropLocations.isEmpty();
        }

        @Override
        public String toString() {
            return (this.hasDepartment() ? this.getDepartment().getDeptCode() : this.getExamType().getReference()) + (String)(this.hasAddLocations() ? " ADD" + String.valueOf(this.getAddLocations()) : "") + (String)(this.hasDropLocations() ? " DROP" + String.valueOf(this.getDropLocations()) : "");
        }
    }

    public static class AttachmentTypeInterface
    implements IsSerializable {
        private Long iId;
        private String iAbbreviation;
        private String iLabel;
        private boolean iImage = false;
        private boolean iTooltip = false;
        private boolean iTable = false;

        public AttachmentTypeInterface() {
        }

        public AttachmentTypeInterface(Long id, String abbv, String label, boolean image, boolean tooltip, boolean table) {
            this.iId = id;
            this.iAbbreviation = abbv;
            this.iLabel = label;
            this.iImage = image;
            this.iTooltip = tooltip;
            this.iTable = table;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbreviation;
        }

        public void setAbbreviation(String abbreviation) {
            this.iAbbreviation = abbreviation;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean isTooltip() {
            return this.iTooltip;
        }

        public void setTooltip(boolean tooltip) {
            this.iTooltip = tooltip;
        }

        public boolean isTable() {
            return this.iTable;
        }

        public void setTable(boolean table) {
            this.iTable = table;
        }

        public boolean isImage() {
            return this.iImage;
        }

        public void setImage(boolean image) {
            this.iImage = image;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AttachmentTypeInterface)) {
                return false;
            }
            return this.getId().equals(((AttachmentTypeInterface)object).getId());
        }
    }

    public static enum FutureOperation implements IsSerializable
    {
        ROOM_PROPERTIES,
        EXAM_PROPERTIES,
        EVENT_PROPERTIES,
        GROUPS,
        FEATURES,
        ROOM_SHARING(false, true),
        EXAM_PREFS(false, true),
        EVENT_AVAILABILITY(false, true),
        PICTURES;

        private boolean iDefaultSelection;
        private boolean iDefaultSelectionNewRoom;

        private FutureOperation(boolean defaultSelection, boolean defaultSelectionNewRoom) {
            this.iDefaultSelection = defaultSelection;
            this.iDefaultSelectionNewRoom = defaultSelectionNewRoom;
        }

        private FutureOperation(boolean defaultSelection) {
            this(defaultSelection, defaultSelection);
        }

        private FutureOperation() {
            this(true, true);
        }

        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }

        public boolean getDefaultSelection() {
            return this.iDefaultSelection;
        }

        public boolean getDefaultSelectionNewRoom() {
            return this.iDefaultSelectionNewRoom;
        }

        public static int getFlagAllEnabled() {
            int ret = 0;
            for (FutureOperation op : FutureOperation.values()) {
                ret = op.set(ret);
            }
            return ret;
        }

        public static int getFlagDefaultsEnabled() {
            int ret = 0;
            for (FutureOperation op : FutureOperation.values()) {
                if (!op.getDefaultSelection()) continue;
                ret = op.set(ret);
            }
            return ret;
        }
    }

    public static class RoomException
    extends GwtRpcException {
        private static final long serialVersionUID = 1L;
        private RoomDetailInterface iRoom;

        public RoomException() {
        }

        public RoomException(String message) {
            super(message);
        }

        public RoomException(String message, Throwable cause) {
            super(message, cause);
        }

        public RoomException withRoom(RoomDetailInterface room) {
            this.iRoom = room;
            return this;
        }

        public boolean hasRoom() {
            return this.iRoom != null;
        }

        public RoomDetailInterface getRoom() {
            return this.iRoom;
        }
    }

    public static class RoomUpdateRpcRequest
    implements GwtRpcRequest<RoomDetailInterface> {
        private Long iSessionId;
        private Operation iOperation;
        private Long iLocationId;
        private RoomDetailInterface iRoom;
        private Map<Long, Integer> iFutureFlags;

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public boolean hasRoom() {
            return this.iRoom != null;
        }

        public RoomDetailInterface getRoom() {
            return this.iRoom;
        }

        public void setRoom(RoomDetailInterface room) {
            this.iRoom = room;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        public boolean hasLocationId() {
            return this.getLocationId() != null;
        }

        public Long getLocationId() {
            return this.iLocationId != null ? this.iLocationId : (this.iRoom != null ? this.iRoom.getUniqueId() : null);
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        public boolean hasLabel() {
            return this.getLabel() != null && !this.getLabel().isEmpty();
        }

        public String getLabel() {
            return this.iRoom != null ? this.iRoom.getLabel() : null;
        }

        public boolean hasFutureFlags() {
            return this.iFutureFlags != null && !this.iFutureFlags.isEmpty();
        }

        public void clearFutureFlags() {
            if (this.iFutureFlags != null) {
                this.iFutureFlags.clear();
            }
        }

        public void setFutureFlag(Long id, int flags) {
            if (this.iFutureFlags == null) {
                this.iFutureFlags = new HashMap<Long, Integer>();
            }
            this.iFutureFlags.put(id, flags);
        }

        public Integer getFutureFlag(Long id) {
            return this.iFutureFlags == null ? null : this.iFutureFlags.get(id);
        }

        public Map<Long, Integer> getFutureFlags() {
            return this.iFutureFlags;
        }

        public int getFutureFlag(Long id, int defaultValue) {
            Integer flags = this.iFutureFlags == null ? null : this.iFutureFlags.get(id);
            return flags == null ? defaultValue : flags;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + " " + (String)(this.hasLocationId() ? this.getLocationId() + (String)(this.hasLabel() ? "/" + this.getLabel() : "") : (this.hasLabel() ? this.getLabel() : ""));
        }

        public static RoomUpdateRpcRequest createDeleteRequest(Long sessionId, Long locationId) {
            RoomUpdateRpcRequest request = new RoomUpdateRpcRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.DELETE);
            request.setLocationId(locationId);
            return request;
        }

        public static RoomUpdateRpcRequest createSaveOrUpdateRequest(RoomDetailInterface room) {
            RoomUpdateRpcRequest request = new RoomUpdateRpcRequest();
            request.setOperation(room.getUniqueId() == null ? Operation.CREATE : Operation.UPDATE);
            request.setRoom(room);
            request.setSessionId(room.getSessionId());
            return request;
        }

        public static enum Operation implements IsSerializable
        {
            CREATE,
            UPDATE,
            DELETE;

        }
    }

    public static class RoomFilterRpcRequest
    extends EventInterface.RoomFilterRpcRequest {
        private static final long serialVersionUID = 1L;
    }

    public static enum RoomsPageMode implements IsSerializable
    {
        COURSES("q=department:Managed", RoomsColumn.NAME, RoomsColumn.TYPE, RoomsColumn.CAPACITY, RoomsColumn.AREA, RoomsColumn.AVAILABILITY, RoomsColumn.DEPARTMENTS, RoomsColumn.FEATURES, RoomsColumn.GROUPS),
        EXAMS("q=department:Managed", RoomsColumn.NAME, RoomsColumn.TYPE, RoomsColumn.CAPACITY, RoomsColumn.EXAM_CAPACITY, RoomsColumn.AREA, RoomsColumn.EXAM_TYPES, RoomsColumn.PERIOD_PREF, RoomsColumn.FEATURES, RoomsColumn.GROUPS),
        EVENTS("q=flag:Event+department:Managed", true, RoomsColumn.NAME, RoomsColumn.TYPE, RoomsColumn.CAPACITY, RoomsColumn.AREA, RoomsColumn.EVENT_DEPARTMENT, RoomsColumn.EVENT_AVAILABILITY, RoomsColumn.EVENT_STATUS, RoomsColumn.EVENT_MESSAGE, RoomsColumn.EVENT_EMAIL, RoomsColumn.BREAK_TIME, RoomsColumn.FEATURES, RoomsColumn.GROUPS);

        private String iQuery;
        private int iColumns;
        private boolean iSessionSelection;

        private RoomsPageMode(String query, boolean sessionSelection, RoomsColumn ... column) {
            this.iQuery = query;
            this.iSessionSelection = sessionSelection;
            this.iColumns = 0;
            for (RoomsColumn f : column) {
                this.iColumns += 1 << f.ordinal();
            }
        }

        private RoomsPageMode(String query, RoomsColumn ... column) {
            this(query, false, column);
        }

        public String getQuery() {
            return this.iQuery;
        }

        public boolean hasColumn(RoomsColumn column) {
            return (this.iColumns & 1 << column.ordinal()) != 0;
        }

        public boolean hasSessionSelection() {
            return this.iSessionSelection;
        }
    }

    public static enum RoomFeaturesColumn {
        NAME,
        ABBREVIATION,
        TYPE,
        DEPARTMENT,
        ROOMS,
        DESCRIPTION;

    }

    public static enum RoomGroupsColumn {
        NAME,
        ABBREVIATION,
        DEFAULT,
        DEPARTMENT,
        ROOMS,
        DESCRIPTION;

    }

    public static enum RoomsColumn {
        NAME,
        EXTERNAL_ID,
        TYPE,
        PARTITION,
        CAPACITY,
        EXAM_CAPACITY,
        AREA,
        COORDINATES,
        DISTANCE_CHECK,
        ROOM_CHECK,
        MAP,
        PICTURES,
        PREFERENCE,
        AVAILABILITY,
        DEPARTMENTS,
        CONTROL_DEPT,
        EXAM_TYPES,
        PERIOD_PREF,
        EVENT_DEPARTMENT,
        EVENT_STATUS,
        EVENT_AVAILABILITY,
        EVENT_MESSAGE,
        EVENT_EMAIL,
        BREAK_TIME,
        SERVICES,
        GROUPS,
        FEATURES;

    }

    public static class RoomPropertiesInterface
    extends MapPropertiesInterface
    implements GwtRpcResponse {
        private AcademicSessionInterface iSession = null;
        private boolean iCanExportPdf = false;
        private boolean iCanExportCsv = false;
        private boolean iCanEditDepartments = false;
        private boolean iCanEditRoomExams = false;
        private List<RoomTypeInterface> iRoomTypes = new ArrayList<RoomTypeInterface>();
        private List<BuildingInterface> iBuildings = new ArrayList<BuildingInterface>();
        private List<FeatureTypeInterface> iFeatureTypes = new ArrayList<FeatureTypeInterface>();
        private List<DepartmentInterface> iDepartments = new ArrayList<DepartmentInterface>();
        private int iNrDepartments = 0;
        private List<ExamTypeInterface> iExamTypes = new ArrayList<ExamTypeInterface>();
        private List<GroupInterface> iGroups = new ArrayList<GroupInterface>();
        private List<FeatureInterface> iFeatures = new ArrayList<FeatureInterface>();
        private List<PreferenceInterface> iPreferences = new ArrayList<PreferenceInterface>();
        private List<AttachmentTypeInterface> iPictureTypes = new ArrayList<AttachmentTypeInterface>();
        private boolean iCanSeeCourses = false;
        private boolean iCanSeeExams = false;
        private boolean iCanSeeEvents = false;
        private boolean iGridAsText = false;
        private boolean iHorizontal = false;
        private List<RoomSharingDisplayMode> iModes;
        private String iEllipsoid = null;
        private boolean iCanChangeAvailability = false;
        private boolean iCanChangeControll = false;
        private boolean iCanChangeExternalId = false;
        private boolean iCanChangeExamStatus = false;
        private boolean iCanChangeEventProperties = false;
        private boolean iCanChangePicture = false;
        private boolean iCanChangePreferences = false;
        private boolean iCanChangeGroups = false;
        private boolean iCanChangeFeatures = false;
        private boolean iCanChangeEventAvailability = false;
        private List<AcademicSessionInterface> iFutureSessions = null;
        private boolean iCanExportRoomGroups = false;
        private boolean iCanChangeDefaultGroup = false;
        private boolean iCanExportRoomFeatures = false;
        private boolean iRoomAreaMetricUnits = false;
        private boolean iCanSaveFilterDefaults = false;
        private Map<String, String> iFilterDefaults = null;
        private Set<EventInterface.EventServiceProviderInterface> iEventServiceProviders = null;

        public AcademicSessionInterface getAcademicSession() {
            return this.iSession;
        }

        public void setAcademicSession(AcademicSessionInterface session) {
            this.iSession = session;
        }

        public Long getAcademicSessionId() {
            return this.iSession == null ? null : this.iSession.getId();
        }

        public String getAcademicSessionName() {
            return this.iSession == null ? null : this.iSession.getLabel();
        }

        public boolean isCanEditDepartments() {
            return this.iCanEditDepartments;
        }

        public void setCanEditDepartments(boolean canEditDepartments) {
            this.iCanEditDepartments = canEditDepartments;
        }

        public boolean isCanExportPdf() {
            return this.iCanExportPdf;
        }

        public void setCanExportPdf(boolean canExportPdf) {
            this.iCanExportPdf = canExportPdf;
        }

        public boolean isCanExportCsv() {
            return this.iCanExportCsv;
        }

        public void setCanExportCsv(boolean canExportCsv) {
            this.iCanExportCsv = canExportCsv;
        }

        public boolean isCanEditRoomExams() {
            return this.iCanEditRoomExams;
        }

        public void setCanEditRoomExams(boolean canEditRoomExams) {
            this.iCanEditRoomExams = canEditRoomExams;
        }

        public boolean isCanAddRoom() {
            return this.iSession == null ? false : this.iSession.isCanAddRoom();
        }

        public void setCanAddRoom(boolean canAddRoom) {
            if (this.iSession != null) {
                this.iSession.setCanAddRoom(canAddRoom);
            }
        }

        public boolean isCanAddNonUniversity() {
            return this.iSession == null ? false : this.iSession.isCanAddNonUniversity();
        }

        public void setCanAddNonUniversity(boolean canAddNonUniv) {
            if (this.iSession != null) {
                this.iSession.setCanAddNonUniversity(canAddNonUniv);
            }
        }

        public boolean isCanAddGlobalRoomGroup() {
            return this.iSession == null ? false : this.iSession.isCanAddGlobalRoomGroup();
        }

        public void setCanAddGlobalRoomGroup(boolean canAddGlobalRoomGroup) {
            if (this.iSession != null) {
                this.iSession.setCanAddGlobalRoomGroup(canAddGlobalRoomGroup);
            }
        }

        public boolean isCanAddDepartmentalRoomGroup() {
            return this.iSession == null ? false : this.iSession.isCanAddDepartmentalRoomGroup();
        }

        public void setCanAddDepartmentalRoomGroup(boolean canAddDepartmentalRoomGroup) {
            if (this.iSession != null) {
                this.iSession.setCanAddDepartmentalRoomGroup(canAddDepartmentalRoomGroup);
            }
        }

        public boolean isCanAddGlobalRoomFeature() {
            return this.iSession == null ? false : this.iSession.isCanAddGlobalRoomFeature();
        }

        public void setCanAddGlobalRoomFeature(boolean canAddGlobalRoomFeature) {
            if (this.iSession != null) {
                this.iSession.setCanAddGlobalRoomFeature(canAddGlobalRoomFeature);
            }
        }

        public boolean isCanAddDepartmentalRoomFeature() {
            return this.iSession == null ? false : this.iSession.isCanAddDepartmentalRoomFeature();
        }

        public void setCanAddDepartmentalRoomFeature(boolean canAddDepartmentalRoomFeature) {
            if (this.iSession != null) {
                this.iSession.setCanAddDepartmentalRoomFeature(canAddDepartmentalRoomFeature);
            }
        }

        public boolean isCanExportRoomGroups() {
            return this.iCanExportRoomGroups;
        }

        public void setCanExportRoomGroups(boolean canExportRoomGroups) {
            this.iCanExportRoomGroups = canExportRoomGroups;
        }

        public boolean isCanChangeDefaultGroup() {
            return this.iCanChangeDefaultGroup;
        }

        public void setCanChangeDefaultGroup(boolean canChangeDefaultGroup) {
            this.iCanChangeDefaultGroup = canChangeDefaultGroup;
        }

        public boolean isCanExportRoomFeatures() {
            return this.iCanExportRoomFeatures;
        }

        public void setCanExportRoomFeatures(boolean canExportRoomFeatures) {
            this.iCanExportRoomFeatures = canExportRoomFeatures;
        }

        public void addRoomType(RoomTypeInterface roomType) {
            this.iRoomTypes.add(roomType);
        }

        public List<RoomTypeInterface> getRoomTypes() {
            return this.iRoomTypes;
        }

        public RoomTypeInterface getRoomType(Long id) {
            for (RoomTypeInterface type : this.iRoomTypes) {
                if (!id.equals(type.getId())) continue;
                return type;
            }
            return null;
        }

        public void addBuilding(BuildingInterface building) {
            this.iBuildings.add(building);
        }

        public List<BuildingInterface> getBuildings() {
            return this.iBuildings;
        }

        public BuildingInterface getBuilding(Long id) {
            for (BuildingInterface building : this.iBuildings) {
                if (!id.equals(building.getId())) continue;
                return building;
            }
            return null;
        }

        public void addFeatureType(FeatureTypeInterface featureType) {
            this.iFeatureTypes.add(featureType);
        }

        public List<FeatureTypeInterface> getFeatureTypes() {
            return this.iFeatureTypes;
        }

        public FeatureTypeInterface getFeatureType(Long id) {
            for (FeatureTypeInterface type : this.iFeatureTypes) {
                if (!id.equals(type.getId())) continue;
                return type;
            }
            return null;
        }

        public void addDepartment(DepartmentInterface department) {
            this.iDepartments.add(department);
        }

        public List<DepartmentInterface> getDepartments() {
            return this.iDepartments;
        }

        public DepartmentInterface getDepartment(Long id) {
            for (DepartmentInterface department : this.iDepartments) {
                if (!id.equals(department.getId())) continue;
                return department;
            }
            return null;
        }

        public void setNrDepartments(int nrDepartments) {
            this.iNrDepartments = nrDepartments;
        }

        public int getNrDepartments() {
            return this.iNrDepartments;
        }

        public void addExamType(ExamTypeInterface examType) {
            this.iExamTypes.add(examType);
        }

        public List<ExamTypeInterface> getExamTypes() {
            return this.iExamTypes;
        }

        public boolean isCanSeeCourses() {
            return this.iCanSeeCourses;
        }

        public void setCanSeeCourses(boolean canSeeCourses) {
            this.iCanSeeCourses = canSeeCourses;
        }

        public boolean isCanSeeExams() {
            return this.iCanSeeExams;
        }

        public void setCanSeeExams(boolean canSeeExams) {
            this.iCanSeeExams = canSeeExams;
        }

        public boolean isCanSeeEvents() {
            return this.iCanSeeEvents;
        }

        public void setCanSeeEvents(boolean canSeeEvents) {
            this.iCanSeeEvents = canSeeEvents;
        }

        public boolean isGridAsText() {
            return this.iGridAsText;
        }

        public void setGridAsText(boolean gridAsText) {
            this.iGridAsText = gridAsText;
        }

        public boolean isHorizontal() {
            return this.iHorizontal;
        }

        public void setHorizontal(boolean horizontal) {
            this.iHorizontal = horizontal;
        }

        public void addGroup(GroupInterface group) {
            this.iGroups.add(group);
        }

        public List<GroupInterface> getGroups() {
            return this.iGroups;
        }

        public GroupInterface getGroup(Long groupId) {
            for (GroupInterface group : this.iGroups) {
                if (!groupId.equals(group.getId())) continue;
                return group;
            }
            return null;
        }

        public void addFeature(FeatureInterface feature) {
            this.iFeatures.add(feature);
        }

        public List<FeatureInterface> getFeatures() {
            return this.iFeatures;
        }

        public void addPreference(PreferenceInterface preference) {
            this.iPreferences.add(preference);
        }

        public List<PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }

        public void addPictureType(AttachmentTypeInterface type) {
            this.iPictureTypes.add(type);
        }

        public boolean hasPictureTypes() {
            return !this.iPictureTypes.isEmpty();
        }

        public List<AttachmentTypeInterface> getPictureTypes() {
            return this.iPictureTypes;
        }

        public AttachmentTypeInterface getPictureType(Long id) {
            for (AttachmentTypeInterface type : this.iPictureTypes) {
                if (!type.getId().equals(id)) continue;
                return type;
            }
            return null;
        }

        public List<AttachmentTypeInterface> getTableTypes() {
            if (this.iPictureTypes == null) {
                return null;
            }
            ArrayList<AttachmentTypeInterface> ret = new ArrayList<AttachmentTypeInterface>();
            for (AttachmentTypeInterface type : this.iPictureTypes) {
                if (!type.isTable()) continue;
                ret.add(type);
            }
            return ret;
        }

        public void addMode(RoomSharingDisplayMode mode) {
            if (this.iModes == null) {
                this.iModes = new ArrayList<RoomSharingDisplayMode>();
            }
            this.iModes.add(mode);
        }

        public List<RoomSharingDisplayMode> getModes() {
            return this.iModes;
        }

        public boolean hasModes() {
            return this.iModes != null && !this.iModes.isEmpty();
        }

        public String getEllipsoid() {
            return this.iEllipsoid;
        }

        public boolean hasEllipsoid() {
            return this.iEllipsoid != null & !this.iEllipsoid.isEmpty();
        }

        public void setEllipsoid(String ellipsoid) {
            this.iEllipsoid = ellipsoid;
        }

        public boolean isCanChangeAvailability() {
            return this.iCanChangeAvailability;
        }

        public void setCanChangeAvailability(boolean canChangeAvailability) {
            this.iCanChangeAvailability = canChangeAvailability;
        }

        public boolean isCanChangeControll() {
            return this.iCanChangeControll;
        }

        public void setCanChangeControll(boolean canChangeControll) {
            this.iCanChangeControll = canChangeControll;
        }

        public boolean isCanChangeExternalId() {
            return this.iCanChangeExternalId;
        }

        public void setCanChangeExternalId(boolean canChangeExternalId) {
            this.iCanChangeExternalId = canChangeExternalId;
        }

        public boolean isCanChangeExamStatus() {
            return this.iCanChangeExamStatus;
        }

        public void setCanChangeExamStatus(boolean canChangeExamStatus) {
            this.iCanChangeExamStatus = canChangeExamStatus;
        }

        public boolean isCanChangeEventProperties() {
            return this.iCanChangeEventProperties;
        }

        public void setCanChangeEventProperties(boolean canChangeEventProperties) {
            this.iCanChangeEventProperties = canChangeEventProperties;
        }

        public boolean isCanChangePicture() {
            return this.iCanChangePicture;
        }

        public void setCanChangePicture(boolean canChangePicture) {
            this.iCanChangePicture = canChangePicture;
        }

        public boolean isCanChangePreferences() {
            return this.iCanChangePreferences;
        }

        public void setCanChangePreferences(boolean canChangePreferences) {
            this.iCanChangePreferences = canChangePreferences;
        }

        public boolean isCanChangeGroups() {
            return this.iCanChangeGroups;
        }

        public void setCanChangeGroups(boolean canChangeGroups) {
            this.iCanChangeGroups = canChangeGroups;
        }

        public boolean isCanChangeFeatures() {
            return this.iCanChangeFeatures;
        }

        public void setCanChangeFeatures(boolean canChangeFeatures) {
            this.iCanChangeFeatures = canChangeFeatures;
        }

        public boolean isCanChangeEventAvailability() {
            return this.iCanChangeEventAvailability;
        }

        public void setCanChangeEventAvailability(boolean canChangeEventAvailability) {
            this.iCanChangeEventAvailability = canChangeEventAvailability;
        }

        public boolean hasFutureSessions() {
            return this.iFutureSessions != null && !this.iFutureSessions.isEmpty();
        }

        public void addFutureSession(AcademicSessionInterface session) {
            if (this.iFutureSessions == null) {
                this.iFutureSessions = new ArrayList<AcademicSessionInterface>();
            }
            this.iFutureSessions.add(session);
        }

        public List<AcademicSessionInterface> getFutureSessions() {
            return this.iFutureSessions;
        }

        public AcademicSessionInterface getFutureSession(Long id) {
            for (AcademicSessionInterface session : this.iFutureSessions) {
                if (!id.equals(session.getId())) continue;
                return session;
            }
            return null;
        }

        public boolean isRoomAreaInMetricUnits() {
            return this.iRoomAreaMetricUnits;
        }

        public void setRoomAreaInMetricUnits(boolean roomAreaInMetricUnits) {
            this.iRoomAreaMetricUnits = roomAreaInMetricUnits;
        }

        public void setCanSaveFilterDefaults(boolean canSaveFilterDefaults) {
            this.iCanSaveFilterDefaults = canSaveFilterDefaults;
        }

        public boolean isCanSaveFilterDefaults() {
            return this.iCanSaveFilterDefaults;
        }

        public void setFilterDefault(String name, String value) {
            if (value == null) {
                return;
            }
            if (this.iFilterDefaults == null) {
                this.iFilterDefaults = new HashMap<String, String>();
            }
            this.iFilterDefaults.put(name, value);
        }

        public boolean hasFilterDefault(String name) {
            return this.iFilterDefaults != null && this.iFilterDefaults.get(name) != null;
        }

        public String getFilterDefault(String name) {
            return this.iFilterDefaults == null ? null : this.iFilterDefaults.get(name);
        }

        public boolean hasEventServiceProviders() {
            return this.iEventServiceProviders != null && !this.iEventServiceProviders.isEmpty();
        }

        public Set<EventInterface.EventServiceProviderInterface> getEventServiceProviders() {
            return this.iEventServiceProviders;
        }

        public void addEventServiceProvider(EventInterface.EventServiceProviderInterface provider) {
            if (this.iEventServiceProviders == null) {
                this.iEventServiceProviders = new TreeSet<EventInterface.EventServiceProviderInterface>();
            }
            this.iEventServiceProviders.add(provider);
        }
    }

    public static class RoomPropertiesRequest
    implements GwtRpcRequest<RoomPropertiesInterface> {
        private Long iSessionId = null;
        private String iMode = null;

        public RoomPropertiesRequest() {
        }

        public RoomPropertiesRequest(Long sessionId, String mode) {
            this.iSessionId = sessionId;
            this.iMode = mode;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public String getMode() {
            return this.iMode;
        }

        public void setMode(String mode) {
            this.iMode = mode;
        }

        public boolean hasMode() {
            return this.iMode != null && !this.iMode.isEmpty();
        }

        @Override
        public String toString() {
            return this.hasSessionId() ? this.getSessionId().toString() : "";
        }
    }

    public static class MapPropertiesInterface
    implements GwtRpcResponse {
        private boolean iGoogleMap = false;
        private boolean iLeafletMap = false;
        private String iGoogleMapApiKey = null;
        private String iLeafletMapTiles = null;
        private String iLeafletMapAttribution = null;

        public void setGoogleMap(boolean map) {
            this.iGoogleMap = map;
        }

        public boolean isGoogleMap() {
            return this.iGoogleMap;
        }

        public void setLeafletMap(boolean map) {
            this.iLeafletMap = map;
        }

        public boolean isLeafletMap() {
            return this.iLeafletMap;
        }

        public void setGoogleMapApiKey(String apiKey) {
            this.iGoogleMapApiKey = apiKey;
        }

        public boolean hasGoogleMapApiKey() {
            return this.iGoogleMapApiKey != null && !this.iGoogleMapApiKey.isEmpty();
        }

        public String getGoogleMapApiKey() {
            return this.iGoogleMapApiKey;
        }

        public void setLeafletMapTiles(String tileUrl) {
            this.iLeafletMapTiles = tileUrl;
        }

        public boolean hasLeafletMapTiles() {
            return this.iLeafletMapTiles != null && !this.iLeafletMapTiles.isEmpty();
        }

        public String getLeafletMapTiles() {
            return this.iLeafletMapTiles;
        }

        public void setLeafletMapAttribution(String tileAttribution) {
            this.iLeafletMapAttribution = tileAttribution;
        }

        public boolean hasLeafletMapAttribution() {
            return this.iLeafletMapAttribution != null && !this.iLeafletMapAttribution.isEmpty();
        }

        public String getLeafletMapAttribution() {
            return this.iLeafletMapAttribution;
        }
    }

    public static class MapPropertiesRequest
    implements GwtRpcRequest<MapPropertiesInterface> {
    }

    public static class PeriodPreferenceRequest
    implements GwtRpcRequest<PeriodPreferenceModel> {
        private Operation iOperation;
        private Long iSourceId;
        private PeriodPreferenceModel iModel;
        private Long iExamTypeId = null;
        private Long iSessionId;

        public Long getLocationId() {
            return this.iSourceId;
        }

        public void setLocationId(Long locationId) {
            this.iSourceId = locationId;
        }

        public Long getExamId() {
            return this.iSourceId;
        }

        public void setExamId(Long examId) {
            this.iSourceId = examId;
        }

        public PeriodPreferenceModel getModel() {
            return this.iModel;
        }

        public void setModel(PeriodPreferenceModel model) {
            this.iModel = model;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + "[" + this.getLocationId() + "," + this.getExamTypeId() + "]";
        }

        public Long getExamTypeId() {
            return this.iExamTypeId;
        }

        public void setExamTypeId(Long examTypeId) {
            this.iExamTypeId = examTypeId;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public static PeriodPreferenceRequest load(Long sessionId, Long locationId, Long examTypeId) {
            PeriodPreferenceRequest request = new PeriodPreferenceRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.LOAD);
            request.setLocationId(locationId);
            request.setExamTypeId(examTypeId);
            return request;
        }

        public static PeriodPreferenceRequest load(Long locationId, Long examTypeId) {
            return PeriodPreferenceRequest.load(null, locationId, examTypeId);
        }

        public static PeriodPreferenceRequest save(Long sessionId, Long locationId, Long examTypeId, PeriodPreferenceModel model) {
            PeriodPreferenceRequest request = new PeriodPreferenceRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.SAVE);
            request.setLocationId(locationId);
            request.setModel(model);
            request.setExamTypeId(examTypeId);
            return request;
        }

        public static PeriodPreferenceRequest save(Long locationId, Long examTypeId, PeriodPreferenceModel model) {
            return PeriodPreferenceRequest.save(null, locationId, examTypeId, model);
        }

        public static PeriodPreferenceRequest loadForExam(Long examId, Long examTypeId) {
            PeriodPreferenceRequest request = new PeriodPreferenceRequest();
            request.setOperation(Operation.LOAD_FOR_EXAM);
            request.setExamTypeId(examTypeId);
            request.setExamId(examId);
            return request;
        }

        public static enum Operation implements IsSerializable
        {
            LOAD,
            SAVE,
            LOAD_FOR_EXAM;

        }
    }

    public static class PeriodPreferenceModel
    implements IsSerializable,
    GwtRpcResponse {
        private ExamTypeInterface iExamType;
        private Long iLocationId;
        private Long iExamId;
        private Long iDefaultPreference;
        private Long iSelectedPreference;
        private Date iFirstDate;
        private TreeSet<Integer> iStarts = new TreeSet();
        private TreeSet<Integer> iDays = new TreeSet();
        private List<PreferenceInterface> iPreferences = new ArrayList<PreferenceInterface>();
        private List<PeriodInterface> iPeriods = new ArrayList<PeriodInterface>();
        private Map<Integer, Map<Integer, Long>> iModel;
        private boolean iHorizontal = false;
        private Long iAssignedPeriodId = null;
        private boolean iReqConfirmation = false;

        public ExamTypeInterface getExamType() {
            return this.iExamType;
        }

        public void setExamType(ExamTypeInterface examType) {
            this.iExamType = examType;
        }

        public void setLocationId(Long id) {
            this.iLocationId = id;
        }

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setExamId(Long id) {
            this.iExamId = id;
        }

        public Long getExamId() {
            return this.iExamId;
        }

        public Date getFirstDate() {
            return this.iFirstDate;
        }

        public void setFirstDate(Date date) {
            this.iFirstDate = date;
        }

        public TreeSet<Integer> getDays() {
            return this.iDays;
        }

        public TreeSet<Integer> getSlots() {
            return this.iStarts;
        }

        public int getLength(int slot) {
            for (PeriodInterface p : this.iPeriods) {
                if (p.getStartSlot() != slot) continue;
                return p.getLength();
            }
            return 12;
        }

        public void setDefaultPreference(PreferenceInterface preference) {
            this.iDefaultPreference = preference == null ? null : preference.getId();
        }

        public PreferenceInterface getDefaultPreference() {
            return this.getPreference(this.iDefaultPreference);
        }

        public void setSelectedPreference(PreferenceInterface preference) {
            this.iSelectedPreference = preference == null ? null : preference.getId();
        }

        public PreferenceInterface getSelectedPreference() {
            return this.getPreference(this.iSelectedPreference);
        }

        public PreferenceInterface getPreference(Long id) {
            if (id == null) {
                id = this.iDefaultPreference;
            }
            if (this.iPreferences == null || id == null) {
                return null;
            }
            for (PreferenceInterface preference : this.iPreferences) {
                if (!preference.getId().equals(id)) continue;
                return preference;
            }
            return !id.equals(this.iDefaultPreference) ? this.getPreference(this.iDefaultPreference) : null;
        }

        public PreferenceInterface getPreference(String code) {
            if (this.iPreferences == null) {
                return null;
            }
            for (PreferenceInterface preference : this.iPreferences) {
                if (!preference.getCode().equals(code)) continue;
                return preference;
            }
            return this.getPreference(this.iDefaultPreference);
        }

        public void addPreference(PreferenceInterface preference) {
            if (this.iPreferences == null) {
                this.iPreferences = new ArrayList<PreferenceInterface>();
            }
            this.iPreferences.add(preference);
        }

        public List<PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }

        public void addPeriod(PeriodInterface period) {
            this.iPeriods.add(period);
            this.iDays.add(period.getDay());
            this.iStarts.add(period.getStartSlot());
        }

        public List<PeriodInterface> getPeriods() {
            return this.iPeriods;
        }

        public PeriodInterface getPeriod(int day, int slot) {
            for (PeriodInterface p : this.iPeriods) {
                if (p.getDay() != day || p.getStartSlot() != slot) continue;
                return p;
            }
            return null;
        }

        public PreferenceInterface getPreference(int day, int slot) {
            if (this.iModel == null) {
                return this.getPreference(this.iDefaultPreference);
            }
            Map<Integer, Long> slot2id = this.iModel.get(day);
            return this.getPreference(slot2id == null ? null : slot2id.get(slot));
        }

        public void setPreference(int day, int slot, Long optionId) {
            Map<Integer, Long> slot2id;
            if (this.iModel == null) {
                this.iModel = new HashMap<Integer, Map<Integer, Long>>();
            }
            if ((slot2id = this.iModel.get(day)) == null) {
                slot2id = new HashMap<Integer, Long>();
                this.iModel.put(day, slot2id);
            }
            if (optionId == null) {
                slot2id.remove(slot);
            } else {
                slot2id.put(slot, optionId);
            }
        }

        public void setPreference(int day, int slot, PreferenceInterface preference) {
            this.setPreference(day, slot, preference == null ? null : preference.getId());
        }

        public boolean isDefaultHorizontal() {
            return this.iHorizontal;
        }

        public void setDefaultHorizontal(boolean horizontal) {
            this.iHorizontal = horizontal;
        }

        public boolean isAssigned(PeriodInterface period) {
            return this.iAssignedPeriodId != null && this.iAssignedPeriodId.equals(period.getId());
        }

        public void setAssignment(PeriodInterface period) {
            this.iAssignedPeriodId = period == null ? null : period.getId();
        }

        public void setAssignedPeriodId(Long periodId) {
            this.iAssignedPeriodId = periodId;
        }

        public boolean isReqConfirmation() {
            return this.iReqConfirmation;
        }

        public void setReqConfirmation(boolean confirm) {
            this.iReqConfirmation = confirm;
        }

        public boolean hasRequired() {
            if (this.iModel == null) {
                return false;
            }
            for (Map<Integer, Long> values : this.iModel.values()) {
                for (Long pref : values.values()) {
                    if (pref != 1L) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasNotAvailable() {
            if (this.iModel != null) {
                for (Map map : this.iModel.values()) {
                    for (Long pref : map.values()) {
                        if (pref != 8L) continue;
                        return true;
                    }
                }
            }
            for (Integer n : this.getSlots()) {
                for (Integer day : this.getDays()) {
                    if (this.getPeriod(day, n) != null) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasPreference() {
            if (this.iModel == null) {
                return false;
            }
            for (Map<Integer, Long> values : this.iModel.values()) {
                for (Long pref : values.values()) {
                    if (pref == 8L || pref == 1L || pref == 4L) continue;
                    return true;
                }
            }
            return false;
        }

        public char id2char(Long id) {
            if (id == null) {
                return this.iExamType.isFinal() ? (char)'2' : 'P';
            }
            switch (id.intValue()) {
                case 1: {
                    return 'R';
                }
                case 2: {
                    return '0';
                }
                case 3: {
                    return '1';
                }
                case 4: {
                    return '2';
                }
                case 5: {
                    return '3';
                }
                case 6: {
                    return '4';
                }
                case 7: {
                    return 'P';
                }
                case 8: {
                    return 'N';
                }
            }
            return '2';
        }

        public Long char2id(char ch) {
            switch (ch) {
                case 'R': {
                    return 1L;
                }
                case '0': {
                    return 2L;
                }
                case '1': {
                    return 3L;
                }
                case '2': {
                    return 4L;
                }
                case '3': {
                    return 5L;
                }
                case '4': {
                    return 6L;
                }
                case 'P': {
                    return 7L;
                }
                case 'N': {
                    return 8L;
                }
            }
            return 4L;
        }

        public String getPattern() {
            String pattern = this.getExamType().getId() + ":" + String.valueOf(this.iAssignedPeriodId == null ? "" : this.iAssignedPeriodId) + ":";
            for (PeriodInterface p : this.iPeriods) {
                PreferenceInterface preference = this.getPreference(p.getDay(), p.getStartSlot());
                pattern = pattern + this.id2char(preference == null ? null : preference.getId());
            }
            return pattern;
        }

        public void setPattern(String pattern) {
            if (pattern.indexOf(58) >= 0) {
                String[] arr = pattern.split(":");
                if (!this.iExamType.getId().equals(Long.valueOf(arr[0]))) {
                    return;
                }
                this.iAssignedPeriodId = arr[1] == null || arr[1].isEmpty() ? null : Long.valueOf(arr[1]);
                pattern = arr[2];
            }
            for (int i = 0; i < this.iPeriods.size(); ++i) {
                char ch = this.iExamType.isFinal() ? (char)'2' : 'P';
                try {
                    ch = pattern.charAt(i);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                this.setPreference(this.iPeriods.get(i).getDay(), this.iPeriods.get(i).getStartSlot(), this.char2id(ch));
            }
        }
    }

    public static class PeriodInterface
    implements IsSerializable {
        private Long iId;
        private int iDay;
        private int iStart;
        private int iLength;

        public PeriodInterface() {
        }

        public PeriodInterface(Long id, int day, int start, int length) {
            this.iId = id;
            this.iDay = day;
            this.iStart = start;
            this.iLength = length;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public int getDay() {
            return this.iDay;
        }

        public void setDay(int day) {
            this.iDay = day;
        }

        public int getStartSlot() {
            return this.iStart;
        }

        public void setStartSlot(int start) {
            this.iStart = start;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }
    }

    public static class PreferenceInterface
    implements IsSerializable {
        private String iCode;
        private String iName;
        private String iAbbv;
        private String iColor;
        private Long iId;
        private boolean iEditable;

        public PreferenceInterface() {
        }

        public PreferenceInterface(Long id, String color, String code, String name, String abbv, boolean editable) {
            this.iId = id;
            this.iColor = color;
            this.iCode = code;
            this.iName = name;
            this.iAbbv = abbv;
            this.iEditable = editable;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getAbbv() {
            return this.iAbbv;
        }

        public void setAbbv(String abbv) {
            this.iAbbv = abbv;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof PreferenceInterface)) {
                return false;
            }
            return this.getId().equals(((PreferenceInterface)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    public static class RoomDetailsRequest
    implements GwtRpcRequest<GwtRpcResponseList<RoomDetailInterface>> {
        private List<Long> iLocationIds = new ArrayList<Long>();
        private String iDepartment = null;

        public void setDepartment(String department) {
            this.iDepartment = department;
        }

        public String getDepartment() {
            return this.iDepartment;
        }

        public boolean hasLocationIds() {
            return this.iLocationIds != null && !this.iLocationIds.isEmpty();
        }

        public List<Long> getLocationIds() {
            return this.iLocationIds;
        }

        public void addLocationId(Long locationId) {
            this.iLocationIds.add(locationId);
        }

        public int size() {
            return this.iLocationIds == null ? 0 : this.iLocationIds.size();
        }

        @Override
        public String toString() {
            return String.valueOf(this.getLocationIds());
        }

        public static RoomDetailsRequest load(Long ... locationId) {
            RoomDetailsRequest request = new RoomDetailsRequest();
            for (Long id : locationId) {
                request.addLocationId(id);
            }
            return request;
        }
    }

    public static class RoomDetailInterface
    extends EventInterface.FilterRpcResponse.Entity
    implements GwtRpcResponse {
        private static final long serialVersionUID = 1L;
        private String iExternalId;
        private BuildingInterface iBuilding;
        private RoomTypeInterface iRoomType;
        private Integer iCapacity;
        private Integer iExamCapacity;
        private Double iX;
        private Double iY;
        private Double iArea;
        private DepartmentInterface iControlDepartment;
        private DepartmentInterface iEventDepartment;
        private List<DepartmentInterface> iDepartments = new ArrayList<DepartmentInterface>();
        private List<GroupInterface> iGroups = new ArrayList<GroupInterface>();
        private List<FeatureInterface> iFeatures = new ArrayList<FeatureInterface>();
        private List<ExamTypeInterface> iExamTypes = new ArrayList<ExamTypeInterface>();
        private boolean iIgnoreTooFar = false;
        private boolean iIgnoreRoomCheck = false;
        private String iPeriodPreference = null;
        private String iAvailability = null;
        private String iEventAvailability = null;
        private String iRoomSharingNote = null;
        private String iEventNote = null;
        private String iDefaultEventNote = null;
        private Integer iEventStatus = null;
        private Integer iBreakTime = null;
        private Integer iDefaultEventStatus = null;
        private Integer iDefaultBreakTime = null;
        private String iPrefix = null;
        private boolean iCanShowDetail = false;
        private boolean iCanSeeAvailability = false;
        private boolean iCanSeePeriodPreferences = false;
        private boolean iCanSeeEventAvailability = false;
        private boolean iCanChange = false;
        private boolean iCanChangeAvailability = false;
        private boolean iCanChangeControll = false;
        private boolean iCanChangeExternalId = false;
        private boolean iCanChangeType = false;
        private boolean iCanChangeCapacity = false;
        private boolean iCanChangeExamStatus = false;
        private boolean iCanChangeRoomProperties = false;
        private boolean iCanChangeEventProperties = false;
        private boolean iCanChangePicture = false;
        private boolean iCanChangePreferences = false;
        private boolean iCanChangeGroups = false;
        private boolean iCanChangeFeatures = false;
        private boolean iCanChangeEventAvailability = false;
        private boolean iCanDelete = false;
        private String iMiniMapUrl = null;
        private String iMapUrl = null;
        private List<RoomPictureInterface> iPictures = new ArrayList<RoomPictureInterface>();
        private String iLastChange = null;
        private RoomSharingModel iRoomSharingModel = null;
        private RoomSharingModel iEventAvailabilityModel = null;
        private Map<Long, PeriodPreferenceModel> iPeriodPreferenceModels = null;
        private List<FutureRoomInterface> iFutureRooms = null;
        private Long iSessionId = null;
        private String iSessionName = null;
        private Set<EventInterface.EventServiceProviderInterface> iServices = null;
        private RoomDetailInterface iParent = null;
        private String iDefaultEventEmail = null;
        private String iEventEmail = null;
        private String iUrl;

        public RoomDetailInterface() {
        }

        public RoomDetailInterface(Long uniqueId, String displayName, String label, String ... properties) {
            super(uniqueId, displayName, label, properties);
        }

        public RoomDetailInterface(EventInterface.FilterRpcResponse.Entity entity) {
            String capacity;
            this.setUniqueId(entity.getUniqueId());
            this.setAbbreviation(entity.getAbbreviation());
            this.setName(entity.getName());
            String roomType = entity.getProperty("type", null);
            if (roomType != null) {
                this.setRoomType(new RoomTypeInterface(-1L, null, roomType, true, null));
            }
            if ((capacity = entity.getProperty("capacity", null)) != null) {
                this.setCapacity(Integer.valueOf(capacity));
            }
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public String getLabel() {
            if (this.iBuilding != null) {
                return this.iBuilding.getAbbreviation() + " " + this.getName();
            }
            return this.getName();
        }

        public String getDisplayName() {
            return this.getAbbreviation();
        }

        public boolean hasDisplayName() {
            return this.getAbbreviation() != null && !this.getAbbreviation().isEmpty();
        }

        public void setDisplayName(String name) {
            this.setAbbreviation(name);
        }

        public RoomTypeInterface getRoomType() {
            return this.iRoomType;
        }

        public void setRoomType(RoomTypeInterface roomType) {
            this.iRoomType = roomType;
        }

        public Integer getCapacity() {
            return this.iCapacity;
        }

        public void setCapacity(Integer capacity) {
            this.iCapacity = capacity;
        }

        public Integer getExamCapacity() {
            return this.iExamCapacity;
        }

        public void setExamCapacity(Integer capacity) {
            this.iExamCapacity = capacity;
        }

        public List<GroupInterface> getGroups() {
            return this.iGroups;
        }

        public void addGroup(GroupInterface group) {
            this.iGroups.add(group);
        }

        public void removeGroup(GroupInterface group) {
            this.iGroups.remove(group);
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public List<GroupInterface> getGlobalGroups() {
            ArrayList<GroupInterface> groups = new ArrayList<GroupInterface>();
            if (this.iGroups != null) {
                for (GroupInterface group : this.iGroups) {
                    if (group.getDepartment() != null) continue;
                    groups.add(group);
                }
            }
            return groups;
        }

        public List<GroupInterface> getDepartmentalGroups(Long departmentId) {
            ArrayList<GroupInterface> groups = new ArrayList<GroupInterface>();
            if (this.iGroups != null) {
                for (GroupInterface group : this.iGroups) {
                    if (group.getDepartment() == null || departmentId != null && !departmentId.equals(group.getDepartment().getId())) continue;
                    groups.add(group);
                }
            }
            return groups;
        }

        public boolean hasGroup(Long groupId) {
            if (this.iGroups == null || groupId == null) {
                return false;
            }
            for (GroupInterface group : this.iGroups) {
                if (!groupId.equals(group.getId())) continue;
                return true;
            }
            return false;
        }

        public boolean hasControlDepartment() {
            return this.iControlDepartment != null;
        }

        public DepartmentInterface getControlDepartment() {
            return this.iControlDepartment;
        }

        public void setControlDepartment(DepartmentInterface controlDepartment) {
            this.iControlDepartment = controlDepartment;
        }

        public boolean hasEventDepartment() {
            return this.iEventDepartment != null;
        }

        public DepartmentInterface getEventDepartment() {
            return this.iEventDepartment;
        }

        public void setEventDepartment(DepartmentInterface eventDepartment) {
            this.iEventDepartment = eventDepartment;
        }

        public List<FeatureInterface> getFeatures() {
            return this.iFeatures;
        }

        public void addFeature(FeatureInterface feature) {
            this.iFeatures.add(feature);
        }

        public void removeFeature(FeatureInterface feature) {
            this.iFeatures.remove(feature);
        }

        public boolean hasFeatures() {
            return this.iFeatures != null && !this.iFeatures.isEmpty();
        }

        public List<FeatureInterface> getFeatures(FeatureTypeInterface type) {
            ArrayList<FeatureInterface> ret = new ArrayList<FeatureInterface>();
            for (FeatureInterface f : this.iFeatures) {
                if ((type != null || f.getType() != null) && (type == null || !type.equals(f.getType()))) continue;
                ret.add(f);
            }
            return ret;
        }

        public List<FeatureInterface> getFeatures(Long typeId) {
            ArrayList<FeatureInterface> ret = new ArrayList<FeatureInterface>();
            for (FeatureInterface f : this.iFeatures) {
                if ((typeId != null || f.getType() != null) && (typeId == null || f.getType() == null || !typeId.equals(f.getType().getId()))) continue;
                ret.add(f);
            }
            return ret;
        }

        public boolean hasFeature(Long featureId) {
            if (this.iFeatures == null || featureId == null) {
                return false;
            }
            for (FeatureInterface feature : this.iFeatures) {
                if (!featureId.equals(feature.getId())) continue;
                return true;
            }
            return false;
        }

        public List<DepartmentInterface> getDepartments() {
            return this.iDepartments;
        }

        public void addDepartment(DepartmentInterface department) {
            this.iDepartments.add(department);
        }

        public boolean hasDepartments() {
            return this.iDepartments != null && !this.iDepartments.isEmpty();
        }

        public DepartmentInterface getDepartment(Long deptId) {
            if (this.iDepartments == null || deptId == null) {
                return null;
            }
            for (DepartmentInterface d : this.iDepartments) {
                if (!deptId.equals(d.getId())) continue;
                return d;
            }
            return null;
        }

        public BuildingInterface getBuilding() {
            return this.iBuilding;
        }

        public void setBuilding(BuildingInterface building) {
            this.iBuilding = building;
        }

        public boolean hasCoordinates() {
            return this.iX != null && this.iY != null;
        }

        public Double getX() {
            return this.iX;
        }

        public void setX(Double x) {
            this.iX = x;
        }

        public Double getY() {
            return this.iY;
        }

        public void setY(Double y) {
            this.iY = y;
        }

        public Double getArea() {
            return this.iArea;
        }

        public void setArea(Double area) {
            this.iArea = area;
        }

        public boolean hasPreference(String deptCode) {
            for (DepartmentInterface d : this.getDepartments()) {
                if (d.getDeptCode().equals(deptCode) || d.getPreference() == null) continue;
                return true;
            }
            return false;
        }

        public boolean hasPreference() {
            for (DepartmentInterface d : this.getDepartments()) {
                if (d.getPreference() == null) continue;
                return true;
            }
            return false;
        }

        public boolean isIgnoreRoomCheck() {
            return this.iIgnoreRoomCheck;
        }

        public void setIgnoreRoomCheck(boolean ignoreRoomCheck) {
            this.iIgnoreRoomCheck = ignoreRoomCheck;
        }

        public boolean isIgnoreTooFar() {
            return this.iIgnoreTooFar;
        }

        public void setIgnoreTooFar(boolean ignoreTooFar) {
            this.iIgnoreTooFar = ignoreTooFar;
        }

        public boolean hasExamTypes() {
            return this.iExamTypes != null && !this.iExamTypes.isEmpty();
        }

        public List<ExamTypeInterface> getExamTypes() {
            return this.iExamTypes;
        }

        public void addExamType(ExamTypeInterface type) {
            this.iExamTypes.add(type);
        }

        public ExamTypeInterface getExamType(Long typeId, String typeRef) {
            if (this.iExamTypes == null || typeId == null) {
                return null;
            }
            for (ExamTypeInterface type : this.iExamTypes) {
                if (!typeId.equals(type.getId()) && (type.getId() != null || typeRef == null || !typeRef.equals(type.getReference()))) continue;
                return type;
            }
            return null;
        }

        public ExamTypeInterface getExamType(Long typeId) {
            return this.getExamType(typeId, null);
        }

        public String getPeriodPreference() {
            return this.iPeriodPreference;
        }

        public void setPeriodPreference(String pref) {
            this.iPeriodPreference = pref;
        }

        public String getAvailability() {
            return this.iAvailability;
        }

        public void setAvailability(String availability) {
            this.iAvailability = availability;
        }

        public String getEventAvailability() {
            return this.iEventAvailability;
        }

        public void setEventAvailability(String availability) {
            this.iEventAvailability = availability;
        }

        public String getRoomSharingNote() {
            return this.iRoomSharingNote;
        }

        public void setRoomSharingNote(String note) {
            this.iRoomSharingNote = note;
        }

        public String getEventNote() {
            return this.iEventNote;
        }

        public void setEventNote(String note) {
            this.iEventNote = note;
        }

        public boolean hasEventNote() {
            return this.iEventNote != null && !this.iEventNote.isEmpty();
        }

        public Integer getEventStatus() {
            return this.iEventStatus;
        }

        public void setEventStatus(Integer eventStatus) {
            this.iEventStatus = eventStatus;
        }

        public Integer getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(Integer breakTime) {
            this.iBreakTime = breakTime;
        }

        public String getDefaultEventNote() {
            return this.iDefaultEventNote;
        }

        public void setDefaultEventNote(String note) {
            this.iDefaultEventNote = note;
        }

        public boolean hasDefaultEventNote() {
            return this.iDefaultEventNote != null && !this.iDefaultEventNote.isEmpty();
        }

        public Integer getDefaultEventStatus() {
            return this.iDefaultEventStatus;
        }

        public void setDefaultEventStatus(Integer eventStatus) {
            this.iDefaultEventStatus = eventStatus;
        }

        public Integer getDefaultBreakTime() {
            return this.iDefaultBreakTime;
        }

        public void setDefaultBreakTime(Integer breakTime) {
            this.iDefaultBreakTime = breakTime;
        }

        public String getPrefix() {
            return this.iPrefix;
        }

        public void setPrefix(String prefix) {
            this.iPrefix = prefix;
        }

        public boolean isCanShowDetail() {
            return this.iCanShowDetail;
        }

        public void setCanShowDetail(boolean canShowDetail) {
            this.iCanShowDetail = canShowDetail;
        }

        public boolean isCanSeeAvailability() {
            return this.iCanSeeAvailability;
        }

        public void setCanSeeAvailability(boolean canSeeAvailability) {
            this.iCanSeeAvailability = canSeeAvailability;
        }

        public boolean isCanSeePeriodPreferences() {
            return this.iCanSeePeriodPreferences;
        }

        public void setCanSeePeriodPreferences(boolean canSeePeriodPreferences) {
            this.iCanSeePeriodPreferences = canSeePeriodPreferences;
        }

        public boolean isCanSeeEventAvailability() {
            return this.iCanSeeEventAvailability;
        }

        public void setCanSeeEventAvailability(boolean canSeeEventAvailability) {
            this.iCanSeeEventAvailability = canSeeEventAvailability;
        }

        public boolean isCanChange() {
            return this.iCanChange;
        }

        public void setCanChange(boolean canChange) {
            this.iCanChange = canChange;
        }

        public boolean isCanEdit() {
            return this.isCanChange() || this.isCanChangeFeatures() || this.isCanChangeGroups() || this.isCanChangeAvailability() || this.isCanChangeEventAvailability() || this.isCanChangePicture() || this.isCanChangePreferences() || this.isCanDelete() || this.isCanChangeEventProperties();
        }

        public boolean isCanChangeAvailability() {
            return this.iCanChangeAvailability;
        }

        public void setCanChangeAvailability(boolean canChangeAvailability) {
            this.iCanChangeAvailability = canChangeAvailability;
        }

        public boolean isCanChangeControll() {
            return this.iCanChangeControll;
        }

        public void setCanChangeControll(boolean canChangeControll) {
            this.iCanChangeControll = canChangeControll;
        }

        public boolean isCanChangeExternalId() {
            return this.iCanChangeExternalId;
        }

        public void setCanChangeExternalId(boolean canChangeExternalId) {
            this.iCanChangeExternalId = canChangeExternalId;
        }

        public boolean isCanChangeType() {
            return this.iCanChangeType;
        }

        public void setCanChangeType(boolean canChangeType) {
            this.iCanChangeType = canChangeType;
        }

        public boolean isCanChangeCapacity() {
            return this.iCanChangeCapacity;
        }

        public void setCanChangeCapacity(boolean canChangeCapacity) {
            this.iCanChangeCapacity = canChangeCapacity;
        }

        public boolean isCanChangeExamStatus() {
            return this.iCanChangeExamStatus;
        }

        public void setCanChangeExamStatus(boolean canChangeExamStatus) {
            this.iCanChangeExamStatus = canChangeExamStatus;
        }

        public boolean isCanChangeRoomProperties() {
            return this.iCanChangeRoomProperties;
        }

        public void setCanChangeRoomProperties(boolean canChangeRoomProperties) {
            this.iCanChangeRoomProperties = canChangeRoomProperties;
        }

        public boolean isCanChangeEventProperties() {
            return this.iCanChangeEventProperties;
        }

        public void setCanChangeEventProperties(boolean canChangeEventProperties) {
            this.iCanChangeEventProperties = canChangeEventProperties;
        }

        public boolean isCanChangePicture() {
            return this.iCanChangePicture;
        }

        public void setCanChangePicture(boolean canChangePicture) {
            this.iCanChangePicture = canChangePicture;
        }

        public boolean isCanChangePreferences() {
            return this.iCanChangePreferences;
        }

        public void setCanChangePreferences(boolean canChangePreferences) {
            this.iCanChangePreferences = canChangePreferences;
        }

        public boolean isCanChangeGroups() {
            return this.iCanChangeGroups;
        }

        public void setCanChangeGroups(boolean canChangeGroups) {
            this.iCanChangeGroups = canChangeGroups;
        }

        public boolean isCanChangeFeatures() {
            return this.iCanChangeFeatures;
        }

        public void setCanChangeFeatures(boolean canChangeFeatures) {
            this.iCanChangeFeatures = canChangeFeatures;
        }

        public boolean isCanChangeEventAvailability() {
            return this.iCanChangeEventAvailability;
        }

        public void setCanChangeEventAvailability(boolean canChangeEventAvailability) {
            this.iCanChangeEventAvailability = canChangeEventAvailability;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public String getMiniMapUrl() {
            return this.iMiniMapUrl;
        }

        public void setMiniMapUrl(String miniMapUrl) {
            this.iMiniMapUrl = miniMapUrl;
        }

        public boolean hasMiniMapUrl() {
            return this.iMiniMapUrl != null && !this.iMiniMapUrl.isEmpty();
        }

        public String getMapUrl() {
            return this.iMapUrl;
        }

        public void setMapUrl(String MapUrl) {
            this.iMapUrl = MapUrl;
        }

        public boolean hasMapUrl() {
            return this.iMapUrl != null && !this.iMapUrl.isEmpty();
        }

        public boolean hasPictures() {
            return this.iPictures != null && !this.iPictures.isEmpty();
        }

        public boolean hasTablePictures() {
            if (this.iPictures == null) {
                return false;
            }
            for (RoomPictureInterface picture : this.getPictures()) {
                if (picture.getPictureType() != null && !picture.getPictureType().isTable()) continue;
                return true;
            }
            return false;
        }

        public boolean hasPictures(AttachmentTypeInterface type) {
            if (this.iPictures == null) {
                return false;
            }
            for (RoomPictureInterface picture : this.getPictures()) {
                if ((type != null || picture.getPictureType() != null) && (type == null || !type.equals(picture.getPictureType()))) continue;
                return true;
            }
            return false;
        }

        public void addPicture(RoomPictureInterface picture) {
            this.iPictures.add(picture);
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public List<RoomPictureInterface> getTablePictures() {
            ArrayList<RoomPictureInterface> ret = new ArrayList<RoomPictureInterface>();
            if (this.iPictures != null) {
                for (RoomPictureInterface picture : this.getPictures()) {
                    if (picture.getPictureType() != null && !picture.getPictureType().isTable()) continue;
                    ret.add(picture);
                }
            }
            return ret;
        }

        public List<RoomPictureInterface> getPictures(AttachmentTypeInterface type) {
            ArrayList<RoomPictureInterface> ret = new ArrayList<RoomPictureInterface>();
            if (this.iPictures != null) {
                for (RoomPictureInterface picture : this.getPictures()) {
                    if ((type != null || picture.getPictureType() != null) && (type == null || !type.equals(picture.getPictureType()))) continue;
                    ret.add(picture);
                }
            }
            return ret;
        }

        public String getLastChange() {
            return this.iLastChange;
        }

        public boolean hasLastChange() {
            return this.iLastChange != null && !this.iLastChange.isEmpty();
        }

        public void setLastChange(String lastChange) {
            this.iLastChange = lastChange;
        }

        public boolean hasRoomSharingModel() {
            return this.iRoomSharingModel != null;
        }

        public void setRoomSharingModel(RoomSharingModel model) {
            this.iRoomSharingModel = model;
        }

        public RoomSharingModel getRoomSharingModel() {
            return this.iRoomSharingModel;
        }

        public boolean hasEventAvailabilityModel() {
            return this.iEventAvailabilityModel != null;
        }

        public void setEventAvailabilityModel(RoomSharingModel model) {
            this.iEventAvailabilityModel = model;
        }

        public RoomSharingModel getEventAvailabilityModel() {
            return this.iEventAvailabilityModel;
        }

        public boolean hasPeriodPreferenceModel(Long examTypeId) {
            return this.iPeriodPreferenceModels != null && this.iPeriodPreferenceModels.containsKey(examTypeId);
        }

        public PeriodPreferenceModel getPeriodPreferenceModel(Long examTypeId) {
            return this.iPeriodPreferenceModels == null ? null : this.iPeriodPreferenceModels.get(examTypeId);
        }

        public void setPeriodPreferenceModel(PeriodPreferenceModel model) {
            if (model == null || model.getExamType() == null) {
                return;
            }
            if (this.iPeriodPreferenceModels == null) {
                this.iPeriodPreferenceModels = new HashMap<Long, PeriodPreferenceModel>();
            }
            this.iPeriodPreferenceModels.put(model.getExamType().getId(), model);
        }

        public boolean hasFutureRooms() {
            return this.iFutureRooms != null && !this.iFutureRooms.isEmpty();
        }

        public List<FutureRoomInterface> getFutureRooms() {
            return this.iFutureRooms;
        }

        public void addFutureRoom(FutureRoomInterface futureRoom) {
            if (this.iFutureRooms == null) {
                this.iFutureRooms = new ArrayList<FutureRoomInterface>();
            }
            this.iFutureRooms.add(futureRoom);
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public boolean hasSessionName() {
            return this.iSessionName != null;
        }

        public String getSessionName() {
            return this.iSessionName;
        }

        public void setSessionName(String sessionName) {
            this.iSessionName = sessionName;
        }

        public boolean hasServices() {
            return this.iServices != null && !this.iServices.isEmpty();
        }

        public void addService(EventInterface.EventServiceProviderInterface service) {
            if (this.iServices == null) {
                this.iServices = new TreeSet<EventInterface.EventServiceProviderInterface>();
            }
            this.iServices.add(service);
        }

        public Set<EventInterface.EventServiceProviderInterface> getServices() {
            return this.iServices;
        }

        public void clearServices() {
            if (this.iServices != null) {
                this.iServices.clear();
            }
        }

        public String getServices(String separator) {
            if (!this.hasServices()) {
                return "";
            }
            Object ret = "";
            for (EventInterface.EventServiceProviderInterface service : this.getServices()) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : separator) + service.getLabel();
            }
            return ret;
        }

        public RoomDetailInterface getParent() {
            return this.iParent;
        }

        public boolean hasParent() {
            return this.iParent != null;
        }

        public void setParent(RoomDetailInterface parent) {
            this.iParent = parent;
        }

        public String getDefaultEventEmail() {
            return this.iDefaultEventEmail;
        }

        public boolean hasDefaultEventEmail() {
            return this.iDefaultEventEmail != null && !this.iDefaultEventEmail.isEmpty();
        }

        public void setDefaultEventEmail(String eventEmail) {
            this.iDefaultEventEmail = eventEmail;
        }

        public String getEventEmail() {
            return this.iEventEmail;
        }

        public boolean hasEventEmail() {
            return this.iEventEmail != null && !this.iEventEmail.isEmpty();
        }

        public void setEventEmail(String eventEmail) {
            this.iEventEmail = eventEmail;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public boolean hasUrl() {
            return this.iUrl != null && !this.iUrl.isEmpty();
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }
    }

    public static class FutureRoomInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iLabel;
        private String iDisplayName;
        private Integer iCapacity;
        private String iType;
        private String iExternalId;
        private AcademicSessionInterface iSession;
        private boolean iCanChange = false;
        private boolean iCanDelete = false;

        public FutureRoomInterface() {
        }

        public FutureRoomInterface(Long id, String label) {
            this.iId = id;
            this.iLabel = label;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getDisplayName() {
            return this.iDisplayName;
        }

        public void setDisplayName(String displayName) {
            this.iDisplayName = displayName;
        }

        public boolean hasDisplayName() {
            return this.iDisplayName != null && !this.iDisplayName.isEmpty();
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean hasType() {
            return this.iType != null && !this.iType.isEmpty();
        }

        public String getType() {
            return this.iType;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setCapacity(Integer capacity) {
            this.iCapacity = capacity;
        }

        public boolean hasCapacity() {
            return this.iCapacity != null && this.iCapacity > 0;
        }

        public Integer getCapacity() {
            return this.iCapacity;
        }

        public AcademicSessionInterface getSession() {
            return this.iSession;
        }

        public void setSession(AcademicSessionInterface session) {
            this.iSession = session;
        }

        public boolean isCanChange() {
            return this.iCanChange;
        }

        public void setCanChange(boolean canChange) {
            this.iCanChange = canChange;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AcademicSessionInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicSessionInterface)object).getId());
        }
    }

    public static class AcademicSessionInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iLabel;
        private boolean iCanAddRoom = false;
        private boolean iCanAddNonUniversity = false;
        private boolean iCanAddDepartmentalRoomGroup = false;
        private boolean iCanAddGlobalRoomGroup = false;
        private boolean iCanAddDepartmentalRoomFeature = false;
        private boolean iCanAddGlobalRoomFeature = false;

        public AcademicSessionInterface() {
        }

        public AcademicSessionInterface(Long id, String label) {
            this.iId = id;
            this.iLabel = label;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean isCanAddRoom() {
            return this.iCanAddRoom;
        }

        public void setCanAddRoom(boolean canAddRoom) {
            this.iCanAddRoom = canAddRoom;
        }

        public boolean isCanAddNonUniversity() {
            return this.iCanAddNonUniversity;
        }

        public void setCanAddNonUniversity(boolean canAddNonUniv) {
            this.iCanAddNonUniversity = canAddNonUniv;
        }

        public boolean isCanAddDepartmentalRoomGroup() {
            return this.iCanAddDepartmentalRoomGroup;
        }

        public void setCanAddDepartmentalRoomGroup(boolean canAddDepartmentalRoomGroup) {
            this.iCanAddDepartmentalRoomGroup = canAddDepartmentalRoomGroup;
        }

        public boolean isCanAddGlobalRoomGroup() {
            return this.iCanAddGlobalRoomGroup;
        }

        public void setCanAddGlobalRoomGroup(boolean canAddGlobalRoomGroup) {
            this.iCanAddGlobalRoomGroup = canAddGlobalRoomGroup;
        }

        public boolean isCanAddDepartmentalRoomFeature() {
            return this.iCanAddDepartmentalRoomFeature;
        }

        public void setCanAddDepartmentalRoomFeature(boolean canAddDepartmentalRoomFeature) {
            this.iCanAddDepartmentalRoomFeature = canAddDepartmentalRoomFeature;
        }

        public boolean isCanAddGlobalRoomFeature() {
            return this.iCanAddGlobalRoomFeature;
        }

        public void setCanAddGlobalRoomFeature(boolean canAddGlobalRoomFeature) {
            this.iCanAddGlobalRoomFeature = canAddGlobalRoomFeature;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof AcademicSessionInterface)) {
                return false;
            }
            return this.getId().equals(((AcademicSessionInterface)object).getId());
        }
    }

    public static class GroupInterface
    extends RoomPropertyInterface {
        private DepartmentInterface iDepartment = null;
        private Boolean iDefault = null;
        private String iDescription = null;
        private List<EventInterface.FilterRpcResponse.Entity> iRooms = null;
        private Boolean iCanEdit = null;
        private Boolean iCanDelete = null;
        private Long iSessionId = null;
        private String iSessionName = null;

        public GroupInterface() {
        }

        public GroupInterface(Long id, String abbv, String label) {
            super(id, abbv, label);
        }

        public GroupInterface(GroupInterface group) {
            super(group);
            this.iDepartment = group.iDepartment;
            this.iDefault = group.iDefault;
            this.iDescription = group.iDescription;
            this.iRooms = group.iRooms == null ? null : new ArrayList<EventInterface.FilterRpcResponse.Entity>(group.iRooms);
            this.iCanEdit = group.iCanEdit;
            this.iCanDelete = group.iCanDelete;
            this.iSessionId = group.iSessionId;
            this.iSessionName = group.iSessionName;
        }

        public boolean isDepartmental() {
            return this.iDepartment != null;
        }

        public DepartmentInterface getDepartment() {
            return this.iDepartment;
        }

        public void setDepartment(DepartmentInterface department) {
            this.iDepartment = department;
        }

        public boolean isDefault() {
            return this.iDefault != null && this.iDefault != false;
        }

        public void setDefault(Boolean isDefault) {
            this.iDefault = isDefault;
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public void addRoom(EventInterface.FilterRpcResponse.Entity room) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            }
            this.iRooms.add(room);
        }

        public List<EventInterface.FilterRpcResponse.Entity> getRooms() {
            return this.iRooms;
        }

        public EventInterface.FilterRpcResponse.Entity getRoom(Long id) {
            if (this.iRooms == null) {
                return null;
            }
            for (EventInterface.FilterRpcResponse.Entity room : this.iRooms) {
                if (!id.equals(room.getUniqueId())) continue;
                return room;
            }
            return null;
        }

        public boolean canEdit() {
            return this.iCanEdit != null && this.iCanEdit != false;
        }

        public void setCanEdit(Boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean canDelete() {
            return this.iCanDelete != null && this.iCanDelete != false;
        }

        public void setCanDelete(Boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public boolean hasSessionName() {
            return this.iSessionName != null;
        }

        public String getSessionName() {
            return this.iSessionName;
        }

        public void setSessionName(String sessionName) {
            this.iSessionName = sessionName;
        }
    }

    public static class FeatureInterface
    extends RoomPropertyInterface {
        private DepartmentInterface iDepartment = null;
        private FeatureTypeInterface iType;
        private List<EventInterface.FilterRpcResponse.Entity> iRooms = null;
        private Boolean iCanEdit = null;
        private Boolean iCanDelete = null;
        private Long iSessionId = null;
        private String iSessionName = null;
        private String iDescription = null;

        public FeatureInterface() {
        }

        public FeatureInterface(Long id, String abbv, String label) {
            super(id, abbv, label);
        }

        public FeatureInterface(FeatureInterface feature) {
            super(feature);
            this.iDepartment = feature.iDepartment;
            this.iRooms = feature.iRooms == null ? null : new ArrayList<EventInterface.FilterRpcResponse.Entity>(feature.iRooms);
            this.iCanEdit = feature.iCanEdit;
            this.iCanDelete = feature.iCanDelete;
            this.iSessionId = feature.iSessionId;
            this.iSessionName = feature.iSessionName;
            this.iDescription = feature.iDescription;
        }

        public boolean isDepartmental() {
            return this.iDepartment != null;
        }

        public DepartmentInterface getDepartment() {
            return this.iDepartment;
        }

        public void setDepartment(DepartmentInterface department) {
            this.iDepartment = department;
        }

        public boolean hasType() {
            return this.iType != null;
        }

        public FeatureTypeInterface getType() {
            return this.iType;
        }

        public void setType(FeatureTypeInterface type) {
            this.iType = type;
        }

        public boolean hasRooms() {
            return this.iRooms != null && !this.iRooms.isEmpty();
        }

        public void addRoom(EventInterface.FilterRpcResponse.Entity room) {
            if (this.iRooms == null) {
                this.iRooms = new ArrayList<EventInterface.FilterRpcResponse.Entity>();
            }
            this.iRooms.add(room);
        }

        public List<EventInterface.FilterRpcResponse.Entity> getRooms() {
            return this.iRooms;
        }

        public EventInterface.FilterRpcResponse.Entity getRoom(Long id) {
            if (this.iRooms == null) {
                return null;
            }
            for (EventInterface.FilterRpcResponse.Entity room : this.iRooms) {
                if (!id.equals(room.getUniqueId())) continue;
                return room;
            }
            return null;
        }

        public boolean canEdit() {
            return this.iCanEdit != null && this.iCanEdit != false;
        }

        public void setCanEdit(Boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean canDelete() {
            return this.iCanDelete != null && this.iCanDelete != false;
        }

        public void setCanDelete(Boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public boolean hasSessionName() {
            return this.iSessionName != null;
        }

        public String getSessionName() {
            return this.iSessionName;
        }

        public void setSessionName(String sessionName) {
            this.iSessionName = sessionName;
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public String getDescription() {
            return this.iDescription;
        }
    }

    public static class DepartmentInterface
    extends RoomPropertyInterface {
        private String iCode;
        private boolean iExternal = false;
        private boolean iEvent = false;
        private String iExternalAbbv;
        private String iExternalLabel;
        private PreferenceInterface iPreference;
        private boolean iCanEditRoomSharing = false;

        public String getDeptCode() {
            return this.iCode;
        }

        public void setDeptCode(String code) {
            this.iCode = code;
        }

        public String getAbbreviationOrCode() {
            return this.getAbbreviation() == null || this.getAbbreviation().isEmpty() ? this.getDeptCode() : this.getAbbreviation();
        }

        public String getExtAbbreviationOrCode() {
            return this.getExtAbbreviation() == null || this.getExtAbbreviation().isEmpty() ? this.getDeptCode() : this.getExtAbbreviation();
        }

        public boolean isExternal() {
            return this.iExternal;
        }

        public void setExternal(boolean external) {
            this.iExternal = external;
        }

        public boolean isEvent() {
            return this.iEvent;
        }

        public void setEvent(boolean event) {
            this.iEvent = event;
        }

        public String getExtAbbreviation() {
            return this.iExternalAbbv;
        }

        public void setExtAbbreviation(String abbv) {
            this.iExternalAbbv = abbv;
        }

        public String getExtAbbreviationWhenExist() {
            return this.getExtAbbreviation() == null || this.getExtAbbreviation().isEmpty() ? this.getAbbreviationOrCode() : this.getExtAbbreviation();
        }

        public String getExtLabel() {
            return this.iExternalLabel;
        }

        public void setExtLabel(String label) {
            this.iExternalLabel = label;
        }

        public String getExtLabelWhenExist() {
            return this.getExtLabel() == null || this.getExtLabel().isEmpty() ? this.getLabel() : this.getExtLabel();
        }

        public PreferenceInterface getPreference() {
            return this.iPreference;
        }

        public void setPreference(PreferenceInterface preference) {
            this.iPreference = preference;
        }

        public boolean isCanEditRoomSharing() {
            return this.iCanEditRoomSharing;
        }

        public void setCanEditRoomSharing(boolean canEditRoomSharing) {
            this.iCanEditRoomSharing = canEditRoomSharing;
        }
    }

    public static class ExamTypeInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iReference;
        private String iLabel;
        private boolean iFinal = false;

        public ExamTypeInterface() {
        }

        public ExamTypeInterface(Long id, String reference, String label, boolean finalExams) {
            this.iId = id;
            this.iReference = reference;
            this.iLabel = label;
            this.iFinal = finalExams;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean isFinal() {
            return this.iFinal;
        }

        public void setFinal(boolean finalExams) {
            this.iFinal = finalExams;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ExamTypeInterface)) {
                return false;
            }
            return this.getId().equals(((ExamTypeInterface)object).getId());
        }
    }

    public static class BuildingInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iAbbreviation;
        private String iName;
        private Double iX;
        private Double iY;
        private String iExternalId;
        private Boolean iCanEdit;

        public BuildingInterface() {
        }

        public BuildingInterface(Long id, String abbreviation, String name) {
            this.iId = id;
            this.iAbbreviation = abbreviation;
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbreviation;
        }

        public void setAbbreviation(String abbreviation) {
            this.iAbbreviation = abbreviation;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasCoordinates() {
            return this.iX != null && this.iY != null;
        }

        public Double getX() {
            return this.iX;
        }

        public void setX(Double x) {
            this.iX = x;
        }

        public Double getY() {
            return this.iY;
        }

        public void setY(Double y) {
            this.iY = y;
        }

        public boolean hasExternalId() {
            return this.iExternalId != null && !this.iExternalId.isEmpty();
        }

        public String getExternalId() {
            return this.iExternalId;
        }

        public void setExternalId(String externalId) {
            this.iExternalId = externalId;
        }

        public void setCanEdit(boolean canEdit) {
            this.iCanEdit = canEdit;
        }

        public boolean isCanEdit() {
            return this.iCanEdit != null && this.iCanEdit != false;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof BuildingInterface)) {
                return false;
            }
            return this.getId().equals(((BuildingInterface)object).getId());
        }
    }

    public static class RoomPropertyInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iAbbv;
        private String iLabel;
        private String iColor;
        private String iTitle;

        public RoomPropertyInterface() {
        }

        public RoomPropertyInterface(Long id, String label) {
            this.iId = id;
            this.iLabel = label;
        }

        public RoomPropertyInterface(Long id, String abbv, String label) {
            this.iId = id;
            this.iAbbv = abbv;
            this.iLabel = label;
        }

        public RoomPropertyInterface(RoomPropertyInterface property) {
            this.iId = property.iId;
            this.iAbbv = property.iAbbv;
            this.iLabel = property.iLabel;
            this.iColor = property.iColor;
            this.iTitle = property.iTitle;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RoomPropertyInterface)) {
                return false;
            }
            return this.getId().equals(((RoomPropertyInterface)object).getId());
        }
    }

    public static class FeatureTypeInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iAbbv;
        private String iLabel;
        private boolean iEvents = false;

        public FeatureTypeInterface() {
        }

        public FeatureTypeInterface(Long id, String abbv, String label, boolean events) {
            this.iId = id;
            this.iAbbv = abbv;
            this.iLabel = label;
            this.iEvents = events;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getAbbreviation() {
            return this.iAbbv;
        }

        public void setAbbreviation(String abbv) {
            this.iAbbv = abbv;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean isEvents() {
            return this.iEvents;
        }

        public void setEvents(boolean events) {
            this.iEvents = events;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FeatureTypeInterface)) {
                return false;
            }
            return this.getId().equals(((FeatureTypeInterface)object).getId());
        }
    }

    public static class RoomTypeInterface
    implements GwtRpcResponse {
        private Long iId;
        private String iReference;
        private String iLabel;
        private boolean iRoom = false;
        private Integer iOrder = null;

        public RoomTypeInterface() {
        }

        public RoomTypeInterface(Long id, String reference, String label, boolean room, Integer ord) {
            this.iId = id;
            this.iReference = reference;
            this.iLabel = label;
            this.iRoom = room;
            this.iOrder = ord;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getReference() {
            return this.iReference;
        }

        public void setReference(String reference) {
            this.iReference = reference;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public boolean isRoom() {
            return this.iRoom;
        }

        public void setRoom(boolean room) {
            this.iRoom = room;
        }

        public Integer getOrder() {
            return this.iOrder;
        }

        public void setOrder(Integer order) {
            this.iOrder = order;
        }

        public boolean hasOrder() {
            return this.iOrder != null;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof RoomTypeInterface)) {
                return false;
            }
            return this.getId().equals(((RoomTypeInterface)object).getId());
        }
    }

    public static class RoomPictureResponse
    implements GwtRpcResponse {
        private String iName;
        private List<RoomPictureInterface> iPictures;
        private RoomPictureRequest.Apply iApply;
        private List<AttachmentTypeInterface> iPictureTypes = null;

        public boolean hasPictures() {
            return this.iPictures != null && !this.iPictures.isEmpty();
        }

        public void addPicture(RoomPictureInterface picture) {
            if (this.iPictures == null) {
                this.iPictures = new ArrayList<RoomPictureInterface>();
            }
            this.iPictures.add(picture);
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getName() {
            return this.iName;
        }

        public RoomPictureRequest.Apply getApply() {
            return this.iApply;
        }

        public void setApply(RoomPictureRequest.Apply apply) {
            this.iApply = apply;
        }

        public void addPictureType(AttachmentTypeInterface type) {
            if (this.iPictureTypes == null) {
                this.iPictureTypes = new ArrayList<AttachmentTypeInterface>();
            }
            this.iPictureTypes.add(type);
        }

        public boolean hasPictureTypes() {
            return this.iPictureTypes != null && !this.iPictureTypes.isEmpty();
        }

        public List<AttachmentTypeInterface> getPictureTypes() {
            return this.iPictureTypes;
        }

        public AttachmentTypeInterface getPictureType(Long id) {
            if (this.iPictureTypes == null) {
                return null;
            }
            for (AttachmentTypeInterface type : this.iPictureTypes) {
                if (!type.getId().equals(id)) continue;
                return type;
            }
            return null;
        }
    }

    public static class RoomPictureRequest
    implements GwtRpcRequest<RoomPictureResponse> {
        private Operation iOperation;
        private Apply iApply;
        private Long iSessionId;
        private Long iLocationId;
        private List<RoomPictureInterface> iPictures;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public void setPictures(List<RoomPictureInterface> pictures) {
            this.iPictures = pictures;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        public Apply getApply() {
            return this.iApply;
        }

        public void setApply(Apply apply) {
            this.iApply = apply;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + "[" + this.getLocationId() + "]";
        }

        public static RoomPictureRequest load(Long sessionId, Long locationId) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.LOAD);
            request.setLocationId(locationId);
            return request;
        }

        public static RoomPictureRequest load(Long locationId) {
            return RoomPictureRequest.load(null, locationId);
        }

        public static RoomPictureRequest save(Long sessionId, Long locationId, Apply apply, List<RoomPictureInterface> pictures) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.SAVE);
            request.setLocationId(locationId);
            request.setPictures(pictures);
            request.setApply(apply);
            return request;
        }

        public static RoomPictureRequest save(Long locationId, Apply apply, List<RoomPictureInterface> pictures) {
            return RoomPictureRequest.save(null, locationId, apply, pictures);
        }

        public static RoomPictureRequest upload(Long sessionId, Long locationId) {
            RoomPictureRequest request = new RoomPictureRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.UPLOAD);
            request.setLocationId(locationId);
            return request;
        }

        public static RoomPictureRequest upload(Long locationId) {
            return RoomPictureRequest.upload(null, locationId);
        }

        public static enum Operation implements IsSerializable
        {
            LOAD,
            SAVE,
            UPLOAD;

        }

        public static enum Apply implements IsSerializable
        {
            THIS_SESSION_ONLY,
            ALL_FUTURE_SESSIONS,
            ALL_SESSIONS;

        }
    }

    public static class RoomPictureInterface
    implements IsSerializable {
        private Long iUniqueId;
        private String iName;
        private String iType;
        private Long iTimeStamp;
        private AttachmentTypeInterface iPictureType;

        public RoomPictureInterface() {
        }

        public RoomPictureInterface(Long uniqueId, String name, String type, Long timeStamp, AttachmentTypeInterface pictureType) {
            this.setUniqueId(uniqueId);
            this.setName(name);
            this.setType(type);
            this.setTimeStamp(timeStamp);
            this.setPictureType(pictureType);
        }

        public Long getUniqueId() {
            return this.iUniqueId;
        }

        public void setUniqueId(Long uniqueId) {
            this.iUniqueId = uniqueId;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public Long getTimeStamp() {
            return this.iTimeStamp;
        }

        public void setTimeStamp(Long timeStamp) {
            this.iTimeStamp = timeStamp;
        }

        public AttachmentTypeInterface getPictureType() {
            return this.iPictureType;
        }

        public void setPictureType(AttachmentTypeInterface type) {
            this.iPictureType = type;
        }
    }

    public static class RoomHintRequest
    implements GwtRpcRequest<RoomHintResponse> {
        private Long iLocationId;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        @Override
        public String toString() {
            return "" + this.getLocationId();
        }

        public static RoomHintRequest load(Long locationId) {
            RoomHintRequest request = new RoomHintRequest();
            request.setLocationId(locationId);
            return request;
        }
    }

    public static class RoomHintResponse
    implements GwtRpcResponse {
        private Long iId = null;
        private String iLabel = null;
        private String iDisplayName = null;
        private String iRoomTypeLabel = null;
        private String iMiniMapUrl = null;
        private Integer iCapacity = null;
        private Integer iExamCapacity = null;
        private Integer iBreakTime = null;
        private String iExamType = null;
        private String iArea = null;
        private List<GroupInterface> iGroups = null;
        private String iEventStatus = null;
        private String iEventDepartment = null;
        private String iNote = null;
        private boolean iIgnoreRoomCheck = false;
        private String iUrl = null;
        private List<FeatureInterface> iFeatures = null;
        private List<RoomPictureInterface> iPictures = null;
        private Set<EventInterface.EventServiceProviderInterface> iServices = null;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getDisplayName() {
            return this.iDisplayName;
        }

        public void setDisplayName(String displayName) {
            this.iDisplayName = displayName;
        }

        public boolean hasDisplayName() {
            return this.iDisplayName != null && !this.iDisplayName.isEmpty();
        }

        public String getRoomTypeLabel() {
            return this.iRoomTypeLabel;
        }

        public void setRoomTypeLabel(String roomTypeLabel) {
            this.iRoomTypeLabel = roomTypeLabel;
        }

        public boolean hasRoomTypeLabel() {
            return this.iRoomTypeLabel != null && !this.iRoomTypeLabel.isEmpty();
        }

        public String getMiniMapUrl() {
            return this.iMiniMapUrl;
        }

        public void setMiniMapUrl(String miniMapUrl) {
            this.iMiniMapUrl = miniMapUrl;
        }

        public boolean hasMiniMapUrl() {
            return this.iMiniMapUrl != null && !this.iMiniMapUrl.isEmpty();
        }

        public Integer getCapacity() {
            return this.iCapacity;
        }

        public void setCapacity(Integer capacity) {
            this.iCapacity = capacity;
        }

        public boolean hasCapacity() {
            return this.iCapacity != null && this.iCapacity != 0;
        }

        public Integer getExamCapacity() {
            return this.iExamCapacity;
        }

        public void setExamCapacity(Integer examCapacity) {
            this.iExamCapacity = examCapacity;
        }

        public boolean hasExamCapacity() {
            return this.iExamCapacity != null && this.iExamCapacity != 0;
        }

        public String getExamType() {
            return this.iExamType;
        }

        public void setExamType(String examType) {
            this.iExamType = examType;
        }

        public boolean hasExamType() {
            return this.iExamType != null && !this.iExamType.isEmpty();
        }

        public String getArea() {
            return this.iArea;
        }

        public void setArea(String area) {
            this.iArea = area;
        }

        public boolean hasArea() {
            return this.iArea != null && !this.iArea.isEmpty();
        }

        public boolean hasFeatures() {
            return this.iFeatures != null && !this.iFeatures.isEmpty();
        }

        public void addFeature(FeatureInterface feature) {
            if (this.iFeatures == null) {
                this.iFeatures = new ArrayList<FeatureInterface>();
            }
            this.iFeatures.add(feature);
        }

        public Set<String> getFeatureTypes() {
            TreeSet<String> types = new TreeSet<String>();
            if (this.iFeatures != null) {
                for (FeatureInterface feature : this.iFeatures) {
                    if (!feature.hasType()) continue;
                    types.add(feature.getType().getLabel());
                }
            }
            return types;
        }

        public List<FeatureInterface> getFeatures(String type) {
            ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
            if (this.iFeatures != null) {
                for (FeatureInterface feature : this.iFeatures) {
                    if (type == null && !feature.hasType()) {
                        features.add(feature);
                        continue;
                    }
                    if (type == null || !feature.hasType() || !type.equals(feature.getType().getLabel())) continue;
                    features.add(feature);
                }
            }
            return features;
        }

        public boolean hasFeatures(String type) {
            if (this.iFeatures != null) {
                for (FeatureInterface feature : this.iFeatures) {
                    if (type == null && !feature.hasType()) {
                        return true;
                    }
                    if (type == null || !feature.hasType() || !type.equals(feature.getType().getLabel())) continue;
                    return true;
                }
            }
            return false;
        }

        public List<GroupInterface> getGroups() {
            return this.iGroups;
        }

        public void addGroup(GroupInterface group) {
            if (this.iGroups == null) {
                this.iGroups = new ArrayList<GroupInterface>();
            }
            this.iGroups.add(group);
        }

        public boolean hasGroups() {
            return this.iGroups != null && !this.iGroups.isEmpty();
        }

        public String getEventStatus() {
            return this.iEventStatus;
        }

        public void setEventStatus(String eventStatus) {
            this.iEventStatus = eventStatus;
        }

        public boolean hasEventStatus() {
            return this.iEventStatus != null && !this.iEventStatus.isEmpty();
        }

        public String getEventDepartment() {
            return this.iEventDepartment;
        }

        public void setEventDepartment(String eventDepartment) {
            this.iEventDepartment = eventDepartment;
        }

        public boolean hasEventDepartment() {
            return this.iEventDepartment != null && !this.iEventDepartment.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public Integer getBreakTime() {
            return this.iBreakTime;
        }

        public void setBreakTime(Integer breakTime) {
            this.iBreakTime = breakTime;
        }

        public boolean hasBreakTime() {
            return this.iBreakTime != null && this.iBreakTime != 0;
        }

        public boolean isIgnoreRoomCheck() {
            return this.iIgnoreRoomCheck;
        }

        public void setIgnoreRoomCheck(boolean ignoreRoomCheck) {
            this.iIgnoreRoomCheck = ignoreRoomCheck;
        }

        public boolean hasPictures() {
            return this.iPictures != null && !this.iPictures.isEmpty();
        }

        public void addPicture(RoomPictureInterface picture) {
            if (this.iPictures == null) {
                this.iPictures = new ArrayList<RoomPictureInterface>();
            }
            this.iPictures.add(picture);
        }

        public List<RoomPictureInterface> getPictures() {
            return this.iPictures;
        }

        public boolean hasServices() {
            return this.iServices != null && !this.iServices.isEmpty();
        }

        public void addService(EventInterface.EventServiceProviderInterface service) {
            if (this.iServices == null) {
                this.iServices = new TreeSet<EventInterface.EventServiceProviderInterface>();
            }
            this.iServices.add(service);
        }

        public Set<EventInterface.EventServiceProviderInterface> getServices() {
            return this.iServices;
        }

        public String getServices(String separator) {
            if (!this.hasServices()) {
                return "";
            }
            Object ret = "";
            for (EventInterface.EventServiceProviderInterface service : this.getServices()) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : separator) + service.getLabel();
            }
            return ret;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public boolean hasUrl() {
            return this.iUrl != null && !this.iUrl.isEmpty();
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }
    }

    public static class RoomSharingRequest
    implements GwtRpcRequest<RoomSharingModel> {
        private Operation iOperation;
        private Long iSessionId;
        private Long iLocationId;
        private RoomSharingModel iModel;
        private boolean iEventAvailability = false;
        private boolean iIncludeRoomPreferences = false;

        public Long getLocationId() {
            return this.iLocationId;
        }

        public void setLocationId(Long locationId) {
            this.iLocationId = locationId;
        }

        public RoomSharingModel getModel() {
            return this.iModel;
        }

        public void setModel(RoomSharingModel model) {
            this.iModel = model;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        @Override
        public String toString() {
            return this.getOperation().name() + "[" + this.getLocationId() + "]";
        }

        public boolean isEventAvailability() {
            return this.iEventAvailability;
        }

        public void setEventAvailability(boolean availability) {
            this.iEventAvailability = availability;
        }

        public boolean isIncludeRoomPreferences() {
            return this.iIncludeRoomPreferences;
        }

        public void setIncludeRoomPreferences(boolean includeRoomPreferences) {
            this.iIncludeRoomPreferences = includeRoomPreferences;
        }

        public boolean hasSessionId() {
            return this.iSessionId != null;
        }

        public Long getSessionId() {
            return this.iSessionId;
        }

        public void setSessionId(Long sessionId) {
            this.iSessionId = sessionId;
        }

        public static RoomSharingRequest load(Long sessionId, Long locationId, boolean eventAvailability, boolean includeRoomPreferences) {
            RoomSharingRequest request = new RoomSharingRequest();
            request.setSessionId(sessionId);
            request.setOperation(Operation.LOAD);
            request.setLocationId(locationId);
            request.setEventAvailability(eventAvailability);
            request.setIncludeRoomPreferences(includeRoomPreferences);
            return request;
        }

        public static RoomSharingRequest load(Long locationId, boolean eventAvailability) {
            return RoomSharingRequest.load(null, locationId, eventAvailability, false);
        }

        public static RoomSharingRequest load(Long locationId, boolean eventAvailability, boolean includeRoomPreferences) {
            return RoomSharingRequest.load(null, locationId, eventAvailability, includeRoomPreferences);
        }

        public static RoomSharingRequest load(Long sessionId, Long locationId, boolean eventAvailability) {
            return RoomSharingRequest.load(sessionId, locationId, eventAvailability, false);
        }

        public static RoomSharingRequest save(Long sessionId, Long locationId, RoomSharingModel model, boolean eventAvailability, boolean includeRoomPreferences) {
            RoomSharingRequest request = new RoomSharingRequest();
            request.setOperation(Operation.SAVE);
            request.setSessionId(sessionId);
            request.setLocationId(locationId);
            request.setModel(model);
            request.setEventAvailability(eventAvailability);
            request.setIncludeRoomPreferences(includeRoomPreferences);
            return request;
        }

        public static RoomSharingRequest save(Long locationId, RoomSharingModel model, boolean eventAvailability, boolean includeRoomPreferences) {
            return RoomSharingRequest.save(null, locationId, model, eventAvailability, includeRoomPreferences);
        }

        public static RoomSharingRequest save(Long locationId, RoomSharingModel model, boolean eventAvailability) {
            return RoomSharingRequest.save(null, locationId, model, eventAvailability, false);
        }

        public static enum Operation implements IsSerializable
        {
            LOAD,
            SAVE;

        }
    }

    public static class RoomSharingModel
    implements IsSerializable,
    GwtRpcResponse {
        private Long iId;
        private String iName;
        private Long iDefaultOption;
        private boolean iDefaultHorizontal;
        private List<RoomSharingDisplayMode> iModes;
        private List<RoomSharingOption> iOptions;
        private List<RoomSharingOption> iOtherOptions;
        protected Map<Integer, Map<Integer, Long>> iModel;
        private Map<Integer, Map<Integer, Boolean>> iEditable;
        private int iDefaultMode = 0;
        private boolean iDefaultEditable = true;
        private String iNote = null;
        private boolean iNoteEditable = false;
        private List<PreferenceInterface> iPreferences = null;
        private Long iDefaultPreference = null;

        public RoomSharingModel() {
        }

        public RoomSharingModel(RoomSharingModel model) {
            this.iId = model.iId;
            this.iName = model.iName;
            this.iDefaultOption = model.iDefaultOption;
            this.iDefaultHorizontal = model.iDefaultHorizontal;
            if (model.iModes != null) {
                this.iModes = new ArrayList<RoomSharingDisplayMode>(model.iModes);
            }
            if (model.iOptions != null) {
                this.iOptions = new ArrayList<RoomSharingOption>(model.iOptions);
            }
            if (model.iOtherOptions != null) {
                this.iOtherOptions = new ArrayList<RoomSharingOption>(model.iOtherOptions);
            }
            this.iDefaultMode = model.iDefaultMode;
            this.iDefaultEditable = model.iDefaultEditable;
            this.iNote = model.iNote;
            this.iNoteEditable = model.iNoteEditable;
            if (this.iPreferences != null) {
                this.iPreferences = new ArrayList<PreferenceInterface>(model.iPreferences);
            }
            this.iDefaultPreference = model.iDefaultPreference;
            if (model.iModel != null) {
                this.iModel = new HashMap<Integer, Map<Integer, Long>>();
                for (Map.Entry<Integer, Map<Integer, Constable>> entry : model.iModel.entrySet()) {
                    this.iModel.put(entry.getKey(), new HashMap<Integer, Constable>(entry.getValue()));
                }
            }
            if (model.iEditable != null) {
                this.iEditable = new HashMap<Integer, Map<Integer, Boolean>>();
                for (Map.Entry<Integer, Map<Integer, Constable>> entry : model.iEditable.entrySet()) {
                    this.iEditable.put(entry.getKey(), new HashMap<Integer, Constable>(entry.getValue()));
                }
            }
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public void addMode(RoomSharingDisplayMode mode) {
            if (this.iModes == null) {
                this.iModes = new ArrayList<RoomSharingDisplayMode>();
            }
            this.iModes.add(mode);
        }

        public List<RoomSharingDisplayMode> getModes() {
            return this.iModes;
        }

        public void setDefaultOption(RoomSharingOption option) {
            this.iDefaultOption = option == null ? null : option.getId();
        }

        public RoomSharingOption getDefaultOption() {
            return this.getOption(this.iDefaultOption);
        }

        public RoomSharingOption getOption(Long id) {
            if (id == null) {
                id = this.iDefaultOption;
            }
            if (this.iOptions == null || id == null) {
                return null;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.getId().equals(id)) continue;
                return option;
            }
            return !id.equals(this.iDefaultOption) ? this.getOption(this.iDefaultOption) : null;
        }

        public void addOption(RoomSharingOption option) {
            if (this.iOptions == null) {
                this.iOptions = new ArrayList<RoomSharingOption>();
            }
            this.iOptions.add(option);
        }

        public void addOther(RoomSharingOption option) {
            if (this.iOtherOptions == null) {
                this.iOtherOptions = new ArrayList<RoomSharingOption>();
            }
            this.iOtherOptions.add(option);
        }

        public List<RoomSharingOption> getAdditionalOptions() {
            ArrayList<RoomSharingOption> other = new ArrayList<RoomSharingOption>();
            if (this.iOtherOptions == null || this.iOtherOptions.isEmpty()) {
                return other;
            }
            for (RoomSharingOption option : this.iOtherOptions) {
                if (this.iOptions.contains(option)) continue;
                other.add(option);
            }
            return other;
        }

        public List<RoomSharingOption> getOptions() {
            return this.iOptions;
        }

        public List<RoomSharingOption> getRemovableOptions() {
            ArrayList<RoomSharingOption> options = new ArrayList<RoomSharingOption>();
            if (this.iOptions == null) {
                return options;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.isDeletable() || option.getId() < 0L) continue;
                options.add(option);
            }
            return options;
        }

        public boolean isEditable() {
            if (this.iOptions == null) {
                return false;
            }
            for (RoomSharingOption option : this.iOptions) {
                if (!option.isEditable()) continue;
                if (this.iDefaultEditable) {
                    return true;
                }
                if (this.iEditable == null || this.iEditable.isEmpty()) {
                    return false;
                }
                for (Map<Integer, Boolean> slot2ed : this.iEditable.values()) {
                    for (Boolean ed : slot2ed.values()) {
                        if (!ed.booleanValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        public RoomSharingOption getOption(int day, int slot) {
            if (this.iModel == null) {
                return this.getOption(this.iDefaultOption);
            }
            Map<Integer, Long> slot2id = this.iModel.get(day);
            return this.getOption(slot2id == null ? null : slot2id.get(slot));
        }

        public void setOption(int day, int slot, Long optionId) {
            Map<Integer, Long> slot2id;
            if (this.iModel == null) {
                this.iModel = new HashMap<Integer, Map<Integer, Long>>();
            }
            if ((slot2id = this.iModel.get(day)) == null) {
                slot2id = new HashMap<Integer, Long>();
                this.iModel.put(day, slot2id);
            }
            if (optionId == null) {
                slot2id.remove(slot);
            } else {
                slot2id.put(slot, optionId);
            }
        }

        public void setOption(int day, int slot, int step, RoomSharingOption option) {
            for (int i = 0; i < step; ++i) {
                this.setOption(day, slot + i, option == null ? null : option.getId());
            }
        }

        public boolean isEditable(int day, int slot) {
            if (this.iEditable == null) {
                return this.iDefaultEditable;
            }
            Map<Integer, Boolean> slot2ed = this.iEditable.get(day);
            if (slot2ed == null) {
                return this.iDefaultEditable;
            }
            Boolean ed = slot2ed.get(slot);
            return ed == null ? this.iDefaultEditable : ed;
        }

        public boolean isEditable(int day, int slot, int step) {
            for (int i = 0; i < step; ++i) {
                if (this.isEditable(day, slot + i)) continue;
                return false;
            }
            return true;
        }

        public void setEditable(int day, int slot, boolean editable) {
            Map<Integer, Boolean> slot2ed;
            if (this.iEditable == null) {
                this.iEditable = new HashMap<Integer, Map<Integer, Boolean>>();
            }
            if ((slot2ed = this.iEditable.get(day)) == null) {
                slot2ed = new HashMap<Integer, Boolean>();
                this.iEditable.put(day, slot2ed);
            }
            slot2ed.put(slot, editable);
        }

        public void setDefaultEditable(boolean editable) {
            this.iDefaultEditable = editable;
        }

        public boolean isDefaultHorizontal() {
            return this.iDefaultHorizontal;
        }

        public void setDefaultHorizontal(boolean horizontal) {
            this.iDefaultHorizontal = horizontal;
        }

        public int getDefaultMode() {
            return this.iDefaultMode;
        }

        public void setDefaultMode(int mode) {
            this.iDefaultMode = mode;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }

        public boolean isNoteEditable() {
            return this.iNoteEditable;
        }

        public void setNoteEditable(boolean noteEditable) {
            this.iNoteEditable = noteEditable;
        }

        public void setDefaultPreference(PreferenceInterface preference) {
            this.iDefaultPreference = preference == null ? null : preference.getId();
        }

        public PreferenceInterface getDefaultPreference() {
            return this.getPreference(this.iDefaultPreference);
        }

        public PreferenceInterface getPreference(Long id) {
            if (id == null) {
                id = this.iDefaultPreference;
            }
            if (this.iPreferences == null || id == null) {
                return null;
            }
            for (PreferenceInterface preference : this.iPreferences) {
                if (!preference.getId().equals(id)) continue;
                return preference;
            }
            return !id.equals(this.iDefaultPreference) ? this.getPreference(this.iDefaultPreference) : null;
        }

        public void addPreference(PreferenceInterface preference) {
            if (this.iPreferences == null) {
                this.iPreferences = new ArrayList<PreferenceInterface>();
            }
            this.iPreferences.add(preference);
        }

        public List<PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }

        public int countOptions(Long optionId) {
            if (this.iModel == null || optionId == null) {
                return 0;
            }
            int ret = 0;
            for (Map<Integer, Long> slot2id : this.iModel.values()) {
                for (Long id : slot2id.values()) {
                    if (!optionId.equals(id)) continue;
                    ++ret;
                }
            }
            return ret;
        }
    }

    public static class RoomSharingOption
    implements IsSerializable {
        private String iCode;
        private String iName;
        private String iColor;
        private Long iId;
        private boolean iEditable;
        private Long iPreferenceId = null;
        private Boolean iDeletable = null;

        public RoomSharingOption() {
        }

        public RoomSharingOption(Long id, String color, String code, String name, boolean editable, Long preferenceId) {
            this.iId = id;
            this.iColor = color;
            this.iCode = code;
            this.iName = name;
            this.iEditable = editable;
            this.iPreferenceId = preferenceId;
        }

        public RoomSharingOption(Long id, String color, String code, String name, boolean editable) {
            this(id, color, code, name, editable, null);
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public void setEditable(boolean editable) {
            this.iEditable = editable;
        }

        public boolean isEditable() {
            return this.iEditable;
        }

        public void setDeletable(Boolean deletable) {
            this.iDeletable = deletable;
        }

        public boolean isDeletable() {
            return this.iDeletable == null ? this.iEditable : this.iDeletable;
        }

        public boolean hasPreference() {
            return this.iPreferenceId != null;
        }

        public void setPreference(Long preferenceId) {
            this.iPreferenceId = preferenceId;
        }

        public Long getPreference() {
            return this.iPreferenceId;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof RoomSharingOption)) {
                return false;
            }
            return this.getId().equals(((RoomSharingOption)o).getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }
    }

    public static class RoomSharingDisplayMode
    implements IsSerializable {
        private String iName;
        private int iFirstDay = 0;
        private int iLastDay = 4;
        private int iFirstSlot = 90;
        private int iLastSlot = 210;
        private int iStep = 6;

        public RoomSharingDisplayMode() {
        }

        public RoomSharingDisplayMode(String m) {
            String[] model = m.split("\\|");
            this.iName = model[0];
            this.iFirstDay = Integer.parseInt(model[1]);
            this.iLastDay = Integer.parseInt(model[2]);
            this.iFirstSlot = Integer.parseInt(model[3]);
            this.iLastSlot = Integer.parseInt(model[4]);
            this.iStep = Integer.parseInt(model[5]);
        }

        public int getFirstDay() {
            return this.iFirstDay;
        }

        public void setFirstDay(int firstDay) {
            this.iFirstDay = firstDay;
        }

        public int getLastDay() {
            return this.iLastDay;
        }

        public void setLastDay(int lastDay) {
            this.iLastDay = lastDay;
        }

        public int getFirstSlot() {
            return this.iFirstSlot;
        }

        public void setFirstSlot(int firstSlot) {
            this.iFirstSlot = firstSlot;
        }

        public int getLastSlot() {
            return this.iLastSlot;
        }

        public void setLastSlot(int lastSlot) {
            this.iLastSlot = lastSlot;
        }

        public int getStep() {
            return this.iStep;
        }

        public void setStep(int step) {
            this.iStep = step;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public String toString() {
            return this.getFirstDay() + "|" + this.getLastDay() + "|" + this.getFirstSlot() + "|" + this.getLastSlot() + "|" + this.getStep();
        }

        public String toHex() {
            return Integer.toHexString(this.getStep() * 4064256 + this.getFirstDay() * 580608 + this.getLastDay() * 82944 + this.getFirstSlot() * 288 + this.getLastSlot() % 288);
        }

        public static RoomSharingDisplayMode fromHex(String hexMode) {
            int mode = Integer.parseInt(hexMode, 16);
            RoomSharingDisplayMode m = new RoomSharingDisplayMode();
            m.setStep(mode / 4064256);
            m.setFirstDay(mode % 4064256 / 580608);
            m.setLastDay(mode % 580608 / 82944);
            m.setFirstSlot(mode % 82944 / 288);
            m.setLastSlot(mode % 288 == 0 ? 288 : mode % 288);
            return m;
        }
    }
}

