/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import org.unitime.timetable.gwt.client.GwtHint;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.client.offerings.TimePreferenceWidget;
import org.unitime.timetable.gwt.client.sectioning.CourseDetailsWidget;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.TableInterface;

public class TableWidget
extends UniTimeTable<TableInterface.LineInterface> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private int iSortColumn = -1;
    private boolean iSortAsc = true;
    private Integer iNavigationLevel = null;

    public TableWidget() {
        this.addMouseClickListener(new UniTimeTable.MouseClickListener<TableInterface.LineInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<TableInterface.LineInterface> event) {
                if (event.getData() != null && event.getData().hasURL()) {
                    LoadingWidget.showLoading(MESSAGES.waitLoadingPage());
                    ToolBox.open(GWT.getHostPageBaseURL() + event.getData().getURL());
                }
            }
        });
    }

    public TableWidget(TableInterface table) {
        this();
        this.setData(table);
        if (table.hasStyle()) {
            TableWidget.applyStyle(this.getElement().getStyle(), table.getStyle());
        }
        if (table.hasClassName()) {
            this.addStyleName(table.getClassName());
        }
    }

    @Override
    protected boolean showHower(int row, TableInterface.LineInterface data) {
        return data != null && data.hasURL();
    }

    protected static void applyStyle(Style style, String text) {
        if (text == null || text.isEmpty()) {
            return;
        }
        for (String param : text.split(";")) {
            if (param.indexOf(58) < 0) continue;
            String key = param.substring(0, param.indexOf(58)).trim();
            String value = param.substring(param.indexOf(58) + 1).trim();
            if (value.isEmpty()) {
                style.clearProperty(key);
                continue;
            }
            style.setProperty(key, value);
        }
    }

    public void setData(final TableInterface table) {
        int row;
        ArrayList<CellWidget> cells;
        this.clearTable();
        this.iNavigationLevel = table.getNavigationLevel();
        String sortCookie = ToolBox.getSessionCookie(table.getId() + ".Sort");
        if (table.getHeader() != null) {
            for (TableInterface.LineInterface line : table.getHeader()) {
                if (!line.hasCells()) continue;
                cells = new ArrayList<CellWidget>();
                for (final TableInterface.CellInterface cell : line.getCells()) {
                    CellWidget cw = new CellWidget(cell, false);
                    cells.add(cw);
                    if (!cell.isSortable()) continue;
                    final int column = cells.size() - 1;
                    cw.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                    if (cell.hasText() && cell.getText().equals(sortCookie)) {
                        this.iSortColumn = column;
                        this.iSortAsc = true;
                    } else if (cell.hasText() && ("!" + cell.getText()).equals(sortCookie)) {
                        this.iSortColumn = column;
                        this.iSortAsc = false;
                    }
                    cw.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent e) {
                            if (TableWidget.this.iSortColumn == column) {
                                TableWidget.this.iSortAsc = !TableWidget.this.iSortAsc;
                            } else {
                                TableWidget.this.iSortColumn = column;
                                TableWidget.this.iSortAsc = true;
                            }
                            TableWidget.this.sort();
                            ToolBox.setSessionCookie(table.getId() + ".Sort", (String)(TableWidget.this.iSortAsc ? cell.getText() : "!" + cell.getText()));
                        }
                    });
                }
                row = this.addRow(null, cells);
                if (line.hasBgColor()) {
                    this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(line.getBgColor());
                }
                if (line.hasTitle()) {
                    this.getRowFormatter().getElement(row).setTitle(line.getTitle());
                }
                if (line.hasStyle()) {
                    TableWidget.applyStyle(this.getRowFormatter().getElement(row).getStyle(), line.getStyle());
                }
                if (!line.hasClassName()) continue;
                this.getRowFormatter().getElement(row).addClassName(line.getClassName());
            }
        }
        if (table.hasErrorMessage()) {
            ArrayList<ErrorWidget> cells2 = new ArrayList<ErrorWidget>();
            cells2.add(new ErrorWidget(table));
            this.addRow(null, cells2);
        }
        if (table.getLines() != null) {
            for (TableInterface.LineInterface line : table.getLines()) {
                if (!line.hasCells()) continue;
                if (line.hasWarning()) {
                    line.getCells().get(0).setWarning(line.getWarning());
                }
                cells = new ArrayList();
                for (final TableInterface.CellInterface cell : line.getCells()) {
                    cells.add(new CellWidget(cell, false));
                }
                row = this.addRow(line, cells);
                if (line.hasBgColor()) {
                    this.getRowFormatter().getElement(row).getStyle().setBackgroundColor(line.getBgColor());
                }
                if (line.hasTitle()) {
                    this.getRowFormatter().getElement(row).setTitle(line.getTitle());
                }
                if (line.hasClassName()) {
                    this.getRowFormatter().getElement(row).addClassName(line.getClassName());
                }
                if (!line.hasStyle()) continue;
                TableWidget.applyStyle(this.getRowFormatter().getElement(row).getStyle(), line.getStyle());
            }
        }
        if (table.hasProperties()) {
            for (TableInterface.PropertyInterface property : table.getProperties()) {
                cells = new ArrayList();
                if (property.getName() == null) {
                    property.getCell().setColSpan(2);
                } else {
                    Label label = new Label(property.getName(), false);
                    cells.add((CellWidget)label);
                }
                CellWidget cell = new CellWidget(property.getCell());
                cells.add(cell);
                TableInterface.LineInterface line = new TableInterface.LineInterface();
                line.addCell(property.getName());
                line.getCells().add(property.getCell());
                int row2 = this.addRow(line, cells);
                if (property.getName() != null) {
                    this.getCellFormatter().getElement(row2, 0).addClassName("label-td");
                    this.getCellFormatter().getElement(row2, 1).addClassName("widget-td");
                    if (!property.hasStyle()) continue;
                    TableWidget.applyStyle(this.getCellFormatter().getElement(row2, 1).getStyle(), property.getStyle());
                    continue;
                }
                this.getCellFormatter().getElement(row2, 0).addClassName("widget-td");
                if (!property.hasStyle()) continue;
                TableWidget.applyStyle(this.getCellFormatter().getElement(row2, 0).getStyle(), property.getStyle());
            }
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortColumn < 0) {
            return;
        }
        for (int col = 0; col < this.getCellCount(0); ++col) {
            String old;
            CellWidget cw = (CellWidget)this.getWidget(0, col);
            if (cw.getElement().getInnerHTML() == null || !(old = cw.getElement().getInnerHTML()).startsWith("\u2193") && !old.startsWith("\u2191")) continue;
            old = old.substring(1);
            cw.getElement().setInnerHTML(old);
        }
        this.sort(null, new Comparator<TableInterface.LineInterface>(){

            @Override
            public int compare(TableInterface.LineInterface l1, TableInterface.LineInterface l2) {
                TableInterface.CellInterface c1 = l1.getCells().get(TableWidget.this.iSortColumn);
                TableInterface.CellInterface c2 = l2.getCells().get(TableWidget.this.iSortColumn);
                Comparable<?> o1 = c1.getComparable();
                Comparable<?> o2 = c2.getComparable();
                if (o1 instanceof String) {
                    return TableInterface.NaturalOrderComparator.compare(o1.toString(), o2.toString());
                }
                return o1.compareTo(o2);
            }
        }, this.iSortAsc);
        CellWidget cw = (CellWidget)this.getWidget(0, this.iSortColumn);
        if (cw.getElement().getInnerHTML() != null) {
            String old = cw.getElement().getInnerHTML();
            cw.getElement().setInnerHTML((this.iSortAsc ? "\u2191" : "\u2193") + old);
        }
        if (this.iNavigationLevel != null) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (int row = 0; row < this.getRowCount(); ++row) {
                TableInterface.LineInterface line = (TableInterface.LineInterface)this.getData(row);
                if (line == null || line.getId() == null) continue;
                ids.add(line.getId());
            }
            if (!ids.isEmpty()) {
                RPC.execute(new TableInterface.NavigationUpdateRequest(this.iNavigationLevel, ids), new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable e) {
                    }

                    public void onSuccess(GwtRpcResponseNull r) {
                    }
                });
            }
        }
    }

    public static native void setLastMouseOverElement(Element var0);

    public static native void executeScript(Element var0, String var1);

    public static class CellWidget
    extends P
    implements UniTimeTable.HasColSpan,
    UniTimeTable.HasRowSpan,
    UniTimeTable.HasCellAlignment,
    UniTimeTable.HasVerticalCellAlignment,
    UniTimeTable.HasStyleName {
        private TableInterface.CellInterface iCell;

        public CellWidget(TableInterface.CellInterface cell) {
            this(cell, false);
        }

        public CellWidget(final TableInterface.CellInterface cell, boolean applyClass) {
            super((Element)(cell.isInline() ? DOM.createSpan() : DOM.createDiv()), new String[0]);
            this.iCell = cell;
            if (cell.hasWarning()) {
                Image warning = new Image(RESOURCES.warning());
                warning.setTitle(cell.getWarning());
                warning.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        UniTimeConfirmationDialog.alert(cell.getWarning());
                        e.preventDefault();
                        e.getNativeEvent().stopPropagation();
                    }
                });
                warning.getElement().getStyle().setPaddingRight(2.0, Style.Unit.PX);
                warning.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.TOP);
                this.add((Widget)warning);
            }
            if (cell.hasText()) {
                if (cell.isHtml()) {
                    if (cell.hasWarning() || cell.isDots()) {
                        p = new P((Element)DOM.createSpan(), new String[0]);
                        ((P)((Object)p)).setHTML(cell.getText());
                        this.add((Widget)p);
                    } else {
                        this.setHTML(cell.getText());
                    }
                } else if (cell.hasWarning() || cell.isDots()) {
                    p = new P((Element)DOM.createSpan(), new String[0]);
                    ((P)((Object)p)).setText(cell.getText());
                    this.add((Widget)p);
                } else {
                    this.setText(cell.getText());
                }
            } else if (!(cell.hasItems() || cell.hasWarning() || cell.hasCourseLink() || cell.getTable() != null || cell.hasScript() || cell.hasWidget() || cell.hasTimePreference())) {
                this.setText("\u202f");
            }
            if (cell.hasTitle()) {
                this.setTitle(cell.getTitle());
            }
            if (cell.hasAnchors()) {
                for (String anchor : cell.getAnchors()) {
                    Anchor a = new Anchor();
                    a.setName(anchor);
                    a.getElement().setId(anchor);
                    this.add((Widget)a);
                }
            }
            if (cell.hasStyle()) {
                TableWidget.applyStyle(this.getElement().getStyle(), cell.getStyle());
            }
            if (applyClass && cell.hasClassName()) {
                this.addStyleName(cell.getClassName());
            }
            if (cell.hasImage()) {
                Image img = new Image(cell.getImage().getSource());
                if (cell.getImage().hasAlt()) {
                    img.setAltText(cell.getImage().getAlt());
                }
                if (cell.getImage().hasTitle()) {
                    img.setTitle(cell.getImage().getTitle());
                }
                if (cell.getImage().hasStyle()) {
                    TableWidget.applyStyle(img.getElement().getStyle(), cell.getImage().getStyle());
                } else {
                    img.getElement().getStyle().setPaddingRight(2.0, Style.Unit.PX);
                    img.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.TOP);
                }
                this.add((Widget)img);
            }
            if (cell.hasColor()) {
                this.getElement().getStyle().setColor(cell.getColor());
            }
            if (cell.isNoWrap()) {
                this.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
            } else if (cell.isWrap()) {
                this.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.PRE_WRAP);
            }
            if (cell.hasMouseOver()) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent e) {
                        TableWidget.setLastMouseOverElement((Element)this.getElement());
                        ToolBox.eval(iCell.getMouseOver());
                    }
                });
            }
            if (cell.hasMouseOut()) {
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent e) {
                        ToolBox.eval(iCell.getMouseOut());
                    }
                });
            }
            if (cell.hasMouseClick()) {
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        TableWidget.setLastMouseOverElement((Element)this.getElement());
                        ToolBox.eval(iCell.getMouseClick());
                    }
                });
            } else if (cell.hasClick()) {
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent e) {
                        final UniTimeDialogBox box = new UniTimeDialogBox(true, true);
                        box.setEscapeToHide(true);
                        CellWidget w = new CellWidget(cell.getClick());
                        box.setWidth("80vw");
                        box.setWidget((Widget)w);
                        box.setText(cell.getClick().getTitle());
                        new Timer(){

                            public void run() {
                                box.center();
                            }
                        }.schedule(200);
                    }
                });
            }
            if (cell.hasTimePreferenceToolTip()) {
                this.addMouseOverHandler(new MouseOverHandler(){

                    public void onMouseOver(MouseOverEvent e) {
                        TimePreferenceWidget w = new TimePreferenceWidget(false, cell.getTimePreferenceToolTip().getPrefLevels(), cell.getTimePreferenceToolTip().isHorizontal());
                        w.setShowLegend(true);
                        w.setModel(cell.getTimePreferenceToolTip());
                        GwtHint.showHint(e.getRelativeElement(), (Widget)w);
                    }
                });
                this.addMouseOutHandler(new MouseOutHandler(){

                    public void onMouseOut(MouseOutEvent e) {
                        GwtHint.hideHint();
                    }
                });
            }
            if (cell.hasIndent()) {
                this.getElement().getStyle().setPaddingLeft((double)cell.getIndent().intValue() * 10.0, Style.Unit.PX);
            }
            if (cell.hasItems()) {
                for (TableInterface.CellInterface item : cell.getItems()) {
                    this.add((Widget)new CellWidget(item, true));
                }
            }
            if (cell.getTable() != null) {
                TableWidget tw = new TableWidget(cell.getTable());
                tw.setStyleName("unitime-InnerTable");
                this.add((Widget)tw);
            }
            if (cell.hasUrl()) {
                this.addStyleName("clickable-cell");
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent evt) {
                        ToolBox.open(GWT.getHostPageBaseURL() + cell.getUrl());
                    }
                });
            }
            if (cell.hasButton()) {
                AriaButton button = new AriaButton(cell.getButton().getText());
                if (cell.getButton().hasTitle()) {
                    button.setTitle(cell.getButton().getTitle());
                }
                this.add((Widget)button);
                button.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent evt) {
                        ToolBox.open(GWT.getHostPageBaseURL() + cell.getButton().getUrl());
                    }
                });
            }
            if (cell.hasCourseLink()) {
                this.add((Widget)new CourseDetailsWidget(cell.getCourseLink().isAnchor()).forCourseId(cell.getCourseLink().getCourseId()));
            }
            if (cell.hasWidget()) {
                if ("UniTimeGWT:InstructorAvailability".equals(cell.getWidget().getId())) {
                    this.add((Widget)new InstructorAvailabilityWidget().forPattern(cell.getWidget().getContent()));
                } else if ("UniTimeGWT:InstructorUnavailability".equals(cell.getWidget().getId())) {
                    this.add((Widget)new SessionDatesSelector().forPattern(cell.getWidget().getContent()));
                } else if ("UniTimeGWT:DatePattern".equals(cell.getWidget().getId())) {
                    this.add((Widget)new SessionDatesSelector().forPattern(cell.getWidget().getContent()));
                }
            }
            if (cell.hasScript()) {
                com.google.gwt.user.client.Element element = this.getElement();
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){
                    final /* synthetic */ Element val$element;
                    final /* synthetic */ TableInterface.CellInterface val$cell;
                    {
                        this.val$element = element;
                        this.val$cell = cellInterface;
                    }

                    public void execute() {
                        TableWidget.executeScript(this.val$element, this.val$cell.getScript());
                    }
                });
            }
            if (cell.isDots()) {
                for (int i = 0; i < this.getWidgetCount(); ++i) {
                    this.getWidget(i).setVisible(i == 0);
                }
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent arg0) {
                        for (int i = 0; i < this.getWidgetCount(); ++i) {
                            this.getWidget(i).setVisible(i != 0);
                        }
                    }
                });
                this.getWidget(0).addStyleName("link");
            }
            if (cell.hasTimePreference()) {
                TimePreferenceWidget w = new TimePreferenceWidget(false, cell.getTimePreference().getPrefLevels(), cell.getTimePreference().isHorizontal());
                w.setShowLegend(false);
                w.setModel(cell.getTimePreference());
                this.add((Widget)w);
            }
        }

        public static native void populate();

        @Override
        public int getColSpan() {
            return this.iCell.getColSpan();
        }

        @Override
        public int getRowSpan() {
            return this.iCell.getRowSpan();
        }

        @Override
        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment() {
            switch (this.iCell.getHorizontalAlignment()) {
                case TOP: {
                    return HasVerticalAlignment.ALIGN_TOP;
                }
                case MIDLE: {
                    return HasVerticalAlignment.ALIGN_MIDDLE;
                }
                case BOTTOM: {
                    return HasVerticalAlignment.ALIGN_BOTTOM;
                }
            }
            return null;
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            switch (this.iCell.getTextAlignment()) {
                case LEFT: {
                    return HasHorizontalAlignment.ALIGN_LEFT;
                }
                case CENTER: {
                    return HasHorizontalAlignment.ALIGN_CENTER;
                }
                case RIGHT: {
                    return HasHorizontalAlignment.ALIGN_RIGHT;
                }
            }
            return null;
        }

        @Override
        public String getStyleName() {
            return this.iCell.getClassName();
        }
    }

    public static class ErrorWidget
    extends P
    implements UniTimeTable.HasColSpan {
        private TableInterface iTable;

        ErrorWidget(TableInterface table) {
            super("unitime-ErrorMessage");
            this.setText(table.getErrorMessage());
            this.iTable = table;
        }

        @Override
        public int getColSpan() {
            int cols = this.iTable.getMaxColumns();
            return cols <= 0 ? 1 : cols;
        }
    }
}

