/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.solver.suggestions;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.TimeHint;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.solver.DataTable;
import org.unitime.timetable.gwt.client.solver.SolverCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class SuggestionsTable
extends UniTimeTable<SuggestionsInterface.Suggestion>
implements TakesValue<Collection<SuggestionsInterface.Suggestion>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    public static NumberFormat sDF = NumberFormat.getFormat((String)"0.###");
    private SuggestionsInterface.SuggestionProperties iProperties;
    private boolean iSuggestions;
    private SuggestionColumn iSortBy = null;
    private boolean iAsc = true;

    public SuggestionsTable(SuggestionsInterface.SuggestionProperties properties, boolean suggestions) {
        this.addStyleName("unitime-ClassAssignmentTable");
        this.addStyleName("unitime-ClassAssignmentTableSuggestions");
        this.iProperties = properties;
        this.iSuggestions = suggestions;
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final SuggestionColumn column : SuggestionColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final SuggestionColumn column : SuggestionColumn.values()) {
            if (!SuggestionsComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    SuggestionsTable.this.doSort(column);
                }

                @Override
                public boolean isApplicable() {
                    return SuggestionsTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(this.iSuggestions ? SolverCookie.getInstance().getSuggestionsSort() : SolverCookie.getInstance().getPlacementsSort());
    }

    protected void doSort(SuggestionColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        if (this.iSuggestions) {
            SolverCookie.getInstance().setSuggestionsSort(this.getSortBy());
        } else {
            SolverCookie.getInstance().setPlacementsSort(this.getSortBy());
        }
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = SuggestionColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = SuggestionColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = SuggestionColumn.SCORE;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new SuggestionsComparator(this.iProperties.getFirstDay(), this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(SuggestionColumn column) {
        switch (column) {
            default: 
        }
        return 1;
    }

    public String getColumnName(SuggestionColumn column, int idx) {
        switch (column) {
            case SCORE: {
                return MESSAGES.colScore();
            }
            case CLASS: {
                return MESSAGES.colClass();
            }
            case DATE: {
                return MESSAGES.colDate();
            }
            case TIME: {
                return MESSAGES.colTime();
            }
            case ROOM: {
                return MESSAGES.colRoom();
            }
            case STUDENTS: {
                return MESSAGES.colStudents();
            }
            case OBJECTIVES: {
                return MESSAGES.colObjectives();
            }
        }
        return column.name();
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(SuggestionColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(SuggestionColumn column) {
        int ret = 0;
        for (SuggestionColumn c : SuggestionColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCellLine(SuggestionsInterface.ClassAssignmentDetails details, boolean conflict, SuggestionColumn column, int idx) {
        switch (column) {
            case CLASS: {
                P classLabel = new P("label");
                classLabel.setText(details.getClazz().getName());
                if (details.getClazz().getPref() != null) {
                    classLabel.getElement().getStyle().setColor(this.iProperties.getPreference(details.getClazz().getPref()).getColor());
                }
                return classLabel;
            }
            case DATE: {
                P date = new P("date");
                if (details.getTime() != null) {
                    P current = new P("old");
                    current.setText(details.getTime().getDatePatternName());
                    if (details.getTime().getDatePatternPreference() != 0) {
                        current.getElement().getStyle().setColor(this.iProperties.getPreference(details.getTime().getDatePatternPreference()).getColor());
                    }
                    if (details.getTime().isStriked()) {
                        current.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                    }
                    date.add((Widget)current);
                    if (details.getAssignedTime() != null && !details.getAssignedTime().getDatePatternName().equals(details.getTime().getDatePatternName())) {
                        P arrow = new P("arrow");
                        arrow.setHTML(MESSAGES.assignmentArrow());
                        date.add((Widget)arrow);
                        P other = new P("new");
                        other.setText(details.getAssignedTime().getDatePatternName());
                        if (details.getAssignedTime().getDatePatternPreference() != 0) {
                            other.getElement().getStyle().setColor(this.iProperties.getPreference(details.getAssignedTime().getDatePatternPreference()).getColor());
                        }
                        if (details.getAssignedTime().isStriked()) {
                            other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                        }
                        date.add((Widget)other);
                    }
                } else if (details.getAssignedTime() != null) {
                    P other = new P("new");
                    other.setText(details.getAssignedTime().getDatePatternName());
                    if (details.getAssignedTime().getDatePatternPreference() != 0) {
                        other.getElement().getStyle().setColor(this.iProperties.getPreference(details.getAssignedTime().getDatePatternPreference()).getColor());
                    }
                    if (details.getAssignedTime().isStriked()) {
                        other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                    }
                    date.add((Widget)other);
                }
                return date;
            }
            case TIME: {
                P time = new P("time");
                if (details.getTime() != null) {
                    final P current = new P("old");
                    current.setText(details.getTime().getName(this.iProperties.getFirstDay(), false, CONSTANTS));
                    if (details.getTime().getPref() != 0) {
                        current.getElement().getStyle().setColor(this.iProperties.getPreference(details.getTime().getPref()).getColor());
                    }
                    if (details.getTime().isStriked()) {
                        current.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                    }
                    final String timeHint = details.getClazz().getClassId() + "," + details.getTime().getDays() + "," + details.getTime().getStartSlot();
                    current.addMouseOverHandler(new MouseOverHandler(){

                        public void onMouseOver(MouseOverEvent e) {
                            TimeHint.showHint((Element)current.getElement(), timeHint);
                        }
                    });
                    current.addMouseOutHandler(new MouseOutHandler(){

                        public void onMouseOut(MouseOutEvent e) {
                            TimeHint.hideHint();
                        }
                    });
                    time.add((Widget)current);
                    if (details.getAssignedTime() == null) {
                        P arrow = new P("arrow");
                        arrow.setHTML(MESSAGES.assignmentArrow());
                        time.add((Widget)arrow);
                        P notAssigned = new P("not-assigned");
                        notAssigned.setText(MESSAGES.unassignment());
                        time.add((Widget)notAssigned);
                    } else if (details.getAssignedTime().getStartSlot() != details.getTime().getStartSlot() || details.getAssignedTime().getDays() != details.getTime().getDays() || !details.getAssignedTime().getPatternId().equals(details.getTime().getPatternId())) {
                        P arrow = new P("arrow");
                        arrow.setHTML(MESSAGES.assignmentArrow());
                        time.add((Widget)arrow);
                        final P other = new P("new");
                        other.setText(details.getAssignedTime().getName(this.iProperties.getFirstDay(), false, CONSTANTS));
                        if (details.getAssignedTime().getPref() != 0) {
                            other.getElement().getStyle().setColor(this.iProperties.getPreference(details.getAssignedTime().getPref()).getColor());
                        }
                        if (details.getAssignedTime().isStriked()) {
                            other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                        }
                        final String otherTimeHint = details.getClazz().getClassId() + "," + details.getAssignedTime().getDays() + "," + details.getAssignedTime().getStartSlot();
                        other.addMouseOverHandler(new MouseOverHandler(){

                            public void onMouseOver(MouseOverEvent e) {
                                TimeHint.showHint((Element)other.getElement(), otherTimeHint);
                            }
                        });
                        other.addMouseOutHandler(new MouseOutHandler(){

                            public void onMouseOut(MouseOutEvent e) {
                                TimeHint.hideHint();
                            }
                        });
                        time.add((Widget)other);
                    }
                } else if (details.getAssignedTime() != null) {
                    final P other = new P("new");
                    other.setText(details.getAssignedTime().getName(this.iProperties.getFirstDay(), false, CONSTANTS));
                    if (details.getAssignedTime().getPref() != 0) {
                        other.getElement().getStyle().setColor(this.iProperties.getPreference(details.getAssignedTime().getPref()).getColor());
                    }
                    if (details.getAssignedTime().isStriked()) {
                        other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                    }
                    final String otherTimeHint = details.getClazz().getClassId() + "," + details.getAssignedTime().getDays() + "," + details.getAssignedTime().getStartSlot();
                    other.addMouseOverHandler(new MouseOverHandler(){

                        public void onMouseOver(MouseOverEvent e) {
                            TimeHint.showHint((Element)other.getElement(), otherTimeHint);
                        }
                    });
                    other.addMouseOutHandler(new MouseOutHandler(){

                        public void onMouseOut(MouseOutEvent e) {
                            TimeHint.hideHint();
                        }
                    });
                    time.add((Widget)other);
                }
                return time;
            }
            case ROOM: {
                P rooms = new P("rooms");
                if (details.getRoom() != null) {
                    for (int i = 0; i < details.getRoom().size(); ++i) {
                        final SuggestionsInterface.RoomInfo r = details.getRoom().get(i);
                        P room = new P("room");
                        final P current = new P("old");
                        current.setText(r.getName());
                        if (r.getPref() != 0) {
                            current.getElement().getStyle().setColor(this.iProperties.getPreference(r.getPref()).getColor());
                        }
                        if (r.isStriked()) {
                            current.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                        }
                        if (r.getId() != null) {
                            current.addMouseOverHandler(new MouseOverHandler(){

                                public void onMouseOver(MouseOverEvent e) {
                                    RoomHint.showHint((Element)current.getElement(), r.getId(), null, null, true);
                                }
                            });
                            current.addMouseOutHandler(new MouseOutHandler(){

                                public void onMouseOut(MouseOutEvent e) {
                                    RoomHint.hideHint();
                                }
                            });
                        }
                        room.add((Widget)current);
                        if (details.getAssignedRoom() != null && i < details.getAssignedRoom().size()) {
                            final SuggestionsInterface.RoomInfo q = details.getAssignedRoom().get(i);
                            if (!q.getId().equals(r.getId())) {
                                P arrow = new P("arrow");
                                arrow.setHTML(MESSAGES.assignmentArrow());
                                room.add((Widget)arrow);
                                final P other = new P("new");
                                other.setText(q.getName());
                                if (q.getPref() != 0) {
                                    other.getElement().getStyle().setColor(this.iProperties.getPreference(q.getPref()).getColor());
                                }
                                if (q.isStriked()) {
                                    other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                                }
                                if (q.getId() != null) {
                                    other.addMouseOverHandler(new MouseOverHandler(){

                                        public void onMouseOver(MouseOverEvent e) {
                                            RoomHint.showHint((Element)other.getElement(), q.getId(), null, null, true);
                                        }
                                    });
                                    other.addMouseOutHandler(new MouseOutHandler(){

                                        public void onMouseOut(MouseOutEvent e) {
                                            RoomHint.hideHint();
                                        }
                                    });
                                }
                                room.add((Widget)other);
                            }
                        } else {
                            P arrow = new P("arrow");
                            arrow.setHTML(MESSAGES.assignmentArrow());
                            room.add((Widget)arrow);
                            P notAssigned = new P("not-assigned");
                            notAssigned.setText(MESSAGES.unassignment());
                            room.add((Widget)notAssigned);
                        }
                        if (i + 1 < details.getRoom().size()) {
                            P separator = new P("separator");
                            separator.setText(CONSTANTS.itemSeparator());
                            rooms.add((Widget)separator);
                            room.add((Widget)separator);
                        }
                        rooms.add((Widget)room);
                    }
                } else if (details.getAssignedRoom() != null) {
                    for (int i = 0; i < details.getAssignedRoom().size(); ++i) {
                        final SuggestionsInterface.RoomInfo q = details.getAssignedRoom().get(i);
                        P room = new P("room");
                        final P other = new P("new");
                        other.setText(q.getName());
                        if (q.getPref() != 0) {
                            other.getElement().getStyle().setColor(this.iProperties.getPreference(q.getPref()).getColor());
                        }
                        if (q.isStriked()) {
                            other.getElement().getStyle().setTextDecoration(Style.TextDecoration.LINE_THROUGH);
                        }
                        if (q.getId() != null) {
                            other.addMouseOverHandler(new MouseOverHandler(){

                                public void onMouseOver(MouseOverEvent e) {
                                    RoomHint.showHint((Element)other.getElement(), q.getId(), null, null, true);
                                }
                            });
                            other.addMouseOutHandler(new MouseOutHandler(){

                                public void onMouseOut(MouseOutEvent e) {
                                    RoomHint.hideHint();
                                }
                            });
                        }
                        room.add((Widget)other);
                        if (i + 1 < details.getAssignedRoom().size()) {
                            P separator = new P("separator");
                            separator.setText(CONSTANTS.itemSeparator());
                            rooms.add((Widget)separator);
                            room.add((Widget)separator);
                        }
                        rooms.add((Widget)room);
                    }
                }
                return rooms;
            }
        }
        return null;
    }

    protected Widget getCell(SuggestionsInterface.Suggestion suggestion, SuggestionColumn column, int idx) {
        switch (column) {
            case SCORE: {
                return new HTML(SuggestionsTable.dispNumber(suggestion.getValue() - suggestion.getBaseValue()));
            }
            case CLASS: {
                P classes = new P("classes");
                if (suggestion.hasDifferentAssignments()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getDifferentAssignments()) {
                        classes.add(this.getCellLine(details, false, column, idx));
                    }
                }
                if (suggestion.hasUnresolvedConflicts()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getUnresolvedConflicts()) {
                        classes.add(this.getCellLine(details, true, column, idx));
                    }
                }
                return classes;
            }
            case DATE: {
                P dates = new P("dates");
                if (suggestion.hasDifferentAssignments()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getDifferentAssignments()) {
                        dates.add(this.getCellLine(details, false, column, idx));
                    }
                }
                if (suggestion.hasUnresolvedConflicts()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getUnresolvedConflicts()) {
                        dates.add(this.getCellLine(details, true, column, idx));
                    }
                }
                return dates;
            }
            case TIME: {
                P times = new P("times");
                if (suggestion.hasDifferentAssignments()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getDifferentAssignments()) {
                        times.add(this.getCellLine(details, false, column, idx));
                    }
                }
                if (suggestion.hasUnresolvedConflicts()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getUnresolvedConflicts()) {
                        times.add(this.getCellLine(details, true, column, idx));
                    }
                }
                return times;
            }
            case ROOM: {
                P rooms = new P("rooms");
                if (suggestion.hasDifferentAssignments()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getDifferentAssignments()) {
                        rooms.add(this.getCellLine(details, false, column, idx));
                    }
                }
                if (suggestion.hasUnresolvedConflicts()) {
                    for (SuggestionsInterface.ClassAssignmentDetails details : suggestion.getUnresolvedConflicts()) {
                        rooms.add(this.getCellLine(details, true, column, idx));
                    }
                }
                return rooms;
            }
            case STUDENTS: {
                return suggestion.hasStudentConflictSummary() ? new DataTable.DataTableCell(null, suggestion.getStudentConflictSummary()) : null;
            }
            case OBJECTIVES: {
                return new Objectives(suggestion);
            }
        }
        return null;
    }

    public int addRow(SuggestionsInterface.Suggestion suggestion) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (SuggestionColumn column : SuggestionColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(suggestion, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        int row = this.addRow(suggestion, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    public static String dispNumber(int number) {
        return SuggestionsTable.dispNumber("", number);
    }

    public static String dispNumber(String prefix, int number) {
        if (number > 0) {
            return "<font color='red'>" + prefix + "+" + number + "</font>";
        }
        if (number < 0) {
            return "<font color='green'>" + prefix + number + "</font>";
        }
        return prefix + "0";
    }

    public static String dispNumberShort(boolean rem, int n1, int n2) {
        if (n1 == 0 && n2 == 0) {
            return "";
        }
        if (rem) {
            return SuggestionsTable.dispNumber(-n1);
        }
        int dif = n2 - n1;
        if (dif == 0) {
            return n1 + "&rarr;" + n2;
        }
        if (dif < 0) {
            return "<font color='green'>" + n1 + "&rarr;" + n2 + "</font>";
        }
        return "<font color='red'>" + n1 + "&rarr;" + n2 + "</font>";
    }

    public static String dispNumber(String prefix, double number) {
        if (number > 0.0) {
            return "<font color='red'>" + prefix + "+" + sDF.format(number) + "</font>";
        }
        if (number < 0.0) {
            return "<font color='green'>" + prefix + sDF.format(number) + "</font>";
        }
        return prefix + "0";
    }

    public static String dispNumberShort(boolean rem, double n1, double n2) {
        return SuggestionsTable.dispNumberShort(rem, "", n1, n2);
    }

    public static String dispNumberShort(boolean rem, String prefix, double n1, double n2) {
        if (n1 == 0.0 && n2 == 0.0) {
            return "";
        }
        if (rem) {
            return SuggestionsTable.dispNumber(prefix, -n1);
        }
        double dif = n2 - n1;
        if (dif == 0.0) {
            return prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2);
        }
        if (dif < 0.0) {
            return "<font color='green'>" + prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2) + "</font>";
        }
        return "<font color='red'>" + prefix + sDF.format(n1) + "&rarr;" + sDF.format(n2) + "</font>";
    }

    public static String dispNumber(int n1, int n2) {
        return SuggestionsTable.dispNumber(n1 - n2);
    }

    public static String dispNumber(double n1, double n2) {
        return SuggestionsTable.dispNumber(n1 - n2);
    }

    public static String dispNumber(double number) {
        return SuggestionsTable.dispNumber("", number);
    }

    public Collection<SuggestionsInterface.Suggestion> getValue() {
        return this.getData();
    }

    public void setValue(Collection<SuggestionsInterface.Suggestion> value) {
        this.clearTable(1);
        if (value != null) {
            for (SuggestionsInterface.Suggestion suggestion : value) {
                this.addRow(suggestion);
            }
        }
        this.sort();
    }

    public static enum SuggestionColumn {
        SCORE,
        CLASS,
        DATE,
        TIME,
        ROOM,
        STUDENTS,
        OBJECTIVES;

    }

    public static class SuggestionsComparator
    implements Comparator<SuggestionsInterface.Suggestion> {
        private Integer iFirstDay;
        private SuggestionColumn iColumn;
        private boolean iAsc;

        public SuggestionsComparator(Integer firstDay, SuggestionColumn column, boolean asc) {
            this.iFirstDay = firstDay;
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareById(SuggestionsInterface.ClassAssignmentDetails c1, SuggestionsInterface.ClassAssignmentDetails c2) {
            return this.compare(c1.getClazz().getClassId(), c2.getClazz().getClassId());
        }

        public int compareByName(SuggestionsInterface.ClassAssignmentDetails c1, SuggestionsInterface.ClassAssignmentDetails c2) {
            return c1.getClazz().compareTo(c2.getClazz());
        }

        public int compareByDate(SuggestionsInterface.TimeInfo t1, SuggestionsInterface.TimeInfo t2) {
            return this.compare(t1 == null ? null : t1.getDatePatternName(), t2 == null ? null : t2.getDatePatternName());
        }

        public int compareByTime(SuggestionsInterface.TimeInfo t1, SuggestionsInterface.TimeInfo t2) {
            int cmp = this.compare(t1 == null ? null : Integer.valueOf(t1.getDaysOrder(this.iFirstDay)), t2 == null ? null : Integer.valueOf(t2.getDaysOrder(this.iFirstDay)));
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.compare(t1 == null ? null : Integer.valueOf(t1.getStartSlot()), t2 == null ? null : Integer.valueOf(t2.getStartSlot()));
            if (cmp != 0) {
                return cmp;
            }
            return this.compare(t1 == null ? null : t1.getName(this.iFirstDay, false, CONSTANTS), t2 == null ? null : t2.getName(this.iFirstDay, false, CONSTANTS));
        }

        public int compareByRoom(List<SuggestionsInterface.RoomInfo> r1, List<SuggestionsInterface.RoomInfo> r2) {
            int c2;
            int c1 = r1 == null ? 0 : r1.size();
            int n = c2 = r2 == null ? 0 : r2.size();
            if (c1 != c2) {
                return c1 < c2 ? -1 : 1;
            }
            for (int i = 0; i < c1; ++i) {
                int cmp = this.compare(r1.get(i).getName(), r2.get(i).getName());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }

        public int compareByCell(TableInterface.TableCellInterface c1, TableInterface.TableCellInterface c2) {
            if (c1 == null) {
                return c2 == null ? 0 : -1;
            }
            if (c2 == null) {
                return 1;
            }
            return c1.compareTo(c2);
        }

        protected int compareByColumn(SuggestionsInterface.ClassAssignmentDetails c1, SuggestionsInterface.ClassAssignmentDetails c2) {
            switch (this.iColumn) {
                case CLASS: {
                    return this.compareByName(c1, c2);
                }
                case DATE: {
                    return this.compareByDate(c1.getAssignedTime() == null ? c1.getTime() : c1.getAssignedTime(), c2.getAssignedTime() == null ? c2.getTime() : c2.getAssignedTime());
                }
                case TIME: {
                    return this.compareByTime(c1.getAssignedTime() == null ? c1.getTime() : c1.getAssignedTime(), c2.getAssignedTime() == null ? c2.getTime() : c2.getAssignedTime());
                }
                case ROOM: {
                    return this.compareByRoom(c1.getAssignedRoom() == null ? c1.getRoom() : c1.getAssignedRoom(), c2.getAssignedRoom() == null ? c2.getRoom() : c2.getAssignedRoom());
                }
            }
            return this.compareByName(c1, c2);
        }

        protected int compareByColumns(List<SuggestionsInterface.ClassAssignmentDetails> l1, List<SuggestionsInterface.ClassAssignmentDetails> l2) {
            if (l1 == null) {
                return l2 == null ? 0 : -1;
            }
            if (l2 == null) {
                return 1;
            }
            Iterator<SuggestionsInterface.ClassAssignmentDetails> i1 = l1.iterator();
            Iterator<SuggestionsInterface.ClassAssignmentDetails> i2 = l2.iterator();
            if (i1.hasNext() && i2.hasNext()) {
                return this.compareByColumn(i1.next(), i2.next());
            }
            return i1.hasNext() ? 1 : -1;
        }

        public int compareByScore(SuggestionsInterface.Suggestion s1, SuggestionsInterface.Suggestion s2) {
            return Double.compare(s1.getValue(), s2.getValue());
        }

        public static boolean isApplicable(SuggestionColumn column) {
            switch (column) {
                case SCORE: 
                case CLASS: 
                case DATE: 
                case TIME: 
                case ROOM: 
                case STUDENTS: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(SuggestionsInterface.Suggestion s1, SuggestionsInterface.Suggestion s2) {
            int cmp;
            if (this.iColumn == SuggestionColumn.SCORE && (cmp = this.compareByScore(s1, s2)) != 0) {
                return this.iAsc ? cmp : -cmp;
            }
            if (this.iColumn == SuggestionColumn.STUDENTS) {
                cmp = this.compareByCell(s1.getStudentConflictSummary(), s2.getStudentConflictSummary());
                if (cmp != 0) {
                    return this.iAsc ? cmp : -cmp;
                }
                cmp = this.compareByScore(s1, s2);
                if (cmp != 0) {
                    return this.iAsc ? cmp : -cmp;
                }
            }
            if ((cmp = this.compareByColumns(s1.getDifferentAssignments(), s2.getDifferentAssignments())) == 0) {
                cmp = this.compareByColumns(s1.getUnresolvedConflicts(), s2.getUnresolvedConflicts());
            }
            if (cmp == 0) {
                cmp = s1.compareTo(s2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }
    }

    protected static class Objectives
    extends P
    implements UniTimeTable.HasVerticalCellAlignment {
        Objectives(SuggestionsInterface.Suggestion suggestion) {
            super("objectives");
            if (suggestion.getCriteria() != null) {
                for (String criterion : new TreeSet<String>(suggestion.getCriteria().keySet())) {
                    double base;
                    double value = suggestion.getCriterion(criterion);
                    if (!(Math.abs(value - (base = suggestion.getBaseCriterion(criterion))) >= 0.001)) continue;
                    P obj = new P("objective");
                    obj.setHTML(criterion + ": " + SuggestionsTable.dispNumber(value, base));
                    this.add((Widget)obj);
                }
            }
        }

        @Override
        public HasVerticalAlignment.VerticalAlignmentConstant getVerticalCellAlignment() {
            return HasVerticalAlignment.ALIGN_MIDDLE;
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }
}

