/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.unitime.timetable.gwt.client.aria.AriaSuggestArea;
import org.unitime.timetable.gwt.client.aria.AriaSuggestBox;
import org.unitime.timetable.gwt.client.aria.AriaTextArea;
import org.unitime.timetable.gwt.client.aria.AriaTextBox;
import org.unitime.timetable.gwt.client.events.SingleDateSelector;
import org.unitime.timetable.gwt.client.sectioning.ScheduleStatus;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class RequestVariableTitleCourseDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtMessages GWT_MSG = (GwtMessages)GWT.create(GwtMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    protected static Logger sLogger = Logger.getLogger(RequestVariableTitleCourseDialog.class.getName());
    private ScheduleStatus iStatus;
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private SpecialRegistrationInterface.VariableTitleCourseInfo iSelectedCourse;
    private SimpleForm iForm;
    private HTML iCourseDetails;
    private int iCourseDetailsLine;
    private AriaTextArea iNote = null;
    private AriaTextBox iCourseName = null;
    private UniTimeWidget<AriaTextBox> iCourseTitle = null;
    private ListBox iCredit;
    private AriaSuggestBox iCourseSuggestBox = null;
    private UniTimeWidget<ListBox> iInstructor;
    private ListBox iGradeMode;
    private SingleDateSelector iDateFrom;
    private SingleDateSelector iDateTo;
    private CheckBox iDisclaimer;
    private int iDisclaimerLine;
    private Timer iTimer;
    private Float iCurrentCredit;
    private Float iMaxCredit;
    private Label iCreditMessage;
    private int iCreditLine;
    private List<String> iSuggestions = new ArrayList<String>();
    private UniTimeHeaderPanel iButtons;

    public RequestVariableTitleCourseDialog(OnlineSectioningInterface.StudentSectioningContext context, ScheduleStatus status) {
        super(true, true);
        this.addStyleName("unitime-RequestVariableTitleCourseDialog");
        this.setText(MESSAGES.dialogRequestVariableTitleCourse());
        this.iContext = context;
        this.iStatus = status;
        this.iForm = new SimpleForm();
        this.iCourseName = new AriaTextBox();
        this.iCourseName.getElement().setAttribute("autocomplete", "off");
        this.iCourseSuggestBox = new AriaSuggestBox(this.iCourseName, new VariableTitleCourseSuggestions());
        this.iTimer = new Timer(){

            public void run() {
                RequestVariableTitleCourseDialog.this.onCourseChanged(RequestVariableTitleCourseDialog.this.iCourseName.getText());
            }
        };
        this.iCourseSuggestBox.addValueChangeHandler(new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                RequestVariableTitleCourseDialog.this.iTimer.schedule(500);
            }
        });
        this.iCourseSuggestBox.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                RequestVariableTitleCourseDialog.this.iTimer.cancel();
                if (event.getSelectedItem() instanceof SpecialRegistrationInterface.VariableTitleCourseInfo) {
                    RequestVariableTitleCourseDialog.this.onCourseChanged(((SpecialRegistrationInterface.VariableTitleCourseInfo)event.getSelectedItem()).getCourseName());
                } else {
                    RequestVariableTitleCourseDialog.this.setCourse(null);
                }
            }
        });
        this.iCourseSuggestBox.addStyleName("course");
        this.iForm.addRow(MESSAGES.propReqVTCourseCourse(), (Widget)this.iCourseSuggestBox);
        this.iCourseDetails = new HTML();
        this.iCourseDetails.addStyleName("details");
        this.iCourseDetailsLine = this.iForm.addRow(MESSAGES.propReqVTCourseDetails(), (Widget)this.iCourseDetails);
        this.iForm.getRowFormatter().setVisible(this.iCourseDetailsLine, false);
        this.iCourseTitle = new UniTimeWidget<AriaTextBox>(new AriaTextBox());
        this.iCourseTitle.getWidget().setStyleName("unitime-TextBox");
        this.iCourseTitle.getWidget().addStyleName("title");
        this.iCourseTitle.getWidget().setMaxLength(30);
        this.iCourseTitle.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RequestVariableTitleCourseDialog.this.iCourseTitle.clearHint();
                RequestVariableTitleCourseDialog.this.iButtons.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propReqVTCourseTitle(), (Widget)this.iCourseTitle);
        this.iCredit = new ListBox();
        this.iCredit.addStyleName("credit");
        this.iCredit.setEnabled(false);
        this.iForm.addRow(MESSAGES.propReqVTCourseCredit(), (Widget)this.iCredit);
        this.iCredit.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RequestVariableTitleCourseDialog.this.checkCredit();
            }
        });
        this.iInstructor = new UniTimeWidget<ListBox>(new ListBox());
        this.iInstructor.getWidget().addStyleName("instructor");
        this.iInstructor.getWidget().setEnabled(false);
        this.iForm.addRow(MESSAGES.propReqVTCourseInstructor(), (Widget)this.iInstructor);
        this.iInstructor.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if ("-".equals(RequestVariableTitleCourseDialog.this.iInstructor.getWidget().getSelectedValue())) {
                    RequestVariableTitleCourseDialog.this.iInstructor.setHint(MESSAGES.hintReqVTCourseNoInstructorMatch());
                } else {
                    RequestVariableTitleCourseDialog.this.iInstructor.clearHint();
                }
            }
        });
        this.iGradeMode = new ListBox();
        this.iGradeMode.addStyleName("grade-mode");
        this.iGradeMode.setEnabled(false);
        this.iForm.addRow(MESSAGES.propReqVTCourseGradeMode(), (Widget)this.iGradeMode);
        AbsolutePanel m = new AbsolutePanel();
        m.setStyleName("dates");
        P from = new P("from");
        from.setText(MESSAGES.propReqVTCourseDatesFrom());
        m.add((Widget)from);
        this.iDateFrom = new SingleDateSelector();
        m.add((Widget)this.iDateFrom);
        P to = new P("to");
        to.setText(MESSAGES.propReqVTCourseDatesTo());
        m.add((Widget)to);
        this.iDateTo = new SingleDateSelector();
        m.add((Widget)this.iDateTo);
        this.iForm.addRow(MESSAGES.propReqVTCourseDates(), (Widget)m);
        this.iDateFrom.setEnabled(false);
        this.iDateTo.setEnabled(false);
        this.iNote = new AriaTextArea();
        this.iNote.setStyleName("unitime-TextArea");
        this.iNote.addStyleName("request-note");
        this.iNote.setVisibleLines(5);
        this.iNote.setCharacterWidth(80);
        AriaSuggestArea noteWithSuggestions = new AriaSuggestArea(this.iNote, this.iSuggestions);
        this.iForm.addRow(MESSAGES.propReqVTCourseNote(), (Widget)noteWithSuggestions);
        noteWithSuggestions.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                String text = RequestVariableTitleCourseDialog.this.iNote.getText();
                if (text.indexOf(60) >= 0 && text.indexOf(62) > text.indexOf(60)) {
                    RequestVariableTitleCourseDialog.this.iNote.setSelectionRange(text.indexOf(60), text.indexOf(62) - text.indexOf(60) + 1);
                }
            }
        });
        this.iDisclaimer = new CheckBox();
        this.iDisclaimer.addStyleName("disclaimer");
        this.iDisclaimer.setValue(Boolean.valueOf(false));
        this.iDisclaimer.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RequestVariableTitleCourseDialog.this.iButtons.setEnabled("submit", RequestVariableTitleCourseDialog.this.iDisclaimer.isEnabled() && RequestVariableTitleCourseDialog.this.iDisclaimer.getValue() != false);
            }
        });
        this.iDisclaimerLine = this.iForm.addRow(MESSAGES.propReqVTCourseDisclaimer(), (Widget)this.iDisclaimer);
        this.iForm.getRowFormatter().setVisible(this.iDisclaimerLine, false);
        this.iCreditMessage = new Label();
        this.iCreditMessage.addStyleName("credit");
        this.iCreditLine = this.iForm.addRow(MESSAGES.propReqVTMaxCredit(), (Widget)this.iCreditMessage);
        this.iForm.getRowFormatter().setVisible(this.iCreditLine, false);
        this.iButtons = new UniTimeHeaderPanel();
        this.iButtons.addButton("submit", MESSAGES.buttonSubmitVariableTitleCourse(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (RequestVariableTitleCourseDialog.this.validate()) {
                    RequestVariableTitleCourseDialog.this.hide();
                    RequestVariableTitleCourseDialog.this.onSubmit();
                }
            }
        });
        this.iButtons.addButton("cancel", MESSAGES.buttonCloseVariableTitleCourse(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                RequestVariableTitleCourseDialog.this.hide();
            }
        });
        this.iButtons.setEnabled("submit", false);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.setWidget((Widget)this.iForm);
    }

    public void requestVariableTitleCourse(Float currentCredit, Float maxCredit) {
        this.iCourseName.setText("");
        this.iCourseTitle.getWidget().setText("");
        this.iDisclaimer.setValue(Boolean.valueOf(false));
        this.iNote.setText("");
        this.iCredit.clear();
        this.iInstructor.getWidget().clear();
        this.iInstructor.clearHint();
        this.iGradeMode.clear();
        this.iDateFrom.setValueInServerTimeZone(null);
        this.iDateTo.setValueInServerTimeZone(null);
        this.setCourse(null);
        this.iCurrentCredit = currentCredit;
        this.iMaxCredit = maxCredit;
        this.center();
        this.iCourseName.setFocus(true);
        sLogger.fine("Current credit: " + currentCredit + " of " + maxCredit);
    }

    protected void onCourseChanged(String course) {
        if (course == null || course.isEmpty()) {
            this.setCourse(null);
        } else {
            if (this.iSelectedCourse != null && (this.iSelectedCourse.getCourseName().equalsIgnoreCase(course) || this.iSelectedCourse.getReplacementString().equalsIgnoreCase(course))) {
                return;
            }
            this.iSectioningService.getVariableTitleCourse(this.iContext, course, new AsyncCallback<SpecialRegistrationInterface.VariableTitleCourseInfo>(){

                public void onFailure(Throwable caught) {
                    RequestVariableTitleCourseDialog.this.iStatus.error(MESSAGES.exceptionGetVariableTitleCourseInfo(caught.getMessage()));
                }

                public void onSuccess(SpecialRegistrationInterface.VariableTitleCourseInfo result) {
                    if (result != null && result.equals(RequestVariableTitleCourseDialog.this.iSelectedCourse)) {
                        return;
                    }
                    RequestVariableTitleCourseDialog.this.setCourse(result);
                }
            });
        }
    }

    protected void setCourse(SpecialRegistrationInterface.VariableTitleCourseInfo course) {
        this.iSelectedCourse = course;
        String lastCredit = this.iCredit.getSelectedValue();
        String lastInstructor = this.iInstructor.getWidget().getSelectedValue();
        String lastGradeMode = this.iGradeMode.getSelectedValue();
        this.iCredit.clear();
        this.iInstructor.getWidget().clear();
        this.iInstructor.clearHint();
        this.iGradeMode.clear();
        this.iCourseDetails.setHTML("");
        this.iForm.getRowFormatter().setVisible(this.iCourseDetailsLine, false);
        this.iForm.getRowFormatter().setVisible(this.iDisclaimerLine, false);
        this.iForm.getRowFormatter().setVisible(this.iCreditLine, false);
        if (this.iSelectedCourse == null) {
            this.iCredit.setEnabled(false);
            this.iInstructor.getWidget().setEnabled(false);
            this.iGradeMode.setEnabled(false);
            this.iDisclaimer.setEnabled(false);
            this.iDateFrom.setEnabled(false);
            this.iDateTo.setEnabled(false);
        } else {
            if (this.iSelectedCourse.hasDetails()) {
                this.iCourseDetails.setHTML(this.iSelectedCourse.getDetails());
                this.iForm.getRowFormatter().setVisible(this.iCourseDetailsLine, true);
            }
            if (this.iSelectedCourse.hasAvailableCredits()) {
                Iterator<Comparable<Float>> iterator = this.iSelectedCourse.getAvailableCredits().iterator();
                while (iterator.hasNext()) {
                    float cred = iterator.next().floatValue();
                    this.iCredit.addItem(MESSAGES.credit(cred), String.valueOf(cred));
                    if (lastCredit == null || !lastCredit.equals(String.valueOf(cred))) continue;
                    this.iCredit.setSelectedIndex(this.iCredit.getItemCount() - 1);
                }
            }
            this.iCredit.setEnabled(this.iCredit.getItemCount() > 0);
            if (this.iDateFrom.getValueInServerTimeZone() == null) {
                this.iDateFrom.setValueInServerTimeZone(this.iSelectedCourse.getStartDate());
            }
            if (this.iDateTo.getValueInServerTimeZone() == null) {
                this.iDateTo.setValueInServerTimeZone(this.iSelectedCourse.getEndDate());
            }
            if (this.iSelectedCourse.hasInstructors()) {
                this.iInstructor.getWidget().addItem(GWT_MSG.itemSelect(), "");
                for (SpecialRegistrationInterface.InstructorInfo i : this.iSelectedCourse.getInstructors()) {
                    this.iInstructor.getWidget().addItem(i.getName(), i.getId().toString());
                    if (lastInstructor == null || !lastInstructor.equals(i.getId().toString())) continue;
                    this.iInstructor.getWidget().setSelectedIndex(this.iInstructor.getWidget().getItemCount() - 1);
                }
                this.iInstructor.getWidget().addItem(MESSAGES.itemReqVTNoInstructor(), "-");
                if (lastInstructor != null && lastInstructor.equals("-")) {
                    this.iInstructor.getWidget().setSelectedIndex(this.iInstructor.getWidget().getItemCount() - 1);
                    this.iInstructor.setHint(MESSAGES.hintReqVTCourseNoInstructorMatch());
                }
            }
            this.iInstructor.getWidget().setEnabled(this.iInstructor.getWidget().getItemCount() > 0);
            if (this.iSelectedCourse.hasGradeModes()) {
                OnlineSectioningInterface.GradeMode selection = this.iSelectedCourse.getDefaultGradeMode();
                if (lastGradeMode != null) {
                    for (OnlineSectioningInterface.GradeMode gm : this.iSelectedCourse.getGradeModes()) {
                        if (!gm.getCode().equals(lastGradeMode)) continue;
                        selection = gm;
                    }
                }
                for (OnlineSectioningInterface.GradeMode gm : this.iSelectedCourse.getGradeModes()) {
                    this.iGradeMode.addItem(gm.getLabel(), gm.getCode());
                    if (!gm.equals(selection)) continue;
                    this.iGradeMode.setSelectedIndex(this.iGradeMode.getItemCount() - 1);
                }
            }
            this.iGradeMode.setEnabled(this.iGradeMode.getItemCount() > 0);
            if (this.iSelectedCourse.hasDisclaimer()) {
                this.iDisclaimer.setText(this.iSelectedCourse.getDisclaimer());
                this.iDisclaimer.setEnabled(true);
                this.iForm.getRowFormatter().setVisible(this.iDisclaimerLine, true);
            }
            this.iSuggestions.clear();
            if (this.iSelectedCourse.hasSuggestions()) {
                this.iSuggestions.addAll(this.iSelectedCourse.getSuggestions());
            }
            this.checkCredit();
        }
        this.iButtons.setEnabled("submit", this.iSelectedCourse != null && (!this.iSelectedCourse.hasDisclaimer() || this.iDisclaimer.getValue() != false));
    }

    protected void checkCredit() {
        if (this.iMaxCredit == null || this.iCurrentCredit == null || this.iCredit.getItemCount() == 0) {
            this.iForm.getRowFormatter().setVisible(this.iCreditLine, false);
        } else {
            float credit = this.iCurrentCredit.floatValue() + Float.valueOf(this.iCredit.getSelectedValue()).floatValue();
            if (credit > this.iMaxCredit.floatValue()) {
                this.iCreditMessage.setText(MESSAGES.varCreditMaxExceeded(credit, this.iMaxCredit.floatValue()));
                this.iForm.getRowFormatter().setVisible(this.iCreditLine, true);
            } else {
                this.iForm.getRowFormatter().setVisible(this.iCreditLine, false);
            }
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.iCourseTitle.getWidget().getText().isEmpty()) {
            this.iCourseTitle.setErrorHint(MESSAGES.errorReqVTCourseNoTitle());
            valid = false;
        }
        if (this.iInstructor.getWidget().isEnabled() && this.iInstructor.getWidget().getSelectedIndex() == 0) {
            this.iInstructor.setErrorHint(MESSAGES.errorReqVTCourseNoTitle());
            valid = false;
        }
        return valid;
    }

    protected void onSubmit() {
        float credit;
        final SpecialRegistrationInterface.VariableTitleCourseRequest request = new SpecialRegistrationInterface.VariableTitleCourseRequest(this.iContext);
        request.setCourse(this.iSelectedCourse);
        request.setCredit(Float.valueOf(this.iCredit.getSelectedValue()));
        request.setTitle(this.iCourseTitle.getWidget().getText());
        request.setNote(this.iNote.getText());
        request.setStartDate(this.iDateFrom.getValueInServerTimeZone());
        request.setEndDate(this.iDateTo.getValueInServerTimeZone());
        if (this.iCurrentCredit != null && this.iMaxCredit != null && (credit = this.iCurrentCredit.floatValue() + Float.valueOf(this.iCredit.getSelectedValue()).floatValue()) > this.iMaxCredit.floatValue()) {
            request.setMaxCredit(Float.valueOf(credit));
        }
        if (this.iInstructor.getWidget().getSelectedIndex() > 0 && !"-".equals(this.iInstructor.getWidget().getSelectedValue())) {
            request.setInstructor(new SpecialRegistrationInterface.InstructorInfo(Long.valueOf(this.iInstructor.getWidget().getSelectedValue()), this.iInstructor.getWidget().getItemText(this.iInstructor.getWidget().getSelectedIndex())));
        }
        if (this.iGradeMode.getItemCount() > 0) {
            request.setGradeModeCode(this.iGradeMode.getSelectedValue());
        }
        LoadingWidget.getInstance().show(MESSAGES.waitRequestVariableTitleCourse());
        this.iSectioningService.requestVariableTitleCourse(request, new AsyncCallback<SpecialRegistrationInterface.VariableTitleCourseResponse>(){

            public void onSuccess(final SpecialRegistrationInterface.VariableTitleCourseResponse response) {
                LoadingWidget.getInstance().hide();
                if (response.hasRequests()) {
                    RequestVariableTitleCourseDialog.this.iStatus.info(MESSAGES.statusVariableCourseRequested());
                    RequestVariableTitleCourseDialog.this.onChange(response);
                } else if (response.getCourse() != null) {
                    Iterator<CourseRequestInterface.Preference> iterator;
                    if (response.getCourse().hasSelectedClasses() && (iterator = response.getCourse().getSelectedClasses().iterator()).hasNext()) {
                        CourseRequestInterface.Preference p = iterator.next();
                        request.setSection(p.getText());
                    }
                    UniTimeConfirmationDialog.confirm(MESSAGES.questionVariableCourseAlreadyExists(), new Command(){

                        public void execute() {
                            request.setCheckIfExists(false);
                            LoadingWidget.getInstance().show(MESSAGES.waitRequestVariableTitleCourse());
                            RequestVariableTitleCourseDialog.this.iSectioningService.requestVariableTitleCourse(request, new AsyncCallback<SpecialRegistrationInterface.VariableTitleCourseResponse>(){

                                public void onSuccess(SpecialRegistrationInterface.VariableTitleCourseResponse response) {
                                    if (response.hasRequests()) {
                                        RequestVariableTitleCourseDialog.this.iStatus.info(MESSAGES.statusVariableCourseRequested());
                                    }
                                    LoadingWidget.getInstance().hide();
                                    RequestVariableTitleCourseDialog.this.onChange(response);
                                }

                                public void onFailure(Throwable caught) {
                                    RequestVariableTitleCourseDialog.this.iStatus.error(MESSAGES.exceptionRequestVariableTitleCourse(caught.getMessage()), caught);
                                    LoadingWidget.getInstance().hide();
                                }
                            });
                        }
                    }, new Command(){

                        public void execute() {
                            RequestVariableTitleCourseDialog.this.onChange(response);
                        }
                    });
                }
            }

            public void onFailure(Throwable caught) {
                RequestVariableTitleCourseDialog.this.iStatus.error(MESSAGES.exceptionRequestVariableTitleCourse(caught.getMessage()), caught);
                LoadingWidget.getInstance().hide();
            }
        });
    }

    protected void onChange(SpecialRegistrationInterface.VariableTitleCourseResponse response) {
    }

    protected class VariableTitleCourseSuggestions
    extends SuggestOracle {
        protected VariableTitleCourseSuggestions() {
        }

        public void requestSuggestions(final SuggestOracle.Request request, final SuggestOracle.Callback callback) {
            RequestVariableTitleCourseDialog.this.iTimer.cancel();
            RequestVariableTitleCourseDialog.this.iSectioningService.listVariableTitleCourses(RequestVariableTitleCourseDialog.this.iContext, request.getQuery(), request.getLimit(), new AsyncCallback<Collection<SpecialRegistrationInterface.VariableTitleCourseInfo>>(){

                public void onSuccess(Collection<SpecialRegistrationInterface.VariableTitleCourseInfo> result) {
                    callback.onSuggestionsReady(request, new SuggestOracle.Response(result));
                }

                public void onFailure(Throwable caught) {
                    ArrayList<SuggestionInterface> suggestions = new ArrayList<SuggestionInterface>();
                    suggestions.add(new SuggestionInterface("<font color='red'>" + caught.getMessage() + "</font>", ""));
                    callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
                }
            });
        }

        public boolean isDisplayStringHTML() {
            return true;
        }
    }

    public static class SuggestionInterface
    implements IsSerializable,
    SuggestOracle.Suggestion {
        private String iDisplayString;
        private String iReplacementString;

        public SuggestionInterface() {
        }

        public SuggestionInterface(String display) {
            this.iDisplayString = display;
            this.iReplacementString = display;
        }

        public SuggestionInterface(String display, String replace) {
            this.iDisplayString = display;
            this.iReplacementString = replace;
        }

        public String getDisplayString() {
            return this.iDisplayString;
        }

        public String getReplacementString() {
            return this.iReplacementString;
        }
    }
}

