/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class EnrollmentConfirmationDialog
extends UniTimeDialogBox {
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    private AriaButton iYes;
    private AriaButton iNo;
    private AsyncCallback<SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse> iCommand;
    private boolean iValue = false;
    private P iOverrideMessage = null;
    private P iWaiting = null;
    private P iMessagePannel = null;
    private boolean iAll = true;
    private SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse iResponse;

    public EnrollmentConfirmationDialog(Throwable exception, ClassAssignmentInterface result, AsyncCallback<SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse> callback) {
        super(true, true);
        this.addStyleName("unitime-CourseRequestsConfirmationDialog");
        this.setText(MESSAGES.dialogEnrollmentConfirmation());
        this.iCommand = callback;
        P panel = new P("unitime-ConfirmationPanel");
        this.setEscapeToHide(true);
        P bd = new P("body-panel");
        panel.add((Widget)bd);
        P ic = new P("icon-panel");
        bd.add((Widget)ic);
        ic.add((Widget)new Image(exception != null ? RESOURCES.statusError() : RESOURCES.statusWarning()));
        P cp = new P("content-panel");
        bd.add((Widget)cp);
        this.iMessagePannel = new P("message-panel");
        cp.add((Widget)this.iMessagePannel);
        if (exception != null) {
            m1 = new P("message");
            m1.setHTML(MESSAGES.messageEnrollmentFailedWithErrors());
            this.iMessagePannel.add((Widget)m1);
            if (exception instanceof SectioningException && ((SectioningException)exception).hasErrors()) {
                ctab = new P("course-table");
                String last = null;
                HashSet<String> msg = new HashSet<String>();
                for (ClassAssignmentInterface.ErrorMessage cm : new TreeSet<ClassAssignmentInterface.ErrorMessage>(((SectioningException)exception).getErrors())) {
                    if (cm.getCode() != null && cm.getCode().startsWith("UT_")) {
                        this.iAll = false;
                    }
                    P cn = new P("course-name");
                    if (last == null || !last.equals(cm.getCourse())) {
                        msg.clear();
                        cn.setText(cm.getCourse());
                    }
                    if (!msg.add(cm.getMessage())) continue;
                    P m = new P("course-message");
                    m.setText(MESSAGES.courseMessage(cm.getMessage()));
                    P crow = new P("course-row");
                    if (last == null || !last.equals(cm.getCourse())) {
                        crow.addStyleName("first-course-line");
                    }
                    crow.add((Widget)cn);
                    crow.add((Widget)m);
                    ctab.add((Widget)crow);
                    last = cm.getCourse();
                }
                this.iMessagePannel.add((Widget)ctab);
            } else {
                em = new P("message", "error-message");
                em.setHTML(exception.getMessage());
                this.iMessagePannel.add((Widget)em);
            }
        } else {
            m1 = new P("message");
            m1.setHTML(MESSAGES.messageEnrollmentSucceededWithErrors());
            this.iMessagePannel.add((Widget)m1);
            if (result.hasErrors()) {
                ctab = new P("course-table");
                String last = null;
                HashSet<String> msg = new HashSet<String>();
                for (ClassAssignmentInterface.ErrorMessage cm : new TreeSet<ClassAssignmentInterface.ErrorMessage>(result.getErrors())) {
                    if (cm.getCode() != null && cm.getCode().startsWith("UT_")) {
                        this.iAll = false;
                    }
                    P cn = new P("course-name");
                    if (last == null || !last.equals(cm.getCourse())) {
                        msg.clear();
                        cn.setText(cm.getCourse());
                    }
                    if (!msg.add(cm.getMessage())) continue;
                    P m = new P("course-message");
                    m.setText(MESSAGES.courseMessage(cm.getMessage()));
                    P crow = new P("course-row");
                    if (last == null || !last.equals(cm.getCourse())) {
                        crow.addStyleName("first-course-line");
                    }
                    crow.add((Widget)cn);
                    crow.add((Widget)m);
                    ctab.add((Widget)crow);
                    last = cm.getCourse();
                }
                this.iMessagePannel.add((Widget)ctab);
            } else {
                em = new P("message", "error-message");
                em.setHTML(result.getMessages("\n"));
                this.iMessagePannel.add((Widget)em);
            }
        }
        this.iOverrideMessage = new P("message", "override-message");
        this.iOverrideMessage.setHTML(MESSAGES.messageCheckingOverrides());
        this.iMessagePannel.add((Widget)this.iOverrideMessage);
        P bp = new P("buttons-panel");
        panel.add((Widget)bp);
        this.iWaiting = new P("unitime-Waiting");
        this.iWaiting.add((Widget)new Image(RESOURCES.loading_small()));
        P wm = new P("waiting-message");
        this.iWaiting.add((Widget)wm);
        wm.setText(MESSAGES.waitOverridesCheck());
        bp.add((Widget)this.iWaiting);
        this.iYes = new AriaButton(MESSAGES.buttonEnrollmentRequestOverrides());
        this.iYes.setVisible(false);
        this.iYes.setEnabled(false);
        this.iYes.addStyleName("yes");
        this.iYes.setTitle(MESSAGES.titleEnrollmentRequestOverrides());
        bp.add((Widget)this.iYes);
        this.iYes.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EnrollmentConfirmationDialog.this.submit();
            }
        });
        this.iNo = new AriaButton(MESSAGES.buttonEnrollmentHideConfirmation());
        this.iNo.addStyleName("no");
        this.iNo.setTitle(MESSAGES.titleEnrollmentHideConfirmation());
        bp.add((Widget)this.iNo);
        this.iNo.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EnrollmentConfirmationDialog.this.hide();
            }
        });
        this.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> event) {
                if (EnrollmentConfirmationDialog.this.iCommand != null) {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            EnrollmentConfirmationDialog.this.iCommand.onSuccess(EnrollmentConfirmationDialog.this.iValue ? EnrollmentConfirmationDialog.this.iResponse : null);
                        }
                    });
                }
            }
        });
        this.setWidget((Widget)panel);
    }

    protected void showError(String message) {
        this.iWaiting.setVisible(false);
        this.iOverrideMessage.setHTML(MESSAGES.messageCannotRequestOverrides(message));
        super.center();
    }

    protected void showErrors(List<ClassAssignmentInterface.ErrorMessage> errors) {
        this.iWaiting.setVisible(false);
        this.iOverrideMessage.setHTML(MESSAGES.messageCannotRequestOverridesErrors());
        P ctab = new P("course-table");
        String last = null;
        HashSet<String> msg = new HashSet<String>();
        for (ClassAssignmentInterface.ErrorMessage cm : errors) {
            P cn = new P("course-name");
            if (last == null || !last.equals(cm.getCourse())) {
                msg.clear();
                cn.setText(cm.getCourse());
            }
            if (!msg.add(cm.getMessage())) continue;
            P m = new P("course-message");
            m.setText(MESSAGES.courseMessage(cm.getMessage()));
            P crow = new P("course-row");
            if (last == null || !last.equals(cm.getCourse())) {
                crow.addStyleName("first-course-line");
            }
            crow.add((Widget)cn);
            crow.add((Widget)m);
            ctab.add((Widget)crow);
            last = cm.getCourse();
        }
        this.iMessagePannel.add((Widget)ctab);
        P m1 = new P("message");
        m1.setHTML(MESSAGES.messageCannotRequestOverridesErrorsBottom());
        this.iMessagePannel.add((Widget)m1);
        super.center();
    }

    protected void showRequestOverrides() {
        this.iWaiting.setVisible(false);
        if (this.iAll) {
            this.iOverrideMessage.setHTML(MESSAGES.messageCanRequestOverridesAll());
        } else {
            this.iOverrideMessage.setHTML(MESSAGES.messageCanRequestOverridesSome());
        }
        this.iYes.setVisible(true);
        this.iYes.setEnabled(true);
        this.iYes.setFocus(true);
        super.center();
    }

    public void setResponse(SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse eligibilityResponse) {
        if (!this.isVisible()) {
            return;
        }
        this.iResponse = eligibilityResponse;
        List<ClassAssignmentInterface.ErrorMessage> errors = eligibilityResponse.getErrors();
        if (eligibilityResponse.isCanSubmit() && errors != null && !errors.isEmpty()) {
            this.showRequestOverrides();
        } else if (eligibilityResponse.hasDeniedErrors()) {
            this.showErrors(eligibilityResponse.getDeniedErrors());
        } else if (eligibilityResponse.hasMessage()) {
            this.showError(eligibilityResponse.getMessage());
        } else if (eligibilityResponse.isCanSubmit()) {
            this.showError(MESSAGES.errorNoRegistrationErrorsDetected());
        } else {
            this.showError(MESSAGES.errorRegistrationErrorsBadResponse());
        }
    }

    public SpecialRegistrationInterface.SpecialRegistrationEligibilityResponse getResponse() {
        return this.iResponse;
    }

    @Override
    public void center() {
        super.center();
        AriaStatus.getInstance().setText(ARIA.dialogOpened(this.getText()));
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                EnrollmentConfirmationDialog.this.iNo.setFocus(true);
            }
        });
    }

    protected void submit() {
        this.iValue = this.iYes.isEnabled();
        this.hide();
    }
}

