/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaSuggestArea;
import org.unitime.timetable.gwt.client.aria.AriaTabBar;
import org.unitime.timetable.gwt.client.aria.AriaTextArea;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.client.sectioning.ScheduleStatus;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.WebTable;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.gwt.shared.SpecialRegistrationInterface;

public class ChangeGradeModesDialog
extends UniTimeDialogBox {
    protected static StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    protected static GwtMessages GWT_MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    protected static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    protected static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private SimpleForm iForm;
    private WebTable iTable;
    private UniTimeHeaderPanel iButtons;
    private List<GradeModeChange> iChanges = new ArrayList<GradeModeChange>();
    private List<VariableCreditChange> iVarChanges = new ArrayList<VariableCreditChange>();
    private Focusable iFirstChange = null;
    private ScheduleStatus iStatus;
    private ArrayList<ClassAssignmentInterface.ClassAssignment> iEnrollment;
    private List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> iApprovals;
    private P iApproval = null;
    private AriaTabBar iCoursesTab = null;
    private P iCoursesTabScroll = null;
    private Map<Integer, String> iTab2Course = new HashMap<Integer, String>();
    private Map<String, String> iCourse2Note = new HashMap<String, String>();
    private AriaTextArea iNote = null;
    private AriaSuggestArea iNoteWithSuggestions;
    private List<CheckBox> iDisclaimers = new ArrayList<CheckBox>();
    private Float iCurrentCredit;
    private Float iMaxCredit;
    private List<String> iSuggestions = new ArrayList<String>();
    private OnlineSectioningInterface.StudentSectioningContext iContext;
    private P iCourseNotes = null;

    public ChangeGradeModesDialog(OnlineSectioningInterface.StudentSectioningContext context, ScheduleStatus status) {
        super(true, true);
        this.addStyleName("unitime-ChangeGradeModesDialog");
        this.setText(MESSAGES.dialogChangeGradeMode());
        this.iContext = context;
        this.iStatus = status;
        this.iForm = new SimpleForm();
        this.iTable = new WebTable();
        this.iTable.setHeader(new WebTable.Row(new WebTable.Cell(MESSAGES.colSubject()), new WebTable.Cell(MESSAGES.colCourse()), new WebTable.Cell(MESSAGES.colSubpart()), new WebTable.Cell(MESSAGES.colClass()), new WebTable.Cell(MESSAGES.colDays()), new WebTable.Cell(MESSAGES.colStart()), new WebTable.Cell(MESSAGES.colEnd()), new WebTable.Cell(MESSAGES.colDate()), new WebTable.Cell(MESSAGES.colRoom()), new WebTable.Cell(MESSAGES.colCredit()), new WebTable.Cell(MESSAGES.colPendingCredit()), new WebTable.Cell(MESSAGES.colTitleGradeMode()), new WebTable.Cell(MESSAGES.colTitlePendingGradeMode())));
        this.iTable.setEmptyMessage(MESSAGES.emptyGradeChanges());
        ScrollPanel scroll = new ScrollPanel((Widget)this.iTable);
        scroll.setStyleName("unitime-ScrollPanel");
        scroll.addStyleName("class-table");
        this.iForm.addRow((Widget)scroll);
        this.iButtons = new UniTimeHeaderPanel();
        this.iButtons.addButton("submit", MESSAGES.buttonSubmitGradeModeChanges(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChangeGradeModesDialog.this.hide();
                ChangeGradeModesDialog.this.onSubmit();
            }
        });
        this.iButtons.addButton("cancel", MESSAGES.buttonCloseGradeModeChanges(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ChangeGradeModesDialog.this.hide();
            }
        });
        this.iButtons.setEnabled("submit", false);
        this.iApproval = new P("approval-panel");
        this.iForm.addRow((Widget)this.iApproval);
        this.iForm.addBottomRow((Widget)this.iButtons);
        this.iCoursesTab = new AriaTabBar();
        this.iCoursesTab.addStyleName("notes-tab");
        this.iCoursesTab.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> event) {
                ChangeGradeModesDialog.this.iCoursesTab.getTabElement((Integer)event.getSelectedItem()).scrollIntoView();
                String course = ChangeGradeModesDialog.this.iTab2Course.get(event.getSelectedItem());
                String message = ChangeGradeModesDialog.this.iCourse2Note.get(course);
                boolean show = ChangeGradeModesDialog.this.iNoteWithSuggestions.isSuggestionListShowing();
                if (show) {
                    ChangeGradeModesDialog.this.iNoteWithSuggestions.hideSuggestionList();
                }
                ChangeGradeModesDialog.this.iNote.setText(message == null ? "" : message);
                if (show) {
                    ChangeGradeModesDialog.this.iNoteWithSuggestions.showSuggestions(ChangeGradeModesDialog.this.iNote.getText());
                }
                ChangeGradeModesDialog.this.iNote.setAriaLabel(ARIA.requestNoteFor(course));
                AriaStatus.getInstance().setHTML(ARIA.requestNoteFor(course));
            }
        });
        this.iCoursesTabScroll = new P("notes-scroll");
        this.iCoursesTabScroll.add((Widget)this.iCoursesTab);
        this.iCoursesTabScroll.getElement().getStyle().clearPosition();
        this.iCoursesTabScroll.getElement().getStyle().clearOverflow();
        this.iNote = new AriaTextArea();
        this.iNote.setStyleName("unitime-TextArea");
        this.iNote.addStyleName("request-notes");
        this.iNote.setVisibleLines(5);
        this.iNote.setCharacterWidth(80);
        this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                ChangeGradeModesDialog.this.iCourse2Note.put(ChangeGradeModesDialog.this.iTab2Course.get(ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab()), (String)event.getValue());
            }
        });
        this.iNote.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (ChangeGradeModesDialog.this.iNoteWithSuggestions.isSuggestionListShowing()) {
                    return;
                }
                if (event.getNativeEvent().getKeyCode() == 9 && event.getNativeEvent().getShiftKey()) {
                    if (ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab() > 0) {
                        ChangeGradeModesDialog.this.iCourse2Note.put(ChangeGradeModesDialog.this.iTab2Course.get(ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab()), ChangeGradeModesDialog.this.iNote.getText());
                        ChangeGradeModesDialog.this.iCoursesTab.selectTab(ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab() - 1, true);
                        event.preventDefault();
                    }
                } else if (event.getNativeEvent().getKeyCode() == 9 && ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab() + 1 < ChangeGradeModesDialog.this.iCoursesTab.getTabCount()) {
                    ChangeGradeModesDialog.this.iCourse2Note.put(ChangeGradeModesDialog.this.iTab2Course.get(ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab()), ChangeGradeModesDialog.this.iNote.getText());
                    ChangeGradeModesDialog.this.iCoursesTab.selectTab(ChangeGradeModesDialog.this.iCoursesTab.getSelectedTab() + 1, true);
                    event.preventDefault();
                }
            }
        });
        this.iNoteWithSuggestions = new AriaSuggestArea(this.iNote, this.iSuggestions);
        this.iNoteWithSuggestions.addStyleName("request-note");
        this.iNoteWithSuggestions.addSelectionHandler(new SelectionHandler<SuggestOracle.Suggestion>(){

            public void onSelection(SelectionEvent<SuggestOracle.Suggestion> event) {
                String text = ChangeGradeModesDialog.this.iNote.getText();
                if (text.indexOf(60) >= 0 && text.indexOf(62) > text.indexOf(60)) {
                    ChangeGradeModesDialog.this.iNote.setSelectionRange(text.indexOf(60), text.indexOf(62) - text.indexOf(60) + 1);
                }
            }
        });
        this.iCourseNotes = new P("course-notes");
        this.iCourseNotes.add((Widget)this.iCoursesTabScroll);
        this.iCourseNotes.add((Widget)this.iNoteWithSuggestions);
        this.setWidget((Widget)this.iForm);
    }

    protected OnlineSectioningInterface.GradeMode getPendingGradeMode(Long courseId) {
        if (this.iApprovals == null) {
            return null;
        }
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse approval : this.iApprovals) {
            if (approval.getStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || !approval.hasChanges()) continue;
            for (ClassAssignmentInterface.ClassAssignment clazz : approval.getChanges()) {
                if (clazz.getGradeMode() == null || !courseId.equals(clazz.getCourseId())) continue;
                return clazz.getGradeMode();
            }
        }
        return null;
    }

    protected Float getPendingCredit(Long courseId) {
        if (this.iApprovals == null) {
            return null;
        }
        for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse approval : this.iApprovals) {
            if (approval.getStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || !approval.hasChanges()) continue;
            for (ClassAssignmentInterface.ClassAssignment clazz : approval.getChanges()) {
                if (clazz.getCreditHour() == null || !courseId.equals(clazz.getCourseId())) continue;
                return clazz.getCreditHour();
            }
        }
        return null;
    }

    public void changeGradeModes(ArrayList<ClassAssignmentInterface.ClassAssignment> enrollment, List<SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse> approvals) {
        LoadingWidget.getInstance().show(MESSAGES.waitRetrieveGradeModes());
        this.iChanges.clear();
        this.iVarChanges.clear();
        this.iFirstChange = null;
        this.iNote.setValue("");
        this.iApproval.clear();
        this.iEnrollment = enrollment;
        this.iApprovals = approvals;
        this.iCourse2Note.clear();
        if (this.iApprovals != null) {
            for (SpecialRegistrationInterface.RetrieveSpecialRegistrationResponse approval : this.iApprovals) {
                String note;
                if (approval.getStatus() == SpecialRegistrationInterface.SpecialRegistrationStatus.Pending && approval.hasChanges()) {
                    for (ClassAssignmentInterface.ClassAssignment clazz : approval.getChanges()) {
                        String note2;
                        if (clazz.getGradeMode() == null && clazz.getCreditHour() == null || (note2 = approval.getNote(clazz.getCourseName())) == null) continue;
                        this.iCourse2Note.put(clazz.getCourseName(), note2);
                    }
                    continue;
                }
                if (approval.getStatus() != SpecialRegistrationInterface.SpecialRegistrationStatus.Pending || !approval.hasErrors() || (note = approval.getNote("MAXI")) == null) continue;
                this.iCourse2Note.put("MAXI", note);
            }
        }
        this.iSectioningService.retrieveGradeModes(new SpecialRegistrationInterface.RetrieveAvailableGradeModesRequest(this.iContext), new AsyncCallback<SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse>(){

            public void onFailure(Throwable caught) {
                ChangeGradeModesDialog.this.iStatus.error(MESSAGES.exceptionRetrieveGradeModes(caught.getMessage()), caught);
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(SpecialRegistrationInterface.RetrieveAvailableGradeModesResponse result) {
                ArrayList<WebTable.Row> rows = new ArrayList<WebTable.Row>();
                ChangeGradeModesDialog.this.iTable.clearData(true);
                ChangeGradeModesDialog.this.iCurrentCredit = result.getCurrentCredit();
                ChangeGradeModesDialog.this.iMaxCredit = result.getMaxCredit();
                ChangeGradeModesDialog.this.iSuggestions.clear();
                if (result.hasSuggestions()) {
                    ChangeGradeModesDialog.this.iSuggestions.addAll(result.getSuggestions());
                }
                Long lastCourseId = null;
                GradeModeChange change = null;
                boolean hasPendingCredit = false;
                boolean hasPendingGradeMode = false;
                for (ClassAssignmentInterface.ClassAssignment clazz : ChangeGradeModesDialog.this.iEnrollment) {
                    if (clazz == null) continue;
                    SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode = result.get(clazz);
                    SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange varCredit = result.getVariableCredits(clazz);
                    if (gradeMode == null && varCredit == null || clazz.getParentSection() != null && clazz.getParentSection().equals(clazz.getSection()) || clazz.isTeachingAssignment() || clazz.isDummy() || clazz.isFreeTime()) continue;
                    VariableCreditChange vcc = null;
                    Float pendingCredit = null;
                    if (varCredit != null) {
                        vcc = new VariableCreditChange(clazz, varCredit);
                        ChangeGradeModesDialog.this.iVarChanges.add(vcc);
                        if (ChangeGradeModesDialog.this.iFirstChange == null) {
                            ChangeGradeModesDialog.this.iFirstChange = (Focusable)vcc.getWidget();
                        }
                        if ((pendingCredit = ChangeGradeModesDialog.this.getPendingCredit(clazz.getCourseId())) != null) {
                            hasPendingCredit = true;
                        }
                    }
                    boolean firstClazz = !clazz.getCourseId().equals(lastCourseId);
                    OnlineSectioningInterface.GradeMode pendingGradeMode = null;
                    if (gradeMode != null) {
                        if (firstClazz) {
                            change = new GradeModeChange(clazz, gradeMode);
                            ChangeGradeModesDialog.this.iChanges.add(change);
                            if (ChangeGradeModesDialog.this.iFirstChange == null) {
                                ChangeGradeModesDialog.this.iFirstChange = (Focusable)change.getWidget();
                            }
                        } else {
                            change.addClassAssignment(clazz, gradeMode);
                        }
                        if ((pendingGradeMode = ChangeGradeModesDialog.this.getPendingGradeMode(clazz.getCourseId())) != null) {
                            hasPendingGradeMode = true;
                            if (pendingGradeMode.getLabel() == null) {
                                SpecialRegistrationInterface.SpecialRegistrationGradeMode m = gradeMode.getAvailableChange(pendingGradeMode.getCode());
                                if (m != null) {
                                    pendingGradeMode.setLabel(m.getLabel());
                                } else {
                                    pendingGradeMode.setLabel(pendingGradeMode.getCode());
                                }
                            }
                        }
                    } else {
                        change = null;
                    }
                    lastCourseId = clazz.getCourseId();
                    String style = firstClazz && !rows.isEmpty() ? "top-border-dashed" : "";
                    WebTable.Row row = null;
                    row = clazz.isAssigned() ? new WebTable.Row(new WebTable.Cell(firstClazz ? clazz.getSubject() : "").aria(clazz.getSubject()), new WebTable.Cell(firstClazz ? clazz.getCourseNbr(CONSTANTS.showCourseTitle()) : "").aria(clazz.getCourseNbr(CONSTANTS.showCourseTitle())), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(clazz.getDaysString(CONSTANTS.shortDays())).aria(clazz.getDaysString(CONSTANTS.longDays(), " ")), new WebTable.Cell(clazz.getStartString(CONSTANTS.useAmPm())).aria(clazz.getStartStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getEndString(CONSTANTS.useAmPm())).aria(clazz.getEndStringAria(CONSTANTS.useAmPm())), new WebTable.Cell(clazz.getDatePattern()), clazz.hasDistanceConflict() ? new WebTable.RoomCell(clazz.hasLongDistanceConflict() ? RESOURCES.longDistantConflict() : RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", "), vcc != null ? vcc : new WebTable.AbbvTextCell(clazz.getCredit()), new WebTable.Cell(pendingCredit == null ? "" : MESSAGES.credit(pendingCredit.floatValue())), change == null ? new WebTable.Cell("") : (firstClazz ? change : new GradeModeLabel(change, gradeMode)), new WebTable.Cell(pendingGradeMode == null ? "" : pendingGradeMode.getLabel())) : new WebTable.Row(new WebTable.Cell(firstClazz ? clazz.getSubject() : "").aria(clazz.getSubject()), new WebTable.Cell(firstClazz ? clazz.getCourseNbr(CONSTANTS.showCourseTitle()) : "").aria(clazz.getCourseNbr(CONSTANTS.showCourseTitle())), new WebTable.Cell(clazz.getSubpart()), new WebTable.Cell(clazz.getSection()), new WebTable.Cell(MESSAGES.arrangeHours(), 3, null), new WebTable.Cell(clazz.getDatePattern()), clazz.hasDistanceConflict() ? new WebTable.RoomCell(clazz.hasLongDistanceConflict() ? RESOURCES.longDistantConflict() : RESOURCES.distantConflict(), MESSAGES.backToBackDistance(clazz.getBackToBackRooms(), clazz.getBackToBackDistance()), clazz.getRooms(), ", ") : new WebTable.RoomCell((List<ClassAssignmentInterface.IdValue>)clazz.getRooms(), ", "), vcc != null ? vcc : new WebTable.AbbvTextCell(clazz.getCredit()), new WebTable.Cell(pendingCredit == null ? "" : MESSAGES.credit(pendingCredit.floatValue())), change == null ? new WebTable.Cell("") : (firstClazz ? change : new GradeModeLabel(change, gradeMode)), new WebTable.Cell(pendingGradeMode == null ? "" : pendingGradeMode.getLabel()));
                    for (WebTable.Cell cell : row.getCells()) {
                        cell.setStyleName(style);
                    }
                    rows.add(row);
                }
                WebTable.Row[] rowArray = new WebTable.Row[rows.size()];
                int idx = 0;
                for (WebTable.Row row : rows) {
                    rowArray[idx++] = row;
                }
                ChangeGradeModesDialog.this.iTable.setData(rowArray);
                ChangeGradeModesDialog.this.iTable.setColumnVisible(10, hasPendingCredit);
                ChangeGradeModesDialog.this.iTable.setColumnVisible(12, hasPendingGradeMode);
                LoadingWidget.getInstance().hide();
                if (rows.isEmpty()) {
                    ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusNoGradeModeChangesAvailable());
                } else {
                    ChangeGradeModesDialog.this.center();
                    if (ChangeGradeModesDialog.this.iFirstChange != null) {
                        ChangeGradeModesDialog.this.iFirstChange.setFocus(true);
                    } else if (!ChangeGradeModesDialog.this.iChanges.isEmpty()) {
                        ((Focusable)ChangeGradeModesDialog.this.iChanges.get(0).getWidget()).setFocus(true);
                    } else if (!ChangeGradeModesDialog.this.iVarChanges.isEmpty()) {
                        ((Focusable)ChangeGradeModesDialog.this.iVarChanges.get(0).getWidget()).setFocus(true);
                    }
                }
            }
        });
    }

    protected void formChanged() {
        P m;
        String lastCourse;
        this.iApproval.clear();
        P ctab = new P("course-table");
        boolean changes = false;
        boolean approvals = false;
        String string = lastCourse = this.iCoursesTab.getTabCount() == 0 ? null : this.iTab2Course.get(this.iCoursesTab.getSelectedTab());
        while (this.iCoursesTab.getTabCount() > 0) {
            this.iCoursesTab.removeTab(0);
        }
        this.iTab2Course.clear();
        this.iDisclaimers.clear();
        TreeSet<String> disclaimers = new TreeSet<String>();
        ArrayList<String> courses = new ArrayList<String>();
        for (GradeModeChange cell : this.iChanges) {
            SpecialRegistrationInterface.SpecialRegistrationGradeMode change = cell.getChange();
            if (change == null) continue;
            changes = true;
            boolean first = true;
            for (ClassAssignmentInterface.ClassAssignment classAssignment : cell.getClassAssignments()) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode ch = cell.getChange(classAssignment.getExternalId());
                if (ch == null || ch.getOriginalGradeMode() != null && ch.getOriginalGradeMode().equals(change.getCode())) continue;
                P cn = new P("course-name");
                if (first) {
                    cn.setText(classAssignment.getCourseName());
                }
                P sn = new P("section-name");
                sn.setText(classAssignment.getSection());
                P m2 = new P("approval-message");
                if (ch.hasApprovals()) {
                    m2.setText(MESSAGES.gradeModeApprovalNeeded(ch.getLabel(), ToolBox.toString(ch.getApprovals())));
                    approvals = true;
                    if (!courses.contains(classAssignment.getCourseName())) {
                        courses.add(classAssignment.getCourseName());
                    }
                } else {
                    m2.setText(MESSAGES.gradeModeNoApprovalNeeded(ch.getLabel()));
                }
                if (ch.hasDisclaimer()) {
                    disclaimers.add(ch.getDisclaimer());
                }
                P crow = new P("course-row");
                if (first) {
                    crow.addStyleName("first-course-line");
                }
                crow.add((Widget)cn);
                crow.add((Widget)sn);
                crow.add((Widget)m2);
                ctab.add((Widget)crow);
                first = false;
            }
        }
        P crtab = new P("course-table");
        boolean credChanges = false;
        boolean credApprovals = false;
        float cred = this.iCurrentCredit == null ? 0.0f : this.iCurrentCredit.floatValue();
        for (VariableCreditChange variableCreditChange : this.iVarChanges) {
            SpecialRegistrationInterface.SpecialRegistrationVariableCredit change = variableCreditChange.getChange();
            if (change == null) continue;
            cred += change.getCreditChange();
            credChanges = true;
            ClassAssignmentInterface.ClassAssignment ca = variableCreditChange.getClassAssignment();
            P cn = new P("course-name");
            cn.setText(ca.getCourseName());
            P sn = new P("section-name");
            sn.setText(ca.getSection());
            P m3 = new P("approval-message");
            if (change.hasApprovals()) {
                m3.setText(MESSAGES.varCreditApprovalNeeded(change.getCredit(), ToolBox.toString(change.getApprovals())));
                credApprovals = true;
                if (!courses.contains(ca.getCourseName())) {
                    courses.add(ca.getCourseName());
                }
            } else {
                m3.setText(MESSAGES.varCreditNoApprovalNeeded(change.getCredit()));
            }
            P crow = new P("course-row");
            crow.addStyleName("first-course-line");
            crow.add((Widget)cn);
            crow.add((Widget)sn);
            crow.add((Widget)m3);
            crtab.add((Widget)crow);
        }
        if (changes) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeListChanges());
            this.iApproval.add((Widget)m);
            this.iApproval.add((Widget)ctab);
        }
        if (credChanges) {
            m = new P("message");
            m.setHTML(MESSAGES.varCreditListChanges());
            this.iApproval.add((Widget)m);
            this.iApproval.add((Widget)crtab);
            if (this.iMaxCredit != null && cred > this.iMaxCredit.floatValue()) {
                m = new P("message", "credit-message");
                m.setHTML(MESSAGES.varCreditMaxExceeded(cred, this.iMaxCredit.floatValue()));
                this.iApproval.add((Widget)m);
            }
        }
        if (approvals || credApprovals || credChanges && this.iMaxCredit != null && cred > this.iMaxCredit.floatValue()) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeChangesNote());
            this.iApproval.add((Widget)m);
            this.iNote.setText("");
            for (String course : courses) {
                this.iTab2Course.put(this.iCoursesTab.getTabCount(), course);
                this.iCoursesTab.addTab(course);
                if (!course.equals(lastCourse)) continue;
                this.iCoursesTab.selectTab(this.iCoursesTab.getTabCount() - 1);
                String message2 = this.iCourse2Note.get(course);
                this.iNote.setText(message2 == null ? "" : message2);
            }
            if (credChanges && this.iMaxCredit != null && cred > this.iMaxCredit.floatValue()) {
                this.iTab2Course.put(this.iCoursesTab.getTabCount(), "MAXI");
                this.iCoursesTab.addTab(MESSAGES.tabRequestNoteMaxCredit());
                if ("MAXI".equals(lastCourse)) {
                    this.iCoursesTab.selectTab(this.iCoursesTab.getTabCount() - 1);
                    String string2 = this.iCourse2Note.get("MAXI");
                    this.iNote.setText(string2 == null ? "" : string2);
                }
            }
            if (this.iCoursesTab.getTabCount() > 0 && this.iCoursesTab.getSelectedTab() < 0) {
                this.iCoursesTab.selectTab(0);
                String string3 = this.iCourse2Note.get(this.iTab2Course.get(0));
                this.iNote.setText(string3 == null ? "" : string3);
            }
            this.iApproval.add((Widget)this.iCourseNotes);
        }
        if (!disclaimers.isEmpty()) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeDisclaimers());
            this.iApproval.add((Widget)m);
            for (String d : disclaimers) {
                CheckBox ch = new CheckBox(d, true);
                ch.addStyleName("disclaimer-message");
                ch.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        ChangeGradeModesDialog.this.submitUpdateEnabled();
                    }
                });
                this.iDisclaimers.add(ch);
                this.iApproval.add((Widget)ch);
            }
        }
        if (changes || credChanges) {
            m = new P("message");
            m.setHTML(MESSAGES.gradeModeChangeOptions());
            this.iApproval.add((Widget)m);
        }
        this.iButtons.setEnabled("submit", (changes || credChanges) && disclaimers.isEmpty(), changes || credChanges);
        this.center();
    }

    protected void submitUpdateEnabled() {
        for (CheckBox ch : this.iDisclaimers) {
            if (ch.getValue().booleanValue()) continue;
            this.iButtons.setEnabled("submit", false, true);
            return;
        }
        this.iButtons.setEnabled("submit", true, true);
    }

    protected void onChange(SpecialRegistrationInterface.ChangeGradeModesResponse response) {
    }

    protected void onSubmit() {
        IsSerializable ch;
        IsSerializable change;
        SpecialRegistrationInterface.ChangeGradeModesRequest request = new SpecialRegistrationInterface.ChangeGradeModesRequest(this.iContext);
        request.setCurrentCredit(this.iCurrentCredit);
        request.setMaxCredit(this.iMaxCredit);
        request.setNote(this.iCourse2Note.get("MAXI"));
        for (GradeModeChange gradeModeChange : this.iChanges) {
            change = gradeModeChange.getChange();
            if (change == null) continue;
            ch = new SpecialRegistrationInterface.SpecialRegistrationGradeModeChange();
            ch.setOriginalGradeMode(gradeModeChange.getGradeModes().get(0).getCurrentGradeMode() == null ? null : gradeModeChange.getGradeModes().get(0).getCurrentGradeMode().getCode());
            ch.setSelectedGradeMode(change.getCode());
            ch.setSelectedGradeModeDescription(change.getLabel());
            ch.setSubject(gradeModeChange.getClassAssignments().get(0).getSubject());
            ch.setCourse(gradeModeChange.getClassAssignments().get(0).getCourseNbr());
            ch.setCredit(gradeModeChange.getClassAssignments().get(0).getCredit());
            ch.setNote(this.iCourse2Note.get(gradeModeChange.getClassAssignments().get(0).getCourseName()));
            for (ClassAssignmentInterface.ClassAssignment ca : gradeModeChange.getClassAssignments()) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode x = gradeModeChange.getChange(ca.getExternalId());
                if (x == null || x.getOriginalGradeMode() != null && x.getOriginalGradeMode().equals(change.getCode())) continue;
                if (x.hasApprovals()) {
                    for (String app : x.getApprovals()) {
                        ch.addApproval(app);
                    }
                }
                ch.addCrn(ca.getExternalId());
            }
            request.addChange((SpecialRegistrationInterface.SpecialRegistrationGradeModeChange)ch);
        }
        for (VariableCreditChange variableCreditChange : this.iVarChanges) {
            change = variableCreditChange.getChange();
            if (change == null) continue;
            ch = new SpecialRegistrationInterface.SpecialRegistrationCreditChange();
            ch.setCredit(change.getCredit());
            ch.setOriginalCredit(change.getOriginalCredit());
            ch.setSubject(variableCreditChange.getClassAssignment().getSubject());
            ch.setCourse(variableCreditChange.getClassAssignment().getCourseNbr());
            ch.setCrn(variableCreditChange.getClassAssignment().getExternalId());
            ch.setNote(this.iCourse2Note.get(variableCreditChange.getClassAssignment().getCourseName()));
            if (change.hasApprovals()) {
                for (String app : change.getApprovals()) {
                    ch.addApproval(app);
                }
            }
            request.addChange((SpecialRegistrationInterface.SpecialRegistrationCreditChange)ch);
        }
        if (request.hasGradeModeChanges() || request.hasCreditChanges()) {
            LoadingWidget.getInstance().show(MESSAGES.waitChangeGradeModes());
            this.iSectioningService.changeGradeModes(request, new AsyncCallback<SpecialRegistrationInterface.ChangeGradeModesResponse>(){

                public void onSuccess(SpecialRegistrationInterface.ChangeGradeModesResponse response) {
                    if (response.hasRequests()) {
                        ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusGradeModeChangesRequested());
                    } else {
                        ChangeGradeModesDialog.this.iStatus.info(MESSAGES.statusGradeModeChangesApplied());
                    }
                    LoadingWidget.getInstance().hide();
                    ChangeGradeModesDialog.this.onChange(response);
                }

                public void onFailure(Throwable caught) {
                    ChangeGradeModesDialog.this.iStatus.error(MESSAGES.exceptionChangeGradeModes(caught.getMessage()), caught);
                    LoadingWidget.getInstance().hide();
                }
            });
        } else {
            this.iStatus.info(MESSAGES.statusNoGradeModeChangesMade());
        }
    }

    public class GradeModeChange
    extends WebTable.Cell
    implements HasAriaLabel {
        private ListBox iList;
        private List<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges> iGradeMode;
        private List<ClassAssignmentInterface.ClassAssignment> iClasses;

        public GradeModeChange(ClassAssignmentInterface.ClassAssignment ca, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode) {
            super(null);
            this.iList = new ListBox();
            this.iList.addStyleName("grade-mode-list");
            this.iClasses = new ArrayList<ClassAssignmentInterface.ClassAssignment>();
            this.iClasses.add(ca);
            this.iGradeMode = new ArrayList<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges>();
            this.iGradeMode.add(gradeMode);
            this.iList.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ChangeGradeModesDialog.this.formChanged();
                }
            });
            this.setup();
        }

        private void setup() {
            this.iList.clear();
            SpecialRegistrationInterface.SpecialRegistrationGradeMode current = this.iGradeMode.get(0).getCurrentGradeMode();
            boolean same = true;
            for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges specialRegistrationGradeModeChanges : this.iGradeMode) {
                SpecialRegistrationInterface.SpecialRegistrationGradeMode m = specialRegistrationGradeModeChanges.getCurrentGradeMode();
                if (current != null) {
                    if (m != null && current.getCode().equals(m.getCode())) continue;
                    same = false;
                    continue;
                }
                if (m == null) continue;
                same = false;
            }
            if (same) {
                if (current != null) {
                    this.iList.addItem(current.getLabel(), current.getCode());
                    this.iList.setSelectedIndex(0);
                } else {
                    this.iList.addItem(MESSAGES.gradeModeItemNotSet(), "");
                    this.iList.setSelectedIndex(0);
                }
            } else if (current != null) {
                this.iList.addItem(MESSAGES.gradeModeItemNotSame(current.getLabel()), "");
                this.iList.setSelectedIndex(0);
            } else {
                this.iList.addItem(MESSAGES.gradeModeItemNotSame(MESSAGES.gradeModeItemNotSet()), "");
                this.iList.setSelectedIndex(0);
            }
            if (!same && current != null) {
                boolean canSetCurrent = true;
                for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm : this.iGradeMode) {
                    if (gm.getAvailableChange(current.getCode()) != null || gm.isCurrentGradeMode(current.getCode())) continue;
                    canSetCurrent = false;
                    break;
                }
                if (canSetCurrent) {
                    this.iList.addItem(current.getLabel(), current.getCode());
                }
            }
            block2: for (SpecialRegistrationInterface.SpecialRegistrationGradeMode specialRegistrationGradeMode : this.iGradeMode.get(0).getAvailableChanges()) {
                for (SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm : this.iGradeMode) {
                    if (gm.getAvailableChange(specialRegistrationGradeMode.getCode()) != null || gm.isCurrentGradeMode(specialRegistrationGradeMode.getCode())) continue;
                    continue block2;
                }
                if (same && current != null && current.getCode().equals(specialRegistrationGradeMode.getCode())) continue;
                this.iList.addItem(specialRegistrationGradeMode.getLabel(), specialRegistrationGradeMode.getCode());
            }
        }

        public void addClassAssignment(ClassAssignmentInterface.ClassAssignment ca, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gm) {
            this.iClasses.add(ca);
            this.iGradeMode.add(gm);
            this.setup();
        }

        @Override
        public String getValue() {
            return this.iList.getValue(this.iList.getSelectedIndex());
        }

        @Override
        public Widget getWidget() {
            return this.iList;
        }

        public SpecialRegistrationInterface.SpecialRegistrationGradeMode getChange() {
            SpecialRegistrationInterface.SpecialRegistrationGradeMode current;
            if (this.iList.getSelectedIndex() <= 0) {
                return null;
            }
            SpecialRegistrationInterface.SpecialRegistrationGradeMode change = this.iGradeMode.get(0).getAvailableChange(this.iList.getValue(this.iList.getSelectedIndex()));
            if (change == null && (current = this.iGradeMode.get(0).getCurrentGradeMode()) != null && current.getCode().equals(this.iList.getValue(this.iList.getSelectedIndex()))) {
                change = current;
            }
            return change;
        }

        public List<ClassAssignmentInterface.ClassAssignment> getClassAssignments() {
            return this.iClasses;
        }

        public List<SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges> getGradeModes() {
            return this.iGradeMode;
        }

        public SpecialRegistrationInterface.SpecialRegistrationGradeMode getChange(String extId) {
            if (this.iList.getSelectedIndex() <= 0) {
                return null;
            }
            for (int i = 0; i < this.iClasses.size(); ++i) {
                if (!extId.equals(this.iClasses.get(i).getExternalId())) continue;
                return this.iGradeMode.get(i).getAvailableChange(this.iList.getValue(this.iList.getSelectedIndex()));
            }
            return null;
        }
    }

    public class VariableCreditChange
    extends WebTable.Cell
    implements HasAriaLabel {
        private ListBox iList;
        private SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange iVarCredit;
        private ClassAssignmentInterface.ClassAssignment iClass;

        public VariableCreditChange(ClassAssignmentInterface.ClassAssignment ca, SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange vcc) {
            super(null);
            this.iList = new ListBox();
            this.iList.addStyleName("variable-credit-list");
            this.iClass = ca;
            this.iVarCredit = vcc;
            this.iList.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    ChangeGradeModesDialog.this.formChanged();
                }
            });
            this.setup();
        }

        private void setup() {
            this.iList.clear();
            boolean hasCredit = false;
            if (this.iVarCredit.hasAvailableCredits()) {
                for (float cred : this.iVarCredit.getAvailableCredits()) {
                    this.iList.addItem(MESSAGES.credit(cred), String.valueOf(cred));
                    if (this.iClass.getCreditHour() != null && this.iClass.getCreditHour().floatValue() == cred) {
                        this.iList.setSelectedIndex(this.iList.getItemCount() - 1);
                        hasCredit = true;
                        continue;
                    }
                    if (this.iClass.getCreditHour() != null || !this.iClass.hasCredit() || this.iClass.guessCreditCount() != cred) continue;
                    this.iList.setSelectedIndex(this.iList.getItemCount() - 1);
                    hasCredit = true;
                }
            }
            if (!hasCredit) {
                if (this.iClass.getCreditHour() != null) {
                    this.iList.insertItem(MESSAGES.credit(this.iClass.getCreditHour().floatValue()), this.iClass.getCreditHour().toString(), 0);
                } else if (this.iClass.getCredit() != null) {
                    this.iList.insertItem(MESSAGES.credit(this.iClass.guessCreditCount()), String.valueOf(this.iClass.guessCreditCount()), 0);
                } else {
                    this.iList.insertItem("", "", 0);
                }
                this.iList.setSelectedIndex(0);
            }
        }

        @Override
        public String getValue() {
            return this.iList.getValue(this.iList.getSelectedIndex());
        }

        @Override
        public Widget getWidget() {
            return this.iList;
        }

        public SpecialRegistrationInterface.SpecialRegistrationVariableCredit getChange() {
            String credit = this.iList.getValue(this.iList.getSelectedIndex());
            if (credit.isEmpty()) {
                return null;
            }
            if (this.iClass.getCreditHour() != null ? this.iClass.getCreditHour().equals(Float.valueOf(credit)) : this.iClass.getCredit() != null && this.iClass.guessCreditCount() == Float.valueOf(credit).floatValue()) {
                return null;
            }
            SpecialRegistrationInterface.SpecialRegistrationVariableCredit change = new SpecialRegistrationInterface.SpecialRegistrationVariableCredit(this.iVarCredit);
            change.setOriginalCredit(this.iClass.getCreditHour() != null ? this.iClass.getCreditHour() : (this.iClass.getCredit() != null ? Float.valueOf(this.iClass.guessCreditCount()) : null));
            change.setCredit(Float.valueOf(credit));
            return change;
        }

        public ClassAssignmentInterface.ClassAssignment getClassAssignment() {
            return this.iClass;
        }

        public SpecialRegistrationInterface.SpecialRegistrationVariableCreditChange getVarCredits() {
            return this.iVarCredit;
        }
    }

    public static class GradeModeLabel
    extends WebTable.Cell {
        private Label iLabel;
        private SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges iGradeMode;

        public GradeModeLabel(GradeModeChange change, SpecialRegistrationInterface.SpecialRegistrationGradeModeChanges gradeMode) {
            super(null);
            this.iGradeMode = gradeMode;
            this.iLabel = new Label();
            this.iLabel.addStyleName("grade-mode-label");
            this.iLabel.setText(this.iGradeMode.getCurrentGradeMode() == null ? "" : this.iGradeMode.getCurrentGradeMode().getLabel());
            final ListBox box = (ListBox)change.getWidget();
            box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    if (box.getSelectedIndex() <= 0) {
                        iLabel.setText(iGradeMode.getCurrentGradeMode() == null ? "" : iGradeMode.getCurrentGradeMode().getLabel());
                    } else {
                        SpecialRegistrationInterface.SpecialRegistrationGradeMode m = iGradeMode.getAvailableChange(box.getValue(box.getSelectedIndex()));
                        if (m == null) {
                            iLabel.setText(iGradeMode.getCurrentGradeMode() == null ? "" : iGradeMode.getCurrentGradeMode().getLabel());
                        } else {
                            iLabel.setText(m.getLabel());
                        }
                    }
                }
            });
        }

        @Override
        public String getValue() {
            return this.iLabel.getText();
        }

        @Override
        public Widget getWidget() {
            return this.iLabel;
        }

        @Override
        public void setStyleName(String styleName) {
            super.setStyleName(styleName);
        }
    }
}

