/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomSharingWidget
extends Composite
implements HasValue<RoomInterface.RoomSharingModel>,
SimpleForm.HasMobileScroll {
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private AbsolutePanel iPanel;
    private ListBox iModeSelection;
    private RoomInterface.RoomSharingDisplayMode iMode = null;
    private CheckBox iHorizontal;
    private RoomInterface.RoomSharingOption iOption = null;
    private P iSelectedIcon = null;
    private P iSelectedTitle = null;
    private RoomInterface.RoomSharingModel iModel;
    protected boolean iEditable = true;
    private TextArea iNote = null;
    private Set<Long> iAddedOptions = new HashSet<Long>();
    private int iSplit = 24;
    private boolean iShowLegend = true;

    public RoomSharingWidget(boolean editable) {
        this(editable, true);
    }

    public RoomSharingWidget(boolean editable, boolean includeNote) {
        this.iEditable = editable;
        VerticalPanel container = new VerticalPanel();
        HorizontalPanel hp = new HorizontalPanel();
        this.iModeSelection = new ListBox();
        this.iModeSelection.setStyleName("unitime-TextBox");
        hp.add((Widget)this.iModeSelection);
        hp.setCellHorizontalAlignment((Widget)this.iModeSelection, HasHorizontalAlignment.ALIGN_LEFT);
        this.iHorizontal = new CheckBox(MESSAGES.roomSharingHorizontal());
        hp.add((Widget)this.iHorizontal);
        hp.setCellHorizontalAlignment((Widget)this.iHorizontal, HasHorizontalAlignment.ALIGN_RIGHT);
        hp.setCellVerticalAlignment((Widget)this.iHorizontal, HasVerticalAlignment.ALIGN_MIDDLE);
        hp.setWidth("100%");
        container.add((Widget)hp);
        this.iModeSelection.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomSharingWidget.this.setMode(RoomSharingWidget.this.iModel.getModes().get(RoomSharingWidget.this.iModeSelection.getSelectedIndex()), RoomSharingWidget.this.iHorizontal.getValue());
            }
        });
        this.iHorizontal.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomSharingWidget.this.setMode(RoomSharingWidget.this.iModel.getModes().get(RoomSharingWidget.this.iModeSelection.getSelectedIndex()), RoomSharingWidget.this.iHorizontal.getValue());
            }
        });
        this.iPanel = new AbsolutePanel();
        this.iPanel.setStyleName("unitime-RoomSharingWidget");
        container.add((Widget)this.iPanel);
        if (this.iEditable && includeNote) {
            this.iNote = new TextArea();
            this.iNote.setStyleName("unitime-TextArea");
            this.iNote.setVisibleLines(10);
            this.iNote.setCharacterWidth(50);
            this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                public void onValueChange(ValueChangeEvent<String> event) {
                    if (RoomSharingWidget.this.iModel != null) {
                        RoomSharingWidget.this.iModel.setNote((String)event.getValue());
                    }
                }
            });
        }
        this.initWidget((Widget)container);
    }

    public int getSplit() {
        return this.iSplit;
    }

    public void setSplit(int split) {
        this.iSplit = split;
    }

    public AbsolutePanel getPanel() {
        return this.iPanel;
    }

    public boolean isEditable() {
        return this.iEditable && this.iModel != null && this.iModel.isEditable();
    }

    public void setEditable(boolean editable) {
        this.iEditable = editable;
    }

    public boolean isEditable(RoomInterface.RoomSharingOption option) {
        return this.isEditable() && option.isEditable();
    }

    public boolean isDeletable(RoomInterface.RoomSharingOption option) {
        return this.isEditable() && option.isDeletable();
    }

    public boolean isEditable(int day, int slot) {
        return this.isEditable() && this.iModel.isEditable(day, slot, this.iMode.getStep());
    }

    public RoomInterface.RoomSharingModel getModel() {
        return this.iModel;
    }

    public void setModel(RoomInterface.RoomSharingModel model) {
        this.iModel = model;
        if (this.iEditable && this.iModel.isNoteEditable() && this.iNote != null) {
            this.iNote.setValue((Object)(this.iModel.hasNote() ? this.iModel.getNote() : ""));
        }
        this.iModeSelection.clear();
        for (RoomInterface.RoomSharingDisplayMode mode : this.iModel.getModes()) {
            this.iModeSelection.addItem(mode.getName());
        }
        this.iModeSelection.setSelectedIndex(this.iModel.getDefaultMode());
        this.iHorizontal.setValue(Boolean.valueOf(model.isDefaultHorizontal()));
        if (this.iModeSelection.getItemCount() > 1) {
            RoomCookie cookie = RoomCookie.getInstance();
            if (cookie.hasMode()) {
                for (int i = 0; i < this.iModel.getModes().size(); ++i) {
                    if (!cookie.getMode().equals(this.iModel.getModes().get(i).toHex())) continue;
                    this.iModeSelection.setSelectedIndex(i);
                    break;
                }
                this.iHorizontal.setValue(Boolean.valueOf(cookie.areRoomsHorizontal()));
            } else {
                this.iHorizontal.setValue(Boolean.valueOf(model.isDefaultHorizontal()));
                this.iModeSelection.setSelectedIndex(this.iModel.getDefaultMode());
            }
        }
        this.iOption = this.iModel.getDefaultOption();
        if (this.iOption == null) {
            this.iOption = this.iModel.getOptions().get(0);
        }
        this.setMode(this.iModel.getModes().get(this.iModeSelection.getSelectedIndex()), this.iHorizontal.getValue());
    }

    public void setShowLegend(boolean showLegend) {
        this.iShowLegend = showLegend;
    }

    public void insert(final RootPanel panel, boolean eventAvailability) {
        Long locationId = Long.valueOf(panel.getElement().getInnerHTML().trim());
        RPC.execute(RoomInterface.RoomSharingRequest.load(locationId, eventAvailability), new AsyncCallback<RoomInterface.RoomSharingModel>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(MESSAGES.failedToLoadRoomAvailability(caught.getMessage()));
            }

            public void onSuccess(RoomInterface.RoomSharingModel result) {
                panel.getElement().setInnerText(null);
                RoomSharingWidget.this.setModel(result);
                panel.add((Widget)RoomSharingWidget.this);
                panel.setVisible(true);
            }
        });
    }

    public static String slot2short(int slot) {
        int h = slot / 12;
        int m = 5 * (slot % 12);
        if (CONSTANTS.useAmPm()) {
            return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
        }
        return h + ":" + (m < 10 ? "0" : "") + m;
    }

    protected void addPreferenceIfNeeded(P line, final RoomInterface.RoomSharingOption option) {
        if (option.hasPreference() && this.iModel.getPreferences() != null) {
            final ListBox pref = new ListBox();
            pref.setStyleName("unitime-TextBox");
            pref.addStyleName("preference");
            for (RoomInterface.PreferenceInterface p : this.iModel.getPreferences()) {
                pref.addItem(p.getName(), p.getId().toString());
            }
            SelectElement selectElement = SelectElement.as((Element)pref.getElement());
            NodeList items = selectElement.getOptions();
            for (int i = 0; i < items.getLength(); ++i) {
                RoomInterface.PreferenceInterface p = this.iModel.getPreferences().get(i);
                if (p.getColor() != null) {
                    ((OptionElement)items.getItem(i)).getStyle().setBackgroundColor(p.getColor());
                }
                if (!((OptionElement)items.getItem(i)).getValue().equals(option.getPreference().toString())) continue;
                pref.setSelectedIndex(i);
            }
            pref.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    option.setPreference(RoomSharingWidget.this.iModel.getPreferences().get(pref.getSelectedIndex()).getId());
                }
            });
            line.add((Widget)pref);
        }
    }

    public void setMode(final RoomInterface.RoomSharingDisplayMode mode, final boolean horizontal) {
        P line;
        P line2;
        this.iMode = mode;
        RoomCookie.getInstance().setMode(horizontal, mode.toHex());
        this.iPanel.clear();
        if (horizontal) {
            P previousTable = null;
            for (int page = 0; page == 0 || this.iSplit > 0 && this.iMode.getFirstSlot() + this.iSplit * page * this.iMode.getStep() < this.iMode.getLastSlot(); ++page) {
                P table = new P("table");
                this.iPanel.add((Widget)table);
                P box = new P("box");
                table.add((Widget)box);
                P header = new P("row");
                box.add((Widget)header);
                P corner = new P("cell", "corner", this.isEditable() ? "clickable" : null);
                corner.setHTML(MESSAGES.roomSharingCorner());
                header.add((Widget)corner);
                int first = this.iMode.getFirstSlot();
                int last = this.iMode.getLastSlot();
                if (this.iSplit > 0) {
                    first = this.iMode.getFirstSlot() + this.iSplit * page * this.iMode.getStep();
                    last = Math.min(first + this.iSplit * this.iMode.getStep(), this.iMode.getLastSlot());
                    if (previousTable != null) {
                        previousTable.getElement().getStyle().setDisplay(Style.Display.BLOCK);
                    }
                    previousTable = table;
                }
                ArrayList thisTime = new ArrayList();
                for (int slot = first; slot < last; slot += this.iMode.getStep()) {
                    P p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                    p.setHTML(MESSAGES.roomSharingTimeHeader(RoomSharingWidget.slot2short(slot), RoomSharingWidget.slot2short(slot + this.iMode.getStep())));
                    final ArrayList t = new ArrayList();
                    thisTime.add(t);
                    header.add((Widget)p);
                    if (!this.isEditable()) continue;
                    p.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            for (Cell d : t) {
                                d.setOption(RoomSharingWidget.this.iOption);
                            }
                        }
                    });
                }
                final ArrayList<Cell> thisPage = new ArrayList<Cell>();
                int day = this.iMode.getFirstDay();
                while (true) {
                    P line3 = new P("row");
                    box.add((Widget)line3);
                    P d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                    d.setHTML(CONSTANTS.days()[day % 7]);
                    line3.add((Widget)d);
                    final ArrayList<Cell> thisDay = new ArrayList<Cell>();
                    for (int slot = first; slot < last; slot += this.iMode.getStep()) {
                        Cell p = new Cell(day, slot);
                        line3.add((Widget)p);
                        thisDay.add(p);
                        thisPage.add(p);
                        ((List)thisTime.get((slot - first) / this.iMode.getStep())).add(p);
                    }
                    if (this.isEditable()) {
                        d.addMouseDownHandler(new MouseDownHandler(){

                            public void onMouseDown(MouseDownEvent event) {
                                for (Cell d : thisDay) {
                                    d.setOption(RoomSharingWidget.this.iOption);
                                }
                            }
                        });
                    }
                    if (day == this.iMode.getLastDay()) break;
                    day = (1 + day) % 7;
                }
                if (!this.isEditable()) continue;
                corner.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisPage) {
                            d.setOption(RoomSharingWidget.this.iOption);
                        }
                    }
                });
            }
        } else {
            P table = new P("table");
            this.iPanel.add((Widget)table);
            P box = new P("box");
            table.add((Widget)box);
            P header = new P("row");
            box.add((Widget)header);
            P corner = new P("cell", "corner", this.isEditable() ? "clickable" : null);
            corner.setHTML(MESSAGES.roomSharingCorner());
            header.add((Widget)corner);
            ArrayList thisDay = new ArrayList();
            int day = this.iMode.getFirstDay();
            int idx = 0;
            while (true) {
                P p = new P("cell", "time", this.isEditable() ? "clickable" : null);
                p.setHTML(CONSTANTS.days()[day % 7]);
                final ArrayList t = new ArrayList();
                thisDay.add(t);
                header.add((Widget)p);
                if (this.isEditable()) {
                    p.addMouseDownHandler(new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            for (Cell d : t) {
                                d.setOption(RoomSharingWidget.this.iOption);
                            }
                        }
                    });
                }
                if (day == this.iMode.getLastDay()) break;
                day = (1 + day) % 7;
                ++idx;
            }
            final ArrayList<Cell> thisPage = new ArrayList<Cell>();
            for (int slot = this.iMode.getFirstSlot(); slot < this.iMode.getLastSlot(); slot += this.iMode.getStep()) {
                line2 = new P("row");
                box.add((Widget)line2);
                P d = new P("cell", "day", this.isEditable() ? "clickable" : null);
                d.setHTML(MESSAGES.roomSharingTimeHeader(RoomSharingWidget.slot2short(slot), RoomSharingWidget.slot2short(slot + this.iMode.getStep())));
                line2.add((Widget)d);
                final ArrayList<Cell> thisSlot = new ArrayList<Cell>();
                day = this.iMode.getFirstDay();
                idx = 0;
                while (true) {
                    Cell p = new Cell(day, slot);
                    line2.add((Widget)p);
                    thisSlot.add(p);
                    thisPage.add(p);
                    ((List)thisDay.get(idx)).add(p);
                    if (day == this.iMode.getLastDay()) break;
                    day = (1 + day) % 7;
                    ++idx;
                }
                if (!this.isEditable()) continue;
                d.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisSlot) {
                            d.setOption(RoomSharingWidget.this.iOption);
                        }
                    }
                });
            }
            if (this.isEditable()) {
                corner.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        for (Cell d : thisPage) {
                            d.setOption(RoomSharingWidget.this.iOption);
                        }
                    }
                });
            }
        }
        if (!this.iShowLegend && !this.isEditable()) {
            return;
        }
        P legend = new P("legend");
        this.iPanel.add((Widget)legend);
        final P box = new P("box");
        legend.add((Widget)box);
        this.iSelectedIcon = null;
        this.iSelectedTitle = null;
        for (final RoomInterface.RoomSharingOption option : this.iModel.getOptions()) {
            line = new P("row");
            final P icon = new P("cell", this.isEditable(option) ? "clickable" : null);
            if (box.getWidgetCount() == 0) {
                icon.addStyleName("first");
            }
            if (option.getCode() != null && !option.getCode().isEmpty()) {
                icon.setHTML(option.getCode());
            }
            icon.getElement().getStyle().setBackgroundColor(option.getColor());
            line.add((Widget)icon);
            final P title = new P("title", this.isEditable(option) ? "editable-title" : null);
            title.setHTML(option.getName());
            line.add((Widget)title);
            this.addPreferenceIfNeeded(line, option);
            if (option.getId() >= 0L && this.isDeletable(option)) {
                Image remove = new Image(RESOURCES.delete());
                remove.addStyleName("remove");
                line.add((Widget)remove);
                remove.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (option.equals(RoomSharingWidget.this.iOption)) {
                            RoomSharingWidget.this.iOption = RoomSharingWidget.this.iModel.getDefaultOption();
                        }
                        box.remove((Widget)line);
                        RoomSharingWidget.this.iModel.getOptions().remove(option);
                        RoomSharingWidget.this.setMode(mode, horizontal);
                    }
                });
            }
            if (this.isEditable(option) && option.equals(this.iOption)) {
                icon.addStyleName("selected");
                title.addStyleName("selected-title");
                this.iSelectedIcon = icon;
                this.iSelectedTitle = title;
            }
            if (this.isEditable(option)) {
                MouseDownHandler md = new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        RoomSharingWidget.this.iOption = option;
                        if (RoomSharingWidget.this.iSelectedIcon != null) {
                            RoomSharingWidget.this.iSelectedIcon.removeStyleName("selected");
                        }
                        if (RoomSharingWidget.this.iSelectedTitle != null) {
                            RoomSharingWidget.this.iSelectedTitle.removeStyleName("selected-title");
                        }
                        icon.addStyleName("selected");
                        title.addStyleName("selected-title");
                        RoomSharingWidget.this.iSelectedIcon = icon;
                        RoomSharingWidget.this.iSelectedTitle = title;
                    }
                };
                icon.addMouseDownHandler(md);
                title.addMouseDownHandler(md);
            }
            box.add((Widget)line);
        }
        if (this.iEditable && this.iModel.isNoteEditable() && this.iNote != null) {
            note = new P("note");
            legend.add((Widget)note);
            label = new P("label");
            label.setText(MESSAGES.propRoomAvailabilityNote());
            note.add((Widget)label);
            value = new P("value");
            value.add((Widget)this.iNote);
            note.add((Widget)value);
        } else if (this.iModel.hasNote()) {
            note = new P("note");
            legend.add((Widget)note);
            label = new P("label");
            label.setText(MESSAGES.propRoomAvailabilityNote());
            note.add((Widget)label);
            value = new P("value");
            value.setHTML(this.iModel.getNote());
            note.add((Widget)value);
        }
        final List<RoomInterface.RoomSharingOption> other = this.iModel.getAdditionalOptions();
        final List<RoomInterface.RoomSharingOption> removable = this.iModel.getRemovableOptions();
        if (!(!this.isEditable() || other.isEmpty() && removable.isEmpty())) {
            if (!other.isEmpty() && other.size() <= 20) {
                P separator = new P("row");
                separator.add((Widget)new P("blank"));
                P message = new P("other");
                message.setHTML(MESSAGES.separatorAddDepartment());
                separator.add((Widget)message);
                box.add((Widget)separator);
                boolean first = true;
                for (final RoomInterface.RoomSharingOption option : other) {
                    line2 = new P("row");
                    P icon = new P("cell", "clickable");
                    if (option.getCode() != null && !option.getCode().isEmpty()) {
                        icon.setHTML(option.getCode());
                    }
                    if (first) {
                        icon.addStyleName("first");
                    }
                    first = false;
                    icon.getElement().getStyle().setBackgroundColor(option.getColor());
                    line2.add((Widget)icon);
                    P title = new P("title", "editable-title");
                    title.setHTML(option.getName());
                    line2.add((Widget)title);
                    Image add = new Image(RESOURCES.add());
                    add.addStyleName("remove");
                    line2.add((Widget)add);
                    add.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            RoomSharingWidget.this.iModel.getOptions().add(option);
                            RoomSharingWidget.this.iOption = option;
                            RoomSharingWidget.this.setMode(mode, horizontal);
                        }
                    });
                    MouseDownHandler md = new MouseDownHandler(){

                        public void onMouseDown(MouseDownEvent event) {
                            RoomSharingWidget.this.iModel.getOptions().add(option);
                            RoomSharingWidget.this.iOption = option;
                            RoomSharingWidget.this.setMode(mode, horizontal);
                        }
                    };
                    icon.addMouseDownHandler(md);
                    title.addMouseDownHandler(md);
                    box.add((Widget)line2);
                }
            }
            if (other.size() >= 20 || removable.size() >= 10) {
                line = new P("row");
                line.add((Widget)new P("blank"));
                P p = new P("button");
                if (other.size() >= 20) {
                    Button button = new Button(MESSAGES.buttonRoomSharingAddDepartment(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            final UniTimeDialogBox dialog = new UniTimeDialogBox(true, false);
                            dialog.setText(MESSAGES.dialogAddDepartment());
                            dialog.setAnimationEnabled(false);
                            dialog.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                                public void onClose(CloseEvent<PopupPanel> event) {
                                    RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.AUTO);
                                }
                            });
                            SimpleForm form = new SimpleForm();
                            final TextBox text = new TextBox();
                            text.setStyleName("unitime-TextArea");
                            text.setWidth("300px");
                            form.addRow(MESSAGES.propFilter(), (Widget)text);
                            final P box = new P("box");
                            final Timer filterTimer = new Timer(){

                                public void run() {
                                    String f = text.getText();
                                    boolean first = true;
                                    for (int i = 0; i < other.size(); ++i) {
                                        P line = (P)box.getWidget(i);
                                        line.setVisible(RoomSharingWidget.this.match(f, (RoomInterface.RoomSharingOption)other.get(i)));
                                        if (first && line.isVisible()) {
                                            ((P)line.getWidget(0)).addStyleName("first");
                                            first = false;
                                            continue;
                                        }
                                        ((P)line.getWidget(0)).removeStyleName("first");
                                    }
                                }
                            };
                            text.addKeyUpHandler(new KeyUpHandler(){

                                public void onKeyUp(KeyUpEvent event) {
                                    filterTimer.schedule(250);
                                    if (event.getNativeKeyCode() == 13) {
                                        String f = text.getText();
                                        for (RoomInterface.RoomSharingOption option : other) {
                                            if (!RoomSharingWidget.this.match(f, option)) continue;
                                            RoomSharingWidget.this.iModel.getOptions().add(option);
                                            RoomSharingWidget.this.iOption = option;
                                            break;
                                        }
                                        dialog.hide();
                                        RoomSharingWidget.this.setMode(mode, horizontal);
                                        return;
                                    }
                                    if (event.getNativeKeyCode() == 27) {
                                        dialog.hide();
                                        return;
                                    }
                                }
                            });
                            P legend = new P("legend");
                            legend.add((Widget)box);
                            for (final RoomInterface.RoomSharingOption option : other) {
                                P line = new P("row");
                                P icon = new P("cell", "clickable");
                                if (option.getCode() != null && !option.getCode().isEmpty()) {
                                    icon.setHTML(option.getCode());
                                }
                                if (box.getWidgetCount() == 0) {
                                    icon.addStyleName("first");
                                }
                                icon.getElement().getStyle().setBackgroundColor(option.getColor());
                                line.add((Widget)icon);
                                P title = new P("title", "editable-title");
                                title.setHTML(option.getName());
                                line.add((Widget)title);
                                ClickHandler md = new ClickHandler(){

                                    public void onClick(ClickEvent event) {
                                        RoomSharingWidget.this.iModel.getOptions().add(option);
                                        dialog.hide();
                                        RoomSharingWidget.this.iOption = option;
                                        RoomSharingWidget.this.setMode(mode, horizontal);
                                    }
                                };
                                icon.addClickHandler(md);
                                title.addClickHandler(md);
                                box.add((Widget)line);
                            }
                            ScrollPanel w = new ScrollPanel();
                            w.addStyleName("scroll");
                            w.addStyleName("unitime-RoomSharingWidget");
                            w.add((Widget)legend);
                            if (other.size() >= 12) {
                                w.setHeight("300px");
                            }
                            int r = form.addRow((Widget)w);
                            form.getCellFormatter().addStyleName(r, 0, "unitime-TopLine");
                            UniTimeHeaderPanel footer = new UniTimeHeaderPanel();
                            footer.addButton("add", MESSAGES.buttonAddAllDepartments(), new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    String f = text.getText();
                                    for (RoomInterface.RoomSharingOption option : other) {
                                        if (!RoomSharingWidget.this.match(f, option)) continue;
                                        RoomSharingWidget.this.iModel.getOptions().add(option);
                                        RoomSharingWidget.this.iOption = option;
                                    }
                                    dialog.hide();
                                    RoomSharingWidget.this.setMode(mode, horizontal);
                                }
                            });
                            footer.addButton("close", MESSAGES.buttonClose(), new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    dialog.hide();
                                }
                            });
                            form.addBottomRow((Widget)footer);
                            dialog.setWidget((Widget)form);
                            RootPanel.getBodyElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
                            dialog.center();
                            text.setFocus(true);
                        }
                    });
                    Character ch = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonRoomSharingAddDepartment());
                    if (ch != null) {
                        button.setAccessKey(ch.charValue());
                    }
                    p.add((Widget)button);
                }
                if (removable.size() >= 10) {
                    Button button = new Button(MESSAGES.buttonRemoveAll(), new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            RoomSharingWidget.this.iModel.getOptions().removeAll(removable);
                            if (removable.contains(RoomSharingWidget.this.iOption)) {
                                RoomSharingWidget.this.iOption = RoomSharingWidget.this.iModel.getDefaultOption();
                            }
                            RoomSharingWidget.this.setMode(mode, horizontal);
                        }
                    });
                    Character ch = UniTimeHeaderPanel.guessAccessKey(MESSAGES.buttonRemoveAll());
                    if (ch != null) {
                        button.setAccessKey(ch.charValue());
                    }
                    button.getElement().getStyle().setMarginLeft(4.0, Style.Unit.PX);
                    p.add((Widget)button);
                }
                line.add((Widget)p);
                box.add((Widget)line);
            }
        }
    }

    protected boolean match(String filter, RoomInterface.RoomSharingOption option) {
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        block0: for (String fw : filter.split(" ")) {
            if (option.getCode() != null && option.getCode().startsWith(fw)) continue;
            if (option.getName() != null && !option.getName().isEmpty()) {
                for (String w : option.getName().split(" ")) {
                    if (w.toLowerCase().startsWith(fw.toLowerCase())) continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<RoomInterface.RoomSharingModel> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public RoomInterface.RoomSharingModel getValue() {
        return this.getModel();
    }

    public void setValue(RoomInterface.RoomSharingModel value) {
        this.setValue(value, false);
    }

    public void setValue(RoomInterface.RoomSharingModel value, boolean fireEvents) {
        this.setModel(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public boolean removeOption(Long id) {
        if (!this.isEditable() || this.iModel == null) {
            return false;
        }
        RoomInterface.RoomSharingOption option = this.iModel.getOption(id);
        if (option != null && option.getId() > 0L && option.isEditable() && this.iAddedOptions.remove(id) && this.iModel.countOptions(id) == 0) {
            this.iModel.getOptions().remove(option);
            this.iOption = this.iModel.getDefaultOption();
            this.setMode(this.iMode, this.iHorizontal.getValue());
            return true;
        }
        return false;
    }

    public boolean addOption(Long optionId) {
        if (!this.isEditable() || this.iModel == null) {
            return false;
        }
        for (RoomInterface.RoomSharingOption option : this.iModel.getAdditionalOptions()) {
            if (!option.getId().equals(optionId) || !option.isEditable()) continue;
            this.iAddedOptions.add(optionId);
            this.iModel.getOptions().add(option);
            this.iOption = option;
            this.setMode(this.iMode, this.iHorizontal.getValue());
            return true;
        }
        return false;
    }

    public class Cell
    extends P {
        private int iDay;
        private int iSlot;

        Cell(int day, int slot) {
            super("cell", "item", RoomSharingWidget.this.isEditable(day, slot) ? "clickable" : null);
            this.iDay = day;
            this.iSlot = slot;
            RoomInterface.RoomSharingOption option = RoomSharingWidget.this.iModel.getOption(day, slot);
            if (option == null) {
                this.getElement().getStyle().clearBackgroundColor();
                this.setHTML("");
                this.setTitle("");
            } else {
                this.getElement().getStyle().setBackgroundColor(option.getColor());
                this.setHTML(option.getCode() == null ? "" : option.getCode());
                this.setTitle(CONSTANTS.longDays()[day] + " " + RoomSharingWidget.slot2short(slot) + " - " + RoomSharingWidget.slot2short(slot + RoomSharingWidget.this.iMode.getStep()) + ": " + option.getName());
            }
            if (RoomSharingWidget.this.isEditable(day, slot)) {
                this.addMouseDownHandler(new MouseDownHandler(){

                    public void onMouseDown(MouseDownEvent event) {
                        Cell.this.setOption(RoomSharingWidget.this.iOption);
                    }
                });
            }
        }

        public void setOption(RoomInterface.RoomSharingOption option) {
            if (!RoomSharingWidget.this.isEditable(this.iDay, this.iSlot)) {
                return;
            }
            RoomSharingWidget.this.iModel.setOption(this.iDay, this.iSlot, RoomSharingWidget.this.iMode.getStep(), option);
            if (option == null) {
                this.getElement().getStyle().clearBackgroundColor();
                this.setHTML("");
                this.setTitle("");
            } else {
                this.getElement().getStyle().setBackgroundColor(option.getColor());
                this.setHTML(option.getCode() == null ? "" : option.getCode());
                this.setTitle(CONSTANTS.longDays()[this.iDay] + " " + RoomSharingWidget.slot2short(this.iSlot) + " - " + RoomSharingWidget.slot2short(this.iSlot + RoomSharingWidget.this.iMode.getStep()) + ": " + option.getName());
            }
            ValueChangeEvent.fire((HasValueChangeHandlers)RoomSharingWidget.this, (Object)RoomSharingWidget.this.getValue());
        }

        public int getDay() {
            return this.iDay;
        }

        public int getSlot() {
            return this.iSlot;
        }
    }
}

