/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaButton;
import org.unitime.timetable.gwt.client.events.AcademicSessionSelectionBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomFilterBox;
import org.unitime.timetable.gwt.client.rooms.RoomGroupEdit;
import org.unitime.timetable.gwt.client.rooms.RoomGroupsComparator;
import org.unitime.timetable.gwt.client.rooms.RoomGroupsTable;
import org.unitime.timetable.gwt.client.rooms.RoomHint;
import org.unitime.timetable.gwt.client.rooms.RoomsPage;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.FilterBox;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomGroupsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private AcademicSessionProvider iSession = null;
    private RoomFilterBox iFilter = null;
    private AriaButton iSearch = null;
    private AriaButton iNew = null;
    private AriaButton iMore = null;
    private SimpleForm iGroupsPanel = null;
    private SimplePanel iRootPanel;
    private SimplePanel iPanel = null;
    private HorizontalPanel iFilterPanel = null;
    private RoomInterface.RoomPropertiesInterface iProperties = null;
    private UniTimeHeaderPanel iGlobalGroupsHeader = null;
    private RoomGroupsTable iGlobalGroupsTable = null;
    private int iGlobalGroupsRow = -1;
    private UniTimeHeaderPanel iDepartmentalGroupsHeader = null;
    private RoomGroupsTable iDepartmentalGroupsTable = null;
    private int iDepartmentalGroupsRow = -1;
    private RoomInterface.RoomsPageMode iMode = RoomInterface.RoomsPageMode.COURSES;
    private UniTimeHeaderPanel iHeaderPanel = null;
    private RoomsPage.HistoryToken iHistoryToken = null;
    private RoomGroupEdit iRoomGroupEdit = null;
    private boolean iInitialized = false;

    public RoomGroupsPage() {
        if (Window.Location.getParameter((String)"mode") != null) {
            this.iMode = RoomInterface.RoomsPageMode.valueOf(Window.Location.getParameter((String)"mode").toUpperCase());
        }
        this.iHistoryToken = new RoomsPage.HistoryToken(this.iMode);
        this.iPanel = new SimplePanel();
        this.iGroupsPanel = new SimpleForm();
        this.iGroupsPanel.setWidth("100%");
        ClickHandler clickSearch = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomGroupsPage.this.changeUrl();
                RoomGroupsPage.this.search(null);
            }
        };
        ClickHandler clickMore = new ClickHandler(){

            public void onClick(ClickEvent event) {
                final PopupPanel popup = new PopupPanel(true);
                UniTimeTableHeader.MenuBarWithAccessKeys menu = new UniTimeTableHeader.MenuBarWithAccessKeys();
                if (RoomGroupsPage.this.iProperties != null && RoomGroupsPage.this.iProperties.isCanSaveFilterDefaults()) {
                    MenuItem item = new MenuItem(MESSAGES.buttonClear(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomGroupsPage.this.iFilter.setValue(RoomGroupsPage.this.iHistoryToken.getDefaultParameter("q", ""), true);
                            RoomGroupsPage.this.hideResults();
                            RoomGroupsPage.this.changeUrl();
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(MESSAGES.buttonClear()));
                    menu.addItem(item);
                    menu.addSeparator();
                }
                MenuBar sortItems = new MenuBar(true);
                for (final RoomInterface.RoomGroupsColumn column : RoomInterface.RoomGroupsColumn.values()) {
                    if (!RoomGroupsComparator.isApplicable(column) || (RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() <= 1 || RoomGroupsPage.this.iGlobalGroupsTable.getNbrCells(column) == 0) && (RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() <= 1 || RoomGroupsPage.this.iDepartmentalGroupsTable.getNbrCells(column) == 0)) continue;
                    String name = RoomGroupsPage.this.iGlobalGroupsTable.getColumnName(column, 0).replace("<br>", " ");
                    MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            int sortBy = RoomCookie.getInstance().getRoomGroupsSortBy();
                            sortBy = sortBy == 1 + column.ordinal() || sortBy == -1 - column.ordinal() ? -sortBy : 1 + column.ordinal();
                            RoomCookie.getInstance().setSortRoomGroupsBy(sortBy);
                            RoomGroupsPage.this.iGlobalGroupsTable.setSortBy(sortBy);
                            RoomGroupsPage.this.iDepartmentalGroupsTable.setSortBy(sortBy);
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), UniTimeHeaderPanel.stripAccessKey(MESSAGES.opSortBy(name)));
                    sortItems.addItem(item);
                }
                MenuItem sortMenu = new MenuItem(MESSAGES.opSort(), sortItems);
                sortMenu.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(sortMenu);
                MenuBar deptItems = new MenuBar(true);
                for (final RoomsTable.DeptMode d : RoomsTable.DeptMode.values()) {
                    String name = RoomCookie.getInstance().getDeptMode() == d.ordinal() ? MESSAGES.opUncheck(d.getName()) : MESSAGES.opCheck(d.getName());
                    MenuItem item = new MenuItem(name, true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomCookie.getInstance().setDeptMode(d.ordinal());
                            RoomGroupsPage.this.iGlobalGroupsTable.refreshTable();
                            RoomGroupsPage.this.iDepartmentalGroupsTable.refreshTable();
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)item.getElement(), d.getName());
                    deptItems.addItem(item);
                }
                MenuItem deptMenu = new MenuItem(MESSAGES.opDepartmentFormat(), deptItems);
                deptMenu.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                menu.addItem(deptMenu);
                if (RoomGroupsPage.this.iProperties.isCanExportRoomGroups()) {
                    menu.addSeparator();
                    MenuItem exportPdf = new MenuItem(MESSAGES.opExportPDF(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomGroupsPage.this.export("roomgroups.pdf");
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)exportPdf.getElement(), MESSAGES.opExportPDF());
                    menu.addItem(exportPdf);
                    MenuItem exportCsv = new MenuItem(MESSAGES.opExportCSV(), true, (Scheduler.ScheduledCommand)new Command(){

                        public void execute() {
                            popup.hide();
                            RoomGroupsPage.this.export("roomgroups.csv");
                        }
                    });
                    Roles.getMenuitemRole().setAriaLabelProperty((Element)exportCsv.getElement(), MESSAGES.opExportCSV());
                    menu.addItem(exportCsv);
                }
                popup.add((Widget)menu);
                popup.showRelativeTo((UIObject)event.getSource());
                menu.focus();
            }
        };
        ClickHandler clickNew = new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomGroupsPage.this.edit(null);
            }
        };
        this.iRoomGroupEdit = new RoomGroupEdit(this.iMode){

            @Override
            protected void onShow() {
                RoomHint.hideHint();
                RoomGroupsPage.this.iRootPanel.setWidget((Widget)RoomGroupsPage.this.iRoomGroupEdit);
                RoomGroupsPage.this.changeUrl();
            }

            @Override
            protected void onHide(boolean refresh, RoomInterface.GroupInterface group) {
                RoomGroupsPage.this.iRootPanel.setWidget((Widget)RoomGroupsPage.this.iGroupsPanel);
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageRoomGroups());
                RoomGroupsPage.this.changeUrl();
                if (refresh && (RoomGroupsPage.this.iGroupsPanel.getRowFormatter().isVisible(RoomGroupsPage.this.iGlobalGroupsRow) || RoomGroupsPage.this.iGroupsPanel.getRowFormatter().isVisible(RoomGroupsPage.this.iDepartmentalGroupsRow))) {
                    RoomGroupsPage.this.search(group == null ? null : group.getId());
                }
            }
        };
        if (this.iMode.hasSessionSelection()) {
            this.iHeaderPanel = new UniTimeHeaderPanel(MESSAGES.sectFilter());
            this.iGroupsPanel.addHeaderRow((Widget)this.iHeaderPanel);
            this.iSession = new AcademicSessionSelectionBox(this.iHistoryToken.getParameter("term"), "RoomGroups"){

                @Override
                protected void onInitializationSuccess(List<AcademicSessionSelectionBox.AcademicSession> sessions) {
                    UniTimePageHeader.getInstance().getRight().setVisible(false);
                    UniTimePageHeader.getInstance().getRight().setPreventDefault(true);
                    RoomGroupsPage.this.setup(this.getAcademicSessionId(), CONSTANTS.searchWhenPageIsLoaded() && (RoomGroupsPage.this.iHistoryToken.hasParameter("id") || RoomGroupsPage.this.iHistoryToken.hasParameter("q")));
                }

                @Override
                protected void onInitializationFailure(Throwable caught) {
                    UniTimeNotifications.error(MESSAGES.failedLoadSessions(caught.getMessage()), caught);
                }
            };
            this.iSession.addAcademicSessionChangeHandler(new AcademicSessionProvider.AcademicSessionChangeHandler(){

                @Override
                public void onAcademicSessionChange(AcademicSessionProvider.AcademicSessionChangeEvent event) {
                    RoomGroupsPage.this.setup(event.getNewAcademicSessionId(), RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() > 1 || RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() > 1);
                }
            });
            this.iGroupsPanel.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSession);
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iGroupsPanel.addRow(MESSAGES.propRoomFilter(), (Widget)this.iFilter);
            this.iHeaderPanel.addButton("search", MESSAGES.buttonSearch(), clickSearch);
            this.iHeaderPanel.addButton("more", MESSAGES.buttonMoreOperations(), clickMore);
            this.iHeaderPanel.addButton("new", MESSAGES.buttonAddNewRoom(), clickNew);
            this.iHeaderPanel.setEnabled("more", false);
            this.iHeaderPanel.setEnabled("new", false);
        } else {
            this.iFilterPanel = new HorizontalPanel();
            this.iFilterPanel.setSpacing(3);
            Label filterLabel = new Label(MESSAGES.propFilter());
            this.iFilterPanel.add((Widget)filterLabel);
            this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
            this.iSession = new Session();
            this.iFilter = new RoomFilterBox(this.iSession);
            this.iFilterPanel.add((Widget)this.iFilter);
            this.iSearch = new AriaButton(MESSAGES.buttonSearch());
            this.iSearch.addStyleName("unitime-NoPrint");
            this.iSearch.addClickHandler(clickSearch);
            this.iFilterPanel.add((Widget)this.iSearch);
            this.iMore = new AriaButton(MESSAGES.buttonMoreOperations());
            this.iMore.setEnabled(false);
            this.iMore.addStyleName("unitime-NoPrint");
            this.iMore.addClickHandler(clickMore);
            this.iFilterPanel.add((Widget)this.iMore);
            this.iNew = new AriaButton(MESSAGES.buttonAddNewRoomGroup());
            this.iNew.setEnabled(false);
            this.iNew.addStyleName("unitime-NoPrint");
            this.iNew.addClickHandler(clickNew);
            this.iFilterPanel.add((Widget)this.iNew);
            int filterRow = this.iGroupsPanel.addRow((Widget)this.iFilterPanel);
            this.iGroupsPanel.getCellFormatter().setHorizontalAlignment(filterRow, 0, HasHorizontalAlignment.ALIGN_CENTER);
            this.setup(null, CONSTANTS.searchWhenPageIsLoaded() && (this.iHistoryToken.hasParameter("id") || this.iHistoryToken.hasParameter("q")));
        }
        this.iGlobalGroupsHeader = new UniTimeHeaderPanel(MESSAGES.headerGlobalRoomGroups());
        this.iGlobalGroupsRow = this.iGroupsPanel.addHeaderRow((Widget)this.iGlobalGroupsHeader);
        this.iGlobalGroupsTable = new RoomGroupsTable(true){

            @Override
            protected void doSort(RoomInterface.RoomGroupsColumn column) {
                super.doSort(column);
                RoomGroupsPage.this.iDepartmentalGroupsTable.setSortBy(RoomCookie.getInstance().getRoomGroupsSortBy());
            }
        };
        this.iGroupsPanel.addRow((Widget)this.iGlobalGroupsTable);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iGlobalGroupsRow, false);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iGlobalGroupsRow + 1, false);
        this.iDepartmentalGroupsHeader = new UniTimeHeaderPanel(MESSAGES.headerDepartmentalRoomGroups());
        this.iDepartmentalGroupsRow = this.iGroupsPanel.addHeaderRow((Widget)this.iDepartmentalGroupsHeader);
        this.iDepartmentalGroupsTable = new RoomGroupsTable(false){

            @Override
            protected void doSort(RoomInterface.RoomGroupsColumn column) {
                super.doSort(column);
                RoomGroupsPage.this.iGlobalGroupsTable.setSortBy(RoomCookie.getInstance().getRoomGroupsSortBy());
            }
        };
        this.iGroupsPanel.addRow((Widget)this.iDepartmentalGroupsTable);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iDepartmentalGroupsRow, false);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iDepartmentalGroupsRow + 1, false);
        this.iRootPanel = new SimplePanel((Widget)this.iGroupsPanel);
        this.iPanel.setWidget((Widget)this.iRootPanel);
        this.iGlobalGroupsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.GroupInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.GroupInterface> event) {
                if (event.getData() != null && (event.getData().canDelete() || event.getData().canEdit())) {
                    RoomGroupsPage.this.edit(event.getData());
                }
            }
        });
        this.iDepartmentalGroupsTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.GroupInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.GroupInterface> event) {
                if (event.getData() != null && (event.getData().canDelete() || event.getData().canEdit())) {
                    RoomGroupsPage.this.edit(event.getData());
                }
            }
        });
        this.initWidget((Widget)this.iPanel);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (!RoomGroupsPage.this.iInitialized) {
                    return;
                }
                RoomGroupsPage.this.iHistoryToken.reset((String)event.getValue());
                RoomGroupsPage.this.updateFilter(RoomGroupsPage.this.iGroupsPanel.getRowFormatter().isVisible(RoomGroupsPage.this.iGlobalGroupsRow) || RoomGroupsPage.this.iGroupsPanel.getRowFormatter().isVisible(RoomGroupsPage.this.iDepartmentalGroupsRow));
            }
        });
    }

    protected void edit(RoomInterface.GroupInterface group) {
        if (this.iRoomGroupEdit == null) {
            return;
        }
        FilterBox.Chip dept = this.iFilter.getChip("department");
        this.iRoomGroupEdit.setGroup(group, dept == null ? null : dept.getValue());
        LoadingWidget.execute(this.iFilter.getElementsRequest(), new AsyncCallback<EventInterface.FilterRpcResponse>(){

            public void onFailure(Throwable caught) {
                RoomGroupsPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRooms(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadRooms(caught.getMessage()), caught);
            }

            public void onSuccess(EventInterface.FilterRpcResponse result) {
                RoomGroupsPage.this.iFilter.clearHint();
                if (result == null || result.getResults() == null || result.getResults().isEmpty()) {
                    RoomGroupsPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomsMatchingFilter());
                } else {
                    RoomGroupsPage.this.iRoomGroupEdit.setRooms(result.getResults());
                    RoomGroupsPage.this.iRoomGroupEdit.show();
                }
            }
        }, MESSAGES.waitLoadingRooms());
    }

    protected void setup(final Long sessionId, final boolean search) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        RPC.execute(new RoomInterface.RoomPropertiesRequest(sessionId, this.iMode.name()), new AsyncCallback<RoomInterface.RoomPropertiesInterface>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                RoomGroupsPage.this.iFilter.setErrorHint(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(RoomInterface.RoomPropertiesInterface result) {
                LoadingWidget.getInstance().hide();
                RoomGroupsPage.this.iProperties = result;
                RoomGroupsPage.this.iRoomGroupEdit.setProperties(RoomGroupsPage.this.iProperties);
                if (RoomGroupsPage.this.iProperties.isCanSaveFilterDefaults()) {
                    RoomGroupsPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    RoomGroupsPage.this.iFilter.setDefaultValueProvider(new TakesValue<String>(){

                        public void setValue(final String value) {
                            RPC.execute(new EventInterface.SaveFilterDefaultRpcRequest(RoomGroupsPage.this.iMode.name() + ".filter", RoomGroupsPage.this.iFilter.getValue()), new AsyncCallback<GwtRpcResponse>(){

                                public void onFailure(Throwable caught) {
                                    UniTimeNotifications.error(MESSAGES.failedSaveAsDefault(caught.getMessage()), caught);
                                }

                                public void onSuccess(GwtRpcResponse result) {
                                    RoomGroupsPage.this.iHistoryToken.setDefaultParameter("q", value);
                                }
                            });
                        }

                        public String getValue() {
                            return RoomGroupsPage.this.iHistoryToken.getDefaultParameter("q", "");
                        }
                    });
                } else {
                    if (result.hasFilterDefault("filter")) {
                        RoomGroupsPage.this.iHistoryToken.setDefaultParameter("q", result.getFilterDefault("filter"));
                    }
                    RoomGroupsPage.this.iFilter.setDefaultValueProvider(null);
                }
                if (RoomGroupsPage.this.iSession instanceof Session) {
                    ((Session)RoomGroupsPage.this.iSession).fireChange();
                }
                if (RoomGroupsPage.this.iNew != null) {
                    RoomGroupsPage.this.iNew.setEnabled(RoomGroupsPage.this.iProperties.isCanAddDepartmentalRoomGroup() || RoomGroupsPage.this.iProperties.isCanAddGlobalRoomGroup());
                }
                if (RoomGroupsPage.this.iHeaderPanel != null) {
                    RoomGroupsPage.this.iHeaderPanel.setEnabled("new", RoomGroupsPage.this.iProperties.isCanAddDepartmentalRoomGroup() || RoomGroupsPage.this.iProperties.isCanAddGlobalRoomGroup());
                }
                if (sessionId != null && RoomGroupsPage.this.iSession instanceof AcademicSessionSelectionBox) {
                    RoomGroupsPage.this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)RoomGroupsPage.this.iSession).getAcademicSessionAbbreviation());
                    RoomGroupsPage.this.iHistoryToken.mark();
                }
                RoomGroupsPage.this.updateFilter(search);
                RoomGroupsPage.this.iInitialized = true;
            }
        });
    }

    protected void updateFilter(boolean search) {
        this.iFilter.setValue(this.iHistoryToken.getParameter("q"), true);
        if (this.iSession instanceof AcademicSessionSelectionBox && this.iHistoryToken.isChanged("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation()) && this.iHistoryToken.getParameter("term") != null) {
            ((AcademicSessionSelectionBox)this.iSession).selectSession(this.iHistoryToken.getParameter("term"), null);
        }
        if (this.iHistoryToken.hasParameter("id")) {
            String id = this.iHistoryToken.getParameter("id");
            if ("add".equals(id)) {
                if (this.iProperties != null && (this.iProperties.isCanAddDepartmentalRoomGroup() || this.iProperties.isCanAddGlobalRoomGroup())) {
                    this.edit(null);
                }
            } else {
                if (this.iGlobalGroupsTable != null) {
                    for (RoomInterface.GroupInterface g : this.iGlobalGroupsTable.getData()) {
                        if (!g.getId().toString().equals(id) || !g.canEdit() && !g.canDelete()) continue;
                        this.edit(g);
                    }
                }
                if (this.iDepartmentalGroupsTable != null) {
                    for (RoomInterface.GroupInterface g : this.iDepartmentalGroupsTable.getData()) {
                        if (!g.getId().toString().equals(id) || !g.canEdit() && !g.canDelete()) continue;
                        this.edit(g);
                    }
                }
            }
        } else if (((Object)((Object)this.iRoomGroupEdit)).equals(this.iRootPanel.getWidget())) {
            this.iRoomGroupEdit.hide();
        } else if (search) {
            this.search(null);
        }
    }

    protected void changeUrl() {
        this.iHistoryToken.reset(null);
        if (this.iSession instanceof AcademicSessionSelectionBox) {
            this.iHistoryToken.setParameter("term", ((AcademicSessionSelectionBox)this.iSession).getAcademicSessionAbbreviation());
        }
        if (((Object)((Object)this.iRoomGroupEdit)).equals(this.iRootPanel.getWidget())) {
            this.iHistoryToken.setParameter("id", this.iRoomGroupEdit.getGroup() == null || this.iRoomGroupEdit.getGroup().getId() == null ? "add" : this.iRoomGroupEdit.getGroup().getId().toString());
        }
        this.iHistoryToken.setParameter("q", this.iFilter.getValue());
        this.iHistoryToken.mark();
        Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
    }

    protected void hideResults() {
        if (this.iMore != null) {
            this.iMore.setEnabled(false);
        }
        if (this.iHeaderPanel != null) {
            this.iHeaderPanel.setEnabled("more", false);
        }
        this.iGlobalGroupsTable.clearTable(1);
        this.iDepartmentalGroupsTable.clearTable(1);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iGlobalGroupsRow, false);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iGlobalGroupsRow + 1, false);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iDepartmentalGroupsRow, false);
        this.iGroupsPanel.getRowFormatter().setVisible(this.iDepartmentalGroupsRow + 1, false);
    }

    protected void search(final Long groupId) {
        this.hideResults();
        RoomInterface.SearchRoomGroupsRequest request = new RoomInterface.SearchRoomGroupsRequest(this.iProperties.getAcademicSessionId());
        request.setFilter((EventInterface.RoomFilterRpcRequest)this.iFilter.getElementsRequest());
        LoadingWidget.execute(request, new AsyncCallback<GwtRpcResponseList<RoomInterface.GroupInterface>>(){

            public void onFailure(Throwable caught) {
                RoomGroupsPage.this.iFilter.setErrorHint(MESSAGES.failedToLoadRoomGroups(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadRoomGroups(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<RoomInterface.GroupInterface> result) {
                RoomGroupsPage.this.iFilter.clearHint();
                if (result == null || result.isEmpty()) {
                    RoomGroupsPage.this.iFilter.setErrorHint(MESSAGES.errorNoRoomGroups());
                } else {
                    FilterBox.Chip dept = RoomGroupsPage.this.iFilter.getChip("department");
                    boolean skipDepartmental = false;
                    RoomInterface.RoomPropertyInterface department = null;
                    if (dept != null) {
                        for (RoomInterface.ExamTypeInterface type : RoomGroupsPage.this.iProperties.getExamTypes()) {
                            if (!type.getReference().equals(dept.getValue())) continue;
                            skipDepartmental = true;
                            break;
                        }
                        for (RoomInterface.DepartmentInterface d : RoomGroupsPage.this.iProperties.getDepartments()) {
                            if (!dept.getValue().equals(d.getDeptCode())) continue;
                            department = d;
                            break;
                        }
                    }
                    for (RoomInterface.GroupInterface group : result) {
                        if (group.isDepartmental()) {
                            if (skipDepartmental || department != null && !department.equals(group.getDepartment()) || dept == null && !group.hasRooms()) continue;
                            RoomGroupsPage.this.iDepartmentalGroupsTable.addGroup(group);
                            continue;
                        }
                        RoomGroupsPage.this.iGlobalGroupsTable.addGroup(group);
                    }
                    RoomGroupsPage.this.iDepartmentalGroupsTable.sort();
                    RoomGroupsPage.this.iGlobalGroupsTable.sort();
                }
                if (RoomGroupsPage.this.iMore != null) {
                    RoomGroupsPage.this.iMore.setEnabled(RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() > 1 || RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() > 1);
                }
                if (RoomGroupsPage.this.iHeaderPanel != null) {
                    RoomGroupsPage.this.iHeaderPanel.setEnabled("more", RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() > 1 || RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() > 1);
                }
                RoomGroupsPage.this.iGroupsPanel.getRowFormatter().setVisible(RoomGroupsPage.this.iGlobalGroupsRow, RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() > 1);
                RoomGroupsPage.this.iGroupsPanel.getRowFormatter().setVisible(RoomGroupsPage.this.iGlobalGroupsRow + 1, RoomGroupsPage.this.iGlobalGroupsTable.getRowCount() > 1);
                RoomGroupsPage.this.iGroupsPanel.getRowFormatter().setVisible(RoomGroupsPage.this.iDepartmentalGroupsRow, RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() > 1);
                RoomGroupsPage.this.iGroupsPanel.getRowFormatter().setVisible(RoomGroupsPage.this.iDepartmentalGroupsRow + 1, RoomGroupsPage.this.iDepartmentalGroupsTable.getRowCount() > 1);
                RoomGroupsPage.this.iGlobalGroupsTable.scrollTo(groupId);
                RoomGroupsPage.this.iDepartmentalGroupsTable.scrollTo(groupId);
            }
        }, MESSAGES.waitLoadingRoomGroups());
    }

    protected void export(String format) {
        RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(this.query(format)), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
            }
        });
    }

    protected String query(String format) {
        Object rooms;
        RoomCookie cookie = RoomCookie.getInstance();
        String query = "output=" + format + "&sort=" + cookie.getRoomsSortBy() + (String)(cookie.hasMode() ? "&mode=" + cookie.getMode() : "") + "&dm=" + cookie.getDeptMode();
        if (this.iProperties.getAcademicSessionId() != null) {
            query = query + "&sid=" + this.iProperties.getAcademicSessionId();
        }
        if (((EventInterface.FilterRpcRequest)(rooms = this.iFilter.getElementsRequest())).hasOptions()) {
            for (Map.Entry<String, Set<String>> option : ((EventInterface.FilterRpcRequest)rooms).getOptions().entrySet()) {
                for (String value : option.getValue()) {
                    query = query + "&r:" + option.getKey() + "=" + URL.encodeQueryString((String)value);
                }
            }
        }
        if (((EventInterface.FilterRpcRequest)rooms).getText() != null && !((EventInterface.FilterRpcRequest)rooms).getText().isEmpty()) {
            query = query + "&r:text=" + URL.encodeQueryString((String)((EventInterface.FilterRpcRequest)rooms).getText());
        }
        return query;
    }

    private class Session
    implements AcademicSessionProvider {
        private List<AcademicSessionProvider.AcademicSessionChangeHandler> iHandlers = new ArrayList<AcademicSessionProvider.AcademicSessionChangeHandler>();

        private Session() {
        }

        @Override
        public void selectSession(Long sessionId, AsyncCallback<Boolean> callback) {
            callback.onSuccess((Object)false);
        }

        @Override
        public String getAcademicSessionName() {
            return RoomGroupsPage.this.iProperties == null ? null : RoomGroupsPage.this.iProperties.getAcademicSessionName();
        }

        @Override
        public Long getAcademicSessionId() {
            return RoomGroupsPage.this.iProperties == null ? null : RoomGroupsPage.this.iProperties.getAcademicSessionId();
        }

        @Override
        public void addAcademicSessionChangeHandler(AcademicSessionProvider.AcademicSessionChangeHandler handler) {
            this.iHandlers.add(handler);
        }

        @Override
        public AcademicSessionProvider.AcademicSessionInfo getAcademicSessionInfo() {
            return null;
        }

        protected void fireChange() {
            AcademicSessionProvider.AcademicSessionChangeEvent event = new AcademicSessionProvider.AcademicSessionChangeEvent(){

                @Override
                public Long getNewAcademicSessionId() {
                    return RoomGroupsPage.this.iProperties == null ? null : RoomGroupsPage.this.iProperties.getAcademicSessionId();
                }

                @Override
                public Long getOldAcademicSessionId() {
                    return null;
                }

                @Override
                public boolean isChanged() {
                    return true;
                }
            };
            for (AcademicSessionProvider.AcademicSessionChangeHandler h : this.iHandlers) {
                h.onAcademicSessionChange(event);
            }
        }
    }
}

