/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.rooms;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.rooms.RoomCookie;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class RoomFeatureEdit
extends Composite {
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private SimpleForm iForm;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private RoomInterface.RoomPropertiesInterface iProperties;
    private RoomInterface.FeatureInterface iFeature;
    private UniTimeWidget<TextBox> iName;
    private UniTimeWidget<TextBox> iAbbreviation;
    private ListBox iType = null;
    private int iTypeRow = -1;
    private UniTimeWidget<ListBox> iDepartment;
    private CheckBox iGlobal;
    private int iDepartmentRow = -1;
    private UniTimeWidget<TextArea> iDescription;
    private RoomsTable iRooms = null;
    private P iFutureSessions;
    private Map<Long, CheckBox> iFutureSessionsToggles = new HashMap<Long, CheckBox>();
    private int iFutureSessionsRow = -1;
    private Label iSessionLabel = null;
    private int iLastScrollTop;
    private int iLastScrollLeft;

    public RoomFeatureEdit(RoomInterface.RoomsPageMode mode) {
        this.iForm = new SimpleForm();
        this.iForm.addStyleName("unitime-RoomFeatureEdit");
        this.iHeader = new UniTimeHeaderPanel();
        ClickHandler createOrUpdateFeature = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (RoomFeatureEdit.this.validate()) {
                    String future = RoomFeatureEdit.this.generateAlsoUpdateMessage();
                    RoomInterface.UpdateRoomFeatureRequest request = new RoomInterface.UpdateRoomFeatureRequest();
                    request.setFeature(RoomFeatureEdit.this.iFeature);
                    request.setSessionId(RoomFeatureEdit.this.iFeature.getSessionId());
                    if (future != null) {
                        if (Window.confirm((String)(RoomFeatureEdit.this.iFeature.getId() == null ? MESSAGES.confirmCreateRoomFeatureInFutureSessions(future) : MESSAGES.confirmUpdateRoomFeatureInFutureSessions(future)))) {
                            RoomFeatureEdit.this.fillFutureFlags(request);
                        } else {
                            return;
                        }
                    }
                    for (int i = 1; i < RoomFeatureEdit.this.iRooms.getRowCount(); ++i) {
                        RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)RoomFeatureEdit.this.iRooms.getData(i);
                        boolean wasSelected = room.hasFeature(RoomFeatureEdit.this.iFeature.getId());
                        boolean selected = RoomFeatureEdit.this.iRooms.isRoomSelected(i);
                        if (selected == wasSelected) continue;
                        if (selected) {
                            request.addLocation(room.getUniqueId());
                            continue;
                        }
                        request.dropLocation(room.getUniqueId());
                    }
                    LoadingWidget.getInstance().show(RoomFeatureEdit.this.iFeature.getId() == null ? MESSAGES.waitSavingRoomFeature() : MESSAGES.waitUpdatingRoomFeature());
                    RPC.execute(request, new AsyncCallback<RoomInterface.FeatureInterface>(){

                        public void onFailure(Throwable caught) {
                            LoadingWidget.getInstance().hide();
                            String message = RoomFeatureEdit.this.iFeature.getId() == null ? MESSAGES.errorFailedToSaveRoomFeature(caught.getMessage()) : MESSAGES.errorFailedToUpdateRoomFeature(caught.getMessage());
                            RoomFeatureEdit.this.iHeader.setErrorMessage(message);
                            UniTimeNotifications.error(message);
                        }

                        public void onSuccess(RoomInterface.FeatureInterface result) {
                            LoadingWidget.getInstance().hide();
                            RoomFeatureEdit.this.hide(true, result);
                        }
                    });
                } else {
                    RoomFeatureEdit.this.iHeader.setErrorMessage(MESSAGES.failedValidationCheckForm());
                    UniTimeNotifications.error(MESSAGES.failedValidationCheckForm());
                }
            }
        };
        this.iHeader.addButton("create", MESSAGES.buttonCreateRoomFeature(), 100, createOrUpdateFeature);
        this.iHeader.addButton("update", MESSAGES.buttonUpdateRoomFeature(), 100, createOrUpdateFeature);
        this.iHeader.addButton("delete", MESSAGES.buttonDeleteRoomFeature(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                String future = RoomFeatureEdit.this.generateAlsoUpdateMessage();
                RoomInterface.UpdateRoomFeatureRequest request = new RoomInterface.UpdateRoomFeatureRequest();
                if (Window.confirm((String)(future == null ? MESSAGES.confirmDeleteRoomFeature() : MESSAGES.confirmDeleteRoomFeatureInFutureSessions(future)))) {
                    if (future != null) {
                        RoomFeatureEdit.this.fillFutureFlags(request);
                    }
                } else {
                    return;
                }
                request.setDeleteFeatureId(RoomFeatureEdit.this.iFeature.getId());
                request.setSessionId(RoomFeatureEdit.this.iFeature.getSessionId());
                LoadingWidget.getInstance().show(MESSAGES.waitDeletingRoomFeature());
                RPC.execute(request, new AsyncCallback<RoomInterface.FeatureInterface>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        String message = MESSAGES.errorFailedToDeleteRoomFeature(caught.getMessage());
                        RoomFeatureEdit.this.iHeader.setErrorMessage(message);
                        UniTimeNotifications.error(message);
                    }

                    public void onSuccess(RoomInterface.FeatureInterface result) {
                        LoadingWidget.getInstance().hide();
                        RoomFeatureEdit.this.hide(true, result);
                    }
                });
            }
        });
        this.iHeader.addButton("back", MESSAGES.buttonBack(), 100, new ClickHandler(){

            public void onClick(ClickEvent event) {
                RoomFeatureEdit.this.hide(false, RoomFeatureEdit.this.iFeature);
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        if (mode.hasSessionSelection()) {
            this.iSessionLabel = new Label();
            this.iForm.addRow(MESSAGES.propAcademicSession(), (Widget)this.iSessionLabel);
        }
        this.iName = new UniTimeWidget<TextBox>(new TextBox());
        this.iName.getWidget().setStyleName("unitime-TextBox");
        this.iName.getWidget().setMaxLength(60);
        this.iName.getWidget().setWidth("370px");
        this.iName.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomFeatureEdit.this.iName.clearHint();
                RoomFeatureEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propName(), (Widget)this.iName);
        this.iAbbreviation = new UniTimeWidget<TextBox>(new TextBox());
        this.iAbbreviation.getWidget().setStyleName("unitime-TextBox");
        this.iAbbreviation.getWidget().setMaxLength(60);
        this.iAbbreviation.getWidget().setWidth("370px");
        this.iAbbreviation.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                RoomFeatureEdit.this.iAbbreviation.clearHint();
                RoomFeatureEdit.this.iHeader.clearMessage();
            }
        });
        this.iForm.addRow(MESSAGES.propAbbreviation(), (Widget)this.iAbbreviation);
        this.iType = new ListBox();
        this.iTypeRow = this.iForm.addRow(MESSAGES.propFeatureType(), (Widget)this.iType);
        this.iForm.getRowFormatter().setVisible(this.iTypeRow, false);
        this.iGlobal = new CheckBox();
        this.iForm.addRow(MESSAGES.propGlobalFeature(), (Widget)this.iGlobal);
        this.iGlobal.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomFeatureEdit.this.iForm.getRowFormatter().setVisible(RoomFeatureEdit.this.iDepartmentRow, (Boolean)event.getValue() == false);
            }
        });
        this.iDepartment = new UniTimeWidget<ListBox>(new ListBox());
        this.iDepartment.getWidget().setStyleName("unitime-TextBox");
        this.iDepartmentRow = this.iForm.addRow(MESSAGES.propDepartment(), (Widget)this.iDepartment);
        this.iDescription = new UniTimeWidget<TextArea>(new TextArea());
        this.iDescription.getWidget().setStyleName("unitime-TextArea");
        this.iDescription.getWidget().setVisibleLines(3);
        this.iDescription.getWidget().setCharacterWidth(50);
        this.iForm.addRow(MESSAGES.propDescription(), (Widget)this.iDescription);
        this.iForm.addHeaderRow(MESSAGES.headerRooms());
        this.iRooms = new RoomsTable(mode, true);
        this.iForm.addRow((Widget)this.iRooms);
        this.iRooms.addMouseClickListener(new UniTimeTable.MouseClickListener<RoomInterface.RoomDetailInterface>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RoomInterface.RoomDetailInterface> event) {
                RoomFeatureEdit.this.iHeader.clearMessage();
            }
        });
        this.iFutureSessions = new P("future-sessions");
        this.iFutureSessionsRow = this.iForm.addRow(MESSAGES.propApplyToFutureSessions(), (Widget)this.iFutureSessions);
        this.iForm.getCellFormatter().addStyleName(this.iFutureSessionsRow, 0, "future-sessions-header");
        this.iForm.getRowFormatter().setVisible(this.iFutureSessionsRow, false);
        this.iFooter = this.iHeader.clonePanel();
        this.iForm.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iForm);
    }

    public void setProperties(RoomInterface.RoomPropertiesInterface properties) {
        this.iProperties = properties;
        this.iRooms.setProperties(properties);
        this.iForm.getRowFormatter().setVisible(this.iTypeRow, !this.iProperties.getFeatureTypes().isEmpty());
        this.iType.clear();
        if (!this.iProperties.getFeatureTypes().isEmpty()) {
            this.iType.addItem(MESSAGES.itemNoFeatureType(), "-1");
            for (RoomInterface.FeatureTypeInterface type : this.iProperties.getFeatureTypes()) {
                this.iType.addItem(type.getLabel(), type.getId().toString());
            }
        }
        this.iFutureSessions.clear();
        this.iForm.getRowFormatter().setVisible(this.iFutureSessionsRow, this.iProperties.hasFutureSessions());
        if (this.iProperties.hasFutureSessions()) {
            CheckBox current = new CheckBox(this.iProperties.getAcademicSessionName());
            current.setValue(Boolean.valueOf(true));
            current.setEnabled(false);
            current.addStyleName("future-session");
            this.iFutureSessions.add((Widget)current);
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                if (!session.isCanAddGlobalRoomGroup() && !session.isCanAddDepartmentalRoomGroup()) continue;
                CheckBox ch = new CheckBox(session.getLabel());
                this.iFutureSessionsToggles.put(session.getId(), ch);
                ch.addStyleName("future-session");
                this.iFutureSessions.add((Widget)ch);
            }
        }
    }

    private void hide(boolean refresh, RoomInterface.FeatureInterface feature) {
        this.setVisible(false);
        this.onHide(refresh, feature);
        Window.scrollTo((int)this.iLastScrollLeft, (int)this.iLastScrollTop);
    }

    protected void onHide(boolean refresh, RoomInterface.FeatureInterface feature) {
    }

    protected void onShow() {
    }

    public void show() {
        UniTimePageLabel.getInstance().setPageName(this.iFeature.getId() == null ? MESSAGES.pageAddRoomFeature() : MESSAGES.pageEditRoomFeature());
        this.setVisible(true);
        this.iLastScrollLeft = Window.getScrollLeft();
        this.iLastScrollTop = Window.getScrollTop();
        this.onShow();
        Window.scrollTo((int)0, (int)0);
    }

    public void hide() {
        this.hide(true, this.iFeature);
    }

    public void setFeature(RoomInterface.FeatureInterface feature, String dept) {
        this.iHeader.clearMessage();
        this.iName.clearHint();
        this.iAbbreviation.clearHint();
        this.iDepartment.clearHint();
        this.iDescription.clearHint();
        if (feature == null) {
            this.iFeature = new RoomInterface.FeatureInterface();
            this.iFeature.setSessionId(this.iProperties.getAcademicSessionId());
            this.iFeature.setSessionName(this.iProperties.getAcademicSessionName());
            if (this.iSessionLabel != null) {
                this.iSessionLabel.setText(this.iProperties.getAcademicSessionName());
            }
            this.iHeader.setEnabled("create", true);
            this.iHeader.setEnabled("update", false);
            this.iHeader.setEnabled("delete", false);
            this.iName.getWidget().setText("");
            this.iAbbreviation.getWidget().setText("");
            this.iDescription.getWidget().setText("");
            this.iDepartment.getWidget().clear();
            this.iGlobal.setValue(Boolean.valueOf(true), true);
            this.iGlobal.setEnabled(true);
            if (this.iType != null && this.iType.getItemCount() > 0) {
                this.iType.setSelectedIndex(0);
            }
            if (this.iProperties.isCanAddDepartmentalRoomFeature()) {
                this.iDepartment.getWidget().addItem(MESSAGES.itemSelect(), "-1");
                this.iDepartment.getWidget().setSelectedIndex(0);
                for (RoomInterface.DepartmentInterface department : this.iProperties.getDepartments()) {
                    this.iDepartment.getWidget().addItem(department.getExtAbbreviationOrCode() + " - " + department.getExtLabelWhenExist(), department.getId().toString());
                    if (dept == null || !dept.equals(department.getDeptCode())) continue;
                    this.iDepartment.getWidget().setSelectedIndex(this.iDepartment.getWidget().getItemCount() - 1);
                    this.iGlobal.setValue(Boolean.valueOf(false), true);
                }
            }
            if (!this.iProperties.isCanAddGlobalRoomFeature()) {
                this.iGlobal.setValue(Boolean.valueOf(false), true);
                this.iGlobal.setEnabled(false);
            } else if (!this.iProperties.isCanAddDepartmentalRoomGroup()) {
                this.iGlobal.setValue(Boolean.valueOf(true), true);
                this.iGlobal.setEnabled(false);
            }
        } else {
            this.iFeature = new RoomInterface.FeatureInterface(feature);
            if (this.iSessionLabel != null) {
                this.iSessionLabel.setText(feature.getSessionName());
            }
            this.iHeader.setEnabled("create", false);
            this.iHeader.setEnabled("update", feature.canEdit());
            this.iHeader.setEnabled("delete", feature.canDelete());
            this.iName.getWidget().setText(feature.getLabel() == null ? "" : feature.getLabel());
            this.iAbbreviation.getWidget().setText(feature.getAbbreviation() == null ? "" : feature.getAbbreviation());
            this.iDescription.getWidget().setText(feature.getDescription() == null ? "" : feature.getDescription());
            if (this.iType != null && this.iType.getItemCount() > 0) {
                if (feature.getType() == null) {
                    this.iType.setSelectedIndex(0);
                } else {
                    this.iType.setSelectedIndex(1 + this.iProperties.getFeatureTypes().indexOf(feature.getType()));
                }
            }
            this.iGlobal.setValue(Boolean.valueOf(!feature.isDepartmental()), true);
            this.iGlobal.setEnabled(false);
            this.iDepartment.getWidget().clear();
            if (feature.isDepartmental()) {
                for (RoomInterface.DepartmentInterface department : this.iProperties.getDepartments()) {
                    this.iDepartment.getWidget().addItem(department.getExtAbbreviationOrCode() + " - " + department.getExtLabelWhenExist(), department.getId().toString());
                }
                int index = this.iProperties.getDepartments().indexOf(feature.getDepartment());
                if (index >= 0) {
                    this.iDepartment.getWidget().setSelectedIndex(index);
                } else {
                    this.iDepartment.getWidget().addItem(feature.getDepartment().getExtAbbreviationOrCode() + " - " + feature.getDepartment().getExtLabelWhenExist(), feature.getDepartment().getId().toString());
                    this.iDepartment.getWidget().setSelectedIndex(this.iDepartment.getWidget().getItemCount() - 1);
                }
            }
        }
        if (this.iProperties.hasFutureSessions()) {
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
                if (ch == null) continue;
                ch.setValue(Boolean.valueOf(RoomCookie.getInstance().getFutureFlags(session.getId()) != null));
            }
        }
    }

    public void setRooms(List<EventInterface.FilterRpcResponse.Entity> rooms) {
        this.iRooms.clearTable(1);
        this.iHeader.clearMessage();
        ValueChangeHandler<Boolean> clearErrorMessage = new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                RoomFeatureEdit.this.iHeader.clearMessage();
            }
        };
        for (EventInterface.FilterRpcResponse.Entity e : rooms) {
            RoomInterface.RoomDetailInterface room = (RoomInterface.RoomDetailInterface)e;
            int row = this.iRooms.addRoom(room);
            boolean selected = room.hasFeature(this.iFeature.getId());
            this.iRooms.selectRoom(row, selected);
            this.iRooms.setSelected(row, selected);
            this.iRooms.getRoomSelection(row).addValueChangeHandler((ValueChangeHandler)clearErrorMessage);
        }
        int sort = RoomCookie.getInstance().getRoomsSortBy();
        if (sort != 0) {
            this.iRooms.setSortBy(sort);
        }
    }

    public boolean validate() {
        boolean result = true;
        this.iFeature.setLabel(this.iName.getWidget().getText());
        if (this.iFeature.getLabel().isEmpty()) {
            this.iName.setErrorHint(MESSAGES.errorNameIsEmpty());
            result = false;
        }
        this.iFeature.setAbbreviation(this.iAbbreviation.getWidget().getText());
        if (this.iFeature.getAbbreviation().isEmpty()) {
            this.iAbbreviation.setErrorHint(MESSAGES.errorAbbreviationIsEmpty());
            result = false;
        }
        if (this.iType != null && this.iType.getItemCount() > 0) {
            this.iFeature.setType(this.iProperties.getFeatureType(Long.valueOf(this.iType.getValue(this.iType.getSelectedIndex()))));
        } else {
            this.iFeature.setType(null);
        }
        this.iFeature.setDescription(this.iDescription.getWidget().getText());
        if (this.iFeature.getDescription().length() > 1000) {
            this.iDescription.setErrorHint(MESSAGES.errorDescriptionTooLong());
            result = false;
        }
        if (!this.iGlobal.getValue().booleanValue()) {
            this.iFeature.setDepartment(this.iProperties.getDepartment(Long.valueOf(this.iDepartment.getWidget().getValue(this.iDepartment.getWidget().getSelectedIndex()))));
            if (this.iFeature.getDepartment() == null) {
                this.iDepartment.setErrorHint(MESSAGES.errorNoDepartmentSelected());
                result = false;
            }
        } else {
            this.iFeature.setDepartment(null);
        }
        return result;
    }

    protected String generateAlsoUpdateMessage() {
        if (!this.iProperties.hasFutureSessions()) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
            CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
            if (ch == null || !ch.getValue().booleanValue()) continue;
            ret.add(session.getLabel());
        }
        if (!ret.isEmpty()) {
            return ToolBox.toString(ret);
        }
        return null;
    }

    protected void fillFutureFlags(RoomInterface.UpdateRoomFeatureRequest request) {
        if (this.iProperties.hasFutureSessions()) {
            for (RoomInterface.AcademicSessionInterface session : this.iProperties.getFutureSessions()) {
                CheckBox ch = this.iFutureSessionsToggles.get(session.getId());
                if (ch == null) continue;
                Integer flags = RoomCookie.getInstance().getFutureFlags(session.getId());
                if (ch.getValue().booleanValue()) {
                    request.addFutureSession(session.getId());
                    if (flags != null) continue;
                    RoomCookie.getInstance().setFutureFlags(session.getId(), RoomInterface.FutureOperation.getFlagDefaultsEnabled());
                    continue;
                }
                if (flags == null) continue;
                RoomCookie.getInstance().setFutureFlags(session.getId(), null);
            }
        }
    }

    public RoomInterface.FeatureInterface getFeature() {
        return this.iFeature;
    }
}

