/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page.mobile;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;

public class MobileNotifications
implements UniTimeNotifications.Display {
    protected List<Notification> iNotifications = new ArrayList<Notification>();
    protected P iPanel = new P("unitime-MobileNotifications");

    public MobileNotifications() {
        RootPanel.get().add((Widget)this.iPanel);
        this.iPanel.addStyleName("unitime-MobileNotifications");
        this.iPanel.getElement().getStyle().setPosition(Style.Position.FIXED);
    }

    @Override
    public void addNotification(String html, UniTimeNotifications.NotificationType type, Command callback) {
        switch (type) {
            case ERROR: {
                this.addNotification(new Notification(html, "error", callback));
                break;
            }
            case WARN: {
                this.addNotification(new Notification(html, "warn", callback));
                break;
            }
            case INFO: {
                this.addNotification(new Notification(html, "info", callback));
            }
        }
    }

    protected void populate(String style) {
        this.iPanel.clear();
        if (!this.iNotifications.isEmpty()) {
            P panel = new P("container", style);
            for (Notification n : this.iNotifications) {
                panel.add(n.asWidget());
            }
            this.iPanel.add((Widget)panel);
        }
    }

    protected void addNotification(final Notification notification) {
        Iterator<Notification> i = this.iNotifications.iterator();
        while (i.hasNext()) {
            Notification n = i.next();
            if (!n.getText().equals(notification.getText())) continue;
            i.remove();
        }
        this.iNotifications.add(notification);
        this.populate("slideup");
        Timer timer = new Timer(){

            public void run() {
                MobileNotifications.this.iNotifications.remove(notification);
                MobileNotifications.this.populate(null);
            }
        };
        timer.schedule(10000);
    }

    public class Notification
    implements IsWidget,
    HasText,
    UniTimeTable.HasStyleName {
        String iText;
        String iStyle;
        Command iCallback;

        Notification(String text, String style, Command callback) {
            this.iText = text;
            this.iStyle = style;
            this.iCallback = callback;
        }

        @Override
        public String getStyleName() {
            return this.iStyle;
        }

        public String getText() {
            return this.iText;
        }

        public void setText(String text) {
            this.iText = text;
        }

        public Widget asWidget() {
            P p = new P("notification", this.getStyleName());
            p.setHTML(this.getText());
            p.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MobileNotifications.this.iNotifications.remove(Notification.this);
                    MobileNotifications.this.populate(null);
                    if (Notification.this.iCallback != null) {
                        Notification.this.iCallback.execute();
                    }
                }
            });
            return p;
        }
    }
}

