/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.page;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ClickableHint;
import org.unitime.timetable.gwt.client.page.InfoPanelDisplay;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.shared.MenuInterface;

public class InfoPanelImpl
extends P
implements InfoPanelDisplay {
    private String iUrl = null;
    private P iText = new P("text");
    private ClickableHint iHint;
    private FlexTable iInfo;
    private PopupPanel iInfoPanel = null;
    private Timer iShowInfo;
    private Timer iHideInfo = null;
    private int iX;
    private int iY;
    private InfoPanelDisplay.Callback iUpdateInfo = null;
    private ClickHandler iDefaultClickHandler;
    private HandlerRegistration iTextClick;
    private HandlerRegistration iHintClick;

    public InfoPanelImpl() {
        super("cell");
        this.add((Widget)this.iText);
        this.iHint = new ClickableHint("");
        this.iHint.setStyleName("hint");
        this.add((Widget)this.iHint);
        this.iUpdateInfo = new InfoPanelDisplay.Callback(){

            @Override
            public void execute(InfoPanelDisplay.Callback callback) {
                if (callback != null) {
                    callback.execute(null);
                }
            }
        };
        this.iInfo = new FlexTable();
        this.iInfo.setStyleName("unitime-InfoTable");
        this.iInfoPanel = new PopupPanel();
        this.iInfoPanel.setWidget((Widget)this.iInfo);
        this.iInfoPanel.setStyleName("unitime-PopupHint");
        this.sinkEvents(16);
        this.sinkEvents(32);
        this.sinkEvents(64);
        this.iShowInfo = new Timer(){

            public void run() {
                if (InfoPanelImpl.this.iInfo.getRowCount() == 0) {
                    return;
                }
                InfoPanelImpl.this.iUpdateInfo.execute(new InfoPanelDisplay.Callback(){

                    @Override
                    public void execute(InfoPanelDisplay.Callback callback) {
                        InfoPanelImpl.this.iInfoPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                            public void setPosition(int offsetWidth, int offsetHeight) {
                                int maxX = Window.getScrollLeft() + Window.getClientWidth() - offsetWidth - 10;
                                InfoPanelImpl.this.iInfoPanel.setPopupPosition(Math.min(InfoPanelImpl.this.iX, maxX), InfoPanelImpl.this.iY);
                            }
                        });
                        if (callback != null) {
                            callback.execute(null);
                        }
                    }
                });
            }
        };
        this.iHideInfo = new Timer(){

            public void run() {
                InfoPanelImpl.this.iInfoPanel.hide();
            }
        };
        this.iDefaultClickHandler = new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InfoPanelImpl.this.iUrl != null && !InfoPanelImpl.this.iUrl.isEmpty()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + InfoPanelImpl.this.iUrl);
                }
            }
        };
        this.iTextClick = this.iHint.addClickHandler(this.iDefaultClickHandler);
        this.iHintClick = this.iText.addClickHandler(this.iDefaultClickHandler);
        this.iHint.setTabIndex(-1);
    }

    @Override
    public String getHint() {
        return this.iHint.getText();
    }

    @Override
    public void setHint(String hint) {
        this.iHint.setText(hint);
    }

    @Override
    public String getText() {
        return this.iText.getText();
    }

    @Override
    public void setText(String text) {
        this.iText.setText(text);
    }

    @Override
    public void setInfo(MenuInterface.InfoInterface info) {
        this.iInfo.clear(true);
        this.iInfo.removeAllRows();
        int row = 0;
        if (info != null) {
            for (MenuInterface.InfoPairInterface pair : info.getPairs()) {
                if (pair.getValue() == null || pair.getValue().isEmpty()) continue;
                this.iInfo.setHTML(row, 0, pair.getName());
                this.iInfo.setHTML(row, 1, pair.getValue());
                if (pair.hasSeparator()) {
                    this.iInfo.getCellFormatter().addStyleName(row, 0, "separator");
                    this.iInfo.getCellFormatter().addStyleName(row, 1, "separator");
                }
                ++row;
            }
        }
    }

    public void onBrowserEvent(Event event) {
        if (this.iHint.getText().isEmpty()) {
            return;
        }
        this.iX = 10 + event.getClientX() + this.getElement().getOwnerDocument().getScrollLeft();
        this.iY = 10 + event.getClientY() + this.getElement().getOwnerDocument().getScrollTop();
        switch (DOM.eventGetType((Event)event)) {
            case 64: {
                if (this.iInfoPanel.isShowing()) {
                    int maxX = Window.getScrollLeft() + Window.getClientWidth() - this.iInfoPanel.getOffsetWidth() - 10;
                    this.iInfoPanel.setPopupPosition(Math.min(this.iX, maxX), this.iY);
                    break;
                }
                if (this.iInfo.getRowCount() <= 0) break;
                this.iShowInfo.cancel();
                this.iShowInfo.schedule(1000);
                break;
            }
            case 32: {
                this.iShowInfo.cancel();
                if (!this.iInfoPanel.isShowing()) break;
                this.iHideInfo.schedule(1000);
            }
        }
    }

    @Override
    public void setCallback(InfoPanelDisplay.Callback callback) {
        this.iUpdateInfo = callback;
    }

    @Override
    public void setUrl(String url) {
        this.iUrl = url;
        if (this.iUrl != null && !this.iUrl.isEmpty()) {
            this.iText.addStyleName("clickable");
            this.iHint.addStyleName("clickable");
            this.iHint.setTabIndex(0);
        }
    }

    @Override
    public boolean isPopupShowing() {
        return this.iInfoPanel.isShowing();
    }

    @Override
    public void setClickHandler(ClickHandler clickHandler) {
        this.iTextClick.removeHandler();
        this.iHintClick.removeHandler();
        if (clickHandler == null) {
            if (this.iUrl != null && !this.iUrl.isEmpty()) {
                this.iText.addStyleName("clickable");
                this.iHint.addStyleName("clickable");
                this.iHint.setTabIndex(0);
            }
            this.iTextClick = this.iHint.addClickHandler(this.iDefaultClickHandler);
            this.iHintClick = this.iText.addClickHandler(this.iDefaultClickHandler);
        } else {
            this.iText.addStyleName("clickable");
            this.iHint.addStyleName("clickable");
            this.iHint.setTabIndex(0);
            this.iTextClick = this.iHint.addClickHandler(clickHandler);
            this.iHintClick = this.iText.addClickHandler(clickHandler);
        }
    }

    @Override
    public String getAriaLabel() {
        return this.iHint.getAriaLabel();
    }

    @Override
    public void setAriaLabel(String text) {
        this.iHint.setAriaLabel(text);
    }
}

