/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.PreferenceEditWidget;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SearchableListBox;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeDialogBox;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class SubpartEditPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private PrefGroupEditInterface.SubpartEditResponse iData;
    private CreditTable iCredits;
    private ListBox iDatePattern;
    private PreferenceEditWidget iPreferences;

    public SubpartEditPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-ClassEditPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"ssuid");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoSubpartId());
        } else {
            this.load(Long.valueOf(id), PrefGroupEditInterface.Operation.GET, true, null);
        }
        this.iHeader.addButton("update", COURSE.actionUpdatePreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubpartEditPage.this.iPreferences.update();
                if (SubpartEditPage.this.validate()) {
                    SubpartEditPage.this.load(SubpartEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.UPDATE, true, null);
                }
            }
        });
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdatePreferences(COURSE.accessUpdatePreferences()));
        this.iHeader.getButton("update").setAccessKey(COURSE.accessUpdatePreferences().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("clear", COURSE.actionClearSubpartPreferences(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubpartEditPage.this.iPreferences.update();
                if (SubpartEditPage.this.iCredits != null) {
                    SubpartEditPage.this.iCredits.update(SubpartEditPage.this.iData);
                }
                SubpartEditPage.this.load(SubpartEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.CLEAR_CLASS_PREFS, true, null);
            }
        });
        this.iHeader.getButton("clear").setTitle(COURSE.titleClearSubpartPreferences(COURSE.accessClearSubpartPreferences()));
        this.iHeader.getButton("clear").setAccessKey(COURSE.accessClearSubpartPreferences().charAt(0));
        this.iHeader.setEnabled("clear", false);
        this.iHeader.addButton("previous", COURSE.actionPreviousSubpart(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubpartEditPage.this.iPreferences.update();
                if (SubpartEditPage.this.validate()) {
                    SubpartEditPage.this.load(SubpartEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.PREVIOUS, true, null);
                }
            }
        });
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousSubpartWithUpdate(COURSE.accessPreviousSubpart()));
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousSubpart().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", COURSE.actionNextSubpart(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                SubpartEditPage.this.iPreferences.update();
                if (SubpartEditPage.this.validate()) {
                    SubpartEditPage.this.load(SubpartEditPage.this.iData.getId(), PrefGroupEditInterface.Operation.NEXT, true, null);
                }
            }
        });
        this.iHeader.getButton("next").setTitle(COURSE.titleNextSubpartWithUpdate(COURSE.accessNextSubpart()));
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextSubpart().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", COURSE.actionBackToDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "subpart?id=" + SubpartEditPage.this.iData.getId());
            }
        });
        this.iHeader.getButton("back").setTitle(COURSE.titleBackToDetail(COURSE.accessBackToDetail()));
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(final Long subpartId, final PrefGroupEditInterface.Operation op, final boolean showLoading, final Command command) {
        if (showLoading) {
            LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        }
        PrefGroupEditInterface.SubpartEditRequest req = new PrefGroupEditInterface.SubpartEditRequest();
        req.setOperation(op);
        if (op != null && this.iData != null) {
            this.iPreferences.update();
            if (this.iCredits != null) {
                this.iCredits.update(this.iData);
            }
            req.setPayLoad(this.iData);
        }
        req.setId(subpartId);
        RPC.execute(req, new AsyncCallback<PrefGroupEditInterface.SubpartEditResponse>(){

            public void onFailure(Throwable caught) {
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                SubpartEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(final PrefGroupEditInterface.SubpartEditResponse response) {
                SubpartEditPage.this.iData = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                if (showLoading) {
                    LoadingWidget.getInstance().hide();
                }
                if (op == PrefGroupEditInterface.Operation.DATE_PATTERN) {
                    SubpartEditPage.this.iPreferences.setValue(response);
                    return;
                }
                SubpartEditPage.this.iPanel.clear();
                SubpartEditPage.this.iHeader.setHeaderTitle(response.getName());
                SubpartEditPage.this.iPanel.addHeaderRow((Widget)SubpartEditPage.this.iHeader);
                for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                    SubpartEditPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                }
                if (response.hasDatePatterms()) {
                    SubpartEditPage.this.iDatePattern = new ListBox();
                    for (PrefGroupEditInterface.IdLabel dp : response.getDatePatterns()) {
                        SubpartEditPage.this.iDatePattern.addItem(dp.getLabel(), dp.getId().toString());
                        if (!dp.getId().equals(response.getDatePatternId())) continue;
                        SubpartEditPage.this.iDatePattern.setSelectedIndex(SubpartEditPage.this.iDatePattern.getItemCount() - 1);
                    }
                    P datePatternPanel = new P("date-pattern");
                    if (response.isSearchableDatePattern()) {
                        datePatternPanel.add((Widget)new SearchableListBox(SubpartEditPage.this.iDatePattern));
                    } else {
                        datePatternPanel.add((Widget)SubpartEditPage.this.iDatePattern);
                    }
                    final ImageButton cal = new ImageButton(RESOURCES.datepattern());
                    SubpartEditPage.this.iDatePattern.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent event) {
                            Long id = Long.valueOf(SubpartEditPage.this.iDatePattern.getSelectedValue());
                            SubpartEditPage.this.iData.setDatePatternId(id);
                            PrefGroupEditInterface.IdLabel dp = response.getDatePattern(id);
                            cal.setVisible(dp != null && dp.getDescription() != null);
                            SubpartEditPage.this.load(subpartId, PrefGroupEditInterface.Operation.DATE_PATTERN, false, null);
                        }
                    });
                    cal.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            Long id = Long.valueOf(SubpartEditPage.this.iDatePattern.getSelectedValue());
                            PrefGroupEditInterface.IdLabel dp = response.getDatePattern(id);
                            if (dp != null && dp.getDescription() != null) {
                                final UniTimeDialogBox box = new UniTimeDialogBox(true, true);
                                SessionDatesSelector w = new SessionDatesSelector().forDatePattern(response.getDatePattern(id).getDescription(), new Command(){

                                    public void execute() {
                                        box.center();
                                    }
                                });
                                w.getElement().getStyle().setProperty("width", "80vw");
                                box.setWidget((Widget)w);
                                box.setText(COURSE.sectPreviewOfDatePattern(SubpartEditPage.this.iDatePattern.getSelectedItemText()));
                            }
                        }
                    });
                    datePatternPanel.add((Widget)cal);
                    SubpartEditPage.this.iPanel.addRow(COURSE.propertyDatePattern(), (Widget)datePatternPanel);
                }
                CheckBox autoSpread = new CheckBox(COURSE.descriptionAutomaticSpreadInTime());
                autoSpread.setValue(Boolean.valueOf(response.isAutoSpreadInTime()));
                autoSpread.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
                SubpartEditPage.this.iPanel.addRow(COURSE.propertyAutomaticSpreadInTime(), (Widget)autoSpread);
                autoSpread.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        SubpartEditPage.this.iData.setAutoSpreadInTime((Boolean)event.getValue());
                    }
                });
                CheckBox canOverlap = new CheckBox(COURSE.descriptionStudentOverlaps());
                canOverlap.getElement().getStyle().setFontStyle(Style.FontStyle.ITALIC);
                canOverlap.setValue(Boolean.valueOf(response.isStudentsCanOverlap()));
                SubpartEditPage.this.iPanel.addRow(COURSE.propertyStudentOverlaps(), (Widget)canOverlap);
                canOverlap.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                    public void onValueChange(ValueChangeEvent<Boolean> event) {
                        SubpartEditPage.this.iData.setStudentsCanOverlap((Boolean)event.getValue());
                    }
                });
                if (response.hasCreditFormats()) {
                    SubpartEditPage.this.iCredits = new CreditTable(response);
                    SubpartEditPage.this.iPanel.addRow(COURSE.propertySubpartCredit(), (Widget)SubpartEditPage.this.iCredits);
                } else {
                    SubpartEditPage.this.iCredits = null;
                }
                SubpartEditPage.this.iPreferences = new PreferenceEditWidget();
                SubpartEditPage.this.iPreferences.setValue(response);
                SubpartEditPage.this.iPanel.addRow((Widget)SubpartEditPage.this.iPreferences);
                SubpartEditPage.this.iPanel.addHeaderRow((Widget)SubpartEditPage.this.iFooter);
                UniTimeNavigation.getInstance().refresh();
                SubpartEditPage.this.iHeader.setEnabled("update", true);
                SubpartEditPage.this.iHeader.setEnabled("previous", response.getPreviousId() != null);
                SubpartEditPage.this.iHeader.setEnabled("next", response.getNextId() != null);
                SubpartEditPage.this.iHeader.setEnabled("clear", response.canClearPrefs());
                if (command != null) {
                    command.execute();
                }
            }
        });
    }

    public boolean validate() {
        this.iHeader.clearMessage();
        String error = this.iPreferences.validate();
        if (error != null) {
            this.iHeader.setErrorMessage(error);
            return false;
        }
        return true;
    }

    public static class CreditTable
    extends SimpleForm {
        ListBox iFormat;
        ListBox iType;
        ListBox iUnitType;
        NumberBox iUnits;
        NumberBox iMaxUnits;
        CheckBox iFractions;

        public CreditTable(PrefGroupEditInterface.SubpartEditResponse response) {
            this.removeStyleName("unitime-NotPrintableBottomLine");
            this.iFormat = new ListBox();
            this.iFormat.addItem(MESSAGES.itemSelect(), "");
            if (response.hasCreditFormats()) {
                for (PrefGroupEditInterface.IdLabel item : response.getCreditFormats()) {
                    this.iFormat.addItem(item.getLabel(), item.getDescription());
                    if (!item.getId().equals(response.getCreditFormatId())) continue;
                    this.iFormat.setSelectedIndex(this.iFormat.getItemCount() - 1);
                }
            }
            this.iFormat.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    this.formatChanged();
                }
            });
            this.addRow((Widget)this.iFormat);
            this.iType = new ListBox();
            if (response.hasCreditTypes()) {
                for (PrefGroupEditInterface.IdLabel item : response.getCreditTypes()) {
                    this.iType.addItem(item.getLabel(), item.getId().toString());
                    if (!item.getId().equals(response.getCreditTypeId())) continue;
                    this.iType.setSelectedIndex(this.iType.getItemCount() - 1);
                }
            }
            this.addRow(MESSAGES.propCreditType(), (Widget)this.iType);
            this.iUnitType = new ListBox();
            if (response.hasCreditUnitTypes()) {
                for (PrefGroupEditInterface.IdLabel item : response.getCreditUnitTypes()) {
                    this.iUnitType.addItem(item.getLabel(), item.getId().toString());
                    if (!item.getId().equals(response.getCreditUnitTypeId())) continue;
                    this.iUnitType.setSelectedIndex(this.iUnitType.getItemCount() - 1);
                }
            }
            this.addRow(MESSAGES.propCreditUnitType(), (Widget)this.iUnitType);
            this.iUnits = new NumberBox();
            this.iUnits.setDecimal(true);
            this.iUnits.setNegative(false);
            this.iUnits.setValue(response.getCreditUnits());
            this.addRow(MESSAGES.propUnits(), (Widget)this.iUnits);
            this.iMaxUnits = new NumberBox();
            this.iMaxUnits.setDecimal(true);
            this.iMaxUnits.setNegative(false);
            this.iMaxUnits.setValue(response.getCreditMaxUnits());
            this.addRow(MESSAGES.propMaxUnits(), (Widget)this.iMaxUnits);
            this.iFractions = new CheckBox();
            this.iFractions.setValue(Boolean.valueOf(response.isCreditFractionsAllowed()));
            this.addRow(MESSAGES.propMaxUnits(), (Widget)this.iFractions);
            this.formatChanged();
        }

        protected void formatChanged() {
            String format = this.iFormat.getSelectedValue();
            if ("fixedUnit".equals(format)) {
                this.getRowFormatter().setVisible(1, true);
                this.getRowFormatter().setVisible(2, true);
                this.getRowFormatter().setVisible(3, true);
                this.getRowFormatter().setVisible(4, false);
                this.getRowFormatter().setVisible(5, false);
            } else if ("arrangeHours".equals(format)) {
                this.getRowFormatter().setVisible(1, true);
                this.getRowFormatter().setVisible(2, true);
                this.getRowFormatter().setVisible(3, false);
                this.getRowFormatter().setVisible(4, false);
                this.getRowFormatter().setVisible(5, false);
            } else if ("variableRange".equals(format)) {
                this.getRowFormatter().setVisible(1, true);
                this.getRowFormatter().setVisible(2, true);
                this.getRowFormatter().setVisible(3, true);
                this.getRowFormatter().setVisible(4, true);
                this.getRowFormatter().setVisible(5, true);
            } else if ("variableMinMax".equals(format)) {
                this.getRowFormatter().setVisible(1, true);
                this.getRowFormatter().setVisible(2, true);
                this.getRowFormatter().setVisible(3, true);
                this.getRowFormatter().setVisible(4, true);
                this.getRowFormatter().setVisible(5, false);
            } else {
                this.getRowFormatter().setVisible(1, false);
                this.getRowFormatter().setVisible(2, false);
                this.getRowFormatter().setVisible(3, false);
                this.getRowFormatter().setVisible(4, false);
                this.getRowFormatter().setVisible(5, false);
            }
        }

        public void update(PrefGroupEditInterface.SubpartEditResponse response) {
            PrefGroupEditInterface.IdLabel format = response.getCreditFormat(this.iFormat.getSelectedValue());
            if (format == null) {
                response.setCreditFormatId(null);
                response.setCreditTypeId(null);
                response.setCreditUnitTypeId(null);
                response.setCreditUnits(null);
                response.setCreditMaxUnits(null);
                response.setCreditFractionsAllowed(false);
                return;
            }
            if ("fixedUnit".equals(format.getDescription())) {
                response.setCreditFormatId(format.getId());
                response.setCreditTypeId(Long.valueOf(this.iType.getSelectedValue()));
                response.setCreditUnitTypeId(Long.valueOf(this.iUnitType.getSelectedValue()));
                response.setCreditUnits(this.iUnits.toFloat());
                response.setCreditMaxUnits(null);
                response.setCreditFractionsAllowed(false);
            } else if ("arrangeHours".equals(format.getDescription())) {
                response.setCreditFormatId(format.getId());
                response.setCreditTypeId(Long.valueOf(this.iType.getSelectedValue()));
                response.setCreditUnitTypeId(Long.valueOf(this.iUnitType.getSelectedValue()));
                response.setCreditUnits(null);
                response.setCreditMaxUnits(null);
                response.setCreditFractionsAllowed(false);
            } else if ("variableRange".equals(format.getDescription())) {
                response.setCreditFormatId(format.getId());
                response.setCreditTypeId(Long.valueOf(this.iType.getSelectedValue()));
                response.setCreditUnitTypeId(Long.valueOf(this.iUnitType.getSelectedValue()));
                response.setCreditUnits(this.iUnits.toFloat());
                response.setCreditMaxUnits(this.iMaxUnits.toFloat());
                response.setCreditFractionsAllowed(this.iFractions.getValue());
            } else if ("variableMinMax".equals(format.getDescription())) {
                response.setCreditFormatId(format.getId());
                response.setCreditTypeId(Long.valueOf(this.iType.getSelectedValue()));
                response.setCreditUnitTypeId(Long.valueOf(this.iUnitType.getSelectedValue()));
                response.setCreditUnits(this.iUnits.toFloat());
                response.setCreditMaxUnits(this.iMaxUnits.toFloat());
                response.setCreditFractionsAllowed(false);
            } else {
                response.setCreditFormatId(null);
                response.setCreditTypeId(null);
                response.setCreditUnitTypeId(null);
                response.setCreditUnits(null);
                response.setCreditMaxUnits(null);
                response.setCreditFractionsAllowed(false);
            }
        }
    }
}

