/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.events.SessionDatesSelector;
import org.unitime.timetable.gwt.client.instructor.InstructorAvailabilityWidget;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.offerings.TimePreferenceWidget;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class PreferenceEditWidget
extends SimpleForm
implements TakesValue<PrefGroupEditInterface.PrefGroupEditResponse> {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    private static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    private UniTimeHeaderPanel iHeader;
    private PrefGroupEditInterface.PrefGroupEditResponse iResponse;
    private List<PreferencesTable> iRoomPrefs;
    private PreferencesTable iDatePrefs;
    private PreferencesTable iDistributionPrefs;
    private PreferencesTable iCoursePrefs;
    private TimePreferenceTable iTimePrefs;
    private InstructorAvailabilityWidget iInstructorAvailability;
    private SessionDatesSelector iInstructorUnavailability;

    public PreferenceEditWidget() {
        this(true);
    }

    public PreferenceEditWidget(boolean header) {
        this.addStyleName("unitime-PreferenceEdit");
        if (header) {
            this.iHeader = new UniTimeHeaderPanel(COURSE.sectionTitlePreferences());
            this.addHeaderRow((Widget)this.iHeader);
        }
    }

    public PrefGroupEditInterface.PrefGroupEditResponse getValue() {
        this.update();
        return this.iResponse;
    }

    public void update() {
        if (this.iTimePrefs != null) {
            this.iTimePrefs.update();
        }
        if (this.iDatePrefs != null) {
            this.iDatePrefs.update();
        }
        if (this.iRoomPrefs != null) {
            for (PreferencesTable rp : this.iRoomPrefs) {
                rp.update();
            }
        }
        if (this.iCoursePrefs != null) {
            this.iCoursePrefs.update();
        }
        if (this.iDistributionPrefs != null) {
            this.iDistributionPrefs.update();
        }
        if (this.iInstructorAvailability != null) {
            this.iResponse.setInstructorTimePrefereneces(((InstructorAvailabilityWidget.InstructorAvailabilityModel)this.iInstructorAvailability.getModel()).getPattern());
        }
        if (this.iInstructorUnavailability != null) {
            this.iResponse.setInstructorUnavailability(this.iInstructorUnavailability.getPattern());
        }
    }

    public static String getName(PrefGroupEditInterface.PreferenceType type) {
        switch (type) {
            case TIME: {
                return COURSE.propertyTime();
            }
            case DATE: {
                return COURSE.propertyDatePatterns();
            }
            case ROOM: {
                return COURSE.propertyRooms();
            }
            case BUILDING: {
                return COURSE.propertyBuildings();
            }
            case ROOM_FEATURE: {
                return COURSE.propertyRoomFeatures();
            }
            case ROOM_GROUP: {
                return COURSE.propertyRoomGroups();
            }
            case DISTRIBUTION: {
                return COURSE.propertyDistribution();
            }
            case COURSE: {
                return COURSE.propertyCoursePrefs();
            }
        }
        return type.name();
    }

    public void setValue(PrefGroupEditInterface.PrefGroupEditResponse response) {
        this.iResponse = response;
        this.clear();
        if (this.iHeader != null) {
            this.addHeaderRow((Widget)this.iHeader);
        }
        this.iTimePrefs = null;
        if (response.hasTimePreferences()) {
            this.iTimePrefs = new TimePreferenceTable(response);
            this.addRow(response.getTimePreferences().getType(), (Widget)this.iTimePrefs);
        }
        this.iInstructorAvailability = null;
        if (response.hasInstructorTimePrefereneces()) {
            this.iInstructorAvailability = new InstructorAvailabilityWidget();
            this.iInstructorAvailability.forPattern(response.getInstructorTimePrefereneces(), true);
            this.addRow(COURSE.propertyTime(), (Widget)this.iInstructorAvailability);
        }
        this.iDatePrefs = null;
        if (response.hasDatePreferences()) {
            this.iDatePrefs = new PreferencesTable(response.getDatePreferences(), null, response);
            this.addRow(PreferenceEditWidget.getName(response.getDatePreferences().getType()), (Widget)this.iDatePrefs);
        }
        this.iRoomPrefs = new ArrayList<PreferencesTable>();
        if (response.hasRoomPreferences()) {
            for (PrefGroupEditInterface.Preferences p : response.getRoomPreferences()) {
                PreferencesTable tab = new PreferencesTable(p, response.getNbrRooms(), response);
                this.iRoomPrefs.add(tab);
                this.addRow(PreferenceEditWidget.getName(p.getType()), (Widget)tab);
            }
        }
        this.iDistributionPrefs = null;
        if (response.hasDistributionPreferences()) {
            this.iDistributionPrefs = new PreferencesTable(response.getDistributionPreferences(), null, response);
            this.addRow(PreferenceEditWidget.getName(response.getDistributionPreferences().getType()), (Widget)this.iDistributionPrefs);
        }
        this.iCoursePrefs = null;
        if (response.hasCoursePreferences()) {
            this.iCoursePrefs = new PreferencesTable(response.getCoursePreferences(), null, response);
            this.addRow(PreferenceEditWidget.getName(response.getCoursePreferences().getType()), (Widget)this.iCoursePrefs);
        }
        if (response.hasInstructorUnavailability()) {
            this.iInstructorUnavailability = new SessionDatesSelector();
            this.iInstructorUnavailability.forPattern(response.getInstructorUnavailability(), true);
            this.addRow(COURSE.propertyUnavailableDates(), (Widget)this.iInstructorUnavailability);
        }
    }

    public String validate() {
        Object error;
        if (this.iTimePrefs != null && (error = this.iTimePrefs.validate()) != null) {
            return error;
        }
        if (this.iDatePrefs != null && (error = this.iDatePrefs.validate()) != null) {
            return error;
        }
        if (this.iRoomPrefs != null) {
            error = this.iRoomPrefs.iterator();
            while (error.hasNext()) {
                PreferencesTable p = (PreferencesTable)((Object)error.next());
                String error2 = p.validate();
                if (error2 == null) continue;
                return error2;
            }
        }
        if (this.iDistributionPrefs != null && (error = this.iDistributionPrefs.validate()) != null) {
            return error;
        }
        if (this.iCoursePrefs != null && (error = this.iCoursePrefs.validate()) != null) {
            return error;
        }
        return null;
    }

    class TimePreferenceTable
    extends P {
        private Map<Long, TimePreferenceWidget> iTimePrefs;
        private PrefGroupEditInterface.PrefGroupEditResponse iResponse;
        private ListBox iTimePatterns;

        TimePreferenceTable(PrefGroupEditInterface.PrefGroupEditResponse response) {
            super("time-preferences");
            this.iResponse = response;
            final PrefGroupEditInterface.TimePreferences timePrefs = response.getTimePreferences();
            this.iTimePatterns = new ListBox();
            final P tpSelection = new P("pattern-selection");
            tpSelection.add((Widget)this.iTimePatterns);
            ImageButton img = new ImageButton(RESOURCES.add());
            tpSelection.add((Widget)img);
            this.iTimePrefs = new HashMap<Long, TimePreferenceWidget>();
            this.add((Widget)tpSelection);
            if (timePrefs.hasSelections()) {
                for (PrefGroupEditInterface.TimeSelection sel : timePrefs.getSelections()) {
                    PrefGroupEditInterface.TimePatternModel model = timePrefs.getItem(sel.getItem());
                    if (model == null) continue;
                    model.setPreference(sel.getPreference());
                    final TimePreferenceWidget tpw = new TimePreferenceWidget(true, this.iResponse.getPrefLevels(), timePrefs.isHorizontal());
                    tpw.setRemove(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            TimePreferenceTable.this.remove((Widget)tpw);
                            TimePreferenceTable.this.iTimePrefs.remove(tpw.getModel().getId());
                            TimePreferenceTable.this.updateTimePatternSelection();
                        }
                    });
                    tpw.setModel(model);
                    this.iTimePrefs.put(sel.getItem(), tpw);
                    this.add((Widget)tpw);
                }
            }
            img.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String value = TimePreferenceTable.this.iTimePatterns.getSelectedValue();
                    if (!value.isEmpty()) {
                        PrefGroupEditInterface.TimePatternModel model = TimePreferenceTable.this.iResponse.getTimePreferences().getItem(Long.valueOf(value));
                        if (model != null) {
                            if (model.isExactTime()) {
                                TimePreferenceTable.this.clear();
                                TimePreferenceTable.this.add((Widget)tpSelection);
                                TimePreferenceTable.this.iTimePrefs.clear();
                            } else {
                                for (TimePreferenceWidget tpw : TimePreferenceTable.this.iTimePrefs.values()) {
                                    if (!tpw.getModel().isExactTime()) continue;
                                    TimePreferenceTable.this.remove((Widget)tpw);
                                    TimePreferenceTable.this.iTimePrefs.remove(tpw.getModel().getId());
                                }
                            }
                            model.setPreference(null);
                            final TimePreferenceWidget tpw = new TimePreferenceWidget(true, TimePreferenceTable.this.iResponse.getPrefLevels(), timePrefs.isHorizontal());
                            tpw.setRemove(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    TimePreferenceTable.this.remove((Widget)tpw);
                                    TimePreferenceTable.this.iTimePrefs.remove(tpw.getModel().getId());
                                    TimePreferenceTable.this.updateTimePatternSelection();
                                }
                            });
                            tpw.setModel(model);
                            TimePreferenceTable.this.iTimePrefs.put(model.getId(), tpw);
                            TimePreferenceTable.this.add((Widget)tpw);
                            tpw.getElement().scrollIntoView();
                        }
                        TimePreferenceTable.this.updateTimePatternSelection();
                    }
                }
            });
            this.updateTimePatternSelection();
        }

        public void update() {
            this.iResponse.getTimePreferences().clearSelections();
            for (TimePreferenceWidget tpw : this.iTimePrefs.values()) {
                this.iResponse.getTimePreferences().addSelection(tpw.getValue());
            }
        }

        public void updateTimePatternSelection() {
            this.iTimePatterns.clear();
            this.iTimePatterns.addItem(MESSAGES.itemSelect(), "");
            for (PrefGroupEditInterface.TimePatternModel model : this.iResponse.getTimePreferences().getItems()) {
                if (this.iTimePrefs.containsKey(model.getId()) || !model.isValid()) continue;
                this.iTimePatterns.addItem(model.getName(), model.getId().toString());
            }
        }

        public String validate() {
            for (TimePreferenceWidget tpw : this.iTimePrefs.values()) {
                PrefGroupEditInterface.TimePatternModel model = tpw.getModel();
                if (!model.isExactTime()) continue;
                if (model.getPreference() == null || model.getPreference().isEmpty()) {
                    return COURSE.errorInvalidTimePreference();
                }
                HashSet<String> times = new HashSet<String>();
                for (String p : model.getPreference().split(";")) {
                    if (times.add(p)) continue;
                    return COURSE.errorInvalidTimePreference();
                }
            }
            return null;
        }
    }

    static class PreferencesTable
    extends P {
        static int lastId = 0;
        ChangeHandler iChangeHandler;
        HandlerRegistration iHandlerRegistration;
        PrefGroupEditInterface.Preferences iPreferences;

        PreferencesTable(final PrefGroupEditInterface.Preferences preferences, final Integer nbrRooms, final PrefGroupEditInterface.PrefGroupEditResponse response) {
            super("preference-table");
            this.iPreferences = preferences;
            if (preferences.hasSelections()) {
                for (PrefGroupEditInterface.Selection selection : preferences.getSelections()) {
                    PreferenceLine p = new PreferenceLine(this.iPreferences.getItems(), response, preferences.isAllowHard(), nbrRooms);
                    PrefGroupEditInterface.IdLabel item = preferences.getItem(selection.getItem());
                    PrefGroupEditInterface.PrefLevel level = response.getPrefLevel(selection.getLevel());
                    if (item != null && level != null && !preferences.isAllowHard() && ("P".equals(level.getCode()) || "R".equals(level.getCode()))) {
                        p.setEditable(false);
                    }
                    p.setValue(selection);
                    this.add((Widget)p);
                }
            }
            this.add((Widget)new PreferenceLine(this.iPreferences.getItems(), response, preferences.isAllowHard(), nbrRooms));
            this.iChangeHandler = new ChangeHandler(){

                public void onChange(ChangeEvent e) {
                    if (((PreferenceLine)this.getWidget(this.getWidgetCount() - 1)).hasSelection()) {
                        PreferenceLine p = new PreferenceLine(iPreferences.getItems(), response, preferences.isAllowHard(), nbrRooms);
                        this.add((Widget)p);
                        iHandlerRegistration.removeHandler();
                        iHandlerRegistration = p.addChangeHandler(iChangeHandler);
                        this.fixButtons();
                    }
                }
            };
            this.fixButtons();
        }

        protected void update() {
            this.iPreferences.clearSelections();
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                PrefGroupEditInterface.Selection selection = p.getValue();
                if (selection == null) continue;
                this.iPreferences.addSelection(selection);
            }
        }

        protected String errorMessage() {
            switch (this.iPreferences.getType()) {
                case ROOM: {
                    return COURSE.errorInvalidRoomPreference();
                }
                case BUILDING: {
                    return COURSE.errorInvalidBuildingPreference();
                }
                case ROOM_FEATURE: {
                    return COURSE.errorInvalidRoomFeaturePreference();
                }
                case ROOM_GROUP: {
                    return COURSE.errorInvalidRoomGroup();
                }
                case DATE: {
                    return COURSE.errorInvalidDatePatternPreference();
                }
                case DISTRIBUTION: {
                    return COURSE.errorInvalidDistributionPreference();
                }
                case COURSE: {
                    return COURSE.errorInvalidCoursePreference();
                }
            }
            return null;
        }

        public String validate() {
            ArrayList<PrefGroupEditInterface.Selection> selections = new ArrayList<PrefGroupEditInterface.Selection>(this.getWidgetCount());
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                PrefGroupEditInterface.IdLabel item = p.getItem();
                if (item == null) continue;
                PrefGroupEditInterface.PrefLevel pref = p.getSelection();
                if (pref == null || "0".equals(pref.getCode())) {
                    return this.errorMessage();
                }
                PrefGroupEditInterface.Selection s = p.getValue();
                for (PrefGroupEditInterface.Selection other : selections) {
                    if (!other.getItem().equals(s.getItem()) || !PrefGroupEditInterface.equals(other.getRoomIndex(), s.getRoomIndex())) continue;
                    return this.errorMessage();
                }
                selections.add(s);
            }
            return null;
        }

        protected void fixButtons() {
            if (this.iHandlerRegistration != null) {
                this.iHandlerRegistration.removeHandler();
            }
            for (int i = 0; i < this.getWidgetCount(); ++i) {
                PreferenceLine p = (PreferenceLine)this.getWidget(i);
                if (i < this.getWidgetCount() - 1) {
                    p.setButtonAdd(false);
                    continue;
                }
                p.setButtonAdd(true);
                this.iHandlerRegistration = p.addChangeHandler(this.iChangeHandler);
            }
        }

        class PreferenceLine
        extends P
        implements HasChangeHandlers,
        TakesValue<PrefGroupEditInterface.Selection> {
            ListBox iList;
            ListBox iRoomIndex;
            List<RadioButton> iRadios;
            ImageButton iButton;
            boolean iButtonAdd;
            List<PrefGroupEditInterface.PrefLevel> iOptions;
            Collection<PrefGroupEditInterface.IdLabel> iItems;
            P iDescription;
            boolean iAllowHard;
            boolean iEditable;
            PrefGroupEditInterface.PrefLevel iNeutral;

            PreferenceLine(Collection<PrefGroupEditInterface.IdLabel> items, final PrefGroupEditInterface.PrefGroupEditResponse response, boolean allowHard, final Integer nbrRooms) {
                super("preference-line");
                this.iButtonAdd = false;
                this.iNeutral = null;
                P line1 = new P("first-line");
                P line2 = new P("second-line");
                this.add((Widget)line1);
                this.add((Widget)line2);
                this.iOptions = new ArrayList<PrefGroupEditInterface.PrefLevel>();
                this.iItems = items;
                this.iAllowHard = allowHard;
                this.iList = new ListBox();
                this.iList.addItem("-", "");
                for (PrefGroupEditInterface.IdLabel item : items) {
                    this.iList.addItem(item.getLabel(), item.getId().toString());
                }
                this.iList.addStyleName("preference-cell");
                this.iList.addChangeHandler(new ChangeHandler(){

                    public void onChange(ChangeEvent event) {
                        PreferenceLine.this.fixOptions();
                        PreferenceLine.this.fireEvent((GwtEvent)event);
                    }
                });
                line1.add((Widget)this.iList);
                this.iRadios = new ArrayList<RadioButton>();
                for (PrefGroupEditInterface.PrefLevel option : response.getPrefLevels()) {
                    if ("0".equals(option.getCode())) {
                        this.iNeutral = option;
                        continue;
                    }
                    this.iOptions.add(option);
                    RadioButton opt = new RadioButton("pref" + lastId, option.getLabel());
                    opt.setTitle(option.getTitle());
                    opt.getElement().getStyle().setColor(option.getColor());
                    opt.addStyleName("preference-cell");
                    this.iRadios.add(opt);
                    line1.add((Widget)opt);
                    opt.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                        public void onValueChange(ValueChangeEvent<Boolean> event) {
                            if (((Boolean)event.getValue()).booleanValue() && !PreferenceLine.this.iAllowHard) {
                                PreferenceLine.this.fixOptions();
                            }
                            ChangeEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)PreferenceLine.this);
                        }
                    });
                }
                if (nbrRooms != null && nbrRooms > 1) {
                    this.iRoomIndex = new ListBox();
                    this.iRoomIndex.addItem(COURSE.itemAllRooms(), "");
                    for (int i = 0; i < nbrRooms; ++i) {
                        this.iRoomIndex.addItem(COURSE.itemOnlyRoom(1 + i), String.valueOf(i));
                    }
                    this.iRoomIndex.addStyleName("preference-cell");
                    this.iRoomIndex.addStyleName("room-index");
                    this.iRoomIndex.addChangeHandler(new ChangeHandler(){

                        public void onChange(ChangeEvent event) {
                            PreferenceLine.this.fireEvent((GwtEvent)event);
                        }
                    });
                    line1.add((Widget)this.iRoomIndex);
                    this.iRoomIndex.setVisible(false);
                }
                this.iButton = new ImageButton(RESOURCES.delete());
                this.iButton.setTitle(MESSAGES.titleDeleteRow());
                this.iButton.addStyleName("preference-cell");
                this.iButton.getElement().getStyle().setCursor(Style.Cursor.POINTER);
                this.iButton.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        if (PreferenceLine.this.iButtonAdd) {
                            PreferencesTable.this.add((Widget)new PreferenceLine(PreferenceLine.this.iItems, response, PreferenceLine.this.iAllowHard, nbrRooms));
                        } else {
                            PreferencesTable.this.remove((Widget)PreferenceLine.this);
                        }
                        PreferencesTable.this.fixButtons();
                    }
                });
                line1.add((Widget)this.iButton);
                this.iDescription = new P("description");
                this.iDescription.setVisible(false);
                line2.add((Widget)this.iDescription);
                this.fixOptions();
                ++lastId;
            }

            public void setEditable(boolean editable) {
                this.iList.setEnabled(editable);
                if (this.iRoomIndex != null) {
                    this.iRoomIndex.setEnabled(editable);
                }
            }

            protected PrefGroupEditInterface.IdLabel getItem() {
                String id = this.iList.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    return null;
                }
                for (PrefGroupEditInterface.IdLabel item : this.iItems) {
                    if (!item.getId().toString().equals(id)) continue;
                    return item;
                }
                return null;
            }

            protected void fixOptions() {
                PrefGroupEditInterface.IdLabel item = this.getItem();
                if (item != null && item.hasDescription()) {
                    this.iDescription.setVisible(true);
                    this.iDescription.setHTML(item.getDescription());
                } else {
                    this.iDescription.setVisible(false);
                }
                if (!this.iList.isEnabled() && !this.getSelection().isHard()) {
                    this.setEditable(true);
                }
                int nbrVisible = 0;
                for (int i = 0; i < this.iOptions.size(); ++i) {
                    RadioButton opt = this.iRadios.get(i);
                    PrefGroupEditInterface.PrefLevel option = this.iOptions.get(i);
                    if (item == null || !this.iAllowHard && ("P".equals(option.getCode()) || "R".equals(option.getCode())) && !opt.getValue().booleanValue() || !item.isAllowed(option)) {
                        opt.setEnabled(opt.getValue().booleanValue());
                        opt.setVisible(opt.getValue().booleanValue());
                        continue;
                    }
                    opt.setEnabled(this.iList.isEnabled());
                    opt.setVisible(this.iList.isEnabled() || opt.getValue() != false);
                    ++nbrVisible;
                }
                if (this.iRoomIndex != null) {
                    this.iRoomIndex.setVisible(nbrVisible > 0);
                }
            }

            public PrefGroupEditInterface.PrefLevel getSelection() {
                for (int i = 0; i < this.iOptions.size(); ++i) {
                    RadioButton opt = this.iRadios.get(i);
                    if (!Boolean.TRUE.equals(opt.getValue())) continue;
                    return this.iOptions.get(i);
                }
                return this.iNeutral;
            }

            public Integer getRoomIndex() {
                if (this.iRoomIndex == null || this.iRoomIndex.getSelectedIndex() == 0) {
                    return null;
                }
                return Integer.valueOf(this.iRoomIndex.getSelectedValue());
            }

            public Long getId() {
                String id = this.iList.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    return null;
                }
                if (this.getSelection() == null) {
                    return null;
                }
                return Long.valueOf(id);
            }

            public boolean hasSelection() {
                String id = this.iList.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    return false;
                }
                PrefGroupEditInterface.PrefLevel selection = this.getSelection();
                return selection != null && !"0".equals(selection.getCode());
            }

            public void setId(Long id) {
                if (id == null) {
                    this.iList.setSelectedIndex(0);
                } else {
                    for (int i = 1; i < this.iList.getItemCount(); ++i) {
                        if (!this.iList.getValue(i).equals(id.toString())) continue;
                        this.iList.setSelectedIndex(i);
                        break;
                    }
                }
            }

            public HandlerRegistration addChangeHandler(ChangeHandler handler) {
                return this.addDomHandler((EventHandler)handler, ChangeEvent.getType());
            }

            public void setButtonAdd(boolean add) {
                this.iButtonAdd = add;
                if (add) {
                    this.iButton.setImage(RESOURCES.add());
                    this.iButton.setTitle(MESSAGES.titleAddRow());
                } else {
                    this.iButton.setImage(RESOURCES.delete());
                    this.iButton.setTitle(MESSAGES.titleDeleteRow());
                }
            }

            public void setValue(PrefGroupEditInterface.Selection value) {
                if (value == null) {
                    this.iList.setSelectedIndex(0);
                    for (RadioButton b : this.iRadios) {
                        b.setValue(Boolean.valueOf(false));
                    }
                } else {
                    int i;
                    for (i = 0; i < this.iList.getItemCount(); ++i) {
                        if (!value.getItem().toString().equals(this.iList.getValue(i))) continue;
                        this.iList.setSelectedIndex(i);
                        break;
                    }
                    for (i = 0; i < this.iOptions.size(); ++i) {
                        RadioButton opt = this.iRadios.get(i);
                        opt.setValue(Boolean.valueOf(this.iOptions.get(i).getId().equals(value.getLevel())));
                        if (this.iList.isEnabled()) continue;
                        opt.setText(this.iOptions.get(i).getTitle());
                    }
                }
                if (this.iRoomIndex != null) {
                    if (value.getRoomIndex() == null) {
                        this.iRoomIndex.setSelectedIndex(0);
                    } else {
                        this.iRoomIndex.setSelectedIndex(1 + value.getRoomIndex());
                    }
                }
                this.fixOptions();
            }

            public PrefGroupEditInterface.Selection getValue() {
                PrefGroupEditInterface.IdLabel item = this.getItem();
                PrefGroupEditInterface.PrefLevel pref = this.getSelection();
                if (item != null && pref != null) {
                    PrefGroupEditInterface.Selection ret = new PrefGroupEditInterface.Selection(item.getId(), pref.getId());
                    ret.setRoomIndex(this.getRoomIndex());
                    return ret;
                }
                return null;
            }
        }
    }
}

