/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class PrefGroupEditInterface {
    public static boolean equalsString(String o1, String o2) {
        return (o1 == null ? "" : o1).equals(o2 == null ? "" : o2);
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static class DistributionsLookupClasses
    implements GwtRpcRequest<GwtRpcResponseList<IdLabel>> {
        private Long iSubpartId;

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }
    }

    public static class DistributionsLookupSubparts
    implements GwtRpcRequest<GwtRpcResponseList<IdLabel>> {
        private Long iCourseId;

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }
    }

    public static class DistributionsLookupCourses
    implements GwtRpcRequest<GwtRpcResponseList<IdLabel>> {
        private Long iSubjectId;

        public Long getSubjectId() {
            return this.iSubjectId;
        }

        public void setSubjectId(Long subjectId) {
            this.iSubjectId = subjectId;
        }
    }

    public static class DistributionObjectInterface
    implements IsSerializable {
        private Long iSubjectId;
        private Long iCourseId;
        private Long iSubpartId;
        private Long iClassId;
        private String iSubject;
        private String iCourse;
        private String iSubpart;
        private String iClazz;

        public Long getSubjectId() {
            return this.iSubjectId;
        }

        public void setSubjectId(Long subjectId) {
            this.iSubjectId = subjectId;
        }

        public Long getCourseId() {
            return this.iCourseId;
        }

        public void setCourseId(Long courseId) {
            this.iCourseId = courseId;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public String getSubject() {
            return this.iSubject;
        }

        public void setSubject(String subject) {
            this.iSubject = subject;
        }

        public String getCourse() {
            return this.iCourse;
        }

        public void setCourse(String course) {
            this.iCourse = course;
        }

        public String getSubpart() {
            return this.iSubpart;
        }

        public void setSubpart(String subpart) {
            this.iSubpart = subpart;
        }

        public String getClazz() {
            return this.iClazz;
        }

        public void setClazz(String clazz) {
            this.iClazz = clazz;
        }

        public boolean isValid() {
            if (this.iClassId == null) {
                return false;
            }
            if (this.iClassId < 0L) {
                return this.iSubpartId != null;
            }
            return true;
        }

        public String getId() {
            return this.iCourseId + ":" + this.iSubpartId + ":" + this.iClassId;
        }
    }

    public static class DistributionEditResponse
    implements GwtRpcResponse {
        private Long iPreferenceId;
        private Long iPrefLevelId;
        private Long iDistTypeId;
        private Long iStructureId;
        private List<IdLabel> iDistTypes;
        private List<IdLabel> iStructures;
        private List<IdLabel> iPrefLevels;
        private List<IdLabel> iSubjects;
        private List<DistributionObjectInterface> iDistributionObjects;
        private boolean iCanDelete;
        private String iBackUrl;
        private String iBackTitle;
        private boolean iConfirms;

        public Long getPreferenceId() {
            return this.iPreferenceId;
        }

        public void setPreferenceId(Long preferenceId) {
            this.iPreferenceId = preferenceId;
        }

        public Long getPrefLevelId() {
            return this.iPrefLevelId;
        }

        public void setPrefLevelId(Long id) {
            this.iPrefLevelId = id;
        }

        public void addPrefLevel(Long id, String label, char pref) {
            if (this.iPrefLevels == null) {
                this.iPrefLevels = new ArrayList<IdLabel>();
            }
            this.iPrefLevels.add(new IdLabel(id, label, "" + pref));
        }

        public List<IdLabel> getPrefLevels() {
            return this.iPrefLevels;
        }

        public boolean hasPrefLevels() {
            return this.iPrefLevels != null && !this.iPrefLevels.isEmpty();
        }

        public IdLabel getPrefLevel(Long id) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (IdLabel item : this.iPrefLevels) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
            return null;
        }

        public Long getDistTypeId() {
            return this.iDistTypeId;
        }

        public void setDistTypeId(Long id) {
            this.iDistTypeId = id;
        }

        public void addDistType(Long id, String label, String description, String allowedPrefs) {
            if (this.iDistTypes == null) {
                this.iDistTypes = new ArrayList<IdLabel>();
            }
            IdLabel dt = new IdLabel(id, label, description);
            dt.setAllowedPrefs(allowedPrefs);
            this.iDistTypes.add(dt);
        }

        public List<IdLabel> getDistTypes() {
            return this.iDistTypes;
        }

        public boolean hasDistTypes() {
            return this.iDistTypes != null && !this.iDistTypes.isEmpty();
        }

        public IdLabel getDistType(Long id) {
            if (this.iDistTypes == null) {
                return null;
            }
            for (IdLabel item : this.iDistTypes) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
            return null;
        }

        public Long getStructureId() {
            return this.iStructureId;
        }

        public void setStructureId(Long id) {
            this.iStructureId = id;
        }

        public void addStructure(int id, String label, String description) {
            if (this.iStructures == null) {
                this.iStructures = new ArrayList<IdLabel>();
            }
            this.iStructures.add(new IdLabel(Long.valueOf(id), label, description));
        }

        public List<IdLabel> getStructures() {
            return this.iStructures;
        }

        public boolean hasStructures() {
            return this.iStructures != null && !this.iStructures.isEmpty();
        }

        public IdLabel getStructure(Long id) {
            if (this.iStructures == null) {
                return null;
            }
            for (IdLabel item : this.iStructures) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
            return null;
        }

        public void addSubject(Long id, String label, String description) {
            if (this.iSubjects == null) {
                this.iSubjects = new ArrayList<IdLabel>();
            }
            this.iSubjects.add(new IdLabel(id, label, description));
        }

        public List<IdLabel> getSubjects() {
            return this.iSubjects;
        }

        public boolean hasSubjects() {
            return this.iSubjects != null && !this.iSubjects.isEmpty();
        }

        public IdLabel getSubject(Long id) {
            if (this.iSubjects == null) {
                return null;
            }
            for (IdLabel item : this.iSubjects) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
            return null;
        }

        public void addDistributionObject(DistributionObjectInterface dist) {
            if (this.iDistributionObjects == null) {
                this.iDistributionObjects = new ArrayList<DistributionObjectInterface>();
            }
            this.iDistributionObjects.add(dist);
        }

        public List<DistributionObjectInterface> getDistributionObjects() {
            return this.iDistributionObjects;
        }

        public boolean hasDistributionObjects() {
            return this.iDistributionObjects != null && !this.iDistributionObjects.isEmpty();
        }

        public void setDistributionObjects(List<DistributionObjectInterface> objects) {
            this.iDistributionObjects = objects;
        }

        public boolean isCanDelete() {
            return this.iCanDelete;
        }

        public void setCanDelete(boolean canDelete) {
            this.iCanDelete = canDelete;
        }

        public boolean hasBackUrl() {
            return this.iBackUrl != null && !this.iBackUrl.isEmpty();
        }

        public void setBackUrl(String backUrl) {
            this.iBackUrl = backUrl;
        }

        public String getBackUrl() {
            return this.iBackUrl;
        }

        public boolean hasBackTitle() {
            return this.iBackTitle != null && !this.iBackTitle.isEmpty();
        }

        public void setBackTitle(String backTitle) {
            this.iBackTitle = backTitle;
        }

        public String getBackTitle() {
            return this.iBackTitle;
        }

        public boolean isConfirms() {
            return this.iConfirms;
        }

        public void setConfirms(boolean confirms) {
            this.iConfirms = confirms;
        }
    }

    public static class DistributionEditRequest
    implements GwtRpcRequest<DistributionEditResponse> {
        private Long iPreferenceId;
        private Long iSubpartId;
        private Long iClassId;
        private Operation iOperation;
        private DistributionEditResponse iData;

        public Long getPreferenceId() {
            return this.iPreferenceId;
        }

        public void setPreferenceId(Long preferenceId) {
            this.iPreferenceId = preferenceId;
        }

        public Long getClassId() {
            return this.iClassId;
        }

        public void setClassId(Long classId) {
            this.iClassId = classId;
        }

        public Long getSubpartId() {
            return this.iSubpartId;
        }

        public void setSubpartId(Long subpartId) {
            this.iSubpartId = subpartId;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation operation) {
            this.iOperation = operation;
        }

        public DistributionEditResponse getData() {
            return this.iData;
        }

        public void setData(DistributionEditResponse data) {
            this.iData = data;
        }

        public static enum Operation {
            GET,
            SAVE,
            DELETE;

        }
    }

    public static class Preferences
    implements IsSerializable,
    Comparable<Preferences> {
        private PreferenceType iType;
        private TreeSet<IdLabel> iItems;
        private List<Selection> iSelections;
        private boolean iAllowHard = true;

        public Preferences() {
        }

        public Preferences(PreferenceType type) {
            this.iType = type;
        }

        public Preferences(Preferences p) {
            this.iType = p.iType;
            if (p.iItems != null) {
                this.iItems = new TreeSet<IdLabel>((SortedSet<IdLabel>)p.iItems);
            }
            if (p.iSelections != null) {
                this.iSelections = new ArrayList<Selection>(p.iSelections);
            }
        }

        public PreferenceType getType() {
            return this.iType;
        }

        public void setType(PreferenceType type) {
            this.iType = type;
        }

        public boolean isAllowHard() {
            return this.iAllowHard;
        }

        public void setAllowHard(boolean allowHard) {
            this.iAllowHard = allowHard;
        }

        public boolean hasItems() {
            return this.iItems != null && !this.iItems.isEmpty();
        }

        public Set<IdLabel> getItems() {
            return this.iItems;
        }

        public IdLabel getItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            for (IdLabel item : this.iItems) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addItem(Long id, String label, String description) {
            IdLabel item;
            if (this.iItems == null) {
                this.iItems = new TreeSet();
            }
            if (!this.iItems.contains(item = new IdLabel(id, label, description))) {
                this.iItems.add(item);
                return item;
            }
            return null;
        }

        public IdLabel removeItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iItems.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public int hashCode() {
            return this.getType().hashCode();
        }

        @Override
        public int compareTo(Preferences other) {
            return this.getType().compareTo(other.getType());
        }

        public boolean hasSelections() {
            return this.iSelections != null && !this.iSelections.isEmpty();
        }

        public void clearSelections() {
            if (this.iSelections != null) {
                this.iSelections.clear();
            }
        }

        public boolean isEmpty() {
            if (this.iSelections != null) {
                for (Selection s : this.iSelections) {
                    if (s.getLevel() == null) continue;
                    return false;
                }
            }
            return true;
        }

        public List<Selection> getSelections() {
            return this.iSelections;
        }

        public void addSelection(Selection selection) {
            if (this.iSelections == null) {
                this.iSelections = new ArrayList<Selection>();
            }
            if (this.getItem(selection.getItem()) != null) {
                this.iSelections.add(selection);
            }
        }

        public Selection getSelection(Long item) {
            if (this.iSelections == null) {
                return null;
            }
            for (Selection selection : this.iSelections) {
                if (!item.equals(selection.getItem())) continue;
                return selection;
            }
            return null;
        }

        public Selection hasNoPrefSelection() {
            if (!this.hasSelections()) {
                return null;
            }
            for (int i = 0; i < this.getSelections().size() - 1; ++i) {
                Selection a = this.getSelections().get(i);
                if (a.getItem() == null || a.getLevel() != null) continue;
                return a;
            }
            return null;
        }

        public Selection hasDuplicateSelection() {
            if (!this.hasSelections()) {
                return null;
            }
            for (int i = 0; i < this.getSelections().size() - 1; ++i) {
                Selection a = this.getSelections().get(i);
                if (a.getItem() == null) continue;
                for (int j = i + 1; j < this.getSelections().size(); ++j) {
                    Selection b = this.getSelections().get(j);
                    if (!a.getItem().equals(b.getItem()) || !PrefGroupEditInterface.equals(a.getRoomIndex(), b.getRoomIndex())) continue;
                    return a;
                }
            }
            return null;
        }

        public boolean equals(Object obj) {
            int originalSelections;
            if (obj == null || !(obj instanceof Preferences)) {
                return false;
            }
            Preferences original = (Preferences)obj;
            if (!PrefGroupEditInterface.equals((Object)this.iType, (Object)original.iType)) {
                return false;
            }
            int selections = this.iSelections == null ? 0 : this.iSelections.size();
            int n = originalSelections = original.iSelections == null ? 0 : original.iSelections.size();
            if (selections != originalSelections) {
                return false;
            }
            if (selections > 0) {
                block0: for (Selection s : this.iSelections) {
                    for (Selection o : original.iSelections) {
                        if (!s.equals(o)) continue;
                        continue block0;
                    }
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return "{ type : " + String.valueOf(this.iType == null ? "-" : this.iType) + ", selections: " + String.valueOf(this.iSelections) + "}";
        }
    }

    public static enum PreferenceType {
        TIME,
        DATE,
        ROOM,
        ROOM_GROUP,
        ROOM_FEATURE,
        BUILDING,
        DISTRIBUTION,
        COURSE;

    }

    public static class TimePreferences
    implements IsSerializable {
        private Long iId;
        private String iType;
        private List<TimePatternModel> iItems;
        private List<TimeSelection> iSelections;
        private boolean iHorizontal = true;

        public TimePreferences() {
        }

        public TimePreferences(Long id, String type) {
            this.iId = id;
            this.iType = type;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getType() {
            return this.iType;
        }

        public void setType(String type) {
            this.iType = type;
        }

        public boolean isHorizontal() {
            return this.iHorizontal;
        }

        public void setHorizontal(boolean horizontal) {
            this.iHorizontal = horizontal;
        }

        public boolean hasItems() {
            return this.iItems != null && !this.iItems.isEmpty();
        }

        public List<TimePatternModel> getItems() {
            return this.iItems;
        }

        public TimePatternModel getItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            for (TimePatternModel item : this.iItems) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public void addItem(TimePatternModel tp) {
            if (this.iItems == null) {
                this.iItems = new ArrayList<TimePatternModel>();
            }
            this.iItems.add(tp);
        }

        public TimePatternModel removeItem(Long id) {
            if (this.iItems == null) {
                return null;
            }
            Iterator<TimePatternModel> i = this.iItems.iterator();
            while (i.hasNext()) {
                TimePatternModel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean hasSelections() {
            return this.iSelections != null && !this.iSelections.isEmpty();
        }

        public void clearSelections() {
            if (this.iSelections != null) {
                this.iSelections.clear();
            }
        }

        public boolean isEmpty() {
            if (this.iSelections != null) {
                for (Selection selection : this.iSelections) {
                    if (selection.getLevel() == null) continue;
                    return false;
                }
            }
            return true;
        }

        public List<TimeSelection> getSelections() {
            return this.iSelections;
        }

        public void addSelection(TimeSelection selection) {
            if (this.iSelections == null) {
                this.iSelections = new ArrayList<TimeSelection>();
            }
            if (this.getItem(selection.getItem()) != null) {
                this.iSelections.add(selection);
            }
        }

        public TimeSelection getSelection(Long item) {
            if (this.iSelections == null) {
                return null;
            }
            for (TimeSelection selection : this.iSelections) {
                if (!item.equals(selection.getItem())) continue;
                return selection;
            }
            return null;
        }

        public String toString() {
            return "{ id : " + this.iId + ", type : " + (String)(this.iType == null ? "null" : "'" + this.iType + "'") + ", selections: " + String.valueOf(this.iSelections) + "}";
        }
    }

    public static class TimeSelection
    extends Selection {
        private String iPreference;

        public TimeSelection() {
        }

        public TimeSelection(Long item, Long level, String preference) {
            super(item, level);
            this.iPreference = preference;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || !(o instanceof TimeSelection)) {
                return false;
            }
            TimeSelection s = (TimeSelection)o;
            return PrefGroupEditInterface.equals(this.getItem(), s.getItem()) && PrefGroupEditInterface.equals(this.getLevel(), s.getLevel()) && PrefGroupEditInterface.equals(this.getPreference(), s.getPreference());
        }

        public String getPreference() {
            return this.iPreference;
        }

        public void setPreference(String preference) {
            this.iPreference = preference;
        }

        @Override
        public String toString() {
            return "{ item : " + this.getItem() + ", preference : " + this.getPreference() + (String)(this.getRoomIndex() == null ? "" : ", room : " + (1 + this.getRoomIndex())) + "}";
        }
    }

    public static class Selection
    implements IsSerializable {
        private Long iItem;
        private Long iLevel;
        private Integer iRoomIndex;

        public Selection() {
        }

        public Selection(Long item, Long level) {
            this.iItem = item;
            this.iLevel = level;
        }

        public Long getItem() {
            return this.iItem;
        }

        public void setItem(Long item) {
            this.iItem = item;
        }

        public Long getLevel() {
            return this.iLevel;
        }

        public void setLevel(Long level) {
            this.iLevel = level;
        }

        public Integer getRoomIndex() {
            return this.iRoomIndex;
        }

        public void setRoomIndex(Integer roomIndex) {
            this.iRoomIndex = roomIndex;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Selection)) {
                return false;
            }
            Selection s = (Selection)o;
            return PrefGroupEditInterface.equals(this.iItem, s.iItem) && PrefGroupEditInterface.equals(this.iLevel, s.iLevel) && PrefGroupEditInterface.equals(this.getRoomIndex(), s.getRoomIndex());
        }

        public String toString() {
            return "{ item : " + this.iItem + ", level : " + this.iLevel + (String)(this.iRoomIndex == null ? "" : ", room: " + (this.iRoomIndex + 1)) + "}";
        }
    }

    public static class TimePatternModel
    implements IsSerializable {
        private boolean iHardAllowed = true;
        private List<Integer> iTimes;
        private List<Integer> iDays;
        private char[][] iPreference;
        private int iLength = 0;
        private int iDayOffset = 0;
        private boolean iExactTime = false;
        private Long iTimePatternId;
        private String iTimePatternName;
        private boolean iValid = true;
        private List<PrefLevel> iPrefLevels;
        private Boolean iHorizontal;
        private int iAssignedDay;
        private int iAssignedTime;

        public TimePatternModel() {
        }

        public TimePatternModel(TimePatternModel tp) {
            if (tp.iTimes != null) {
                this.iTimes = new ArrayList<Integer>(tp.iTimes);
            }
            if (tp.iDays != null) {
                this.iDays = new ArrayList<Integer>(tp.iDays);
            }
            if (tp.iPreference != null) {
                this.iPreference = new char[this.iDays.size()][this.iTimes.size()];
                for (int d = 0; d < this.iDays.size(); ++d) {
                    for (int t = 0; t < this.iTimes.size(); ++t) {
                        this.iPreference[d][t] = tp.iPreference[d][t];
                    }
                }
            }
            this.iLength = tp.iLength;
            this.iDayOffset = tp.iDayOffset;
            this.iExactTime = tp.iExactTime;
            this.iValid = tp.iValid;
            this.iTimePatternId = tp.iTimePatternId;
            this.iTimePatternName = tp.iTimePatternName;
        }

        public Long getId() {
            return this.iTimePatternId;
        }

        public void setId(Long id) {
            this.iTimePatternId = id;
        }

        public String getName() {
            return this.iTimePatternName;
        }

        public void setName(String name) {
            this.iTimePatternName = name;
        }

        public boolean isExactTime() {
            return this.iExactTime;
        }

        public void setExactTime(boolean exactTime) {
            this.iExactTime = exactTime;
        }

        public boolean isValid() {
            return this.iValid;
        }

        public void setValid(boolean valid) {
            this.iValid = valid;
        }

        public boolean hasAllowedPrefs() {
            return !this.iHardAllowed;
        }

        public void setAllowHard(boolean allowHard) {
            this.iHardAllowed = allowHard;
        }

        public boolean isAllowedPref(Character code) {
            if (this.iHardAllowed) {
                return true;
            }
            return code.charValue() != 'R' && code.charValue() != 'P';
        }

        public boolean hasRequired() {
            return !this.isExactTime() && this.getPreference().indexOf(82) >= 0;
        }

        public boolean hasPreference() {
            return !this.isExactTime() && (this.getPreference().indexOf(80) >= 0 || this.getPreference().indexOf(48) >= 0 || this.getPreference().indexOf(49) >= 0 || this.getPreference().indexOf(50) >= 0 || this.getPreference().indexOf(51) >= 0);
        }

        public void addTime(int time) {
            if (this.iTimes == null) {
                this.iTimes = new ArrayList<Integer>();
            }
            this.iTimes.add(time);
        }

        public List<Integer> getTimes() {
            return this.iTimes;
        }

        public void addDays(int days) {
            if (this.iDays == null) {
                this.iDays = new ArrayList<Integer>();
            }
            this.iDays.add(days);
        }

        public List<Integer> getDays() {
            return this.iDays;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public int getLength(Integer length) {
            return this.iLength;
        }

        public void setDayOffset(int offset) {
            this.iDayOffset = offset;
        }

        public int getDayOffset() {
            return this.iDayOffset;
        }

        public void setPreference(String preference) {
            block6: {
                block5: {
                    if (!this.isExactTime()) break block5;
                    if (this.iDays != null) {
                        this.iDays.clear();
                    }
                    if (this.iTimes != null) {
                        this.iTimes.clear();
                    }
                    if (preference == null) break block6;
                    for (String p : preference.split(";")) {
                        if (p.indexOf(44) < 0) continue;
                        this.addDays(Integer.valueOf(p.substring(0, p.indexOf(44))));
                        this.addTime(Integer.valueOf(p.substring(1 + p.indexOf(44))));
                    }
                    break block6;
                }
                this.iPreference = new char[this.iDays.size()][this.iTimes.size()];
                int idx = 0;
                for (int d = 0; d < this.iDays.size(); ++d) {
                    for (int t = 0; t < this.iTimes.size(); ++t) {
                        this.iPreference[d][t] = preference == null || preference.length() <= idx ? 50 : (int)preference.charAt(idx);
                        ++idx;
                    }
                }
            }
        }

        public String getPreference() {
            if (this.isExactTime()) {
                if (this.iDays != null && this.iDays.size() > 0 && this.iTimes != null && this.iTimes.size() > 0) {
                    String ret = null;
                    for (int i = 0; i < Math.min(this.iDays.size(), this.iTimes.size()); ++i) {
                        ret = i == 0 ? String.valueOf(this.iDays.get(i)) + "," + String.valueOf(this.iTimes.get(i)) : ret + ";" + String.valueOf(this.iDays.get(i)) + "," + String.valueOf(this.iTimes.get(i));
                    }
                    return ret;
                }
                return null;
            }
            Object ret = "";
            for (int d = 0; d < this.iDays.size(); ++d) {
                for (int t = 0; t < this.iTimes.size(); ++t) {
                    ret = (String)ret + this.iPreference[d][t];
                }
            }
            return ret;
        }

        public char getPreference(int days, int time) {
            return this.iPreference[days][time];
        }

        public void setPreference(int days, int time, char code) {
            this.iPreference[days][time] = code;
        }

        public Integer getExactTime() {
            if (this.iTimes != null && this.iTimes.size() == 1) {
                return this.iTimes.get(0);
            }
            return null;
        }

        public Integer getExactDays() {
            if (this.iDays != null && this.iDays.size() == 1) {
                return this.iDays.get(0);
            }
            return null;
        }

        public void setExactTime(Integer time) {
            if (this.iTimes != null) {
                this.iTimes.clear();
            }
            if (time != null) {
                this.addTime(time);
            }
        }

        public void setExactDays(Integer days) {
            if (this.iDays != null) {
                this.iDays.clear();
            }
            if (days != null) {
                this.addTime(days);
            }
        }

        public int getNrTimes() {
            return this.iTimes == null ? 0 : this.iTimes.size();
        }

        public int getNrDays() {
            return this.iDays == null ? 0 : this.iDays.size();
        }

        public String getDaysLabel(int index, GwtConstants gwtC) {
            Object shortDays = "";
            Object longDays = "";
            int nrDays = 0;
            int dayCode = this.iDays.get(index);
            for (int i = 0; i < DayCode.values().length; ++i) {
                DayCode dc = DayCode.values()[(i + this.iDayOffset) % DayCode.values().length];
                if ((dc.getCode() & dayCode) == 0) continue;
                ++nrDays;
                shortDays = (String)shortDays + gwtC.shortDays()[dc.ordinal()];
                longDays = (String)longDays + gwtC.days()[dc.ordinal()];
            }
            return nrDays > 1 ? shortDays : longDays;
        }

        public String getStartTime(int index, GwtConstants gwtC) {
            int startSlot = this.iTimes.get(index);
            int min = startSlot * 5;
            int h = min / 60;
            int m = min % 60;
            if (gwtC.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? gwtC.timeShortPm() : gwtC.timeShortAm());
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String getEndTime(int index, GwtConstants gwtC) {
            int startSlot = this.iTimes.get(index);
            int min = startSlot * 5 + this.iLength;
            int h = min / 60;
            int m = min % 60;
            if (gwtC.useAmPm()) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h >= 12 ? gwtC.timeShortPm() : gwtC.timeShortAm());
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public void addPrefLevel(PrefLevel prefLevel) {
            if (this.iPrefLevels == null) {
                this.iPrefLevels = new ArrayList<PrefLevel>();
            }
            this.iPrefLevels.add(prefLevel);
        }

        public List<PrefLevel> getPrefLevels() {
            return this.iPrefLevels;
        }

        public PrefLevel getPrefLevel(Long id) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getId().equals(id)) continue;
                return level;
            }
            return null;
        }

        public PrefLevel getPrefLevel(String code) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getCode().equals(code)) continue;
                return level;
            }
            return null;
        }

        public void setPrefLevels(List<PrefLevel> prefLevels) {
            this.iPrefLevels = prefLevels;
        }

        public boolean isHorizontal() {
            return this.iHorizontal != null && this.iHorizontal != false;
        }

        public void setHorizontal(boolean horizontal) {
            this.iHorizontal = horizontal;
        }

        public void setAssignment(int dayCode, int startSlot) {
            this.iAssignedDay = dayCode;
            this.iAssignedTime = startSlot;
        }

        public boolean isAssigned(int d, int t) {
            return this.iAssignedDay == this.iDays.get(d) && this.iAssignedTime == this.iTimes.get(t);
        }
    }

    public static enum DayCode {
        MON(64),
        TUE(32),
        WED(16),
        THU(8),
        FRI(4),
        SAT(2),
        SUN(1);

        private int iCode;

        private DayCode(int code) {
            this.iCode = code;
        }

        public int getCode() {
            return this.iCode;
        }
    }

    public static class IdLabel
    implements IsSerializable,
    Comparable<IdLabel> {
        private Long iId;
        private String iLabel;
        private String iDescription;
        private String iAllowedPrefs;

        public IdLabel() {
        }

        public IdLabel(Long id, String label, String description) {
            this.iId = id;
            this.iLabel = label;
            this.iDescription = description;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassAssignmentInterface.IdValue)) {
                return false;
            }
            return this.getId().equals(((ClassAssignmentInterface.IdValue)o).getId());
        }

        @Override
        public int compareTo(IdLabel other) {
            return TableInterface.NaturalOrderComparator.compare(this.getLabel(), other.getLabel());
        }

        public boolean hasDescription() {
            return this.iDescription != null && !this.iDescription.isEmpty();
        }

        public String getDescription() {
            return this.iDescription;
        }

        public void setDescription(String description) {
            this.iDescription = description;
        }

        public boolean hasAllowedPrefs() {
            return this.iAllowedPrefs != null && !this.iAllowedPrefs.isEmpty();
        }

        public String getAllowedPrefs() {
            return this.iAllowedPrefs;
        }

        public void setAllowedPrefs(String prefs) {
            this.iAllowedPrefs = prefs;
        }

        public boolean isAllowed(PrefLevel pref) {
            if (this.iAllowedPrefs == null || this.iAllowedPrefs.isEmpty()) {
                return true;
            }
            return this.iAllowedPrefs.indexOf(pref.getTpCode().charValue()) >= 0;
        }

        public String toString() {
            return "{ id : " + this.iId + ", label : " + (String)(this.iLabel == null ? "null" : "'" + this.iLabel + "'") + "}";
        }
    }

    public static class PrefLevel
    implements IsSerializable {
        private Long iId;
        private String iLabel;
        private String iTitle;
        private String iColor;
        private String iCode;
        private Character iTpCode;

        public PrefLevel() {
        }

        public PrefLevel(Long id, String code, String label, String title, String color, char tpCode) {
            this.iId = id;
            this.iCode = code;
            this.iLabel = label;
            this.iTitle = title;
            this.iColor = color;
            this.iTpCode = Character.valueOf(tpCode);
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getCode() {
            return this.iCode;
        }

        public void setCode(String code) {
            this.iCode = code;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public void setLabel(String label) {
            this.iLabel = label;
        }

        public String getTitle() {
            return this.iTitle;
        }

        public void setTitle(String title) {
            this.iTitle = title;
        }

        public String getColor() {
            return this.iColor;
        }

        public void setColor(String color) {
            this.iColor = color;
        }

        public boolean isHard() {
            return "R".equals(this.iCode) || "P".equals(this.iCode);
        }

        public void setTpCode(Character tpCode) {
            this.iTpCode = tpCode;
        }

        public Character getTpCode() {
            return this.iTpCode;
        }

        public String toString() {
            return "{ id : " + this.iId + ", label : " + (String)(this.iLabel == null ? "null" : "'" + this.iLabel + "'") + "}";
        }
    }

    public static class ClassInstr
    implements IsSerializable {
        private Long iId;
        private Long iInstructorId;
        private Long iResponsibilityId;
        private boolean iCheckConflicts = true;
        private int iPercent = 0;

        public ClassInstr() {
        }

        public ClassInstr(Long instructorId, Long responsibilityId) {
            this.iInstructorId = instructorId;
            this.iResponsibilityId = responsibilityId;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Long getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(Long instructorId) {
            this.iInstructorId = instructorId;
        }

        public Long getResponsibilityId() {
            return this.iResponsibilityId;
        }

        public void setResponsibilityId(Long responsibilityId) {
            this.iResponsibilityId = responsibilityId;
        }

        public boolean isCheckConflicts() {
            return this.iCheckConflicts;
        }

        public void setCheckConflicts(boolean checkConflicts) {
            this.iCheckConflicts = checkConflicts;
        }

        public int getPercentShare() {
            return this.iPercent;
        }

        public void setPercentShare(int percent) {
            this.iPercent = percent;
        }

        public int hashCode() {
            if (this.getResponsibilityId() == null) {
                return this.getInstructorId().hashCode();
            }
            return this.getInstructorId().hashCode() ^ this.getResponsibilityId().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ClassInstr)) {
                return false;
            }
            ClassInstr ci = (ClassInstr)o;
            if (!ci.getInstructorId().equals(this.getInstructorId())) {
                return false;
            }
            if (this.getResponsibilityId() == null) {
                return ci.getResponsibilityId() == null;
            }
            return this.getResponsibilityId().equals(ci.getResponsibilityId());
        }
    }

    public static class InstructorAssignmentPreferencesEditResponse
    extends PrefGroupEditResponse {
        private Long iTeachingPrefId;
        private Float iMaxTeachingLoad;
        private Set<Long> iAttributeIds;
        private List<InstructorInterface.AttributeInterface> iAttributes;

        public Long getTeachingPrefId() {
            return this.iTeachingPrefId;
        }

        public void setTeachingPrefId(Long prefId) {
            this.iTeachingPrefId = prefId;
        }

        public Float getMaxTeachingLoad() {
            return this.iMaxTeachingLoad;
        }

        public void setMaxTeachingLoad(Float maxLoad) {
            this.iMaxTeachingLoad = maxLoad;
        }

        public void addInstructorAttribute(InstructorInterface.AttributeInterface attribute) {
            this.addInstructorAttribute(attribute.getId());
        }

        public void addInstructorAttribute(Long attributeId) {
            if (this.iAttributeIds == null) {
                this.iAttributeIds = new HashSet<Long>();
            }
            this.iAttributeIds.add(attributeId);
        }

        public void removeInstructorAttribute(Long attributeId) {
            if (this.iAttributeIds == null) {
                this.iAttributeIds = new HashSet<Long>();
            }
            this.iAttributeIds.remove(attributeId);
        }

        public boolean hasInstructorAttribute(InstructorInterface.AttributeInterface attribute) {
            return this.hasInstructorAttribute(attribute.getId());
        }

        public boolean hasInstructorAttribute(Long attributeId) {
            return this.iAttributeIds != null && this.iAttributeIds.contains(attributeId);
        }

        public Set<Long> getInstructorAttributeIds() {
            return this.iAttributeIds;
        }

        public boolean hasInstructorAttributeIds() {
            return this.iAttributeIds != null && !this.iAttributeIds.isEmpty();
        }

        public List<InstructorInterface.AttributeInterface> getAttributes() {
            return this.iAttributes;
        }

        public void addAttribute(InstructorInterface.AttributeInterface attribute) {
            if (this.iAttributes == null) {
                this.iAttributes = new ArrayList<InstructorInterface.AttributeInterface>();
            }
            this.iAttributes.add(attribute);
        }

        public Set<InstructorInterface.AttributeTypeInterface> getAttributeTypes() {
            TreeSet<InstructorInterface.AttributeTypeInterface> types = new TreeSet<InstructorInterface.AttributeTypeInterface>();
            if (this.iAttributes != null) {
                for (InstructorInterface.AttributeInterface attribute : this.iAttributes) {
                    if (attribute.getType() == null) continue;
                    types.add(attribute.getType());
                }
            }
            return types;
        }

        public List<InstructorInterface.AttributeInterface> getAttributesOfType(InstructorInterface.AttributeTypeInterface type) {
            ArrayList<InstructorInterface.AttributeInterface> ret = new ArrayList<InstructorInterface.AttributeInterface>();
            if (this.iAttributes != null) {
                for (InstructorInterface.AttributeInterface attribute : this.iAttributes) {
                    if (type == null && attribute.getType() == null) {
                        ret.add(attribute);
                    }
                    if (type == null || !type.equals(attribute.getType())) continue;
                    ret.add(attribute);
                }
            }
            return ret;
        }

        public boolean hasAttributesOfType(InstructorInterface.AttributeTypeInterface type) {
            if (this.iAttributes != null) {
                for (InstructorInterface.AttributeInterface attribute : this.iAttributes) {
                    if (type == null && attribute.getType() == null) {
                        return true;
                    }
                    if (type == null || !type.equals(attribute.getType())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class InstructorAssignmentPreferencesEditRequest
    extends PrefGroupEditRequest<InstructorAssignmentPreferencesEditResponse>
    implements GwtRpcRequest<InstructorAssignmentPreferencesEditResponse> {
    }

    public static class InstructorPreferencesEditResponse
    extends PrefGroupEditResponse {
    }

    public static class InstructorPreferencesEditRequest
    extends PrefGroupEditRequest<InstructorPreferencesEditResponse>
    implements GwtRpcRequest<InstructorPreferencesEditResponse> {
    }

    public static class SubpartEditResponse
    extends PrefGroupEditResponse {
        private TableInterface iProperties;
        private Boolean iSearchableDatePattern;
        private Long iDatePatternId;
        private List<IdLabel> iDatePatterns;
        private List<IdLabel> iInstructionalTypes;
        private List<IdLabel> iExtInstructionalTypes;
        private Boolean iAutoSpreadInTime;
        private Boolean iStudentsCanOverlap;
        private Boolean iCreditFractionsAllowed;
        private Float iCreditUnits;
        private Float iCreditMaxUnits;
        private Long iCreditFormatId;
        private List<IdLabel> iCreditFormats;
        private Long iCreditTypeId;
        private List<IdLabel> iCreditTypes;
        private Long iCreditUnitTypeId;
        private List<IdLabel> iCreditUnitTypes;

        public boolean hasProperties() {
            return this.iProperties != null && !this.iProperties.hasProperties();
        }

        public TableInterface getProperties() {
            return this.iProperties;
        }

        public void setProperties(TableInterface properties) {
            this.iProperties = properties;
        }

        public TableInterface.CellInterface addProperty(String text) {
            if (this.iProperties == null) {
                this.iProperties = new TableInterface();
            }
            return this.iProperties.addProperty(text);
        }

        public boolean isAutoSpreadInTime() {
            return this.iAutoSpreadInTime == null || this.iAutoSpreadInTime != false;
        }

        public void setAutoSpreadInTime(Boolean spread) {
            this.iAutoSpreadInTime = spread;
        }

        public boolean isStudentsCanOverlap() {
            return this.iStudentsCanOverlap == null || this.iStudentsCanOverlap != false;
        }

        public void setStudentsCanOverlap(Boolean canOverlap) {
            this.iStudentsCanOverlap = canOverlap;
        }

        public boolean isSearchableDatePattern() {
            return this.iSearchableDatePattern != null && this.iSearchableDatePattern != false;
        }

        public void setSearchableDatePattern(boolean searchableDatePattern) {
            this.iSearchableDatePattern = searchableDatePattern;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public void setDatePatternId(Long datePatternId) {
            this.iDatePatternId = datePatternId;
        }

        public boolean hasDatePatterms() {
            return this.iDatePatterns != null && !this.iDatePatterns.isEmpty();
        }

        public List<IdLabel> getDatePatterns() {
            return this.iDatePatterns;
        }

        public IdLabel getDatePattern(Long id) {
            if (this.iDatePatterns == null) {
                return null;
            }
            for (IdLabel item : this.iDatePatterns) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addDatePattern(Long id, String label, String pattern) {
            if (this.iDatePatterns == null) {
                this.iDatePatterns = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, pattern);
            this.iDatePatterns.add(item);
            return item;
        }

        public IdLabel removeDatePattern(Long id) {
            if (this.iDatePatterns == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iDatePatterns.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public boolean hasInstructionalTypes() {
            return this.iInstructionalTypes != null && !this.iInstructionalTypes.isEmpty();
        }

        public List<IdLabel> getInstructionalTypes() {
            return this.iInstructionalTypes;
        }

        public IdLabel getInstructionalType(Long id) {
            if (this.iInstructionalTypes != null) {
                for (IdLabel item : this.iInstructionalTypes) {
                    if (!id.equals(item.getId())) continue;
                    return item;
                }
            }
            if (this.iExtInstructionalTypes != null) {
                for (IdLabel item : this.iExtInstructionalTypes) {
                    if (!id.equals(item.getId())) continue;
                    return item;
                }
            }
            return null;
        }

        public IdLabel addInstructionalType(Long id, String label, String description) {
            if (this.iInstructionalTypes == null) {
                this.iInstructionalTypes = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, description);
            this.iInstructionalTypes.add(item);
            return item;
        }

        public boolean hasExtInstructionalTypes() {
            return this.iExtInstructionalTypes != null && !this.iExtInstructionalTypes.isEmpty();
        }

        public List<IdLabel> getExtInstructionalTypes() {
            return this.iExtInstructionalTypes;
        }

        public IdLabel addExtInstructionalType(Long id, String label, String description) {
            if (this.iExtInstructionalTypes == null) {
                this.iExtInstructionalTypes = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, description);
            this.iExtInstructionalTypes.add(item);
            return item;
        }

        public boolean isCreditFractionsAllowed() {
            return this.iCreditFractionsAllowed != null && this.iCreditFractionsAllowed != false;
        }

        public void setCreditFractionsAllowed(boolean frectionsAllowed) {
            this.iCreditFractionsAllowed = frectionsAllowed;
        }

        public boolean hasCreditUnits() {
            return this.iCreditUnits != null;
        }

        public Float getCreditUnits() {
            return this.iCreditUnits;
        }

        public void setCreditUnits(Float credits) {
            this.iCreditUnits = credits;
        }

        public boolean hasCreditMaxUnits() {
            return this.iCreditMaxUnits != null;
        }

        public Float getCreditMaxUnits() {
            return this.iCreditMaxUnits;
        }

        public void setCreditMaxUnits(Float credits) {
            this.iCreditMaxUnits = credits;
        }

        public boolean hasCreditFormats() {
            return this.iCreditFormats != null && !this.iCreditFormats.isEmpty();
        }

        public List<IdLabel> getCreditFormats() {
            return this.iCreditFormats;
        }

        public IdLabel getCreditFormat(Long id) {
            if (this.iCreditFormats == null) {
                return null;
            }
            for (IdLabel item : this.iCreditFormats) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel getCreditFormat(String reference) {
            if (this.iCreditFormats == null) {
                return null;
            }
            for (IdLabel item : this.iCreditFormats) {
                if (!reference.equals(item.getDescription())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addCreditFormat(Long id, String label, String reference) {
            if (this.iCreditFormats == null) {
                this.iCreditFormats = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, reference);
            this.iCreditFormats.add(item);
            return item;
        }

        public boolean hasCreditTypes() {
            return this.iCreditTypes != null && !this.iCreditTypes.isEmpty();
        }

        public List<IdLabel> getCreditTypes() {
            return this.iCreditTypes;
        }

        public IdLabel getCreditType(Long id) {
            if (this.iCreditTypes == null) {
                return null;
            }
            for (IdLabel item : this.iCreditTypes) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addCreditType(Long id, String label, String reference) {
            if (this.iCreditTypes == null) {
                this.iCreditTypes = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, reference);
            this.iCreditTypes.add(item);
            return item;
        }

        public boolean hasCreditUnitTypes() {
            return this.iCreditUnitTypes != null && !this.iCreditUnitTypes.isEmpty();
        }

        public List<IdLabel> getCreditUnitTypes() {
            return this.iCreditUnitTypes;
        }

        public IdLabel getCreditUnitType(Long id) {
            if (this.iCreditUnitTypes == null) {
                return null;
            }
            for (IdLabel item : this.iCreditUnitTypes) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addCreditUnitType(Long id, String label, String reference) {
            if (this.iCreditUnitTypes == null) {
                this.iCreditUnitTypes = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, reference);
            this.iCreditUnitTypes.add(item);
            return item;
        }

        public String getCreditFormat() {
            if (this.iCreditFormatId == null) {
                return null;
            }
            IdLabel format = this.getCreditFormat(this.iCreditFormatId);
            return format == null ? null : format.getDescription();
        }

        public Long getCreditFormatId() {
            return this.iCreditFormatId;
        }

        public void setCreditFormatId(Long id) {
            this.iCreditFormatId = id;
        }

        public Long getCreditTypeId() {
            return this.iCreditTypeId;
        }

        public void setCreditTypeId(Long id) {
            this.iCreditTypeId = id;
        }

        public Long getCreditUnitTypeId() {
            return this.iCreditUnitTypeId;
        }

        public void setCreditUnitTypeId(Long id) {
            this.iCreditUnitTypeId = id;
        }
    }

    public static class SubpartEditRequest
    extends PrefGroupEditRequest<SubpartEditResponse>
    implements GwtRpcRequest<SubpartEditResponse> {
    }

    public static class ClassEditResponse
    extends PrefGroupEditResponse {
        private TableInterface iProperties;
        private TableInterface iTimetable;
        private Boolean iSearchableDatePattern;
        private Long iDatePatternId;
        private List<IdLabel> iDatePatterns;
        private Boolean iDisplayInstructors;
        private Boolean iStudentScheduling;
        private String iScheduleNote;
        private String iRequestNote;
        private List<IdLabel> iResponsibilities;
        private List<IdLabel> iInstructors;
        private List<ClassInstr> iClassInstructors;
        private InheritInstructorPrefs iInheritInstructorPrefs;
        private Long iDefaultResponsibilityId;

        public boolean hasProperties() {
            return this.iProperties != null && !this.iProperties.hasProperties();
        }

        public TableInterface getProperties() {
            return this.iProperties;
        }

        public void setProperties(TableInterface properties) {
            this.iProperties = properties;
        }

        public TableInterface.CellInterface addProperty(String text) {
            if (this.iProperties == null) {
                this.iProperties = new TableInterface();
            }
            return this.iProperties.addProperty(text);
        }

        public InheritInstructorPrefs getInheritInstructorPrefs() {
            return this.iInheritInstructorPrefs == null ? InheritInstructorPrefs.NEVER : this.iInheritInstructorPrefs;
        }

        public void setInheritInstructorPrefs(InheritInstructorPrefs prefs) {
            this.iInheritInstructorPrefs = prefs;
        }

        public boolean hasTimetable() {
            return this.iTimetable != null;
        }

        public TableInterface getTimetable() {
            return this.iTimetable;
        }

        public void setTimetable(TableInterface timetable) {
            this.iTimetable = timetable;
        }

        public boolean isDisplayInstructors() {
            return this.iDisplayInstructors == null || this.iDisplayInstructors != false;
        }

        public void setDisplayInstructors(Boolean display) {
            this.iDisplayInstructors = display;
        }

        public boolean isStudentScheduling() {
            return this.iStudentScheduling == null || this.iStudentScheduling != false;
        }

        public void setStudentScheduling(Boolean scheduling) {
            this.iStudentScheduling = scheduling;
        }

        public String getScheduleNote() {
            return this.iScheduleNote;
        }

        public boolean hasScheduleNote() {
            return this.iScheduleNote != null && !this.iScheduleNote.isEmpty();
        }

        public void setScheduleNote(String note) {
            this.iScheduleNote = note;
        }

        public String getRequestNote() {
            return this.iRequestNote;
        }

        public boolean hasRequestNote() {
            return this.iRequestNote != null && !this.iRequestNote.isEmpty();
        }

        public void setRequestNote(String note) {
            this.iRequestNote = note;
        }

        public boolean isSearchableDatePattern() {
            return this.iSearchableDatePattern != null && this.iSearchableDatePattern != false;
        }

        public void setSearchableDatePattern(boolean searchableDatePattern) {
            this.iSearchableDatePattern = searchableDatePattern;
        }

        public Long getDatePatternId() {
            return this.iDatePatternId;
        }

        public void setDatePatternId(Long datePatternId) {
            this.iDatePatternId = datePatternId;
        }

        public boolean hasDatePatterms() {
            return this.iDatePatterns != null && !this.iDatePatterns.isEmpty();
        }

        public List<IdLabel> getDatePatterns() {
            return this.iDatePatterns;
        }

        public IdLabel getDatePattern(Long id) {
            if (this.iDatePatterns == null) {
                return null;
            }
            for (IdLabel item : this.iDatePatterns) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addDatePattern(Long id, String label, String pattern) {
            if (this.iDatePatterns == null) {
                this.iDatePatterns = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, pattern);
            this.iDatePatterns.add(item);
            return item;
        }

        public IdLabel removeDatePattern(Long id) {
            if (this.iDatePatterns == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iDatePatterns.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public boolean hasInstructors() {
            return this.iInstructors != null && !this.iInstructors.isEmpty();
        }

        public List<IdLabel> getInstructors() {
            return this.iInstructors;
        }

        public IdLabel getInstructor(Long id) {
            if (this.iInstructors == null) {
                return null;
            }
            for (IdLabel item : this.iInstructors) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addInstructor(Long id, String label, String description) {
            if (this.iInstructors == null) {
                this.iInstructors = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, description);
            this.iInstructors.add(item);
            return item;
        }

        public IdLabel removeInstructor(Long id) {
            if (this.iInstructors == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iInstructors.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public boolean hasResponsibilities() {
            return this.iResponsibilities != null && !this.iResponsibilities.isEmpty();
        }

        public List<IdLabel> getResponsibilities() {
            return this.iResponsibilities;
        }

        public IdLabel getResponsibility(Long id) {
            if (this.iResponsibilities == null) {
                return null;
            }
            for (IdLabel item : this.iResponsibilities) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public IdLabel addResponsibility(Long id, String label, String description) {
            if (this.iResponsibilities == null) {
                this.iResponsibilities = new ArrayList<IdLabel>();
            }
            IdLabel item = new IdLabel(id, label, description);
            this.iResponsibilities.add(item);
            return item;
        }

        public IdLabel removeResponsibility(Long id) {
            if (this.iResponsibilities == null) {
                return null;
            }
            Iterator<IdLabel> i = this.iResponsibilities.iterator();
            while (i.hasNext()) {
                IdLabel item = i.next();
                if (!id.equals(item.getId())) continue;
                i.remove();
                return item;
            }
            return null;
        }

        public Long getDefaultResponsibilityId() {
            return this.iDefaultResponsibilityId;
        }

        public void setDefaultResponsibilityId(Long defaultResponsibilityId) {
            this.iDefaultResponsibilityId = defaultResponsibilityId;
        }

        public boolean hasClassInstructors() {
            return this.iClassInstructors != null && !this.iClassInstructors.isEmpty();
        }

        public List<ClassInstr> getClassInstructors() {
            return this.iClassInstructors;
        }

        public void setClassInstructors(List<ClassInstr> classInstructors) {
            this.iClassInstructors = classInstructors;
        }

        public ClassInstr getClassInstructor(Long id) {
            if (this.iClassInstructors == null) {
                return null;
            }
            for (ClassInstr item : this.iClassInstructors) {
                if (!id.equals(item.getId())) continue;
                return item;
            }
            return null;
        }

        public void addClassInstructor(ClassInstr instr) {
            if (this.iClassInstructors == null) {
                this.iClassInstructors = new ArrayList<ClassInstr>();
            }
            this.iClassInstructors.add(instr);
        }

        public ClassInstr removeClassInstructor(Long instructorId, Long responsibilityId) {
            if (this.iClassInstructors == null) {
                return null;
            }
            ClassInstr ci = new ClassInstr(instructorId, responsibilityId);
            Iterator<ClassInstr> i = this.iClassInstructors.iterator();
            while (i.hasNext()) {
                ClassInstr item = i.next();
                if (!ci.equals(item)) continue;
                i.remove();
                return item;
            }
            return null;
        }
    }

    public static class ClassEditRequest
    extends PrefGroupEditRequest<ClassEditResponse>
    implements GwtRpcRequest<ClassEditResponse> {
    }

    public static abstract class PrefGroupEditResponse
    implements GwtRpcResponse {
        private Long iId;
        private Long iPreviousId;
        private Long iNextId;
        private String iName;
        private Preferences iDatePrefs;
        private TimePreferences iTimePrefs;
        private List<PrefLevel> iPrefLevels;
        private List<Preferences> iRoomPrefs;
        private Preferences iDistributionPrefs;
        private Preferences iCoursePrefs;
        private Integer iNbrRooms;
        private String iUrl;
        private String iInstructorUnavailability = null;
        private String iInstructorTimePreferences = null;
        private Boolean iCanClearPrefs;

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public boolean hasRoomPreferences() {
            return this.iRoomPrefs != null && !this.iRoomPrefs.isEmpty();
        }

        public List<Preferences> getRoomPreferences() {
            return this.iRoomPrefs;
        }

        public void addRoomPreference(Preferences pref) {
            if (this.iRoomPrefs == null) {
                this.iRoomPrefs = new ArrayList<Preferences>();
            }
            this.iRoomPrefs.add(pref);
        }

        public Preferences getRoomPreference(PreferenceType type) {
            if (this.iRoomPrefs == null) {
                return null;
            }
            for (Preferences p : this.iRoomPrefs) {
                if (type != p.getType()) continue;
                return p;
            }
            return null;
        }

        public boolean hasTimePreferences() {
            return this.iTimePrefs != null && this.iTimePrefs.hasItems();
        }

        public TimePreferences getTimePreferences() {
            return this.iTimePrefs;
        }

        public void setTimePreferences(TimePreferences datePrefs) {
            this.iTimePrefs = datePrefs;
        }

        public boolean hasDatePreferences() {
            return this.iDatePrefs != null && this.iDatePrefs.hasItems();
        }

        public Preferences getDatePreferences() {
            return this.iDatePrefs;
        }

        public void setDatePreferences(Preferences datePrefs) {
            this.iDatePrefs = datePrefs;
        }

        public boolean hasDistributionPreferences() {
            return this.iDistributionPrefs != null && this.iDistributionPrefs.hasItems();
        }

        public Preferences getDistributionPreferences() {
            return this.iDistributionPrefs;
        }

        public void setDistributionPreferences(Preferences distributionPrefs) {
            this.iDistributionPrefs = distributionPrefs;
        }

        public boolean hasCoursePreferences() {
            return this.iCoursePrefs != null && this.iCoursePrefs.hasItems();
        }

        public Preferences getCoursePreferences() {
            return this.iCoursePrefs;
        }

        public void setCoursePreferences(Preferences coursePrefs) {
            this.iCoursePrefs = coursePrefs;
        }

        public void addPrefLevel(PrefLevel prefLevel) {
            if (this.iPrefLevels == null) {
                this.iPrefLevels = new ArrayList<PrefLevel>();
            }
            this.iPrefLevels.add(prefLevel);
        }

        public List<PrefLevel> getPrefLevels() {
            return this.iPrefLevels;
        }

        public PrefLevel getPrefLevel(Long id) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getId().equals(id)) continue;
                return level;
            }
            return null;
        }

        public PrefLevel getPrefLevel(String code) {
            if (this.iPrefLevels == null) {
                return null;
            }
            for (PrefLevel level : this.iPrefLevels) {
                if (!level.getCode().equals(code)) continue;
                return level;
            }
            return null;
        }

        public void setNbrRooms(int nbrRooms) {
            this.iNbrRooms = nbrRooms;
        }

        public Integer getNbrRooms() {
            return this.iNbrRooms;
        }

        public boolean hasRooms() {
            return this.iNbrRooms != null && this.iNbrRooms > 0;
        }

        public boolean hasMultipleRooms() {
            return this.iNbrRooms != null && this.iNbrRooms > 1;
        }

        public boolean hasUrl() {
            return this.iUrl != null && !this.iUrl.isEmpty();
        }

        public void setUrl(String url) {
            this.iUrl = url;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public void setPreviousId(Long id) {
            this.iPreviousId = id;
        }

        public Long getPreviousId() {
            return this.iPreviousId;
        }

        public void setNextId(Long id) {
            this.iNextId = id;
        }

        public Long getNextId() {
            return this.iNextId;
        }

        public boolean hasInstructorUnavailability() {
            return this.iInstructorUnavailability != null && !this.iInstructorUnavailability.isEmpty();
        }

        public String getInstructorUnavailability() {
            return this.iInstructorUnavailability;
        }

        public void setInstructorUnavailability(String unavailability) {
            this.iInstructorUnavailability = unavailability;
        }

        public boolean hasInstructorTimePrefereneces() {
            return this.iInstructorTimePreferences != null && !this.iInstructorTimePreferences.isEmpty();
        }

        public String getInstructorTimePrefereneces() {
            return this.iInstructorTimePreferences;
        }

        public void setInstructorTimePrefereneces(String preferences) {
            this.iInstructorTimePreferences = preferences;
        }

        public boolean canClearPrefs() {
            return this.iCanClearPrefs != null && this.iCanClearPrefs != false;
        }

        public void setCanClearPrefs(boolean canClearPrefs) {
            this.iCanClearPrefs = canClearPrefs;
        }
    }

    public static abstract class PrefGroupEditRequest<T>
    implements IsSerializable {
        private Long iId;
        private Operation iOperation;
        private T iPayLoad;

        PrefGroupEditRequest() {
        }

        PrefGroupEditRequest(Long id) {
            this.iId = id;
        }

        PrefGroupEditRequest(Long id, Operation op, T payLoad) {
            this.iId = id;
            this.iOperation = op;
            this.iPayLoad = payLoad;
        }

        public Long getId() {
            return this.iId;
        }

        public void setId(Long id) {
            this.iId = id;
        }

        public Operation getOperation() {
            return this.iOperation;
        }

        public void setOperation(Operation op) {
            this.iOperation = op;
        }

        public T getPayLoad() {
            return this.iPayLoad;
        }

        public void setPayLoad(T payLoad) {
            this.iPayLoad = payLoad;
        }
    }

    public static enum InheritInstructorPrefs {
        NEVER,
        ALWAYS,
        ASK;

    }

    public static enum Operation {
        GET,
        UPDATE,
        NEXT,
        PREVIOUS,
        CLEAR_CLASS_PREFS,
        DATE_PATTERN,
        INSTRUCTORS;

    }
}

