/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.curricula.CourseCurriculaTable;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestsWidget;
import org.unitime.timetable.gwt.client.instructor.survey.OfferingDetailWidget;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.reservations.ReservationTable;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.gwt.client.tables.TableWidget;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class OfferingDetailPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimplePanel iRootPanel;
    private SimpleForm iPanel = new SimpleForm(2);
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private int iTeachingRequestsRow = -1;
    private int iReservationsRow = -1;
    private OfferingsInterface.OfferingDetailResponse iResponse;

    public OfferingDetailPage() {
        this.iPanel.removeStyleName("unitime-NotPrintableBottomLine");
        this.iRootPanel = new SimplePanel((Widget)this.iPanel);
        this.iRootPanel.addStyleName("unitime-OfferingDetailPage");
        this.initWidget((Widget)this.iRootPanel);
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"io");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoOfferingId());
        } else {
            this.load(Long.valueOf(id), null);
        }
        this.iHeader.addButton("lock", COURSE.actionLockIO(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.Lock);
            }
        });
        this.iHeader.setEnabled("lock", false);
        this.iHeader.getButton("lock").setAccessKey(COURSE.accessLockIO().charAt(0));
        this.iHeader.getButton("lock").setTitle(COURSE.titleLockIO(COURSE.accessLockIO()));
        this.iHeader.addButton("unlock", COURSE.actionUnlockIO(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.Unlock);
            }
        });
        this.iHeader.setEnabled("unlock", false);
        this.iHeader.getButton("unlock").setAccessKey(COURSE.accessUnlockIO().charAt(0));
        this.iHeader.getButton("unlock").setTitle(COURSE.titleUnlockIO(COURSE.accessUnlockIO()));
        this.iHeader.addButton("add-config", COURSE.actionAddConfiguration(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "instrOfferingConfig?op=" + URL.encodeQueryString((String)COURSE.actionAddConfiguration()) + "&offering=" + OfferingDetailPage.this.iResponse.getOfferingId());
            }
        });
        this.iHeader.setEnabled("add-config", false);
        this.iHeader.getButton("add-config").setAccessKey(COURSE.accessAddConfiguration().charAt(0));
        this.iHeader.getButton("add-config").setTitle(COURSE.titleAddConfiguration(COURSE.accessAddConfiguration()));
        this.iHeader.addButton("cross-list", COURSE.actionCrossLists(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "crossListsModify.action?instrOfferingId=" + OfferingDetailPage.this.iResponse.getOfferingId() + "&uid=" + OfferingDetailPage.this.iResponse.getCourseId() + "&op=" + URL.encodeQueryString((String)COURSE.actionCrossLists()));
            }
        });
        this.iHeader.setEnabled("cross-list", false);
        this.iHeader.getButton("cross-list").setAccessKey(COURSE.accessCrossLists().charAt(0));
        this.iHeader.getButton("cross-list").setTitle(COURSE.titleCrossLists(COURSE.accessCrossLists()));
        this.iHeader.addButton("make-offered", COURSE.actionMakeOffered(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                if (OfferingDetailPage.this.iResponse.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(COURSE.confirmMakeOffered(), new Command(){

                        public void execute() {
                            OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.MakeOffered);
                        }
                    });
                } else {
                    OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.MakeOffered);
                }
            }
        });
        this.iHeader.setEnabled("make-offered", false);
        this.iHeader.getButton("make-offered").setAccessKey(COURSE.accessMakeOffered().charAt(0));
        this.iHeader.getButton("make-offered").setTitle(COURSE.titleMakeOffered(COURSE.accessMakeOffered()));
        this.iHeader.addButton("make-not-offered", COURSE.actionMakeNotOffered(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                if (OfferingDetailPage.this.iResponse.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(COURSE.confirmMakeNotOffered(), new Command(){

                        public void execute() {
                            OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.MakeNotOffered);
                        }
                    });
                } else {
                    OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.MakeNotOffered);
                }
            }
        });
        this.iHeader.setEnabled("make-not-offered", false);
        this.iHeader.getButton("make-not-offered").setAccessKey(COURSE.accessMakeNotOffered().charAt(0));
        this.iHeader.getButton("make-not-offered").setTitle(COURSE.titleMakeNotOffered(COURSE.accessMakeNotOffered()));
        this.iHeader.addButton("delete", COURSE.actionDeleteIO(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                if (OfferingDetailPage.this.iResponse.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(COURSE.confirmDeleteIO(), new Command(){

                        public void execute() {
                            OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.Delete);
                        }
                    });
                } else {
                    OfferingDetailPage.this.load(OfferingDetailPage.this.iResponse.getOfferingId(), OfferingsInterface.OfferingDetailRequest.Action.Delete);
                }
            }
        });
        this.iHeader.setEnabled("delete", false);
        this.iHeader.getButton("delete").setAccessKey(COURSE.accessDeleteIO().charAt(0));
        this.iHeader.getButton("delete").setTitle(COURSE.titleDeleteIO(COURSE.accessDeleteIO()));
        this.iHeader.addButton("previous", COURSE.actionPreviousIO(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "offering?io=" + OfferingDetailPage.this.iResponse.getPreviousId());
            }
        });
        this.iHeader.setEnabled("previous", false);
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousIO().charAt(0));
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousIO(COURSE.accessPreviousIO()));
        this.iHeader.addButton("next", COURSE.actionNextIO(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "offering?io=" + OfferingDetailPage.this.iResponse.getNextId());
            }
        });
        this.iHeader.setEnabled("next", false);
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextIO().charAt(0));
        this.iHeader.getButton("next").setTitle(COURSE.titleNextIO(COURSE.accessNextIO()));
        this.iHeader.addButton("back", COURSE.actionBackIODetail(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "back.action?uri=" + URL.encodeQueryString((String)OfferingDetailPage.this.iResponse.getBackUrl()) + "&backId=" + OfferingDetailPage.this.iResponse.getOfferingId() + "&backType=InstructionalOffering");
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackIODetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
    }

    protected void load(Long offeringId, OfferingsInterface.OfferingDetailRequest.Action action) {
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        OfferingsInterface.OfferingDetailRequest req = new OfferingsInterface.OfferingDetailRequest();
        req.setOfferingId(offeringId);
        req.setAction(action);
        req.setBackId(Window.Location.getParameter((String)"backId"));
        req.setBackType(Window.Location.getParameter((String)"backType"));
        req.setExamId(Window.Location.getParameter((String)"examId"));
        RPC.execute(req, new AsyncCallback<OfferingsInterface.OfferingDetailResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                OfferingDetailPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(final OfferingsInterface.OfferingDetailResponse response) {
                UniTimeHeaderPanel hp;
                OfferingDetailPage.this.iResponse = response;
                if (response.hasUrl()) {
                    ToolBox.open(GWT.getHostPageBaseURL() + response.getUrl());
                    return;
                }
                LoadingWidget.getInstance().hide();
                OfferingDetailPage.this.iPanel.clear();
                OfferingDetailPage.this.iPanel.addHeaderRow((Widget)OfferingDetailPage.this.iHeader);
                OfferingDetailPage.this.iHeader.getHeaderTitlePanel().clear();
                Anchor anchor = new Anchor(response.getName());
                anchor.setHref("offerings?subjectArea=" + response.getSubjectAreaId() + "&courseNbr=" + response.getCoruseNumber() + "#A" + response.getOfferingId());
                anchor.setAccessKey(COURSE.accessBackToIOList().charAt(0));
                anchor.setTitle(COURSE.titleBackToIOList(COURSE.accessBackToIOList()));
                anchor.setStyleName("l8");
                OfferingDetailPage.this.iHeader.getHeaderTitlePanel().add((Widget)anchor);
                TableWidget coursesTable = new TableWidget(response.getCourses());
                coursesTable.setStyleName("unitime-InnerTable");
                coursesTable.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
                OfferingDetailPage.this.iPanel.addRow(COURSE.propertyCourseOfferings(), (Widget)coursesTable);
                for (TableInterface.PropertyInterface property : response.getProperties().getProperties()) {
                    OfferingDetailPage.this.iPanel.addRow(property.getName(), (Widget)new TableWidget.CellWidget(property.getCell(), true));
                }
                if (response.hasOperation("instructor-survey")) {
                    OfferingDetailPage.this.iTeachingRequestsRow = OfferingDetailPage.this.iPanel.addRow((Widget)new OfferingDetailWidget().forOfferingId(response.getOfferingId()));
                }
                if (response.hasOperation("curricula")) {
                    OfferingDetailPage.this.iPanel.addRow((Widget)new CourseCurriculaTable(true, true).forOfferingId(response.getOfferingId()));
                }
                if (response.hasOperation("reservations")) {
                    OfferingDetailPage.this.iReservationsRow = OfferingDetailPage.this.iPanel.addRow((Widget)new ReservationTable(response.hasOperation("reservations-editable"), true).forOfferingId(response.getOfferingId()));
                }
                if (response.hasConfigs()) {
                    for (final OfferingsInterface.OfferingConfigInterface config : response.getConfigs()) {
                        UniTimeHeaderPanel hp2 = new UniTimeHeaderPanel(config.getName());
                        OfferingDetailPage.this.iPanel.addHeaderRow((Widget)hp2);
                        OfferingDetailPage.this.iPanel.addRow((Widget)new TableWidget(config));
                        if (config.hasAnchor()) {
                            Anchor a = new Anchor();
                            a.setName(config.getAnchor());
                            a.getElement().setId(config.getAnchor());
                            hp2.insertLeft((Widget)a, false);
                        }
                        if (config.hasOperation("config-edit")) {
                            hp2.addButton("config-edit", COURSE.actionEditConfiguration(), new ClickHandler(){

                                public void onClick(ClickEvent evt) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + "instrOfferingConfig?id=" + config.getConfigId());
                                }
                            });
                            hp2.getButton("config-edit").setTitle(COURSE.titleEditConfiguration());
                        }
                        if (config.hasOperation("class-setup")) {
                            hp2.addButton("class-setup", COURSE.actionClassSetup(), new ClickHandler(){

                                public void onClick(ClickEvent evt) {
                                    ToolBox.open(GWT.getHostPageBaseURL() + "multipleClassSetup?id=" + config.getConfigId());
                                }
                            });
                            hp2.getButton("class-setup").setTitle(COURSE.titleClassSetup());
                        }
                        if (!config.hasOperation("assign-instructors")) continue;
                        hp2.addButton("assign-instructors", COURSE.actionAssignInstructors(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "assignClassInstructors?configId=" + config.getConfigId());
                            }
                        });
                        hp2.getButton("assign-instructors").setTitle(COURSE.titleAssignInstructors());
                    }
                }
                if (response.hasOperation("teaching-requests")) {
                    OfferingDetailPage.this.iTeachingRequestsRow = OfferingDetailPage.this.iPanel.addRow((Widget)new TeachingRequestsWidget().forOfferingId(response.getOfferingId()));
                }
                if (response.hasDistributions()) {
                    hp = new UniTimeHeaderPanel(response.getDistributions().getName());
                    OfferingDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    OfferingDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getDistributions()));
                }
                if (response.hasExaminations()) {
                    hp = new UniTimeHeaderPanel(response.getExaminations().getName());
                    OfferingDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    OfferingDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getExaminations()));
                    if (response.hasOperation("add-exam")) {
                        hp.addButton("add-exam", COURSE.actionAddExamination(), new ClickHandler(){

                            public void onClick(ClickEvent evt) {
                                ToolBox.open(GWT.getHostPageBaseURL() + "examEdit.action?firstType=InstructionalOffering&firstId=" + response.getOfferingId());
                            }
                        });
                        hp.getButton("add-exam").setAccessKey(COURSE.accessAddExamination().charAt(0));
                        hp.getButton("add-exam").setTitle(COURSE.titleAddExamination(COURSE.accessAddExamination()));
                    }
                }
                if (response.hasLastChanges()) {
                    hp = new UniTimeHeaderPanel(response.getLastChanges().getName());
                    OfferingDetailPage.this.iPanel.addHeaderRow((Widget)hp);
                    OfferingDetailPage.this.iPanel.addRow((Widget)new TableWidget(response.getLastChanges()));
                }
                if (response.isOffered()) {
                    OfferingDetailPage.this.iPanel.addRow((Widget)new EnrollmentTable(true, true, true).forOfferingId(response.getOfferingId()));
                }
                OfferingDetailPage.this.iPanel.addBottomRow((Widget)OfferingDetailPage.this.iFooter);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        Element e;
                        String token = Window.Location.getHash();
                        if ((token != null && (token.startsWith("#A") || token.equals("#back")) || token.startsWith("#ioc")) && (e = Document.get().getElementById(token.substring(1))) != null) {
                            ToolBox.scrollToElement(e);
                        }
                        if ((e = Document.get().getElementById("back")) != null) {
                            ToolBox.scrollToElement(e);
                        }
                        if (token.equals("#reservations") && OfferingDetailPage.this.iReservationsRow >= 0) {
                            ToolBox.scrollToElement((Element)OfferingDetailPage.this.iPanel.getRowFormatter().getElement(OfferingDetailPage.this.iReservationsRow));
                        }
                        if (token.equals("#instructors") && OfferingDetailPage.this.iTeachingRequestsRow >= 0) {
                            ToolBox.scrollToElement((Element)OfferingDetailPage.this.iPanel.getRowFormatter().getElement(OfferingDetailPage.this.iTeachingRequestsRow));
                        }
                    }
                });
                for (String op : OfferingDetailPage.this.iHeader.getOperations()) {
                    OfferingDetailPage.this.iHeader.setEnabled(op, response.hasOperation(op));
                }
                if (response.hasBackTitle()) {
                    OfferingDetailPage.this.iHeader.getButton("back").setTitle(COURSE.titleBackIODetail(COURSE.accessBackIODetail()).replace("%%", response.getBackTitle()));
                    OfferingDetailPage.this.iFooter.getButton("back").setTitle(COURSE.titleBackIODetail(COURSE.accessBackIODetail()).replace("%%", response.getBackTitle()));
                }
                UniTimeNavigation.getInstance().refresh();
            }
        });
    }
}

