/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.offerings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.offerings.OfferingsInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.NumberBox;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseNull;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;

public class CrossListPage
extends Composite {
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    private static final GwtResources RES = (GwtResources)GWT.create(GwtResources.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iPanel = new SimpleForm();
    private Label iLimit;
    private Label iError;
    private ListBox iCourses;
    private Button iAddCourse;
    private UniTimeHeaderPanel iHeader;
    private UniTimeHeaderPanel iFooter;
    private OfferingsInterface.CrossListGetResponse iCrossList;
    private UniTimeTable<OfferingsInterface.CrossListedCourse> iTable;
    private int iLimitRow = -1;

    public CrossListPage() {
        this.iPanel.addStyleName("unitime-CrossListPage");
        this.iHeader = new UniTimeHeaderPanel();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        P limitPanel = new P("offering-limit");
        this.iLimit = new Label();
        limitPanel.add((Widget)this.iLimit);
        this.iError = new Label();
        this.iError.addStyleName("unitime-ErrorMessage");
        this.iError.setVisible(false);
        limitPanel.add((Widget)this.iError);
        this.iLimitRow = this.iPanel.addRow(COURSE.propertyIOLimit(), (Widget)limitPanel);
        this.iCourses = new ListBox();
        this.iCourses.getElement().getStyle().setMarginRight(10.0, Style.Unit.PX);
        this.iAddCourse = new Button(COURSE.actionAddCourseToCrossList());
        this.iAddCourse.setTitle(COURSE.titleAddCourseToCrossList(COURSE.accessAddCourseToCrossList()));
        this.iAddCourse.setAccessKey(COURSE.accessAddCourseToCrossList().charAt(0));
        this.iAddCourse.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                int col;
                if (CrossListPage.this.iCourses.getSelectedIndex() <= 0) {
                    return;
                }
                OfferingsInterface.CrossListedCourse clc = CrossListPage.this.iCrossList.getAvailableCourse(Long.valueOf(CrossListPage.this.iCourses.getSelectedValue()));
                int controllingLine = -1;
                for (int i = 1; i < CrossListPage.this.iTable.getRowCount() - 1; ++i) {
                    RadioButton control = (RadioButton)CrossListPage.this.iTable.getWidget(i, 1);
                    if (!control.getValue().booleanValue()) continue;
                    controllingLine = i;
                    break;
                }
                for (col = 0; col < CrossListPage.this.iTable.getCellCount(CrossListPage.this.iTable.getRowCount() - 2); ++col) {
                    CrossListPage.this.iTable.getCellFormatter().addStyleName(CrossListPage.this.iTable.getRowCount() - 2, col, "BottomBorderGray");
                }
                CrossListPage.this.iTable.setRow(CrossListPage.this.iTable.insertRow(CrossListPage.this.iTable.getRowCount() - 1), clc, CrossListPage.this.toLine(clc));
                if (controllingLine >= 0) {
                    ((RadioButton)CrossListPage.this.iTable.getWidget(controllingLine, 1)).setValue(Boolean.valueOf(true));
                }
                for (col = 0; col < CrossListPage.this.iTable.getCellCount(CrossListPage.this.iTable.getRowCount() - 2); ++col) {
                    CrossListPage.this.iTable.getCellFormatter().addStyleName(CrossListPage.this.iTable.getRowCount() - 2, col, "BottomBorderGray");
                }
                CrossListPage.this.updateAvaliableCourses();
            }
        });
        P panel = new P("course-selection");
        panel.add((Widget)this.iCourses);
        panel.add((Widget)this.iAddCourse);
        P hint = new P("unitime-Hint");
        hint.setText(COURSE.hintCrossLists());
        panel.add((Widget)hint);
        this.iPanel.addRow(COURSE.propertyCourseOfferings(), (Widget)panel);
        this.iTable = new UniTimeTable();
        this.iPanel.addRow("", (Widget)this.iTable);
        this.iHeader.addButton("update", COURSE.actionUpdateCrossLists(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                OfferingsInterface.CrossListUpdateRequest request = new OfferingsInterface.CrossListUpdateRequest();
                request.setOfferingId(CrossListPage.this.iCrossList.getOfferingId());
                request.setCourses(CrossListPage.this.iTable.getData());
                RPC.execute(request, new AsyncCallback<GwtRpcResponseNull>(){

                    public void onFailure(Throwable caught) {
                        LoadingWidget.getInstance().hide();
                        CrossListPage.this.iHeader.setErrorMessage(caught.getMessage());
                        UniTimeNotifications.error(caught.getMessage(), caught);
                    }

                    public void onSuccess(GwtRpcResponseNull response) {
                        LoadingWidget.getInstance().hide();
                        ToolBox.open(GWT.getHostPageBaseURL() + "offering?id=" + CrossListPage.this.iCrossList.getOfferingId());
                    }
                });
            }
        });
        this.iHeader.setEnabled("update", false);
        this.iHeader.getButton("update").setAccessKey(COURSE.accessUpdateCrossLists().charAt(0));
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdateCrossLists(COURSE.accessUpdateCrossLists()));
        this.iHeader.addButton("back", COURSE.actionBackToIODetail(), new ClickHandler(){

            public void onClick(ClickEvent evt) {
                ToolBox.open(GWT.getHostPageBaseURL() + "offering?id=" + CrossListPage.this.iCrossList.getOfferingId());
            }
        });
        this.iHeader.setEnabled("back", false);
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackToIODetail().charAt(0));
        this.iHeader.getButton("back").setTitle(COURSE.titleBackToIODetail(COURSE.accessBackToIODetail()));
        this.iFooter = this.iHeader.clonePanel();
        this.iPanel.addBottomRow((Widget)this.iFooter);
        this.initWidget((Widget)this.iPanel);
        String id = Window.Location.getParameter((String)"id");
        if (id == null) {
            id = Window.Location.getParameter((String)"instrOfferingId");
        }
        if (id == null || id.isEmpty()) {
            LoadingWidget.getInstance().hide();
            this.iHeader.setErrorMessage(COURSE.errorNoOfferingId());
        } else {
            this.load(Long.valueOf(id));
        }
    }

    protected List<Widget> toLine(final OfferingsInterface.CrossListedCourse clc) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        line.add((Widget)new Label(clc.getCourseName()));
        Control control = new Control();
        control.setValue(clc.isControl());
        control.setEnabled(clc.isCanEdit());
        control.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> arg0) {
                CrossListPage.this.updateCounts();
            }
        });
        line.add((Widget)control);
        MyNumberBox limit = new MyNumberBox();
        limit.setNegative(false);
        limit.setDecimal(false);
        limit.setValue(clc.getReserved());
        limit.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                CrossListPage.this.updateCounts();
            }
        });
        line.add((Widget)limit);
        RightLabel projected = new RightLabel(clc.hasProjected() ? clc.getProjected().toString() : "-");
        line.add((Widget)projected);
        RightLabel lastterm = new RightLabel(clc.hasLastTerm() ? clc.getLastTerm().toString() : "-");
        line.add((Widget)lastterm);
        ImageButton delete = new ImageButton(RES.delete());
        delete.setEnabled(clc.isCanDelete());
        delete.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent e) {
                if (CrossListPage.this.iTable.getRowCount() <= 3) {
                    return;
                }
                for (int i = 1; i < CrossListPage.this.iTable.getRowCount() - 1; ++i) {
                    OfferingsInterface.CrossListedCourse d = CrossListPage.this.iTable.getData(i);
                    if (!clc.equals(d)) continue;
                    CrossListPage.this.iTable.removeRow(i);
                    break;
                }
                CrossListPage.this.updateAvaliableCourses();
                CrossListPage.this.updateCounts();
            }
        });
        line.add((Widget)delete);
        return line;
    }

    protected void updateAvaliableCourses() {
        this.iCourses.clear();
        HashSet<Long> listed = new HashSet<Long>();
        for (OfferingsInterface.CrossListedCourse clc : this.iTable.getData()) {
            if (clc == null || clc.getCourseId() == null) continue;
            listed.add(clc.getCourseId());
        }
        this.iCourses.addItem(COURSE.itemSelect());
        if (this.iCrossList.hasAvailableCourses()) {
            for (OfferingsInterface.CrossListedCourse clc : this.iCrossList.getAvailableCourses()) {
                if (listed.contains(clc.getCourseId())) continue;
                this.iCourses.addItem(clc.getCourseName(), clc.getCourseId().toString());
            }
        }
        this.updateCounts();
    }

    protected void updateCounts() {
        boolean hasControl = false;
        int total = 0;
        boolean hasLimit = false;
        boolean hasNoLimit = false;
        int projTotal = 0;
        int lastTermTotal = 0;
        int firstEditable = -1;
        for (int i = 1; i < this.iTable.getRowCount() - 1; ++i) {
            NumberBox reserved;
            Integer r;
            OfferingsInterface.CrossListedCourse clc = this.iTable.getData(i);
            RadioButton control = (RadioButton)this.iTable.getWidget(i, 1);
            if (control.getValue().booleanValue()) {
                hasControl = true;
            }
            if ((r = (reserved = (NumberBox)this.iTable.getWidget(i, 2)).toInteger()) != null) {
                total += r.intValue();
                hasLimit = true;
            } else {
                hasNoLimit = true;
            }
            clc.setReserved(r);
            clc.setControl(control.getValue());
            ImageButton delete = (ImageButton)this.iTable.getWidget(i, 5);
            control.setEnabled(clc.isCanEdit() && (i > 1 || this.iTable.getRowCount() > 3));
            delete.setEnabled(clc.isCanDelete() && (i > 1 || this.iTable.getRowCount() > 3));
            delete.setVisible(clc.isCanDelete() && (i > 1 || this.iTable.getRowCount() > 3));
            reserved.setEnabled(this.iCrossList.isSingleCourseLimitAllowed() || i > 1 || this.iTable.getRowCount() > 3);
            reserved.setVisible(this.iCrossList.isSingleCourseLimitAllowed() || i > 1 || this.iTable.getRowCount() > 3);
            if (clc.getProjected() != null) {
                projTotal += clc.getProjected().intValue();
            }
            if (clc.getLastTerm() != null) {
                lastTermTotal += clc.getLastTerm().intValue();
            }
            if (firstEditable >= 0 || !clc.isCanEdit()) continue;
            firstEditable = i;
        }
        Label totalLabel = (Label)this.iTable.getWidget(this.iTable.getRowCount() - 1, 2);
        totalLabel.setText(total <= 0 ? "" : String.valueOf(total));
        Label projLabel = (Label)this.iTable.getWidget(this.iTable.getRowCount() - 1, 3);
        projLabel.setText(projTotal <= 0 ? "" : String.valueOf(projTotal));
        Label lastTermLabel = (Label)this.iTable.getWidget(this.iTable.getRowCount() - 1, 4);
        lastTermLabel.setText(lastTermTotal <= 0 ? "" : String.valueOf(lastTermTotal));
        if (!hasControl && firstEditable >= 0) {
            OfferingsInterface.CrossListedCourse clc = this.iTable.getData(1);
            RadioButton control = (RadioButton)this.iTable.getWidget(firstEditable, 1);
            control.setValue(Boolean.valueOf(true));
            clc.setControl(true);
            hasControl = true;
        }
        if (!hasControl) {
            this.iError.setText(COURSE.errorRequiredControllingCourse());
            this.iError.setVisible(true);
            this.iHeader.setEnabled("update", false);
        } else if (!this.iCrossList.isUnlimited() && hasLimit && !hasNoLimit && this.iCrossList.getLimit() > total && (this.iCrossList.isSingleCourseLimitAllowed() || this.iTable.getRowCount() > 3)) {
            this.iError.setText(COURSE.errorCrossListsLimitsDoNotMatch());
            this.iError.setVisible(true);
            this.iHeader.setEnabled("update", true);
        } else {
            this.iError.setText("");
            this.iError.setVisible(false);
            this.iHeader.setEnabled("update", true);
        }
        if (!this.iCrossList.isUnlimited()) {
            if (total >= this.iCrossList.getLimit()) {
                totalLabel.getElement().getStyle().setColor("green");
            } else {
                totalLabel.getElement().getStyle().setColor("red");
            }
        }
        this.iTable.getRowFormatter().setVisible(this.iTable.getRowCount() - 1, this.iTable.getRowCount() > 3);
        for (int col = 0; col < this.iTable.getCellCount(this.iTable.getRowCount() - 2); ++col) {
            this.iTable.getCellFormatter().removeStyleName(this.iTable.getRowCount() - 2, col, "BottomBorderGray");
        }
    }

    protected void load(Long offeringId) {
        OfferingsInterface.CrossListGetRequest request = new OfferingsInterface.CrossListGetRequest();
        request.setOfferingId(offeringId);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<OfferingsInterface.CrossListGetResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                CrossListPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(OfferingsInterface.CrossListGetResponse response) {
                int col;
                CrossListPage.this.iCrossList = response;
                CrossListPage.this.iHeader.setHeaderTitle(response.getOfferingName());
                if (response.isUnlimited()) {
                    CrossListPage.this.iLimit.setText("\u221e");
                } else if (response.getLimit() != null) {
                    CrossListPage.this.iLimit.setText(response.getLimit().toString());
                } else {
                    CrossListPage.this.iPanel.getRowFormatter().setVisible(CrossListPage.this.iLimitRow, false);
                }
                CrossListPage.this.iTable.clearTable();
                ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
                UniTimeTableHeader hCourse = new UniTimeTableHeader(COURSE.columnCrossListsOffering());
                header.add(hCourse);
                UniTimeTableHeader hControl = new UniTimeTableHeader(COURSE.columnCrossListsControlling());
                hControl.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                header.add(hControl);
                UniTimeTableHeader hReserved = new UniTimeTableHeader(COURSE.columnCrossListsReserved());
                hReserved.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                header.add(hReserved);
                UniTimeTableHeader hProjected = new UniTimeTableHeader(COURSE.columnCrossListsProjected());
                hProjected.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                header.add(hProjected);
                UniTimeTableHeader hLastTerm = new UniTimeTableHeader(COURSE.columnCrossListsLastTerm());
                hLastTerm.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
                header.add(hLastTerm);
                header.add(new UniTimeTableHeader("&nbsp;"));
                CrossListPage.this.iTable.addRow(null, header);
                int projTotal = 0;
                int lastTermTotal = 0;
                int controllingLine = -1;
                for (OfferingsInterface.CrossListedCourse crs : response.getCourses()) {
                    CrossListPage.this.iTable.addRow(crs, CrossListPage.this.toLine(crs));
                    for (col = 0; col < CrossListPage.this.iTable.getCellCount(CrossListPage.this.iTable.getRowCount() - 1); ++col) {
                        CrossListPage.this.iTable.getCellFormatter().addStyleName(CrossListPage.this.iTable.getRowCount() - 1, col, "BottomBorderGray");
                    }
                    if (crs.getProjected() != null) {
                        projTotal += crs.getProjected().intValue();
                    }
                    if (crs.getLastTerm() != null) {
                        lastTermTotal += crs.getLastTerm().intValue();
                    }
                    if (!crs.isControl()) continue;
                    controllingLine = CrossListPage.this.iTable.getRowCount() - 1;
                }
                if (controllingLine >= 0) {
                    ((RadioButton)CrossListPage.this.iTable.getWidget(controllingLine, 1)).setValue(Boolean.valueOf(true));
                }
                for (int col2 = 0; col2 < CrossListPage.this.iTable.getCellCount(CrossListPage.this.iTable.getRowCount() - 1); ++col2) {
                    CrossListPage.this.iTable.getCellFormatter().removeStyleName(CrossListPage.this.iTable.getRowCount() - 1, col2, "BottomBorderGray");
                }
                ArrayList<Label> totals = new ArrayList<Label>();
                totals.add(new Label(COURSE.rowCrossListsTotal()));
                totals.add(new Label(""));
                RightLabel total = new RightLabel("" + projTotal);
                total.getElement().getStyle().setPaddingRight(5.0, Style.Unit.PX);
                totals.add(total);
                totals.add(new RightLabel("" + lastTermTotal));
                totals.add(new RightLabel(""));
                totals.add(new Label(""));
                CrossListPage.this.iTable.addRow(null, totals);
                for (col = 0; col < totals.size(); ++col) {
                    CrossListPage.this.iTable.getCellFormatter().addStyleName(CrossListPage.this.iTable.getRowCount() - 1, col, "rowTotal");
                }
                CrossListPage.this.updateAvaliableCourses();
                CrossListPage.this.updateCounts();
                LoadingWidget.getInstance().hide();
                CrossListPage.this.iHeader.setEnabled("update", true);
                CrossListPage.this.iHeader.setEnabled("back", true);
            }
        });
    }

    static class Control
    extends RadioButton
    implements UniTimeTable.HasCellAlignment {
        Control() {
            super("controlling-course");
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_CENTER;
        }
    }

    static class MyNumberBox
    extends NumberBox
    implements UniTimeTable.HasCellAlignment {
        MyNumberBox() {
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    static class RightLabel
    extends Label
    implements UniTimeTable.HasCellAlignment {
        RightLabel(String label) {
            super(label);
        }

        @Override
        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }
}

