/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor.survey;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.instructor.survey.CourseSelectionBox;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyInterface;
import org.unitime.timetable.gwt.client.instructor.survey.InstructorSurveyPage;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;

public class InstructorSurveyCourseTable
extends UniTimeTable<InstructorSurveyInterface.Course> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private InstructorSurveyInterface.CourseColumn iSortBy = null;
    private boolean iAsc = true;
    private int iCustom = 0;
    private List<InstructorSurveyInterface.CustomField> iCustomFields;
    private boolean iEditable = true;
    private Long iSessionId;

    public InstructorSurveyCourseTable(Long sessionId, List<InstructorSurveyInterface.CustomField> cf, boolean editable) {
        this.iSessionId = sessionId;
        this.iCustomFields = cf;
        this.iEditable = editable;
        this.addStyleName("unitime-InstructorSurveyCourseTable");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final InstructorSurveyInterface.CourseColumn col : InstructorSurveyInterface.CourseColumn.values()) {
            for (int i = 0; i < this.getColSpan(col); ++i) {
                final UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col, i));
                final int index = i;
                if (CourseComparator.isApplicable(col)) {
                    RoomsTable.SortOperation op = new RoomsTable.SortOperation(){

                        public void execute() {
                            InstructorSurveyCourseTable.this.doSort(col, index);
                        }

                        @Override
                        public boolean isApplicable() {
                            return InstructorSurveyCourseTable.this.getRowCount() > 1 && h.isVisible();
                        }

                        @Override
                        public boolean hasSeparator() {
                            return false;
                        }

                        @Override
                        public String getName() {
                            return MESSAGES.opSortBy(this.getColumnName());
                        }

                        @Override
                        public String getColumnName() {
                            return h.getHTML().replace("<br>", " ");
                        }
                    };
                    h.addOperation(op);
                }
                header.add(h);
            }
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(AdminCookie.getInstance().getSortSurveyCourses());
    }

    public int getColSpan(InstructorSurveyInterface.CourseColumn column) {
        switch (column) {
            case CUSTOM: {
                return this.iCustomFields == null ? 0 : this.iCustomFields.size();
            }
        }
        return 1;
    }

    public String getColumnName(InstructorSurveyInterface.CourseColumn column, int index) {
        switch (column) {
            case COURSE: {
                return MESSAGES.colCourse();
            }
            case CUSTOM: {
                return this.iCustomFields.get(index).getName();
            }
        }
        return column.name();
    }

    public Widget getColumnWidget(InstructorSurveyInterface.CourseColumn column, final InstructorSurveyInterface.Course course, int index) {
        switch (column) {
            case COURSE: {
                final CourseSelectionBox box = new CourseSelectionBox(this.iSessionId);
                box.addStyleName("course-box");
                box.setValue(course);
                box.addCourseSelectionHandler(new CourseSelectionHandler(){

                    @Override
                    public void onCourseSelection(CourseSelectionEvent event) {
                        if (event.getValue() == null) {
                            course.setId(null);
                            course.setCourseName(null);
                            course.setCourseTitle(null);
                        } else {
                            course.setId(event.getValue().getCourseId());
                            course.setCourseName(event.getValue().getCourseName());
                            course.setCourseTitle(event.getValue().getCourseTitle());
                            int row = InstructorSurveyCourseTable.this.getRowForWidget((Widget)box);
                            if (row == InstructorSurveyCourseTable.this.getRowCount() - 1) {
                                InstructorSurveyCourseTable.this.addRow(new InstructorSurveyInterface.Course());
                            }
                        }
                    }
                });
                box.setEnabled(this.iEditable);
                return box;
            }
            case CUSTOM: {
                final InstructorSurveyInterface.CustomField cf = this.iCustomFields.get(index);
                if (this.iEditable) {
                    InstructorSurveyPage.Note custom = new InstructorSurveyPage.Note();
                    custom.setCharacterWidth(cf.getLength());
                    custom.getElement().setAttribute("maxlength", "2048");
                    custom.addStyleName("custom-" + cf.getId());
                    custom.setEnabled(this.iEditable);
                    if (course != null && course.hasCustomField(cf)) {
                        custom.setText(course.getCustomField(cf));
                        custom.resizeNotes();
                    }
                    custom.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

                        public void onValueChange(ValueChangeEvent<String> event) {
                            course.setCustomField(cf, (String)event.getValue());
                        }
                    });
                    return custom;
                }
                Label custom = new Label();
                if (course != null && course.hasCustomField(cf)) {
                    custom.setText(course.getCustomField(cf));
                }
                custom.getElement().getStyle().setWidth(6.77 * (double)cf.getLength(), Style.Unit.PX);
                custom.addStyleName("readonly-note");
                return custom;
            }
        }
        return null;
    }

    public void addRow(InstructorSurveyInterface.Course course) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (InstructorSurveyInterface.CourseColumn col : InstructorSurveyInterface.CourseColumn.values()) {
            for (int i = 0; i < this.getColSpan(col); ++i) {
                line.add(this.getColumnWidget(col, course, i));
            }
        }
        this.addRow(course, line);
    }

    public void setData(List<InstructorSurveyInterface.Course> courses) {
        this.clearTable(1);
        if (courses != null) {
            for (InstructorSurveyInterface.Course course : courses) {
                this.addRow(course);
            }
        }
        this.sort();
    }

    protected void doSort(InstructorSurveyInterface.CourseColumn column, int index) {
        if (column == this.iSortBy && index == this.iCustom) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iCustom = index;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortSurveyCourses(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        if (this.iSortBy == InstructorSurveyInterface.CourseColumn.CUSTOM) {
            return this.iAsc ? InstructorSurveyInterface.CourseColumn.values().length + 1 + this.iCustom : -InstructorSurveyInterface.CourseColumn.values().length - this.iCustom - 1;
        }
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
            this.iCustom = 0;
        } else if (sortBy > 0) {
            if (sortBy >= InstructorSurveyInterface.CourseColumn.values().length) {
                this.iCustom = sortBy - InstructorSurveyInterface.CourseColumn.values().length - 1;
                this.iSortBy = InstructorSurveyInterface.CourseColumn.CUSTOM;
                this.iAsc = true;
            } else {
                this.iSortBy = InstructorSurveyInterface.CourseColumn.values()[sortBy - 1];
                this.iAsc = true;
                this.iCustom = 0;
            }
        } else if (-sortBy >= InstructorSurveyInterface.CourseColumn.values().length) {
            this.iCustom = -sortBy - InstructorSurveyInterface.CourseColumn.values().length - 1;
            this.iSortBy = InstructorSurveyInterface.CourseColumn.CUSTOM;
            this.iAsc = false;
        } else {
            this.iSortBy = InstructorSurveyInterface.CourseColumn.values()[-1 - sortBy];
            this.iAsc = false;
            this.iCustom = 0;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        UniTimeTableHeader header = this.getHeader(this.iSortBy.ordinal());
        if (this.iSortBy == InstructorSurveyInterface.CourseColumn.CUSTOM) {
            header = this.getHeader(InstructorSurveyInterface.CourseColumn.CUSTOM.ordinal() + this.iCustom);
        }
        InstructorSurveyInterface.CustomField cf = this.iCustom >= 0 && this.iCustomFields != null && this.iCustom < this.iCustomFields.size() ? this.iCustomFields.get(this.iCustom) : null;
        this.sort(header, new CourseComparator(this.iSortBy, cf, true), this.iAsc);
    }

    public static class CourseComparator
    implements Comparator<InstructorSurveyInterface.Course> {
        private InstructorSurveyInterface.CourseColumn iColumn;
        private boolean iAsc;
        private InstructorSurveyInterface.CustomField iCustomField;

        public CourseComparator(InstructorSurveyInterface.CourseColumn column, InstructorSurveyInterface.CustomField cf, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
            this.iCustomField = cf;
        }

        public int compareById(InstructorSurveyInterface.Course r1, InstructorSurveyInterface.Course r2) {
            return this.compare(r1.getId(), r2.getId());
        }

        public int compareByName(InstructorSurveyInterface.Course r1, InstructorSurveyInterface.Course r2) {
            return this.compare(r1.getCourseName(), r2.getCourseName());
        }

        public int compareByCustom(InstructorSurveyInterface.Course r1, InstructorSurveyInterface.Course r2) {
            if (this.iCustomField != null) {
                return this.compare(r1.getCustomField(this.iCustomField), r2.getCustomField(this.iCustomField));
            }
            return 0;
        }

        protected int compareByColumn(InstructorSurveyInterface.Course r1, InstructorSurveyInterface.Course r2) {
            switch (this.iColumn) {
                case COURSE: {
                    return this.compareByName(r1, r2);
                }
                case CUSTOM: {
                    return this.compareByCustom(r1, r2);
                }
            }
            return this.compareByName(r1, r2);
        }

        public static boolean isApplicable(InstructorSurveyInterface.CourseColumn column) {
            switch (column) {
                case CUSTOM: 
                case COURSE: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(InstructorSurveyInterface.Course r1, InstructorSurveyInterface.Course r2) {
            if (r1.isEmpty()) {
                return r2.isEmpty() ? 0 : 1;
            }
            if (r2.isEmpty()) {
                return -1;
            }
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByName(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareByCustom(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }
    }
}

