/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.instructor.InstructorCookie;
import org.unitime.timetable.gwt.client.instructor.TeachingAssignmentsPage;
import org.unitime.timetable.gwt.client.instructor.TeachingRequestsTable;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;

public class TeachingRequestsWidget
extends SimpleForm {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel(MESSAGES.sectTeachingRequests());
    private TeachingRequestsTable iTable;
    private Long iOfferingId;

    public TeachingRequestsWidget() {
        this.iHeader.addCollapsibleHandler(new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> event) {
                InstructorCookie.getInstance().setShowTeachingRequests((Boolean)event.getValue());
                if (TeachingRequestsWidget.this.iTable != null) {
                    TeachingRequestsWidget.this.iTable.setVisible((Boolean)event.getValue());
                } else if (((Boolean)event.getValue()).booleanValue()) {
                    TeachingRequestsWidget.this.refresh();
                }
            }
        });
        this.iHeader.setCollapsible(InstructorCookie.getInstance().isShowTeachingRequests());
        this.removeStyleName("unitime-NotPrintableBottomLine");
        this.addHeaderRow((Widget)this.iHeader);
        this.iHeader.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.iHeader.addButton("setup", MESSAGES.buttonSetupTeachingRequests(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                ToolBox.open(GWT.getHostPageBaseURL() + "setupTeachingRequests?offeringId=" + TeachingRequestsWidget.this.iOfferingId);
            }
        });
    }

    public void insert(RootPanel panel) {
        this.iOfferingId = Long.valueOf(panel.getElement().getInnerText());
        if (InstructorCookie.getInstance().isShowTeachingRequests()) {
            this.refresh();
        }
        panel.getElement().setInnerText(null);
        panel.add((Widget)this);
        panel.setVisible(true);
    }

    public TeachingRequestsWidget forOfferingId(Long offeringId) {
        this.iOfferingId = offeringId;
        if (InstructorCookie.getInstance().isShowTeachingRequests()) {
            this.refresh();
        }
        return this;
    }

    protected void refresh() {
        this.iHeader.showLoading();
        if (this.iTable == null) {
            this.init();
        } else {
            this.populate();
        }
    }

    protected void init() {
        RPC.execute(new InstructorInterface.TeachingRequestsPagePropertiesRequest(), new AsyncCallback<InstructorInterface.TeachingRequestsPagePropertiesResponse>(){

            public void onFailure(Throwable caught) {
                TeachingRequestsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                TeachingRequestsWidget.this.iHeader.setCollapsible(null);
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.TeachingRequestsPagePropertiesResponse result) {
                TeachingRequestsWidget.this.iTable = new TeachingRequestsTable(){

                    @Override
                    protected void onAssignmentChanged(List<InstructorInterface.AssignmentInfo> assignments) {
                        if (TeachingRequestsWidget.this.iTable.isVisible()) {
                            TeachingRequestsWidget.this.refresh();
                        }
                    }
                };
                TeachingRequestsWidget.this.iTable.setProperties(result);
                TeachingRequestsWidget.this.iTable.setVisible(false);
                TeachingRequestsWidget.this.addRow((Widget)TeachingRequestsWidget.this.iTable);
                TeachingRequestsWidget.this.populate();
            }
        });
    }

    protected void populate() {
        RPC.execute(new InstructorInterface.TeachingRequestsPageRequest(this.iOfferingId), new AsyncCallback<GwtRpcResponseList<InstructorInterface.TeachingRequestInfo>>(){

            public void onFailure(Throwable caught) {
                TeachingRequestsWidget.this.iHeader.setCollapsible(null);
                TeachingRequestsWidget.this.iHeader.setErrorMessage(MESSAGES.failedToLoadTeachingRequests(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadTeachingRequests(caught.getMessage()), caught);
            }

            public void onSuccess(GwtRpcResponseList<InstructorInterface.TeachingRequestInfo> result) {
                TeachingRequestsWidget.this.iHeader.clearMessage();
                LoadingWidget.getInstance().hide();
                TeachingRequestsWidget.this.iTable.populate(result, null);
                TeachingRequestsWidget.this.iTable.setVisible(true);
                String requestId = Window.Location.getParameter((String)"requestId");
                if (requestId != null && !requestId.isEmpty()) {
                    Long id = Long.valueOf(requestId);
                    for (int row = 0; row < TeachingRequestsWidget.this.iTable.getRowCount(); ++row) {
                        TeachingAssignmentsPage.SingleTeachingAssingment a = (TeachingAssignmentsPage.SingleTeachingAssingment)TeachingRequestsWidget.this.iTable.getData(row);
                        if (a == null || a.getRequest() == null || !id.equals(a.getRequest().getRequestId())) continue;
                        ToolBox.scrollToElement((Element)TeachingRequestsWidget.this.iTable.getRowFormatter().getElement(row));
                        break;
                    }
                }
            }
        });
    }
}

