/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.gwt.client.Lookup;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.offerings.PrefGroupEditInterface;
import org.unitime.timetable.gwt.client.page.UniTimeNavigation;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.InstructorInterface;
import org.unitime.timetable.gwt.shared.PersonInterface;

public class InstructorEditPage
extends Composite {
    private static final CourseMessages COURSE = (CourseMessages)GWT.create(CourseMessages.class);
    private static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private SimpleForm iPanel = new SimpleForm();
    private UniTimeHeaderPanel iHeader = new UniTimeHeaderPanel();
    private UniTimeHeaderPanel iFooter;
    private InstructorInterface.InstructorEditResponse iData;
    private TextBox iExternalId;
    private TextBox iAccountName;
    private TextBox iFirstName;
    private TextBox iMiddleName;
    private TextBox iLastName;
    private TextBox iAcadTitle;
    private TextBox iEmail;
    private ListBox iPosition;
    private TextArea iNote;
    private CheckBox iIgnoreTooFar;
    private Lookup iLookupDialog;

    public InstructorEditPage() {
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iHeader.addButton("save", COURSE.actionSaveInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.SAVE);
            }
        });
        this.iHeader.getButton("save").setTitle(COURSE.titleSaveInstructor(COURSE.accessSaveInstructor()));
        this.iHeader.getButton("save").setAccessKey(COURSE.accessSaveInstructor().charAt(0));
        this.iHeader.setEnabled("save", false);
        this.iHeader.addButton("update", COURSE.actionUpdateInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.SAVE);
            }
        });
        this.iHeader.getButton("update").setTitle(COURSE.titleUpdateInstructor(COURSE.actionUpdateInstructor()));
        this.iHeader.getButton("update").setAccessKey(COURSE.actionUpdateInstructor().charAt(0));
        this.iHeader.setEnabled("update", false);
        this.iHeader.addButton("delete", COURSE.actionDeleteInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InstructorEditPage.this.iData.isConfirms()) {
                    UniTimeConfirmationDialog.confirm(COURSE.confirmDeleteInstructor(), new Command(){

                        public void execute() {
                            InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.DELETE);
                        }
                    });
                } else {
                    InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.DELETE);
                }
            }
        });
        this.iHeader.getButton("delete").setTitle(COURSE.titleDeleteInstructor(COURSE.actionDeleteInstructor()));
        this.iHeader.getButton("delete").setAccessKey(COURSE.actionDeleteInstructor().charAt(0));
        this.iHeader.setEnabled("delete", false);
        this.iHeader.addButton("lookup", COURSE.actionLookupInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                String query = (InstructorEditPage.this.iFirstName.getText() + (String)(InstructorEditPage.this.iMiddleName.getText().isEmpty() ? "" : " " + InstructorEditPage.this.iMiddleName.getText()) + " " + InstructorEditPage.this.iLastName.getText()).trim();
                if (query.isEmpty()) {
                    query = InstructorEditPage.this.iEmail.getText();
                }
                if (query.isEmpty()) {
                    query = InstructorEditPage.this.iExternalId.getText();
                }
                InstructorEditPage.this.iLookupDialog.setQuery(query);
                InstructorEditPage.this.iLookupDialog.center();
            }
        });
        this.iHeader.getButton("lookup").setTitle(COURSE.titleLookupInstructor(COURSE.accessLookupInstructor()));
        this.iHeader.getButton("lookup").setAccessKey(COURSE.accessLookupInstructor().charAt(0));
        this.iHeader.setEnabled("lookup", false);
        this.iHeader.addButton("previous", COURSE.actionPreviousInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.PREVIOUS);
            }
        });
        this.iHeader.getButton("previous").setTitle(COURSE.titlePreviousInstructor(COURSE.accessPreviousInstructor()));
        this.iHeader.getButton("previous").setAccessKey(COURSE.accessPreviousInstructor().charAt(0));
        this.iHeader.setEnabled("previous", false);
        this.iHeader.addButton("next", COURSE.actionNextInstructor(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                InstructorEditPage.this.save(InstructorInterface.InstructorEditRequest.Operation.NEXT);
            }
        });
        this.iHeader.getButton("next").setTitle(COURSE.titleNextInstructor(COURSE.accessNextInstructor()));
        this.iHeader.getButton("next").setAccessKey(COURSE.accessNextInstructor().charAt(0));
        this.iHeader.setEnabled("next", false);
        this.iHeader.addButton("back", COURSE.actionBackInstructorDetail(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InstructorEditPage.this.iData.getInstructorId() != null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + InstructorEditPage.this.iData.getInstructorId());
                } else {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructors");
                }
            }
        });
        this.iHeader.getButton("back").setTitle(COURSE.titleBackInstructorDetail(COURSE.accessBackInstructorDetail()));
        this.iHeader.getButton("back").setAccessKey(COURSE.accessBackInstructorDetail().charAt(0));
        this.iFooter = this.iHeader.clonePanel();
        this.initWidget((Widget)this.iPanel);
        this.iExternalId = new TextBox();
        this.iExternalId.setMaxLength(40);
        this.iExternalId.setWidth("100px");
        this.iExternalId.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setExternalId((String)e.getValue());
            }
        });
        this.iAccountName = new TextBox();
        this.iAccountName.setMaxLength(20);
        this.iAccountName.setWidth("100px");
        this.iAccountName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setCareerAcct((String)e.getValue());
            }
        });
        this.iFirstName = new TextBox();
        this.iFirstName.setMaxLength(100);
        this.iFirstName.setWidth("200px");
        this.iFirstName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setFirstName((String)e.getValue());
            }
        });
        this.iMiddleName = new TextBox();
        this.iMiddleName.setMaxLength(100);
        this.iMiddleName.setWidth("200px");
        this.iMiddleName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setMiddleName((String)e.getValue());
            }
        });
        this.iLastName = new TextBox();
        this.iLastName.setMaxLength(100);
        this.iLastName.setWidth("200px");
        this.iLastName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setLastName((String)e.getValue());
            }
        });
        this.iAcadTitle = new TextBox();
        this.iAcadTitle.setMaxLength(50);
        this.iAcadTitle.setWidth("100px");
        this.iAcadTitle.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setAcademicTitle((String)e.getValue());
            }
        });
        this.iEmail = new TextBox();
        this.iEmail.setMaxLength(200);
        this.iEmail.setWidth("300px");
        this.iEmail.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setEmail((String)e.getValue());
            }
        });
        this.iPosition = new ListBox();
        this.iPosition.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent e) {
                String id = InstructorEditPage.this.iPosition.getSelectedValue();
                if (id == null || id.isEmpty()) {
                    InstructorEditPage.this.iData.setPositionId(null);
                } else {
                    InstructorEditPage.this.iData.setPositionId(Long.valueOf(id));
                }
            }
        });
        this.iNote = new TextArea();
        this.iNote.setStyleName("unitime-TextArea");
        this.iNote.setHeight("75px");
        this.iNote.setWidth("500px");
        this.iNote.getElement().setAttribute("maxlength", "2048");
        this.iNote.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> e) {
                InstructorEditPage.this.iData.setNote((String)e.getValue());
            }
        });
        this.iIgnoreTooFar = new CheckBox();
        this.iIgnoreTooFar.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

            public void onValueChange(ValueChangeEvent<Boolean> e) {
                InstructorEditPage.this.iData.setIgnoteTooFar((Boolean)e.getValue());
            }
        });
        this.iLookupDialog = new Lookup();
        this.iLookupDialog.addValueChangeHandler(new ValueChangeHandler<PersonInterface>(){

            public void onValueChange(ValueChangeEvent<PersonInterface> event) {
                PersonInterface person = (PersonInterface)event.getValue();
                if (person != null) {
                    InstructorEditPage.this.iFirstName.setValue((Object)(person.getFirstName() == null ? "" : person.getFirstName()), true);
                    InstructorEditPage.this.iMiddleName.setValue((Object)(person.getMiddleName() == null ? "" : person.getMiddleName()), true);
                    InstructorEditPage.this.iLastName.setValue((Object)(person.getLastName() == null ? "" : person.getLastName()), true);
                    InstructorEditPage.this.iAcadTitle.setValue((Object)(person.getAcademicTitle() == null ? "" : person.getAcademicTitle()), true);
                    InstructorEditPage.this.iExternalId.setValue((Object)(person.getId() == null ? "" : person.getId()), true);
                    InstructorEditPage.this.iEmail.setValue((Object)(person.getEmail() == null ? "" : person.getEmail()), true);
                }
            }
        });
        String id = History.getToken();
        if (id == null || id.isEmpty()) {
            id = Window.Location.getParameter((String)"id");
        }
        if (id == null || id.isEmpty()) {
            id = Window.Location.getParameter((String)"instructorId");
        }
        if (id == null || id.isEmpty()) {
            String deptId = Window.Location.getParameter((String)"departmentId");
            this.load(null, deptId == null || deptId.isEmpty() ? null : Long.valueOf(deptId));
        } else {
            this.load(Long.valueOf(id), null);
        }
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                String token = (String)event.getValue();
                if (token != null && !token.isEmpty()) {
                    InstructorEditPage.this.load(Long.valueOf(token), null);
                } else {
                    InstructorEditPage.this.load(Long.valueOf(Window.Location.getParameter((String)"instructorId")), null);
                }
            }
        });
    }

    protected void save(final InstructorInterface.InstructorEditRequest.Operation op) {
        this.iHeader.clearMessage();
        InstructorInterface.InstructorEditRequest request = new InstructorInterface.InstructorEditRequest();
        request.setInstructorId(this.iData.getInstructorId());
        request.setDepartmentId(this.iData.getDepartmentId());
        request.setOperation(op);
        if (op != InstructorInterface.InstructorEditRequest.Operation.DELETE) {
            request.setData(this.iData);
            if (this.iData.getLastName() == null || this.iData.getLastName().isEmpty()) {
                this.iHeader.setErrorMessage(COURSE.errorRequiredLastName());
                return;
            }
        }
        if (op == InstructorInterface.InstructorEditRequest.Operation.DELETE) {
            LoadingWidget.getInstance().show(MESSAGES.waitDeletingRecord());
        } else {
            LoadingWidget.getInstance().show(MESSAGES.waitSavingRecord());
        }
        RPC.execute(request, new AsyncCallback<InstructorInterface.InstructorEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                InstructorEditPage.this.iHeader.setErrorMessage(caught.getMessage());
                UniTimeNotifications.error(caught.getMessage(), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorEditResponse response) {
                LoadingWidget.getInstance().hide();
                if (response == null) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructors");
                } else if (op == InstructorInterface.InstructorEditRequest.Operation.SAVE) {
                    ToolBox.open(GWT.getHostPageBaseURL() + "instructor?id=" + response.getInstructorId());
                } else {
                    InstructorEditPage.this.populate(response);
                }
            }
        });
    }

    protected void load(Long instructorId, Long departmentId) {
        InstructorInterface.InstructorEditRequest request = new InstructorInterface.InstructorEditRequest();
        request.setInstructorId(instructorId);
        request.setDepartmentId(departmentId);
        request.setOperation(InstructorInterface.InstructorEditRequest.Operation.GET);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingData());
        RPC.execute(request, new AsyncCallback<InstructorInterface.InstructorEditResponse>(){

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                InstructorEditPage.this.iHeader.setErrorMessage(MESSAGES.failedToInitialize(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToInitialize(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }

            public void onSuccess(InstructorInterface.InstructorEditResponse response) {
                LoadingWidget.getInstance().hide();
                InstructorEditPage.this.populate(response);
            }
        });
    }

    protected void populate(InstructorInterface.InstructorEditResponse response) {
        this.iData = response;
        this.iPanel.clear();
        this.iPanel.addHeaderRow((Widget)this.iHeader);
        this.iExternalId.setValue((Object)(this.iData.getExternalId() == null ? "" : this.iData.getExternalId()));
        this.iPanel.addRow(COURSE.propertyExternalId(), (Widget)this.iExternalId);
        this.iAccountName.setValue((Object)(this.iData.getCareerAcct() == null ? "" : this.iData.getCareerAcct()));
        this.iPanel.addRow(COURSE.propertyAccountName(), (Widget)this.iAccountName);
        this.iFirstName.setValue((Object)(this.iData.getFirstName() == null ? "" : this.iData.getFirstName()));
        this.iPanel.addRow(COURSE.propertyFirstName(), (Widget)this.iFirstName);
        this.iMiddleName.setValue((Object)(this.iData.getMiddleName() == null ? "" : this.iData.getMiddleName()));
        this.iPanel.addRow(COURSE.propertyMiddleName(), (Widget)this.iMiddleName);
        this.iLastName.setValue((Object)(this.iData.getLastName() == null ? "" : this.iData.getLastName()));
        this.iPanel.addRow(COURSE.propertyLastName(), (Widget)this.iLastName);
        this.iAcadTitle.setValue((Object)(this.iData.getAcademicTitle() == null ? "" : this.iData.getAcademicTitle()));
        this.iPanel.addRow(COURSE.propertyAcademicTitle(), (Widget)this.iAcadTitle);
        this.iEmail.setValue((Object)(this.iData.getEmail() == null ? "" : this.iData.getEmail()));
        this.iPanel.addRow(COURSE.propertyFirstName(), (Widget)this.iEmail);
        this.iPanel.addRow(COURSE.propertyDepartment(), (Widget)new Label(this.iData.getDepartment()));
        this.iPosition.clear();
        if (this.iData.hasPositions()) {
            this.iPosition.addItem(COURSE.valueNotSet(), "");
            for (PrefGroupEditInterface.IdLabel position : this.iData.getPositions()) {
                this.iPosition.addItem(position.getLabel(), position.getId().toString());
                if (!position.getId().equals(this.iData.getPositionId())) continue;
                this.iPosition.setSelectedIndex(this.iPosition.getItemCount() - 1);
            }
            this.iPanel.addRow(COURSE.propertyInstructorPosition(), (Widget)this.iPosition);
        } else {
            this.iData.setPositionId(null);
            this.iPosition = null;
        }
        this.iNote.setText(this.iData.getNote() == null ? "" : this.iData.getNote());
        this.iPanel.addRow(COURSE.propertyNote(), (Widget)this.iNote);
        this.iIgnoreTooFar.setValue(Boolean.valueOf(this.iData.isIgnoreTooFar()));
        this.iPanel.addRow(COURSE.propertyIgnoreTooFar(), (Widget)this.iIgnoreTooFar);
        this.iPanel.addBottomRow((Widget)this.iFooter);
        this.iHeader.setEnabled("delete", this.iData.isCanDelete());
        this.iHeader.setEnabled("previous", this.iData.hasPrevious());
        this.iHeader.setEnabled("next", this.iData.hasNext());
        this.iHeader.setEnabled("save", this.iData.getInstructorId() == null);
        this.iHeader.setEnabled("update", this.iData.getInstructorId() != null);
        this.iHeader.setEnabled("back", true);
        this.iHeader.setEnabled("lookup", true);
        if (this.iData.getInstructorId() != null && !this.iData.getInstructorId().toString().equals(Window.Location.getParameter((String)"instructorId"))) {
            History.newItem((String)this.iData.getInstructorId().toString(), (boolean)false);
        }
        UniTimePageLabel.getInstance().setPageName(this.iData.getInstructorId() == null ? MESSAGES.pageAddInstructor() : MESSAGES.pageEditInstructor());
        UniTimeNavigation.getInstance().refresh();
    }
}

