/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.instructor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.rooms.RoomSharingWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.shared.RoomInterface;

public class InstructorAvailabilityWidget
extends RoomSharingWidget {
    private static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Hidden iPattern = null;

    public InstructorAvailabilityWidget() {
        super(false);
    }

    public void insert(final RootPanel panel) {
        RPC.execute(InstructorAvailabilityRequest.load(null), new AsyncCallback<InstructorAvailabilityModel>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught);
            }

            public void onSuccess(InstructorAvailabilityModel model) {
                if (panel.getElement().getFirstChildElement() != null) {
                    InstructorAvailabilityWidget.this.iPattern = Hidden.wrap((Element)panel.getElement().getFirstChildElement());
                    model.setPattern(InstructorAvailabilityWidget.this.iPattern.getValue());
                    InstructorAvailabilityWidget.this.addValueChangeHandler(new ValueChangeHandler<RoomInterface.RoomSharingModel>(){

                        public void onValueChange(ValueChangeEvent<RoomInterface.RoomSharingModel> event) {
                            InstructorAvailabilityWidget.this.iPattern.setValue(((RoomInterface.RoomSharingModel)event.getValue()).toString());
                        }
                    });
                    InstructorAvailabilityWidget.this.iEditable = true;
                } else {
                    String pattern = panel.getElement().getInnerText().trim();
                    panel.getElement().setInnerText(null);
                    model.setPattern(pattern);
                    InstructorAvailabilityWidget.this.iEditable = false;
                }
                InstructorAvailabilityWidget.this.setModel(model);
                panel.add((Widget)InstructorAvailabilityWidget.this);
                panel.setVisible(true);
            }
        });
    }

    public InstructorAvailabilityWidget forPattern(String pattern) {
        return this.forPattern(pattern, false);
    }

    public InstructorAvailabilityWidget forPattern(final String pattern, final boolean editable) {
        RPC.execute(InstructorAvailabilityRequest.load(null), new AsyncCallback<InstructorAvailabilityModel>(){

            public void onFailure(Throwable caught) {
                UniTimeNotifications.error(caught);
            }

            public void onSuccess(InstructorAvailabilityModel model) {
                model.setPattern(pattern);
                InstructorAvailabilityWidget.this.iEditable = editable;
                InstructorAvailabilityWidget.this.setShowLegend(false);
                InstructorAvailabilityWidget.this.setModel(model);
            }
        });
        return this;
    }

    public static class InstructorAvailabilityRequest
    implements GwtRpcRequest<InstructorAvailabilityModel> {
        private String iInstructorId;
        private boolean iNotAvailable = false;

        public String getInstructorId() {
            return this.iInstructorId;
        }

        public void setInstructorId(String instructorId) {
            this.iInstructorId = instructorId;
        }

        public boolean isIncludeNotAvailable() {
            return this.iNotAvailable;
        }

        public void setIncludeNotAvailable(boolean notAvailable) {
            this.iNotAvailable = notAvailable;
        }

        public static InstructorAvailabilityRequest load(String instructorId) {
            return InstructorAvailabilityRequest.load(instructorId, false);
        }

        public static InstructorAvailabilityRequest load(String instructorId, boolean includeNotAvailable) {
            InstructorAvailabilityRequest request = new InstructorAvailabilityRequest();
            request.setInstructorId(instructorId);
            request.setIncludeNotAvailable(includeNotAvailable);
            return request;
        }

        @Override
        public String toString() {
            return this.iInstructorId == null ? "NULL" : this.iInstructorId;
        }
    }

    public static class InstructorAvailabilityModel
    extends RoomInterface.RoomSharingModel {
        public InstructorAvailabilityModel() {
        }

        public InstructorAvailabilityModel(InstructorAvailabilityModel model) {
            super(model);
        }

        public char id2char(Long id) {
            if (id == null) {
                return '2';
            }
            switch (id.intValue()) {
                case -1: {
                    return 'R';
                }
                case -2: {
                    return '0';
                }
                case -3: {
                    return '1';
                }
                case -4: {
                    return '2';
                }
                case -5: {
                    return '3';
                }
                case -6: {
                    return '4';
                }
                case -7: {
                    return 'P';
                }
                case -8: {
                    return 'N';
                }
            }
            return '2';
        }

        public Long char2id(char ch) {
            switch (ch) {
                case 'R': {
                    return -1L;
                }
                case '0': {
                    return -2L;
                }
                case '1': {
                    return -3L;
                }
                case '2': {
                    return -4L;
                }
                case '3': {
                    return -5L;
                }
                case '4': {
                    return -6L;
                }
                case 'P': {
                    return -7L;
                }
                case 'N': {
                    return -8L;
                }
            }
            return -4L;
        }

        public String getPattern() {
            Object pattern = "";
            for (int d = 0; d < 7; ++d) {
                for (int s = 0; s < 288; ++s) {
                    RoomInterface.RoomSharingOption option = this.getOption(d, s);
                    pattern = (String)pattern + this.id2char(option == null ? null : option.getId());
                }
            }
            return pattern;
        }

        public void setPattern(String pattern) {
            if (pattern.length() <= 336) {
                boolean req = pattern.indexOf(82) >= 0;
                for (int d = 0; d < 7; ++d) {
                    for (int s = 0; s < 288; ++s) {
                        int ch = 50;
                        try {
                            ch = pattern.charAt(48 * d + s / 6);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.setOption(d, s, this.char2id((char)(req ? (ch == 82 ? 50 : 80) : ch)));
                    }
                }
            } else {
                for (int d = 0; d < 7; ++d) {
                    for (int s = 0; s < 288; ++s) {
                        char ch = '2';
                        try {
                            ch = pattern.charAt(288 * d + s);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        this.setOption(d, s, this.char2id(ch));
                    }
                }
            }
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean isEmpty() {
            if (this.iModel == null) {
                return true;
            }
            Long neutral = this.char2id('2');
            for (Map slot2id : this.iModel.values()) {
                for (Long id : slot2id.values()) {
                    if (neutral.equals(id)) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean hasHard() {
            if (this.iModel == null) {
                return false;
            }
            Long proh = this.char2id('P');
            Long req = this.char2id('R');
            for (Map slot2id : this.iModel.values()) {
                for (Long id : slot2id.values()) {
                    if (!proh.equals(id) && !req.equals(id)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

