/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.aria;

import com.google.gwt.aria.client.Roles;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasAllFocusHandlers;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.Image;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;

public class ImageButton
extends Image
implements HasEnabled,
Focusable,
HasAriaLabel,
HasAllFocusHandlers {
    private ImageResource iUp = null;
    private ImageResource iDown = null;
    private ImageResource iOver = null;
    private ImageResource iDisabled = null;
    private boolean iEnabled = true;
    private boolean iFocusing = false;

    public ImageButton(ImageResource faceUp, ImageResource faceDown, ImageResource faceOver, ImageResource faceDisabled) {
        this.iUp = faceUp;
        this.iDown = faceDown;
        this.iOver = faceOver;
        this.iDisabled = faceDisabled;
        this.setResource(this.iUp);
        this.setTabIndex(0);
        this.setStyleName("unitime-ImageButton");
        Roles.getButtonRole().set((Element)this.getElement());
        this.sinkEvents(896);
        this.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (ImageButton.this.isEnabled() && ImageButton.this.iOver != null) {
                    ImageButton.this.setResource(ImageButton.this.iOver);
                }
            }
        });
        this.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                if (ImageButton.this.isEnabled()) {
                    ImageButton.this.setResource(ImageButton.this.iUp);
                }
            }
        });
        this.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                if (ImageButton.this.isEnabled() && ImageButton.this.iDown != null) {
                    ImageButton.this.setResource(ImageButton.this.iDown);
                }
            }
        });
        this.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                if (ImageButton.this.isEnabled()) {
                    ImageButton.this.setResource(ImageButton.this.iUp);
                }
            }
        });
        this.addStyleName("unitime-ImageButton-focus");
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (ImageButton.this.isEnabled() && ImageButton.this.iOver != null) {
                    ImageButton.this.setResource(ImageButton.this.iOver);
                }
            }
        });
        this.addBlurHandler(new BlurHandler(){

            public void onBlur(BlurEvent event) {
                if (ImageButton.this.isEnabled()) {
                    ImageButton.this.setResource(ImageButton.this.iUp);
                }
            }
        });
    }

    public void setImage(ImageResource image) {
        this.iUp = image;
        this.iOver = image;
        this.setResource(image);
    }

    public ImageButton(ImageResource faceUp, ImageResource faceDown, ImageResource faceOver) {
        this(faceUp, faceDown, faceOver, null);
    }

    public ImageButton(ImageResource faceUp, ImageResource faceOver) {
        this(faceUp, null, faceOver, null);
    }

    public ImageButton(ImageResource faceUp) {
        this(faceUp, null, faceUp, null);
    }

    public boolean isEnabled() {
        return this.iEnabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.iEnabled != enabled) {
            this.iEnabled = enabled;
            this.setResource(enabled ? this.iUp : (this.iDisabled != null ? this.iDisabled : this.iUp));
            if (enabled) {
                this.removeStyleName("unitime-ImageButton-disabled");
            } else {
                this.addStyleName("unitime-ImageButton-disabled");
            }
            Roles.getButtonRole().setAriaDisabledState((Element)this.getElement(), !enabled);
        }
    }

    public void setFace(ImageResource face) {
        this.setResource(face);
    }

    public int getTabIndex() {
        return this.getElement().getTabIndex();
    }

    public void setAccessKey(char key) {
        this.setAccessKey((Element)this.getElement(), key);
    }

    private native void setAccessKey(Element var1, char var2);

    public void setFocus(boolean focused) {
        if (focused) {
            this.getElement().focus();
        } else {
            this.getElement().blur();
        }
    }

    public void setTabIndex(int index) {
        this.getElement().setTabIndex(index);
    }

    protected void onClick() {
        this.getElement().dispatchEvent(Document.get().createClickEvent(1, 0, 0, 0, 0, false, false, false, false));
    }

    public void onBrowserEvent(Event event) {
        if (!this.isEnabled()) {
            return;
        }
        super.onBrowserEvent(event);
        if ((event.getTypeInt() & 0x380) != 0) {
            int type = DOM.eventGetType((Event)event);
            char keyCode = (char)event.getKeyCode();
            switch (type) {
                case 128: {
                    if (keyCode != ' ' && keyCode != '\n' && keyCode != '\r' || this.iDown == null) break;
                    this.setResource(this.iDown);
                    break;
                }
                case 512: {
                    if (keyCode != ' ' && keyCode != '\n' && keyCode != '\r') break;
                    this.setResource(this.iUp);
                    this.onClick();
                }
            }
        }
    }

    @Override
    public String getAriaLabel() {
        return this.getAltText();
    }

    @Override
    public void setAriaLabel(String text) {
        this.setAltText(text);
    }

    public void setAltText(String altText) {
        super.setAltText(altText);
        if (this.getTitle() == null || this.getTitle().isEmpty()) {
            this.setTitle(altText);
        }
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.addDomHandler((EventHandler)handler, FocusEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.addDomHandler((EventHandler)handler, BlurEvent.getType());
    }
}

