/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.admin;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.ServerDateTimeFormat;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.TaskInterface;

public class TaskExecutionsTable
extends UniTimeTable<TaskInterface.TaskExecutionInterface>
implements TakesValue<Collection<TaskInterface.TaskExecutionInterface>> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private TaskExecutionsTableColumn iSortBy = null;
    private boolean iAsc = true;
    private TaskInterface.TaskOptionsInterface iOptions;
    private static DateTimeFormat sDateFormatMeeting = ServerDateTimeFormat.getFormat(CONSTANTS.meetingDateFormat());
    private static DateTimeFormat sDateFormatTS = ServerDateTimeFormat.getFormat(CONSTANTS.timeStampFormatShort());

    public TaskExecutionsTable() {
        this.setStyleName("unitime-PeriodicTaskTable");
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final TaskExecutionsTableColumn column : TaskExecutionsTableColumn.values()) {
            int nrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nrCells; ++idx) {
                UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(column, idx), this.getColumnAlignment(column, idx));
                header.add(h);
            }
        }
        for (final TaskExecutionsTableColumn column : TaskExecutionsTableColumn.values()) {
            if (!TaskExecutionsTableComparator.isApplicable(column) || this.getNbrCells(column) <= 0) continue;
            final UniTimeTableHeader h = (UniTimeTableHeader)header.get(this.getCellIndex(column));
            SortOperation op = new SortOperation(){

                public void execute() {
                    TaskExecutionsTable.this.doSort(column);
                }

                @Override
                public boolean isApplicable() {
                    return TaskExecutionsTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        this.setSortBy(AdminCookie.getInstance().getSortTaskExecutionsBy());
    }

    public void setOptions(TaskInterface.TaskOptionsInterface options) {
        this.iOptions = options;
    }

    public TaskInterface.TaskOptionsInterface getOptions() {
        return this.iOptions;
    }

    protected void doSort(TaskExecutionsTableColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortTaskExecutionsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = TaskExecutionsTableColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = TaskExecutionsTableColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        if (this.getNbrCells(this.iSortBy) == 0) {
            this.iSortBy = TaskExecutionsTableColumn.DATE;
        }
        UniTimeTableHeader header = this.getHeader(this.getCellIndex(this.iSortBy));
        this.sort(header, new TaskExecutionsTableComparator(this.iSortBy, true), this.iAsc);
    }

    protected int getNbrCells(TaskExecutionsTableColumn column) {
        switch (column) {
            default: 
        }
        return 1;
    }

    public String getColumnName(TaskExecutionsTableColumn column, int idx) {
        switch (column) {
            case DATE: {
                return MESSAGES.colTaskScheduleDate();
            }
            case TIME: {
                return MESSAGES.colTaskScheduleTime();
            }
            case QUEUED: {
                return MESSAGES.colTaskQueued();
            }
            case STARTED: {
                return MESSAGES.colTaskStarted();
            }
            case FINISHED: {
                return MESSAGES.colTaskFinished();
            }
            case STATUS: {
                return MESSAGES.colTaskStatus();
            }
            case MESSAGE: {
                return MESSAGES.colTaskStatusMessage();
            }
            case OUTPUT: {
                return MESSAGES.colTaskOutput();
            }
        }
        return column.name();
    }

    public int getColumnIndex(TaskExecutionsTableColumn column) {
        int before = 0;
        for (TaskExecutionsTableColumn c : TaskExecutionsTableColumn.values()) {
            if (c.equals((Object)column)) {
                return before;
            }
            before += this.getNbrCells(c);
        }
        return -1;
    }

    protected HasHorizontalAlignment.HorizontalAlignmentConstant getColumnAlignment(TaskExecutionsTableColumn column, int idx) {
        switch (column) {
            default: 
        }
        return HasHorizontalAlignment.ALIGN_LEFT;
    }

    protected int getCellIndex(TaskExecutionsTableColumn column) {
        int ret = 0;
        for (TaskExecutionsTableColumn c : TaskExecutionsTableColumn.values()) {
            if (c.ordinal() >= column.ordinal()) continue;
            ret += this.getNbrCells(c);
        }
        return ret;
    }

    protected Widget getCell(TaskInterface.TaskExecutionInterface e, TaskExecutionsTableColumn column, int idx) {
        switch (column) {
            case DATE: {
                return new Label(sDateFormatMeeting.format(e.getExecutionDate()));
            }
            case TIME: {
                return new Label(e.getExecutionTime(CONSTANTS));
            }
            case QUEUED: {
                return new Label(e.getQueued() == null ? "" : sDateFormatTS.format(e.getQueued()));
            }
            case STARTED: {
                return new Label(e.getStarted() == null ? "" : sDateFormatTS.format(e.getStarted()));
            }
            case FINISHED: {
                return new Label(e.getFinished() == null ? "" : sDateFormatTS.format(e.getFinished()));
            }
            case STATUS: {
                return new Label(CONSTANTS.taskStatus()[e.getStatus().ordinal()]);
            }
            case MESSAGE: {
                Label message = new Label(e.getStatusMessage() == null ? "" : e.getStatusMessage());
                message.addStyleName("status-message");
                if (e.getStatusMessage() != null) {
                    message.setTitle(e.getStatusMessage());
                }
                return message;
            }
            case OUTPUT: {
                if (e.getOutput() != null) {
                    return new Anchor(e.getOutput(), GWT.getHostPageBaseURL() + "taskfile?e=" + e.getId());
                }
                return new Label("");
            }
        }
        return null;
    }

    public int getRow(Long execId) {
        if (execId == null) {
            return -1;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            TaskInterface.TaskExecutionInterface task = (TaskInterface.TaskExecutionInterface)this.getData(row);
            if (task == null || !execId.equals(task.getId())) continue;
            return row;
        }
        return -1;
    }

    public void scrollToTaskExecution(Long execId) {
        if (execId == null) {
            return;
        }
        for (int row = 1; row < this.getRowCount(); ++row) {
            TaskInterface.TaskExecutionInterface task = (TaskInterface.TaskExecutionInterface)this.getData(row);
            if (task == null || !execId.equals(task.getId())) continue;
            this.getRowFormatter().getElement(row).scrollIntoView();
            return;
        }
    }

    public int addExecution(TaskInterface.TaskExecutionInterface exec) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        for (TaskExecutionsTableColumn column : TaskExecutionsTableColumn.values()) {
            int nbrCells = this.getNbrCells(column);
            for (int idx = 0; idx < nbrCells; ++idx) {
                Object cell = this.getCell(exec, column, idx);
                if (cell == null) {
                    cell = new P(new String[0]);
                }
                widgets.add((Widget)cell);
            }
        }
        for (Widget w : widgets) {
            if (w == null) continue;
            w.addStyleName("status-" + exec.getStatus().name().toLowerCase());
        }
        int row = this.addRow(exec, widgets);
        this.getRowFormatter().setStyleName(row, "row");
        for (int col = 0; col < this.getCellCount(row); ++col) {
            this.getCellFormatter().setStyleName(row, col, "cell");
        }
        return row;
    }

    public void setValue(Collection<TaskInterface.TaskExecutionInterface> value) {
        this.clearTable(1);
        boolean hasOutput = false;
        if (value != null) {
            for (TaskInterface.TaskExecutionInterface exec : value) {
                this.addExecution(exec);
                if (exec.getOutput() == null) continue;
                hasOutput = true;
            }
        }
        this.setColumnVisible(this.getColumnIndex(TaskExecutionsTableColumn.OUTPUT), hasOutput);
        this.sort();
    }

    public Collection<TaskInterface.TaskExecutionInterface> getValue() {
        return this.getData();
    }

    public static enum TaskExecutionsTableColumn {
        DATE,
        TIME,
        QUEUED,
        STARTED,
        FINISHED,
        STATUS,
        MESSAGE,
        OUTPUT;

    }

    public static class TaskExecutionsTableComparator
    implements Comparator<TaskInterface.TaskExecutionInterface> {
        private TaskExecutionsTableColumn iColumn;
        private boolean iAsc;

        public TaskExecutionsTableComparator(TaskExecutionsTableColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        protected int compareByTime(TaskInterface.TaskExecutionInterface e1, TaskInterface.TaskExecutionInterface e2) {
            int cmp = Integer.valueOf(e1.getSlot()).compareTo(e2.getSlot());
            if (cmp != 0) {
                return cmp;
            }
            return e1.getDayOfYear().compareTo(e2.getDayOfYear());
        }

        protected int compareByDate(TaskInterface.TaskExecutionInterface e1, TaskInterface.TaskExecutionInterface e2) {
            int cmp = e1.getDayOfYear().compareTo(e2.getDayOfYear());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.valueOf(e1.getSlot()).compareTo(e2.getSlot());
        }

        protected int compareByStatus(TaskInterface.TaskExecutionInterface e1, TaskInterface.TaskExecutionInterface e2) {
            return e1 == null ? (e2 == null ? 0 : -1) : (e2 == null ? 1 : e1.compareTo(e2));
        }

        protected int compareByColumn(TaskInterface.TaskExecutionInterface e1, TaskInterface.TaskExecutionInterface e2) {
            switch (this.iColumn) {
                case DATE: {
                    return this.compareByDate(e1, e2);
                }
                case TIME: {
                    return this.compareByTime(e1, e2);
                }
                case STATUS: {
                    return this.compareByStatus(e1, e2);
                }
                case QUEUED: {
                    return this.compare(e1.getQueued(), e2.getQueued());
                }
                case FINISHED: {
                    return this.compare(e1.getFinished(), e1.getFinished());
                }
                case STARTED: {
                    return this.compare(e1.getStarted(), e2.getStarted());
                }
                case MESSAGE: {
                    return this.compare(e1.getStatusMessage(), e2.getStatusMessage());
                }
                case OUTPUT: {
                    return this.compare(e1.getOutput(), e2.getOutput());
                }
            }
            return e1.compareTo(e2);
        }

        public static boolean isApplicable(TaskExecutionsTableColumn column) {
            switch (column) {
                case DATE: 
                case TIME: 
                case QUEUED: 
                case STARTED: 
                case FINISHED: 
                case STATUS: 
                case MESSAGE: 
                case OUTPUT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(TaskInterface.TaskExecutionInterface e1, TaskInterface.TaskExecutionInterface e2) {
            int cmp = this.compareByColumn(e1, e2);
            if (cmp != 0) {
                return this.iAsc ? cmp : -cmp;
            }
            return this.iAsc ? e1.compareTo(e2) : e2.compareTo(e1);
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Date n1, Date n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : n1.compareTo(n2));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return b1 == null ? (b2 == null ? 0 : -1) : (b2 == null ? 1 : (b1.booleanValue() == b2.booleanValue() ? 0 : (b1 != false ? 1 : -1)));
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }
}

