/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.ExactTimeMins;
import org.unitime.timetable.model.dao.ExactTimeMinsDAO;

public class ExactTimeEditForm
implements UniTimeForm {
    private static final long serialVersionUID = -7288169370839578510L;
    private List<ExactTimeMins> iExactTimeMins;

    public ExactTimeEditForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
    }

    @Override
    public void reset() {
        this.iExactTimeMins = new ArrayList(ExactTimeMinsDAO.getInstance().findAll());
        Collections.sort(this.iExactTimeMins);
    }

    public void save() throws Exception {
        Transaction tx = null;
        try {
            Session hibSession = ExactTimeMinsDAO.getInstance().getSession();
            if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                tx = hibSession.beginTransaction();
            }
            for (ExactTimeMins ex : this.iExactTimeMins) {
                hibSession.merge((Object)ex);
            }
            if (tx != null) {
                tx.commit();
            }
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public int getSize() {
        return this.iExactTimeMins.size();
    }

    public List<ExactTimeMins> getExactTimeMins() {
        return this.iExactTimeMins;
    }

    public int getMinsPerMtgMin(int idx) {
        return this.iExactTimeMins.get(idx).getMinsPerMtgMin();
    }

    public int getMinsPerMtgMax(int idx) {
        return this.iExactTimeMins.get(idx).getMinsPerMtgMax();
    }

    public int getNrTimeSlots(int idx) {
        return this.iExactTimeMins.get(idx).getNrSlots();
    }

    public int getBreakTime(int idx) {
        return this.iExactTimeMins.get(idx).getBreakTime();
    }

    public void setMinsPerMtgMin(int idx, int minsPerMtgMin) {
        this.iExactTimeMins.get(idx).setMinsPerMtgMin(minsPerMtgMin);
    }

    public void setMinsPerMtgMax(int idx, int minsPerMtgMax) {
        this.iExactTimeMins.get(idx).setMinsPerMtgMax(minsPerMtgMax);
    }

    public void setNrTimeSlots(int idx, int nrTimeSlots) {
        this.iExactTimeMins.get(idx).setNrSlots(nrTimeSlots);
    }

    public void setBreakTime(int idx, int breakTime) {
        this.iExactTimeMins.get(idx).setBreakTime(breakTime);
    }
}

