/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Set;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.UniTimeForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;

public class ApplicationConfigForm
implements UniTimeForm {
    private static final long serialVersionUID = 4677371360700536609L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private String op;
    private String key;
    private String value;
    private String description;
    private boolean allSessions;
    private Long[] sessions = null;
    private boolean showAll = false;

    public ApplicationConfigForm() {
        this.reset();
    }

    @Override
    public void validate(UniTimeAction action) {
        if (this.key == null || this.key.trim().length() == 0) {
            action.addFieldError("form.key", MSG.errorRequiredField(MSG.columnAppConfigKey()));
        }
    }

    @Override
    public void reset() {
        this.op = "list";
        this.key = "";
        this.value = "";
        this.description = "";
        this.allSessions = false;
        this.sessions = null;
        this.showAll = false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public boolean isAllSessions() {
        return this.allSessions;
    }

    public void setAllSessions(boolean allSessions) {
        this.allSessions = allSessions;
    }

    public Set<Session> getListSessions() {
        return new TreeSet<Session>(SessionDAO.getInstance().findAll());
    }

    public Long[] getSessions() {
        return this.sessions;
    }

    public void setSessions(Long[] sessions) {
        this.sessions = sessions;
    }

    public String getType() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        if (p == null) {
            return null;
        }
        Class type = p.type();
        if (type == null || type.equals(String.class)) {
            return null;
        }
        if (type.equals(Class.class) && p.implementation() != null) {
            if (p.implementation().isInterface()) {
                return "class implementing " + p.implementation().getSimpleName();
            }
            return "class extending " + p.implementation().getSimpleName();
        }
        return type.getSimpleName().toLowerCase();
    }

    public String getValues() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        if (p == null) {
            return null;
        }
        String[] vals = p.availableValues();
        if (vals != null && vals.length > 0) {
            Object ret = "";
            for (int i = 0; i < vals.length; ++i) {
                if (i > 0) {
                    ret = (String)ret + ", ";
                }
                ret = (String)ret + vals[i];
            }
            return ret;
        }
        return null;
    }

    public String getDefault() {
        ApplicationProperty p = ApplicationProperty.fromKey(this.key);
        return p != null ? p.defaultValue() : null;
    }

    public boolean getShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }
}

