/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;

public class JavaScriptCacheFilter
implements Filter {
    public void init(FilterConfig cfg) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setDateHeader("Date", System.currentTimeMillis());
            httpResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
            if (httpRequest.getRequestURI().endsWith(".nocache.js")) {
                httpResponse.setHeader("Pragma", "no-cache");
                httpResponse.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
                chain.doFilter(request, response);
            } else {
                httpResponse.setHeader("Cache-control", "private, max-age=86400, must-revalidate");
                chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(httpResponse){

                    public void addHeader(String name, String value) {
                        if (!"Pragma".equalsIgnoreCase(name)) {
                            super.addHeader(name, value);
                        }
                    }

                    public void setHeader(String name, String value) {
                        if (!"Pragma".equalsIgnoreCase(name)) {
                            super.setHeader(name, value);
                        }
                    }
                });
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

