/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.rooms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.rooms.RoomsComparator;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.RoomFeatureTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.webutil.RequiredTimeTable;

public abstract class RoomsExporter
implements Exporter {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public void export(ExportHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId);
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        RoomInterface.RoomFilterRpcRequest request = new RoomInterface.RoomFilterRpcRequest();
        request.setCommand(EventInterface.FilterRpcRequest.Command.ENUMERATE);
        request.setSessionId(sessionId);
        Enumeration<String> e = helper.getParameterNames();
        while (e.hasMoreElements()) {
            String command = e.nextElement();
            if (command.equals("r:text")) {
                request.setText(helper.getParameter("r:text"));
                continue;
            }
            if (!command.startsWith("r:")) continue;
            for (String value : helper.getParameterValues(command)) {
                request.addOption(command.substring(2), value);
            }
        }
        request.addOption("flag", "plain");
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), sessionId);
        if (context.isAuthenticated() && context.getUser().getExternalUserId() != null) {
            request.setOption("user", context.getUser().getExternalUserId());
        }
        context.checkPermission(Right.Rooms);
        ExportContext ec = new ExportContext();
        if (helper.getParameter("dm") != null) {
            ec.setDepartmentMode(Integer.parseInt(helper.getParameter("dm")));
        }
        ec.setNrDepartments(Department.findAllBeingUsed(sessionId).size());
        EventInterface.FilterRpcResponse response = new EventInterface.FilterRpcResponse();
        new RoomDetailsBackend().enumarate(request, response, context);
        ArrayList<RoomInterface.RoomDetailInterface> rooms = new ArrayList<RoomInterface.RoomDetailInterface>();
        if (response.hasResults()) {
            for (EventInterface.FilterRpcResponse.Entity e2 : response.getResults()) {
                rooms.add((RoomInterface.RoomDetailInterface)e2);
            }
        }
        if (helper.getParameter("sort") != null) {
            RoomsComparator cmp = null;
            try {
                int sort = Integer.parseInt(helper.getParameter("sort"));
                if (sort > 0) {
                    cmp = new RoomsComparator(RoomInterface.RoomsColumn.values()[sort - 1], true);
                } else if (sort < 0) {
                    cmp = new RoomsComparator(RoomInterface.RoomsColumn.values()[-1 - sort], false);
                }
            }
            catch (Exception sort) {
                // empty catch block
            }
            if (cmp != null) {
                Collections.sort(rooms, cmp);
            }
        }
        ec.setRoomCookieFlags(helper.getParameter("flags") == null ? 65535 : Integer.parseInt(helper.getParameter("flags")));
        if (helper.getParameter("orientation") != null) {
            ec.setVertical("vertical".equals(helper.getParameter("orientation")));
            ec.setGridAsText("text".equals(helper.getParameter("orientation")));
        } else if (context.getUser() != null) {
            ec.setVertical(CommonValues.VerticalGrid.eq(context.getUser().getProperty(UserProperty.GridOrientation)));
            ec.setGridAsText(context.getUser() == null ? false : CommonValues.TextGrid.eq(UserProperty.GridOrientation.get(context.getUser())));
        }
        ec.setMode(helper.getParameter("mode"));
        if (ec.getMode() == null && context.getUser() != null) {
            ec.setMode(RequiredTimeTable.getTimeGridSize(context.getUser()));
        }
        for (RoomFeatureType type : new TreeSet(RoomFeatureTypeDAO.getInstance().findAll())) {
            ec.addRoomFeatureType(new RoomInterface.FeatureTypeInterface(type.getUniqueId(), type.getReference(), type.getLabel(), type.isShowInEventManagement()));
        }
        for (AttachmentType type : AttachmentType.listTypes(AttachmentType.VisibilityFlag.ROOM_PICTURE_TYPE, AttachmentType.VisibilityFlag.SHOW_ROOMS_TABLE)) {
            ec.addPictureType(RoomPicturesBackend.getPictureType(type));
        }
        ec.setDepartment(request.getOption("department"));
        this.print(helper, rooms, ec);
    }

    protected boolean hasShowHideOperation(RoomInterface.RoomsColumn column) {
        switch (column) {
            case NAME: {
                return false;
            }
        }
        return true;
    }

    protected int getWebTableNbrCells(RoomInterface.RoomsColumn column, ExportContext context) {
        switch (column) {
            case PICTURES: {
                return 1 + context.getPictureTypes().size();
            }
            case FEATURES: {
                return 1 + context.getRoomFeatureTypes().size();
            }
        }
        return 1;
    }

    protected int getNbrCells(RoomInterface.RoomsColumn column, ExportContext context) {
        return this.getWebTableNbrCells(column, context);
    }

    protected boolean isColumnVisible(Column column, ExportContext context) {
        if (!this.hasShowHideOperation(column.getColumn())) {
            return true;
        }
        int colIndex = 0;
        for (RoomInterface.RoomsColumn c : RoomInterface.RoomsColumn.values()) {
            if (c.ordinal() >= column.getColumn().ordinal()) continue;
            colIndex += this.getWebTableNbrCells(c, context);
        }
        if (column.getIndex() < this.getWebTableNbrCells(column.getColumn(), context)) {
            colIndex += column.getIndex();
        }
        return (context.getRoomCookieFlags() & 1 << colIndex) != 0;
    }

    protected String getColumnName(Column column, ExportContext ec) {
        switch (column.getColumn()) {
            case NAME: {
                return MESSAGES.colName();
            }
            case TYPE: {
                return MESSAGES.colType();
            }
            case EXTERNAL_ID: {
                return MESSAGES.colExternalId();
            }
            case CAPACITY: {
                return MESSAGES.colCapacity();
            }
            case EXAM_CAPACITY: {
                return MESSAGES.colExaminationCapacity();
            }
            case AREA: {
                return MESSAGES.colArea(ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? CONSTANTS.roomAreaMetricUnitsShortPlainText() : CONSTANTS.roomAreaUnitsShortPlainText());
            }
            case COORDINATES: {
                return MESSAGES.colCoordinates();
            }
            case DISTANCE_CHECK: {
                return MESSAGES.colDistances();
            }
            case ROOM_CHECK: {
                return MESSAGES.colRoomCheck();
            }
            case MAP: {
                return MESSAGES.colMap();
            }
            case PICTURES: {
                if (column.getIndex() == 0) {
                    return MESSAGES.colPictures();
                }
                return ec.getPictureTypes().get(column.getIndex() - 1).getAbbreviation();
            }
            case PREFERENCE: {
                return MESSAGES.colPreference();
            }
            case AVAILABILITY: {
                return MESSAGES.colAvailability();
            }
            case DEPARTMENTS: {
                return MESSAGES.colDepartments();
            }
            case CONTROL_DEPT: {
                return MESSAGES.colControl();
            }
            case EXAM_TYPES: {
                return MESSAGES.colExamTypes();
            }
            case PERIOD_PREF: {
                return MESSAGES.colPeriodPreferences();
            }
            case EVENT_DEPARTMENT: {
                return MESSAGES.colEventDepartment();
            }
            case EVENT_STATUS: {
                return MESSAGES.colEventStatus();
            }
            case EVENT_AVAILABILITY: {
                return MESSAGES.colEventAvailability();
            }
            case EVENT_MESSAGE: {
                return MESSAGES.colEventMessage();
            }
            case EVENT_EMAIL: {
                return MESSAGES.colEventEmail();
            }
            case BREAK_TIME: {
                return MESSAGES.colBreakTime();
            }
            case GROUPS: {
                return MESSAGES.colGroups();
            }
            case FEATURES: {
                if (column.getIndex() == 0) {
                    return MESSAGES.colFeatures();
                }
                return ec.getRoomFeatureTypes().get(column.getIndex() - 1).getAbbreviation();
            }
            case SERVICES: {
                return MESSAGES.colAvailableServices();
            }
            case PARTITION: {
                return MESSAGES.colPartitionOf();
            }
        }
        return column.getColumn().name();
    }

    protected abstract void print(ExportHelper var1, List<RoomInterface.RoomDetailInterface> var2, ExportContext var3) throws IOException;

    protected static class ExportContext {
        private String iDepartment = null;
        private List<RoomInterface.FeatureTypeInterface> iFeatureTypes = new ArrayList<RoomInterface.FeatureTypeInterface>();
        private List<RoomInterface.AttachmentTypeInterface> iPictureTypes = new ArrayList<RoomInterface.AttachmentTypeInterface>();
        private int iNrDepartments = 0;
        private int iDepartmentMode = 0;
        private int iRoomCookieFlags = 0;
        private boolean iGridAsText = false;
        private boolean iVertical = true;
        private String iMode = null;
        private String iSeparator = "\n";
        private Formats.Format<Number> iAreaFormat = Formats.getNumberFormat(CONSTANTS.roomAreaFormat());
        private Formats.Format<Number> iCoordinateFormat = Formats.getNumberFormat(CONSTANTS.roomCoordinateFormat());

        protected ExportContext() {
        }

        public void setDepartment(String department) {
            this.iDepartment = department;
        }

        public String getDepartment() {
            return this.iDepartment;
        }

        public int getDepartmentMode() {
            return this.iDepartmentMode;
        }

        public void setDepartmentMode(int deptMode) {
            this.iDepartmentMode = deptMode;
        }

        public void addRoomFeatureType(RoomInterface.FeatureTypeInterface type) {
            this.iFeatureTypes.add(type);
        }

        public List<RoomInterface.FeatureTypeInterface> getRoomFeatureTypes() {
            return this.iFeatureTypes;
        }

        public void addPictureType(RoomInterface.AttachmentTypeInterface type) {
            this.iPictureTypes.add(type);
        }

        public List<RoomInterface.AttachmentTypeInterface> getPictureTypes() {
            return this.iPictureTypes;
        }

        public void setRoomCookieFlags(int flags) {
            this.iRoomCookieFlags = flags;
        }

        public int getRoomCookieFlags() {
            return this.iRoomCookieFlags;
        }

        public void setGridAsText(boolean gridAsText) {
            this.iGridAsText = gridAsText;
        }

        public boolean isGridAsText() {
            return this.iGridAsText;
        }

        public void setVertical(boolean vertical) {
            this.iVertical = vertical;
        }

        public boolean isVertical() {
            return this.iVertical;
        }

        public void setMode(String mode) {
            this.iMode = mode;
        }

        public String getMode() {
            return this.iMode;
        }

        public void setSeparator(String separator) {
            this.iSeparator = separator;
        }

        public String getSeparator() {
            return this.iSeparator;
        }

        public Formats.Format<Number> getAreaFormat() {
            return this.iAreaFormat;
        }

        public Formats.Format<Number> getCoordinateFormat() {
            return this.iCoordinateFormat;
        }

        public void setNrDepartments(int nrDepartments) {
            this.iNrDepartments = nrDepartments;
        }

        protected String dept2string(RoomInterface.DepartmentInterface d, boolean ext) {
            if (d == null) {
                return "";
            }
            switch (this.getDepartmentMode()) {
                case 0: {
                    return d.getDeptCode();
                }
                case 1: {
                    return ext ? d.getExtAbbreviationWhenExist() : d.getAbbreviationOrCode();
                }
                case 2: {
                    return ext ? d.getExtLabelWhenExist() : d.getLabel();
                }
                case 3: {
                    return ext ? d.getExtAbbreviationWhenExist() + " - " + d.getExtLabelWhenExist() : d.getAbbreviationOrCode() + " - " + d.getLabel();
                }
                case 4: {
                    return ext ? d.getDeptCode() + " - " + d.getExtLabelWhenExist() : d.getDeptCode() + " - " + d.getLabel();
                }
            }
            return d.getDeptCode();
        }

        protected boolean isAllDepartments(Collection<RoomInterface.DepartmentInterface> departments) {
            return departments.size() > 3 && this.iNrDepartments == departments.size();
        }

        protected String dept2string(Collection<RoomInterface.DepartmentInterface> departments, boolean ext) {
            if (departments == null || departments.isEmpty()) {
                return "";
            }
            if (this.isAllDepartments(departments)) {
                return MESSAGES.departmentsAllLabel();
            }
            Object ret = "";
            for (RoomInterface.DepartmentInterface d : departments) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + this.dept2string(d, ext);
            }
            return ret;
        }

        protected String pref2string(Collection<RoomInterface.DepartmentInterface> departments) {
            if (departments == null || departments.isEmpty()) {
                return "";
            }
            Object ret = "";
            for (RoomInterface.DepartmentInterface d : departments) {
                if (d.getPreference() == null) continue;
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + d.getPreference().getName() + " " + this.dept2string(d, true);
            }
            return ret;
        }

        protected String examTypes2string(Collection<RoomInterface.ExamTypeInterface> types) {
            if (types == null || types.isEmpty()) {
                return "";
            }
            Object ret = "";
            for (RoomInterface.ExamTypeInterface t : types) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + t.getLabel();
            }
            return ret;
        }

        protected String features2string(Collection<RoomInterface.FeatureInterface> features, RoomInterface.FeatureTypeInterface type) {
            if (features == null || features.isEmpty()) {
                return "";
            }
            Object ret = "";
            for (RoomInterface.FeatureInterface f : features) {
                if (type == null && f.getType() == null) {
                    ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + f.getLabel();
                }
                if (type == null || !type.equals(f.getType())) continue;
                if (f.getDepartment() != null) {
                    ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + f.getLabel() + " (" + this.dept2string(f.getDepartment(), true) + ")";
                    continue;
                }
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + f.getLabel();
            }
            return ret;
        }

        protected String groups2string(Collection<RoomInterface.GroupInterface> groups) {
            if (groups == null || groups.isEmpty()) {
                return "";
            }
            Object ret = "";
            for (RoomInterface.GroupInterface g : groups) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + g.getLabel() + (String)(g.getDepartment() == null ? "" : " (" + this.dept2string(g.getDepartment(), true) + ")");
            }
            return ret;
        }

        protected String services2string(Collection<EventInterface.EventServiceProviderInterface> services, RoomInterface.DepartmentInterface eventDept) {
            if (services == null || services.isEmpty()) {
                return "";
            }
            Object ret = "";
            for (EventInterface.EventServiceProviderInterface s : services) {
                ret = (String)ret + (((String)ret).isEmpty() ? "" : this.getSeparator()) + s.getLabel() + (String)(s.getDepartmentId() == null || eventDept == null ? "" : " (" + this.dept2string(eventDept, true) + ")");
            }
            return ret;
        }
    }

    protected static class Column {
        private RoomInterface.RoomsColumn iColumn;
        private int iIndex;

        Column(RoomInterface.RoomsColumn column, int index) {
            this.iColumn = column;
            this.iIndex = index;
        }

        public int getIndex() {
            return this.iIndex;
        }

        public RoomInterface.RoomsColumn getColumn() {
            return this.iColumn;
        }
    }
}

