/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.instructors;

import java.io.IOException;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.PDFPrinter;
import org.unitime.timetable.export.instructors.InstructorsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;

@Service(value="org.unitime.timetable.export.Exporter:instructors.pdf")
public class InstructorsPDF
extends InstructorsCSV {
    @Override
    public String reference() {
        return "instructors.pdf";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.exportDataPdf(this.getInstructors(helper), helper);
    }

    protected void exportDataPdf(TableInterface table, ExportHelper helper) throws IOException {
        PDFPrinter printer = new PDFPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), table.getId() + "-" + this.reference(), false);
        for (int i = 0; i < table.getHeader().size(); ++i) {
            printer.printHeader(i, table.getHeader().size(), printer.toA(table.getHeader().get(0), true));
        }
        if (table.hasErrorMessage()) {
            PDFPrinter.A a = new PDFPrinter.A();
            a.italic();
            a.center();
            a.setColor("red");
            a.setText(table.getErrorMessage());
            a.setColSpan(table.getMaxColumns());
            printer.printLine(a);
        }
        if (table.getLines() != null) {
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(printer.toA(line, false));
            }
        }
        printer.flushTable(table.getName());
        printer.flush();
        printer.close();
    }
}

