/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;

@Service(value="org.unitime.timetable.export.Exporter:events.json")
public class EventsExportEventsToJSON
extends EventsExporter {
    @Override
    public String reference() {
        return "events.json";
    }

    @Override
    protected void print(ExportHelper helper, EventInterface.EventLookupRpcRequest request, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        helper.setup("application/json", this.reference(), false);
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonSerializer<Date>(){

            public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(src));
            }
        }).setFieldNamingStrategy(new FieldNamingStrategy(){
            Pattern iPattern = Pattern.compile("i([A-Z])(.*)");

            public String translateName(Field f) {
                Matcher matcher = this.iPattern.matcher(f.getName());
                if (matcher.matches()) {
                    return matcher.group(1).toLowerCase() + matcher.group(2);
                }
                return f.getName();
            }
        }).setPrettyPrinting().create();
        helper.getWriter().write(gson.toJson(events));
    }
}

