/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.courses.ClassAssignmentsTableBuilder;
import org.unitime.timetable.server.courses.ClassesTableBuilder;
import org.unitime.timetable.server.courses.DistributionsTableBuilder;
import org.unitime.timetable.server.courses.InstructionalOfferingTableBuilder;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;

@Service(value="org.unitime.timetable.export.Exporter:offerings.csv")
public class OfferingsCSV
implements Exporter {
    @Autowired
    protected AssignmentService<ClassAssignmentProxy> classAssignmentService;
    @Autowired
    protected SolverService<ExamSolverProxy> examinationSolverService;

    @Override
    public String reference() {
        return "offerings.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.InstructionalOfferingsExportPDF);
        this.exportDataCsv(this.getOfferings(helper), helper);
    }

    protected void checkPermission(ExportHelper helper, Right right) {
        ArrayList<SubjectArea> subjectAreas = new ArrayList<SubjectArea>();
        for (String subjectAreaId : helper.getParameter("subjectArea").split(",")) {
            SubjectArea subjectArea;
            if (subjectAreaId.isEmpty() || (subjectArea = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            subjectAreas.add(subjectArea);
            helper.getSessionContext().checkPermissionAnySession((Object)subjectArea.getDepartment(), right, new Qualifiable[0]);
        }
    }

    protected List<TableInterface> getOfferings(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        InstructionalOfferingTableBuilder builder = new InstructionalOfferingTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForInstructionalOfferings(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getClasses(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        ClassesTableBuilder builder = new ClassesTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForClasses(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getClassAssignments(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        ClassAssignmentsTableBuilder builder = new ClassAssignmentsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        builder.generateTableForClassAssignments(this.classAssignmentService.getAssignment(), this.examinationSolverService.getSolver(), new Filter(helper), helper.getParameter("subjectArea").split(","), response);
        return response;
    }

    protected List<TableInterface> getDistributions(ExportHelper helper) {
        ArrayList<TableInterface> response = new ArrayList<TableInterface>();
        DistributionsTableBuilder builder = new DistributionsTableBuilder(helper.getSessionContext(), helper.getParameter("backType"), helper.getParameter("backId"));
        builder.setSimple(true);
        Filter filter = new Filter(helper);
        for (String subjectAreaId : helper.getParameter("subjectArea").split(",")) {
            SubjectArea area;
            if (subjectAreaId.isEmpty() || (area = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(subjectAreaId))) == null) continue;
            TableInterface table = builder.getDistPrefsTableForFilter(filter, area.getUniqueId());
            table.setName(area.getLabel());
            table.setId(subjectAreaId);
            response.add(table);
        }
        return response;
    }

    protected void exportDataCsv(List<TableInterface> response, ExportHelper helper) throws IOException {
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), this.reference(), false);
        for (TableInterface table : response) {
            if (table.hasName()) {
                printer.printLine(table.getName());
            }
            if (table.hasErrorMessage()) {
                printer.printLine(table.getErrorMessage());
            }
            if (table.getHeader() != null) {
                for (TableInterface.LineInterface line : table.getHeader()) {
                    printer.printHeader(this.toLine(line));
                }
            }
            if (table.getLines() == null) continue;
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(this.toLine(line));
            }
        }
        printer.flush();
        printer.close();
    }

    protected String[] toLine(TableInterface.LineInterface line) {
        ArrayList<String> row = new ArrayList<String>();
        if (line.hasCells()) {
            for (TableInterface.CellInterface cell : line.getCells()) {
                row.add(cell.toString());
                for (int i = 1; i < cell.getColSpan(); ++i) {
                    row.add("");
                }
            }
        }
        return row.toArray(new String[0]);
    }

    public static class Filter
    implements TableInterface.FilterInterface {
        ExportHelper iHelper;

        public Filter(ExportHelper helper) {
            this.iHelper = helper;
        }

        @Override
        public boolean hasParameter(String name) {
            return this.iHelper.getParameter(name) != null;
        }

        @Override
        public String getParameterValue(String name) {
            return this.iHelper.getParameter(name);
        }

        @Override
        public String getParameterValue(String name, String defaultValue) {
            String value = this.iHelper.getParameter(name);
            return value == null ? defaultValue : value;
        }
    }
}

