/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.defaults;

import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.security.UserContext;

public enum UserProperty {
    LastAcademicSession("LastUsed.acadSessionId", "Last used academic session id"),
    CourseOfferingNoteDisplay("crsOffrNoteDisplay", CommonValues.NoteAsIcon, "Display an icon or shortened text when a course offering has a schedule note."),
    SchedulePrintNoteDisplay("printNoteDisplay", CommonValues.NoteAsIcon, "Display an icon or shortened text when a class has a schedule print note."),
    ManagerNoteDisplay("mgrNoteDisplay", CommonValues.NoteAsIcon, "Display an icon or shortened text when a class has a note to the schedule manager."),
    GridOrientation("timeGrid", CommonValues.VerticalGrid, "Time grid display format"),
    GridSize("timeGridSize", "Workdays x Daytime", "Time grid default selection"),
    NameFormat("name", CommonValues.NameLastInitial, "Instructor name display format"),
    ClassesKeepSort("keepSort", CommonValues.No, "Sort classes on detail pages based on Classes page sorting options."),
    ConfirmationDialogs("jsConfirm", CommonValues.Yes, "Display confirmation dialogs"),
    InheritInstructorPrefs("inheritInstrPref", CommonValues.Never, "Inherit instructor preferences on a class"),
    DisplayLastChanges("dispLastChanges", CommonValues.Yes, "Display last changes"),
    DispInstructorPrefs("InstructorDetail.distPref", CommonValues.Yes, "Display instructor preferences"),
    VariableClassLimits("showVarLimits", CommonValues.No, "Show the option to set variable class limits"),
    ConfigAutoCalc("cfgAutoCalc", CommonValues.Yes, "Automatically calculate number of classes and room size when editing configuration"),
    SortNames("instrNameSort", CommonValues.SortByLastName, "Sort instructor names"),
    RoomFeaturesInOneColumn("roomFeaturesInOneColumn", CommonValues.Yes, "Display Room Features In One Column"),
    HighlighClassPreferences("highlightClassPrefs", CommonValues.UseSystemDefault, "Highlight preferences that are set directly on classes"),
    PrimaryCampus("primaryAcademicInitiative", "Primary academic initiative"),
    StudentDashboardShowUnmatchedClasses("sctdashShowUnmatchedClasses", CommonValues.Yes, "Student Scheduling Dashboard: Show classes not meeting the filter (as grayed out)."),
    StudentDashboardShowUnmatchedCourses("sctdashShowUnmatchedCourses", CommonValues.No, "Student Scheduling Dashboard: Show courses that have no students meeting the filter (as grayed out)."),
    StickyTables("stickyTables", CommonValues.No, "Instructional Offerings / Classes: Freeze header row.");

    String iKey;
    String iDefault;
    String iDescription;

    private UserProperty(String key, String defaultValue, String description) {
        this.iKey = key;
        this.iDefault = defaultValue;
        this.iDescription = defaultValue;
    }

    private UserProperty(String key, String description) {
        this(key, (String)null, description);
    }

    private UserProperty(String key, CommonValues defaultValue, String description) {
        this(key, defaultValue.value(), description);
    }

    public String key() {
        return this.iKey;
    }

    public String defaultValue() {
        return this.iDefault;
    }

    public String description() {
        return this.iDescription;
    }

    public String get(UserContext user) {
        return user == null ? this.defaultValue() : user.getProperty(this);
    }
}

