/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;

public class SessionImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("session")) {
            throw new Exception("Given XML file is not a Session load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            DepartmentStatusType statusType = DepartmentStatusType.findByRef("initial");
            Iterator iter = root.elementIterator();
            while (iter.hasNext()) {
                Element element = (Element)iter.next();
                String beginDate = element.attributeValue("beginDate");
                if (beginDate == null) {
                    this.error("Begin date not provided.");
                    continue;
                }
                String endDate = element.attributeValue("endDate");
                if (endDate == null) {
                    this.error("End date not provided.");
                    continue;
                }
                String classesEnd = element.attributeValue("classesEnd");
                if (classesEnd == null) {
                    this.error("Classes end date not provided.");
                    continue;
                }
                String examBegin = element.attributeValue("examBegin", classesEnd);
                String eventBegin = element.attributeValue("eventBegin", beginDate);
                String eventEnd = element.attributeValue("eventEnd", endDate);
                Session session = new Session();
                session.setAcademicInitiative(campus);
                session.setAcademicYear(year);
                session.setAcademicTerm(term);
                SimpleDateFormat df = new SimpleDateFormat(root.attributeValue("dateFormat", "M/d/y"));
                session.setSessionBeginDateTime(df.parse(beginDate));
                session.setSessionEndDateTime(df.parse(endDate));
                session.setClassesEndDateTime(df.parse(classesEnd));
                session.setExamBeginDate(df.parse(examBegin));
                session.setEventBeginDate(df.parse(eventBegin));
                session.setEventEndDate(df.parse(eventEnd));
                session.setStatusType(statusType);
                session.setLastWeekToEnroll(Integer.valueOf(element.attributeValue("lastWeekToEnroll", "1")));
                session.setLastWeekToChange(Integer.valueOf(element.attributeValue("lastWeekToChange", "1")));
                session.setLastWeekToDrop(Integer.valueOf(element.attributeValue("lastWeekToDrop", "4")));
                this.getHibSession().persist((Object)session);
                this.flushIfNeeded(false);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }
}

